/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.client;

import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.jboss.resteasy.client.jaxrs.ResteasyWebTarget;
import org.keycloak.testsuite.client.resources.TestApplicationResource;
import org.keycloak.testsuite.client.resources.TestExampleCompanyResource;
import org.keycloak.testsuite.client.resources.TestingResource;

public class KeycloakTestingClient {
    private final ResteasyWebTarget target;
    private final ResteasyClient client;

    KeycloakTestingClient(String serverUrl, ResteasyClient resteasyClient) {
        this.client = resteasyClient != null ? resteasyClient : new ResteasyClientBuilder().connectionPoolSize(10).build();
        this.target = this.client.target(serverUrl);
    }

    public static KeycloakTestingClient getInstance(String serverUrl) {
        return new KeycloakTestingClient(serverUrl, null);
    }

    public TestingResource testing() {
        return (TestingResource)this.target.proxy(TestingResource.class);
    }

    public TestApplicationResource testApp() {
        return (TestApplicationResource)this.target.proxy(TestApplicationResource.class);
    }

    public TestExampleCompanyResource testExampleCompany() {
        return (TestExampleCompanyResource)this.target.proxy(TestExampleCompanyResource.class);
    }

    public void close() {
        this.client.close();
    }
}

