/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.console.page;

import java.net.URI;
import javax.ws.rs.core.UriBuilder;
import org.jboss.arquillian.graphene.page.Page;
import org.keycloak.protocol.oidc.OIDCLoginProtocolService;
import org.keycloak.testsuite.auth.page.AuthServer;
import org.keycloak.testsuite.auth.page.login.PageWithLoginUrl;
import org.keycloak.testsuite.console.page.fragment.Menu;
import org.keycloak.testsuite.console.page.fragment.ModalDialog;
import org.keycloak.testsuite.page.PageWithLogOutAction;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

public class AdminConsole
extends AuthServer
implements PageWithLoginUrl,
PageWithLogOutAction {
    public static final String ADMIN_REALM = "adminRealm";
    @Page
    private Menu menu;
    @FindBy(xpath="//div[@class='modal-dialog']")
    protected ModalDialog modalDialog;
    @FindBy(css=".btn-danger")
    protected WebElement dangerButton;
    @FindBy(css=".btn-primary")
    protected WebElement primaryButton;
    @FindBy(css="navbar-brand")
    protected WebElement brandLink;

    public AdminConsole() {
        this.setUriParameter(ADMIN_REALM, "master");
    }

    public AdminConsole setAdminRealm(String adminRealm) {
        this.setUriParameter(ADMIN_REALM, adminRealm);
        return this;
    }

    public String getAdminRealm() {
        return this.getUriParameter(ADMIN_REALM).toString();
    }

    @Override
    public UriBuilder createUriBuilder() {
        return super.createUriBuilder().path("admin/{adminRealm}/console");
    }

    @Override
    public URI getOIDCLoginUrl() {
        return OIDCLoginProtocolService.authUrl((UriBuilder)UriBuilder.fromPath((String)this.getAuthRoot())).build(new Object[]{this.getAdminRealm()});
    }

    @Override
    public void logOut() {
        this.menu.logOut();
    }
}

