/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.console.page;

import org.keycloak.testsuite.console.page.AdminConsoleRealmsRoot;
import org.keycloak.testsuite.util.WaitUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

public class AdminConsoleRealm
extends AdminConsoleRealmsRoot {
    public static final String CONSOLE_REALM = "consoleRealm";
    @FindBy(xpath="//div[./h2[text()='Configure']]")
    private ConfigureMenu configureMenu;
    @FindBy(xpath="//div[./h2[text()='Manage']]")
    protected ManageMenu manageMenu;

    public AdminConsoleRealm() {
        this.setUriParameter(CONSOLE_REALM, "test");
    }

    public AdminConsoleRealm setConsoleRealm(String realm) {
        this.setUriParameter(CONSOLE_REALM, realm);
        return this;
    }

    public String getConsoleRealm() {
        return this.getUriParameter(CONSOLE_REALM).toString();
    }

    @Override
    public String getUriFragment() {
        return super.getUriFragment() + "/{" + CONSOLE_REALM + "}";
    }

    public ConfigureMenu configure() {
        WaitUtils.waitUntilElement(By.xpath((String)"//div[./h2[text()='Configure']]")).is().present();
        return this.configureMenu;
    }

    public ManageMenu manage() {
        WaitUtils.waitUntilElement(By.xpath((String)"//div[./h2[text()='Manage']]")).is().present();
        return this.manageMenu;
    }

    public class ManageMenu {
        @FindBy(partialLinkText="Users")
        private WebElement usersLink;
        @FindBy(partialLinkText="Sessions")
        private WebElement sessionsLink;
        @FindBy(partialLinkText="Events")
        private WebElement eventsLink;

        public void users() {
            this.usersLink.click();
        }

        public void sessions() {
            this.sessionsLink.click();
        }

        public void events() {
            this.eventsLink.click();
        }
    }

    public class ConfigureMenu {
        @FindBy(partialLinkText="Realm Settings")
        private WebElement realmSettingsLink;
        @FindBy(partialLinkText="Clients")
        private WebElement clientsLink;
        @FindBy(partialLinkText="Roles")
        private WebElement rolesLink;
        @FindBy(partialLinkText="Identity Providers")
        private WebElement identityProvidersLink;
        @FindBy(partialLinkText="User Federation")
        private WebElement userFederationLink;
        @FindBy(partialLinkText="Authentication")
        private WebElement authenticationLink;

        public void realmSettings() {
            this.realmSettingsLink.click();
        }

        public void clients() {
            this.clientsLink.click();
        }

        public void roles() {
            this.rolesLink.click();
        }

        public void identityProviders() {
            this.identityProvidersLink.click();
        }

        public void userFederation() {
            this.userFederationLink.click();
        }

        public void authentication() {
            this.authenticationLink.click();
        }
    }
}

