/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.console.page.events;

import org.keycloak.testsuite.console.page.events.Events;
import org.keycloak.testsuite.console.page.fragment.DataTable;
import org.keycloak.testsuite.page.Form;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

public class AdminEvents
extends Events {
    @FindBy(tagName="table")
    private AdminEventsTable table;

    @Override
    public String getUriFragment() {
        return super.getUriFragment() + "/admin-events";
    }

    public AdminEventsTable table() {
        return this.table;
    }

    public class AdminEventsTable
    extends DataTable {
        @FindBy(xpath="//button[text()[contains(.,'Filter')]]")
        private WebElement filterButton;
        @FindBy(tagName="form")
        private AdminEventsTableFilterForm filterForm;

        public void update() {
            this.clickHeaderButton("Update");
        }

        public void reset() {
            this.clickHeaderButton("Reset");
        }

        public void filter() {
            this.filterButton.click();
        }

        public AdminEventsTableFilterForm filterForm() {
            return this.filterForm;
        }

        public class AdminEventsTableFilterForm
        extends Form {
            @FindBy(id="resource")
            private WebElement resourcePathInput;
            @FindBy(id="realm")
            private WebElement realmInput;
            @FindBy(id="client")
            private WebElement clientInput;
            @FindBy(id="user")
            private WebElement userInput;
            @FindBy(id="ipAddress")
            private WebElement ipAddressInput;
            @FindBy(xpath="//div[@id='s2id_adminEnabledEventOperations']/ul")
            private WebElement operationTypesInput;
            @FindBy(xpath="//div[@id='select2-drop']")
            private WebElement operationTypesValues;

            public void addOperationType(String type) {
                this.operationTypesInput.click();
                this.operationTypesValues.findElement(By.xpath((String)("//div[text() = '" + type + "']"))).click();
            }

            public void removeOperationType(String type) {
                this.operationTypesInput.findElement(By.xpath((String)("//div[text()='" + type + "']/../a"))).click();
            }

            public void setResourcePathInput(String value) {
                AdminEventsTableFilterForm.setInputValue(this.resourcePathInput, value);
            }

            public void setRealmInput(String value) {
                AdminEventsTableFilterForm.setInputValue(this.realmInput, value);
            }

            public void setClientInput(String value) {
                AdminEventsTableFilterForm.setInputValue(this.clientInput, value);
            }

            public void setUserInput(String value) {
                AdminEventsTableFilterForm.setInputValue(this.userInput, value);
            }

            public void setIpAddressInput(String value) {
                AdminEventsTableFilterForm.setInputValue(this.ipAddressInput, value);
            }
        }
    }
}

