/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.console.page.fragment;

import java.util.List;
import org.jboss.arquillian.drone.api.annotation.Drone;
import org.keycloak.testsuite.util.WaitUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

public class DataTable {
    @Drone
    protected WebDriver driver;
    @FindBy(css="input[class*='search']")
    private WebElement searchInput;
    @FindBy(css="div[class='input-group-addon'] i")
    private WebElement searchButton;
    @FindBy(tagName="thead")
    private WebElement header;
    @FindBy(css="tbody")
    private WebElement body;
    @FindBy(xpath="(//table)[1]/tbody/tr[@class='ng-scope']")
    private List<WebElement> rows;
    @FindBy
    private WebElement infoRow;

    public void search(String pattern) {
        this.searchInput.sendKeys(new CharSequence[]{pattern});
        this.searchButton.click();
    }

    public void clickHeaderButton(String buttonText) {
        this.header.findElement(By.xpath((String)(".//button[text()='" + buttonText + "']"))).click();
        WaitUtils.waitForPageToLoad(this.driver);
    }

    public void clickHeaderLink(String linkText) {
        this.header.findElement(By.linkText((String)linkText)).click();
        WaitUtils.waitForPageToLoad(this.driver);
    }

    public WebElement body() {
        return this.body;
    }

    public List<WebElement> rows() {
        return this.rows;
    }

    public WebElement getRowByLinkText(String text) {
        WebElement row = this.body.findElement(By.xpath((String)(".//tr[./td/a[text()='" + text + "']]")));
        return row;
    }

    public void clickRowByLinkText(String text) {
        this.body.findElement(By.xpath((String)(".//tr/td/a[text()='" + text + "']"))).click();
    }

    public void clickRowActionButton(WebElement row, String buttonText) {
        row.findElement(By.xpath((String)(".//td[contains(@class, 'kc-action-cell') and text()='" + buttonText + "']"))).click();
    }
}

