/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.console.page.fragment;

import java.util.List;
import org.keycloak.testsuite.util.WaitUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

public class Menu {
    private static final String MENU_LOCATOR = "ul[class='dropdown-menu']";
    @FindBy(css="ul[class='dropdown-menu']")
    private List<WebElement> menuList;
    @FindBy(css=".dropdown-toggle")
    private List<WebElement> toggle;

    public void logOut() {
        this.clickOnMenuElement(MenuType.USER, "Sign Out");
    }

    public void goToAccountManagement() {
        this.clickOnMenuElement(MenuType.USER, "Manage Account");
    }

    public void switchRealm(String realmName) {
        if (!realmName.equals(this.getCurrentRealm())) {
            this.clickOnMenuElement(MenuType.REALM, realmName);
        }
    }

    public String getCurrentRealm() {
        WaitUtils.waitUntilElement(By.cssSelector((String)MENU_LOCATOR)).is().present();
        return this.toggle.get(1).getText();
    }

    private void clickOnMenuElement(MenuType menuType, String linkText) {
        int menuOrder = 0;
        switch (menuType) {
            case REALM: {
                menuOrder = 1;
                break;
            }
            case USER: {
                menuOrder = 0;
            }
        }
        WaitUtils.waitUntilElement(By.cssSelector((String)MENU_LOCATOR)).is().present();
        if (!this.menuList.get(menuOrder).isDisplayed()) {
            this.toggle.get(menuOrder).click();
        }
        for (WebElement item : this.menuList.get(menuOrder).findElements(By.cssSelector((String)"ul[class='dropdown-menu'] a"))) {
            if (!item.getText().contains(linkText)) continue;
            item.click();
            return;
        }
        throw new RuntimeException("Could not find menu item containing \"" + linkText + "\"");
    }

    private static enum MenuType {
        USER,
        REALM;

    }
}

