/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.console.page.fragment;

import org.jboss.arquillian.graphene.fragment.Root;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.keycloak.testsuite.util.WaitUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Actions;

public class OnOffSwitch {
    @Root
    private WebElement root;
    @ArquillianResource
    private Actions actions;

    public OnOffSwitch() {
    }

    public OnOffSwitch(WebElement root, Actions actions) {
        this.root = root;
        this.actions = actions;
    }

    public boolean isOn() {
        WaitUtils.waitUntilElement(this.root).is().present();
        return this.root.findElement(By.tagName((String)"input")).isSelected();
    }

    private void click() {
        WaitUtils.waitUntilElement(this.root).is().present();
        this.actions.moveToElement(this.root.findElement(By.tagName((String)"label"))).click().build().perform();
    }

    public void toggle() {
        this.click();
    }

    public void on() {
        if (!this.isOn()) {
            this.click();
        }
    }

    public void off() {
        if (this.isOn()) {
            this.click();
        }
    }

    public void setOn(boolean on) {
        if (on && !this.isOn() || !on && this.isOn()) {
            this.click();
        }
    }
}

