/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.page;

import com.google.common.base.Function;
import org.jboss.arquillian.drone.api.annotation.Drone;
import org.jboss.arquillian.graphene.fragment.Root;
import org.jboss.logging.Logger;
import org.keycloak.testsuite.util.WaitUtils;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.WebDriverWait;

public abstract class AbstractAlert {
    protected final Logger log = Logger.getLogger(this.getClass());
    @Root
    protected WebElement root;
    @Drone
    protected WebDriver driver;

    public String getText() {
        return this.root.getText();
    }

    public boolean isSuccess() {
        this.log.debug((Object)"Alert.isSuccess()");
        return this.checkAlertType("success");
    }

    protected boolean checkAlertType(String type) {
        WaitUtils.waitForPageToLoad(this.driver);
        try {
            new WebDriverWait(this.driver, 1L).until((Function)ExpectedConditions.attributeContains((WebElement)this.root, (String)"class", (String)("alert-" + type)));
        }
        catch (TimeoutException e) {
            return false;
        }
        return true;
    }
}

