/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.page;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.ws.rs.core.UriBuilder;
import org.keycloak.testsuite.page.AbstractPage;

public abstract class AbstractPageWithInjectedUrl
extends AbstractPage {
    public abstract URL getInjectedUrl();

    protected URL createInjectedURL(String url) {
        if (!System.getProperty("app.server").equals("eap6")) {
            return null;
        }
        try {
            if (Boolean.parseBoolean(System.getProperty("app.server.ssl.required"))) {
                return new URL("https://localhost:" + System.getProperty("app.server.https.port", "8543") + "/" + url);
            }
            return new URL("http://localhost:" + System.getProperty("app.server.http.port", "8180") + "/" + url);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public UriBuilder createUriBuilder() {
        try {
            return UriBuilder.fromUri((URI)this.getInjectedUrl().toURI());
        }
        catch (URISyntaxException ex) {
            throw new IllegalStateException(ex);
        }
    }
}

