/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.pages;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.keycloak.services.Urls;
import org.keycloak.testsuite.pages.AbstractAccountPage;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;

public class AccountApplicationsPage
extends AbstractAccountPage {
    @Override
    public boolean isCurrent() {
        return this.driver.getTitle().contains("Account Management") && this.driver.getCurrentUrl().endsWith("/account/applications");
    }

    @Override
    public void open() {
        this.driver.navigate().to(this.getPath());
    }

    private String getPath() {
        return Urls.accountApplicationsPage((URI)this.getAuthServerRoot(), (String)"test").toString();
    }

    public void revokeGrant(String clientId) {
        this.driver.findElement(By.id((String)("revoke-" + clientId))).click();
    }

    public Map<String, AppEntry> getApplications() {
        HashMap<String, AppEntry> table = new HashMap<String, AppEntry>();
        for (WebElement r : this.driver.findElements(By.tagName((String)"tr"))) {
            int count = 0;
            AppEntry currentEntry = null;
            block8: for (WebElement col : r.findElements(By.tagName((String)"td"))) {
                switch (++count) {
                    case 1: {
                        currentEntry = new AppEntry();
                        String client = col.getText();
                        table.put(client, currentEntry);
                        break;
                    }
                    case 2: {
                        String[] roles;
                        String rolesStr = col.getText();
                        for (String role : roles = rolesStr.split(",")) {
                            role = role.trim();
                            currentEntry.addAvailableRole(role);
                        }
                        continue block8;
                    }
                    case 3: {
                        String[] roles;
                        String rolesStr = col.getText();
                        if (rolesStr.isEmpty()) break;
                        for (String role : roles = rolesStr.split(",")) {
                            role = role.trim();
                            currentEntry.addGrantedRole(role);
                        }
                        continue block8;
                    }
                    case 4: {
                        String[] protMappers;
                        String protMappersStr = col.getText();
                        if (protMappersStr.isEmpty()) break;
                        for (String protMapper : protMappers = protMappersStr.split(",")) {
                            protMapper = protMapper.trim();
                            currentEntry.addMapper(protMapper);
                        }
                        continue block8;
                    }
                    case 5: {
                        String[] grants;
                        String additionalGrant = col.getText();
                        if (additionalGrant.isEmpty()) break;
                        for (String grant : grants = additionalGrant.split(",")) {
                            grant = grant.trim();
                            currentEntry.addAdditionalGrant(grant);
                        }
                        break;
                    }
                }
            }
        }
        table.remove("Application");
        return table;
    }

    public static class AppEntry {
        private final List<String> rolesAvailable = new ArrayList<String>();
        private final List<String> rolesGranted = new ArrayList<String>();
        private final List<String> protocolMappersGranted = new ArrayList<String>();
        private final List<String> additionalGrants = new ArrayList<String>();

        private void addAvailableRole(String role) {
            this.rolesAvailable.add(role);
        }

        private void addGrantedRole(String role) {
            this.rolesGranted.add(role);
        }

        private void addMapper(String protocolMapper) {
            this.protocolMappersGranted.add(protocolMapper);
        }

        private void addAdditionalGrant(String grant) {
            this.additionalGrants.add(grant);
        }

        public List<String> getRolesGranted() {
            return this.rolesGranted;
        }

        public List<String> getRolesAvailable() {
            return this.rolesAvailable;
        }

        public List<String> getProtocolMappersGranted() {
            return this.protocolMappersGranted;
        }

        public List<String> getAdditionalGrants() {
            return this.additionalGrants;
        }
    }
}

