/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.pages;

import java.net.URI;
import org.keycloak.services.Urls;
import org.keycloak.testsuite.pages.AbstractAccountPage;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

public class AccountFederatedIdentityPage
extends AbstractAccountPage {
    @FindBy(className="alert-error")
    private WebElement errorMessage;
    private String realmName = "test";

    @Override
    public void open() {
        this.driver.navigate().to(this.getPath());
    }

    public void realm(String realmName) {
        this.realmName = realmName;
    }

    public String getPath() {
        return Urls.accountFederatedIdentityPage((URI)this.getAuthServerRoot(), (String)this.realmName).toString();
    }

    @Override
    public boolean isCurrent() {
        return this.driver.getTitle().contains("Account Management") && this.driver.getPageSource().contains("Federated Identities");
    }

    public void clickAddProvider(String providerId) {
        this.driver.findElement(By.id((String)("add-" + providerId))).click();
    }

    public void clickRemoveProvider(String providerId) {
        this.driver.findElement(By.id((String)("remove-" + providerId))).click();
    }

    public String getError() {
        return this.errorMessage.getText();
    }
}

