/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.pages;

import java.net.URI;
import javax.ws.rs.core.UriBuilder;
import org.keycloak.services.resources.AccountService;
import org.keycloak.testsuite.pages.AbstractAccountPage;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

public class AccountPasswordPage
extends AbstractAccountPage {
    @FindBy(id="password")
    private WebElement passwordInput;
    @FindBy(id="password-new")
    private WebElement newPasswordInput;
    @FindBy(id="password-confirm")
    private WebElement passwordConfirmInput;
    @FindBy(className="btn-primary")
    private WebElement submitButton;
    private String realmName = "test";

    public void changePassword(String password, String newPassword, String passwordConfirm) {
        this.passwordInput.sendKeys(new CharSequence[]{password});
        this.newPasswordInput.sendKeys(new CharSequence[]{newPassword});
        this.passwordConfirmInput.sendKeys(new CharSequence[]{passwordConfirm});
        this.submitButton.click();
    }

    public void changePassword(String newPassword, String passwordConfirm) {
        this.newPasswordInput.sendKeys(new CharSequence[]{newPassword});
        this.passwordConfirmInput.sendKeys(new CharSequence[]{passwordConfirm});
        this.submitButton.click();
    }

    @Override
    public boolean isCurrent() {
        return this.driver.getTitle().contains("Account Management") && this.driver.getCurrentUrl().split("\\?")[0].endsWith("/account/password");
    }

    @Override
    public void open() {
        this.driver.navigate().to(this.getPath());
    }

    public void realm(String realmName) {
        this.realmName = realmName;
    }

    public String getPath() {
        return AccountService.passwordUrl((UriBuilder)UriBuilder.fromUri((URI)this.getAuthServerRoot())).build(new Object[]{this.realmName}).toString();
    }
}

