/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.pages;

import java.net.URI;
import java.util.LinkedList;
import java.util.List;
import org.keycloak.services.Urls;
import org.keycloak.testsuite.pages.AbstractAccountPage;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

public class AccountSessionsPage
extends AbstractAccountPage {
    private String realmName = "test";
    @FindBy(id="logout-all-sessions")
    private WebElement logoutAllLink;

    @Override
    public boolean isCurrent() {
        return this.driver.getTitle().contains("Account Management") && this.driver.getCurrentUrl().endsWith("/account/sessions");
    }

    public void realm(String realmName) {
        this.realmName = realmName;
    }

    public String getPath() {
        return Urls.accountSessionsPage((URI)this.getAuthServerRoot(), (String)this.realmName).toString();
    }

    @Override
    public void open() {
        this.driver.navigate().to(this.getPath());
    }

    public void logoutAll() {
        this.logoutAllLink.click();
    }

    public List<List<String>> getSessions() {
        LinkedList<List<String>> table = new LinkedList<List<String>>();
        for (WebElement r : this.driver.findElements(By.tagName((String)"tr"))) {
            LinkedList<String> row = new LinkedList<String>();
            for (WebElement col : r.findElements(By.tagName((String)"td"))) {
                row.add(col.getText());
            }
            table.add(row);
        }
        table.remove(0);
        return table;
    }
}

