/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.pages;

import java.net.URI;
import javax.ws.rs.core.UriBuilder;
import org.keycloak.services.resources.AccountService;
import org.keycloak.testsuite.pages.AbstractAccountPage;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

public class AccountTotpPage
extends AbstractAccountPage {
    @FindBy(id="totpSecret")
    private WebElement totpSecret;
    @FindBy(id="totp")
    private WebElement totpInput;
    @FindBy(css="button[type=\"submit\"]")
    private WebElement submitButton;
    @FindBy(id="remove-mobile")
    private WebElement removeLink;

    private String getPath() {
        return AccountService.totpUrl((UriBuilder)UriBuilder.fromUri((URI)this.getAuthServerRoot())).build(new Object[]{"test"}).toString();
    }

    public void configure(String totp) {
        this.totpInput.sendKeys(new CharSequence[]{totp});
        this.submitButton.click();
    }

    public String getTotpSecret() {
        return this.totpSecret.getAttribute("value");
    }

    @Override
    public boolean isCurrent() {
        return this.driver.getTitle().contains("Account Management") && this.driver.getCurrentUrl().split("\\?")[0].endsWith("/account/totp");
    }

    @Override
    public void open() {
        this.driver.navigate().to(this.getPath());
    }

    public void removeTotp() {
        this.removeLink.click();
    }
}

