/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.pages;

import javax.ws.rs.core.UriBuilder;
import org.keycloak.protocol.oidc.OIDCLoginProtocolService;
import org.keycloak.testsuite.pages.AbstractPage;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

public class AppPage
extends AbstractPage {
    public static final String AUTH_SERVER_URL = "http://localhost:8180/auth";
    public static final String baseUrl = "http://localhost:8180/auth/realms/master/app/auth";
    @FindBy(id="account")
    private WebElement accountLink;

    @Override
    public void open() {
        this.driver.navigate().to(baseUrl);
    }

    @Override
    public boolean isCurrent() {
        return this.driver.getCurrentUrl().startsWith(baseUrl);
    }

    public RequestType getRequestType() {
        return RequestType.valueOf(this.driver.getTitle());
    }

    public void openAccount() {
        this.accountLink.click();
    }

    public void logout() {
        String logoutUri = OIDCLoginProtocolService.logoutUrl((UriBuilder)UriBuilder.fromUri((String)AUTH_SERVER_URL)).queryParam("redirect_uri", new Object[]{baseUrl}).build(new Object[]{"test"}).toString();
        this.driver.navigate().to(logoutUri);
    }

    public static enum RequestType {
        AUTH_RESPONSE,
        LOGOUT_REQUEST,
        APP_REQUEST;

    }
}

