/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.pages;

import org.jboss.arquillian.test.api.ArquillianResource;
import org.keycloak.testsuite.pages.AbstractPage;
import org.keycloak.testsuite.util.OAuthClient;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

public class LoginPage
extends AbstractPage {
    @ArquillianResource
    protected OAuthClient oauth;
    @FindBy(id="username")
    private WebElement usernameInput;
    @FindBy(id="password")
    private WebElement passwordInput;
    @FindBy(id="totp")
    private WebElement totp;
    @FindBy(id="rememberMe")
    private WebElement rememberMe;
    @FindBy(name="login")
    private WebElement submitButton;
    @FindBy(name="cancel")
    private WebElement cancelButton;
    @FindBy(linkText="Register")
    private WebElement registerLink;
    @FindBy(linkText="Forgot Password?")
    private WebElement resetPasswordLink;
    @FindBy(linkText="Username")
    private WebElement recoverUsernameLink;
    @FindBy(className="alert-error")
    private WebElement loginErrorMessage;
    @FindBy(className="alert-warning")
    private WebElement loginWarningMessage;
    @FindBy(className="alert-success")
    private WebElement loginSuccessMessage;
    @FindBy(className="alert-info")
    private WebElement loginInfoMessage;
    @FindBy(id="kc-current-locale-link")
    private WebElement languageText;
    @FindBy(id="kc-locale-dropdown")
    private WebElement localeDropdown;

    public void login(String username, String password) {
        this.usernameInput.clear();
        this.usernameInput.sendKeys(new CharSequence[]{username});
        this.passwordInput.clear();
        this.passwordInput.sendKeys(new CharSequence[]{password});
        this.submitButton.click();
    }

    public void login(String password) {
        this.passwordInput.clear();
        this.passwordInput.sendKeys(new CharSequence[]{password});
        this.submitButton.click();
    }

    public void missingPassword(String username) {
        this.usernameInput.clear();
        this.usernameInput.sendKeys(new CharSequence[]{username});
        this.passwordInput.clear();
        this.submitButton.click();
    }

    public void missingUsername() {
        this.usernameInput.clear();
        this.submitButton.click();
    }

    public String getUsername() {
        return this.usernameInput.getAttribute("value");
    }

    public boolean isUsernameInputEnabled() {
        return this.usernameInput.isEnabled();
    }

    public String getPassword() {
        return this.passwordInput.getAttribute("value");
    }

    public void cancel() {
        this.cancelButton.click();
    }

    public String getError() {
        return this.loginErrorMessage != null ? this.loginErrorMessage.getText() : null;
    }

    public String getSuccessMessage() {
        return this.loginSuccessMessage != null ? this.loginSuccessMessage.getText() : null;
    }

    public String getInfoMessage() {
        return this.loginInfoMessage != null ? this.loginInfoMessage.getText() : null;
    }

    @Override
    public boolean isCurrent() {
        return this.driver.getTitle().equals("Log in to test") || this.driver.getTitle().equals("Anmeldung bei test");
    }

    public void clickRegister() {
        this.registerLink.click();
    }

    public void clickSocial(String providerId) {
        WebElement socialButton = this.findSocialButton(providerId);
        socialButton.click();
    }

    public WebElement findSocialButton(String providerId) {
        String id = "zocial-" + providerId;
        return this.driver.findElement(By.id((String)id));
    }

    public void resetPassword() {
        this.resetPasswordLink.click();
    }

    public void recoverUsername() {
        this.recoverUsernameLink.click();
    }

    public void setRememberMe(boolean enable) {
        boolean current = this.rememberMe.isSelected();
        if (current != enable) {
            this.rememberMe.click();
        }
    }

    public boolean isRememberMeChecked() {
        return this.rememberMe.isSelected();
    }

    @Override
    public void open() {
        this.oauth.openLoginForm();
        this.assertCurrent();
    }

    public String getLanguageDropdownText() {
        return this.languageText.getText();
    }

    public void openLanguage(String language) {
        WebElement langLink = this.localeDropdown.findElement(By.xpath((String)("//a[text()='" + language + "']")));
        String url = langLink.getAttribute("href");
        this.driver.navigate().to(url);
    }
}

