/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.pages;

import org.keycloak.testsuite.pages.AbstractPage;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

public class LoginUpdateProfilePage
extends AbstractPage {
    @FindBy(id="firstName")
    private WebElement firstNameInput;
    @FindBy(id="lastName")
    private WebElement lastNameInput;
    @FindBy(id="email")
    private WebElement emailInput;
    @FindBy(css="input[type=\"submit\"]")
    private WebElement submitButton;
    @FindBy(className="alert-error")
    private WebElement loginErrorMessage;

    public void update(String firstName, String lastName, String email) {
        this.firstNameInput.clear();
        this.firstNameInput.sendKeys(new CharSequence[]{firstName});
        this.lastNameInput.clear();
        this.lastNameInput.sendKeys(new CharSequence[]{lastName});
        this.emailInput.clear();
        this.emailInput.sendKeys(new CharSequence[]{email});
        this.submitButton.click();
    }

    public String getError() {
        return this.loginErrorMessage != null ? this.loginErrorMessage.getText() : null;
    }

    public String getFirstName() {
        return this.firstNameInput.getAttribute("value");
    }

    public String getLastName() {
        return this.lastNameInput.getAttribute("value");
    }

    public String getEmail() {
        return this.emailInput.getAttribute("value");
    }

    @Override
    public boolean isCurrent() {
        return this.driver.getTitle().equals("Update Account Information");
    }

    @Override
    public void open() {
        throw new UnsupportedOperationException();
    }
}

