/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.pages;

import org.junit.Assert;
import org.keycloak.testsuite.pages.AbstractPage;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

public class RegisterPage
extends AbstractPage {
    @FindBy(id="firstName")
    private WebElement firstNameInput;
    @FindBy(id="lastName")
    private WebElement lastNameInput;
    @FindBy(id="email")
    private WebElement emailInput;
    @FindBy(id="username")
    private WebElement usernameInput;
    @FindBy(id="password")
    private WebElement passwordInput;
    @FindBy(id="password-confirm")
    private WebElement passwordConfirmInput;
    @FindBy(css="input[type=\"submit\"]")
    private WebElement submitButton;
    @FindBy(className="alert-error")
    private WebElement loginErrorMessage;
    @FindBy(className="instruction")
    private WebElement loginInstructionMessage;

    public void register(String firstName, String lastName, String email, String username, String password, String passwordConfirm) {
        this.firstNameInput.clear();
        if (firstName != null) {
            this.firstNameInput.sendKeys(new CharSequence[]{firstName});
        }
        this.lastNameInput.clear();
        if (lastName != null) {
            this.lastNameInput.sendKeys(new CharSequence[]{lastName});
        }
        this.emailInput.clear();
        if (email != null) {
            this.emailInput.sendKeys(new CharSequence[]{email});
        }
        this.usernameInput.clear();
        if (username != null) {
            this.usernameInput.sendKeys(new CharSequence[]{username});
        }
        this.passwordInput.clear();
        if (password != null) {
            this.passwordInput.sendKeys(new CharSequence[]{password});
        }
        this.passwordConfirmInput.clear();
        if (passwordConfirm != null) {
            this.passwordConfirmInput.sendKeys(new CharSequence[]{passwordConfirm});
        }
        this.submitButton.click();
    }

    public void registerWithEmailAsUsername(String firstName, String lastName, String email, String password, String passwordConfirm) {
        this.firstNameInput.clear();
        if (firstName != null) {
            this.firstNameInput.sendKeys(new CharSequence[]{firstName});
        }
        this.lastNameInput.clear();
        if (lastName != null) {
            this.lastNameInput.sendKeys(new CharSequence[]{lastName});
        }
        this.emailInput.clear();
        if (email != null) {
            this.emailInput.sendKeys(new CharSequence[]{email});
        }
        try {
            this.usernameInput.clear();
            Assert.fail((String)"Form must be without username field");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        this.passwordInput.clear();
        if (password != null) {
            this.passwordInput.sendKeys(new CharSequence[]{password});
        }
        this.passwordConfirmInput.clear();
        if (passwordConfirm != null) {
            this.passwordConfirmInput.sendKeys(new CharSequence[]{passwordConfirm});
        }
        this.submitButton.click();
    }

    public String getError() {
        return this.loginErrorMessage != null ? this.loginErrorMessage.getText() : null;
    }

    public String getInstruction() {
        try {
            return this.loginInstructionMessage != null ? this.loginInstructionMessage.getText() : null;
        }
        catch (NoSuchElementException noSuchElementException) {
            return null;
        }
    }

    public String getFirstName() {
        return this.firstNameInput.getAttribute("value");
    }

    public String getLastName() {
        return this.lastNameInput.getAttribute("value");
    }

    public String getEmail() {
        return this.emailInput.getAttribute("value");
    }

    public String getUsername() {
        return this.usernameInput.getAttribute("value");
    }

    public String getPassword() {
        return this.passwordInput.getAttribute("value");
    }

    public String getPasswordConfirm() {
        return this.passwordConfirmInput.getAttribute("value");
    }

    @Override
    public boolean isCurrent() {
        return this.driver.getTitle().equals("Register with test");
    }

    @Override
    public void open() {
        throw new UnsupportedOperationException();
    }
}

