/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.jboss.logging.Logger;
import org.keycloak.models.UserFederationProvider;
import org.keycloak.testsuite.util.IOUtil;

public class LDAPTestConfiguration {
    private static final Logger log = Logger.getLogger(LDAPTestConfiguration.class);
    private int sleepTime;
    private boolean startEmbeddedLdapServer = true;
    private boolean caseSensitiveLogin = true;
    private Map<String, String> config;
    protected static final Map<String, String> PROP_MAPPINGS = new HashMap<String, String>();
    protected static final Map<String, String> DEFAULT_VALUES = new HashMap<String, String>();

    public static LDAPTestConfiguration readConfiguration(String connectionPropertiesLocation) {
        LDAPTestConfiguration ldapTestConfiguration = new LDAPTestConfiguration();
        ldapTestConfiguration.loadConnectionProperties(connectionPropertiesLocation);
        return ldapTestConfiguration;
    }

    public static String getResource(String resourceName) {
        return new File(IOUtil.PROJECT_BUILD_DIRECTORY, "dependency/kerberos/" + resourceName).getAbsolutePath();
    }

    protected void loadConnectionProperties(String connectionPropertiesLocation) {
        PropertiesConfiguration p;
        InputStream is;
        try {
            if (connectionPropertiesLocation.startsWith("classpath:")) {
                String classPathLocation = connectionPropertiesLocation.replace("classpath:", "");
                log.info((Object)("Reading LDAP configuration from classpath from: " + classPathLocation));
                is = LDAPTestConfiguration.class.getClassLoader().getResourceAsStream(classPathLocation);
            } else {
                String file = LDAPTestConfiguration.getResource(connectionPropertiesLocation);
                log.info((Object)("Reading LDAP configuration from: " + connectionPropertiesLocation));
                is = new FileInputStream(file);
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        try {
            p = new PropertiesConfiguration();
            p.setDelimiterParsingDisabled(true);
            p.load(is);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.config = new HashMap<String, String>();
        for (Map.Entry<String, String> property : PROP_MAPPINGS.entrySet()) {
            String propertyName = property.getKey();
            String configName = property.getValue();
            String value = p.getString(configName);
            if (value == null) {
                value = DEFAULT_VALUES.get(propertyName);
            }
            this.config.put(propertyName, value);
        }
        this.startEmbeddedLdapServer = p.getBoolean("idm.test.ldap.start.embedded.ldap.server", true);
        this.sleepTime = p.getInteger("idm.test.ldap.sleepTime", Integer.valueOf(1000));
        this.caseSensitiveLogin = p.getBoolean("idm.test.kerberos.caseSensitiveLogin", true);
        log.info((Object)("Start embedded server: " + this.startEmbeddedLdapServer));
        log.info((Object)("Read config: " + this.config));
    }

    public Map<String, String> getLDAPConfig() {
        return this.config;
    }

    public boolean isStartEmbeddedLdapServer() {
        return this.startEmbeddedLdapServer;
    }

    public int getSleepTime() {
        return this.sleepTime;
    }

    public boolean isCaseSensitiveLogin() {
        return this.caseSensitiveLogin;
    }

    static {
        PROP_MAPPINGS.put("connectionUrl", "idm.test.ldap.connection.url");
        PROP_MAPPINGS.put("baseDn", "idm.test.ldap.base.dn");
        PROP_MAPPINGS.put("usersDn", "idm.test.ldap.user.dn.suffix");
        PROP_MAPPINGS.put("bindDn", "idm.test.ldap.bind.dn");
        PROP_MAPPINGS.put("bindCredential", "idm.test.ldap.bind.credential");
        PROP_MAPPINGS.put("vendor", "idm.test.ldap.vendor");
        PROP_MAPPINGS.put("connectionPooling", "idm.test.ldap.connection.pooling");
        PROP_MAPPINGS.put("pagination", "idm.test.ldap.pagination");
        PROP_MAPPINGS.put("batchSizeForSync", "idm.test.ldap.batch.size.for.sync");
        PROP_MAPPINGS.put("usernameLDAPAttribute", "idm.test.ldap.username.ldap.attribute");
        PROP_MAPPINGS.put("rdnLDAPAttribute", "idm.test.ldap.rdn.ldap.attribute");
        PROP_MAPPINGS.put("userObjectClasses", "idm.test.ldap.user.object.classes");
        PROP_MAPPINGS.put("editMode", "idm.test.ldap.edit.mode");
        PROP_MAPPINGS.put("allowKerberosAuthentication", "idm.test.kerberos.allow.kerberos.authentication");
        PROP_MAPPINGS.put("kerberosRealm", "idm.test.kerberos.realm");
        PROP_MAPPINGS.put("serverPrincipal", "idm.test.kerberos.server.principal");
        PROP_MAPPINGS.put("keyTab", "idm.test.kerberos.keytab");
        PROP_MAPPINGS.put("debug", "idm.test.kerberos.debug");
        PROP_MAPPINGS.put("allowPasswordAuthentication", "idm.test.kerberos.allow.password.authentication");
        PROP_MAPPINGS.put("updateProfileFirstLogin", "idm.test.kerberos.update.profile.first.login");
        PROP_MAPPINGS.put("useKerberosForPasswordAuthentication", "idm.test.kerberos.use.kerberos.for.password.authentication");
        DEFAULT_VALUES.put("connectionUrl", "ldap://localhost:10389");
        DEFAULT_VALUES.put("baseDn", "dc=keycloak,dc=org");
        DEFAULT_VALUES.put("usersDn", "ou=People,dc=keycloak,dc=org");
        DEFAULT_VALUES.put("bindDn", "uid=admin,ou=system");
        DEFAULT_VALUES.put("bindCredential", "secret");
        DEFAULT_VALUES.put("vendor", "other");
        DEFAULT_VALUES.put("connectionPooling", "true");
        DEFAULT_VALUES.put("pagination", "true");
        DEFAULT_VALUES.put("batchSizeForSync", String.valueOf(1000));
        DEFAULT_VALUES.put("usernameLDAPAttribute", null);
        DEFAULT_VALUES.put("userObjectClasses", null);
        DEFAULT_VALUES.put("editMode", UserFederationProvider.EditMode.READ_ONLY.toString());
        DEFAULT_VALUES.put("allowKerberosAuthentication", "false");
        DEFAULT_VALUES.put("kerberosRealm", "KEYCLOAK.ORG");
        DEFAULT_VALUES.put("serverPrincipal", "HTTP/localhost@KEYCLOAK.ORG");
        String keyTabPath = LDAPTestConfiguration.getResource("http.keytab");
        DEFAULT_VALUES.put("keyTab", keyTabPath);
        DEFAULT_VALUES.put("debug", "true");
        DEFAULT_VALUES.put("allowPasswordAuthentication", "true");
        DEFAULT_VALUES.put("updateProfileFirstLogin", "true");
        DEFAULT_VALUES.put("useKerberosForPasswordAuthentication", "false");
    }
}

