/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.util;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.jboss.logging.Logger;

public class LogChecker {
    private static final Logger log = Logger.getLogger(LogChecker.class);
    private static final String[] IGNORED = new String[]{".*Jetty ALPN support not found.*"};

    public static void checkServerLog(File logFile) throws IOException {
        String[] logContent;
        log.info((Object)String.format("Checking server log: '%s'", logFile.getAbsolutePath()));
        for (String logText : logContent = FileUtils.readFileToString((File)logFile).split("\n")) {
            boolean containsError;
            boolean bl = containsError = logText.contains("ERROR") || logText.contains("SEVERE") || logText.contains("Exception ");
            if (!containsError) continue;
            boolean ignore = false;
            for (String i : IGNORED) {
                if (!logText.matches(i)) continue;
                ignore = true;
                break;
            }
            if (ignore) continue;
            throw new RuntimeException(String.format("Server log file contains ERROR: '%s'", logText));
        }
    }

    public static void checkJBossServerLog(String jbossHome) throws IOException {
        boolean domain = System.getProperty("auth.server.config.property.name", "standalone").contains("domain");
        if (domain) {
            LogChecker.checkServerLog(new File(jbossHome + "/domain/log/process-controller.log"));
            LogChecker.checkServerLog(new File(jbossHome + "/domain/log/host-controller.log"));
            LogChecker.checkServerLog(new File(jbossHome + "/domain/servers/load-balancer/log/server.log"));
            LogChecker.checkServerLog(new File(jbossHome + "/domain/servers/server-one/log/server.log"));
        } else {
            LogChecker.checkServerLog(new File(jbossHome + "/standalone/log/server.log"));
        }
    }
}

