/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.util;

import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.MimeMessage;
import org.junit.Assert;

public class MailUtils {
    private static Pattern mailPattern = Pattern.compile("http[^\\s\"]*");

    public static String getLink(String body) {
        Matcher matcher = mailPattern.matcher(body);
        if (matcher.find()) {
            return matcher.group();
        }
        throw new AssertionError((Object)("No link found in " + body));
    }

    public static String getPasswordResetEmailLink(MimeMessage message) throws IOException, MessagingException {
        Multipart multipart = (Multipart)message.getContent();
        String textContentType = multipart.getBodyPart(0).getContentType();
        Assert.assertEquals((Object)"text/plain; charset=UTF-8", (Object)textContentType);
        String textBody = (String)multipart.getBodyPart(0).getContent();
        String textChangePwdUrl = MailUtils.getLink(textBody);
        String htmlContentType = multipart.getBodyPart(1).getContentType();
        Assert.assertEquals((Object)"text/html; charset=UTF-8", (Object)htmlContentType);
        String htmlBody = (String)multipart.getBodyPart(1).getContent();
        String htmlChangePwdUrl = MailUtils.getLink(htmlBody);
        Assert.assertEquals((Object)htmlChangePwdUrl, (Object)textChangePwdUrl);
        return htmlChangePwdUrl;
    }
}

