/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.util;

import com.google.common.base.Function;
import java.util.regex.Pattern;
import org.jboss.logging.Logger;
import org.keycloak.testsuite.util.WaitUtils;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.ie.InternetExplorerDriver;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.WebDriverWait;

public final class URLUtils {
    public static void navigateToUri(WebDriver driver, String uri, boolean waitForMatch) {
        URLUtils.navigateToUri(driver, uri, waitForMatch, true);
    }

    private static void navigateToUri(WebDriver driver, String uri, boolean waitForMatch, boolean enableIEWorkaround) {
        Logger log = Logger.getLogger(URLUtils.class);
        log.info((Object)"starting navigation");
        if (driver instanceof InternetExplorerDriver && driver.getCurrentUrl().equals(uri)) {
            log.info((Object)"IE workaround: target URL equals current URL - refreshing the page");
            driver.navigate().refresh();
        }
        WaitUtils.waitForPageToLoad(driver);
        log.info((Object)("current URL:  " + driver.getCurrentUrl()));
        log.info((Object)("navigating to " + uri));
        driver.navigate().to(uri);
        if (waitForMatch) {
            String loginUrl = "^[^\\?]+/auth/realms/[^/]+/(protocol|login-actions).+$";
            try {
                new WebDriverWait(driver, 3L).until((Function)ExpectedConditions.or((ExpectedCondition[])new ExpectedCondition[]{ExpectedConditions.urlMatches((String)("^" + Pattern.quote(uri) + ".*$")), ExpectedConditions.urlMatches((String)loginUrl)}));
            }
            catch (TimeoutException e) {
                log.info((Object)"new current URL doesn't start with desired URL");
            }
        }
        WaitUtils.waitForPageToLoad(driver);
        log.info((Object)("new current URL:  " + driver.getCurrentUrl()));
        if (enableIEWorkaround && driver instanceof InternetExplorerDriver && (driver.getCurrentUrl().matches("^[^#]+/#state=[^#/&]+&code=[^#/&]+$") || driver.getCurrentUrl().matches("^.+/auth/admin/[^/]+/console/$"))) {
            log.info((Object)"IE workaround: reloading the page after deleting the cookies...");
            URLUtils.navigateToUri(driver, uri, waitForMatch, false);
        } else {
            log.info((Object)"navigation complete");
        }
    }

    public static boolean currentUrlEqual(WebDriver driver, String url) {
        return URLUtils.urlCheck(driver, ExpectedConditions.urlToBe((String)url));
    }

    public static boolean currentUrlDoesntEqual(WebDriver driver, String url) {
        return URLUtils.urlCheck(driver, ExpectedConditions.not((ExpectedCondition)ExpectedConditions.urlToBe((String)url)));
    }

    public static boolean currentUrlStartWith(WebDriver driver, String url) {
        return URLUtils.urlCheck(driver, ExpectedConditions.urlMatches((String)("^" + Pattern.quote(url) + ".*$")));
    }

    public static boolean currentUrlDoesntStartWith(WebDriver driver, String url) {
        return URLUtils.urlCheck(driver, ExpectedConditions.urlMatches((String)("^(?!" + Pattern.quote(url) + ").+$")));
    }

    private static boolean urlCheck(WebDriver driver, ExpectedCondition condition) {
        return URLUtils.urlCheck(driver, condition, false);
    }

    private static boolean urlCheck(WebDriver driver, ExpectedCondition condition, boolean secondTry) {
        Logger log = Logger.getLogger(URLUtils.class);
        try {
            new WebDriverWait(driver, 1L, 100L).until((Function)condition);
        }
        catch (TimeoutException e) {
            if (driver instanceof InternetExplorerDriver && !secondTry) {
                log.info((Object)"IE workaround: checking URL failed at first attempt - refreshing the page and trying one more time...");
                driver.navigate().refresh();
                URLUtils.urlCheck(driver, condition, true);
            }
            return false;
        }
        return true;
    }
}

