/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework;

class AttributeTokenizer {
    String s;
    int length;
    int pos = 0;

    AttributeTokenizer(String input) {
        this.s = input;
        this.length = this.s.length();
    }

    String getWord() {
        this.skipWhite();
        boolean backslash = false;
        boolean quote = false;
        StringBuffer val = new StringBuffer();
        int end = 0;
        block5: while (this.pos < this.length) {
            if (backslash) {
                backslash = false;
                val.append(this.s.charAt(this.pos));
            } else {
                char c = this.s.charAt(this.pos);
                switch (c) {
                    case '\"': {
                        quote = !quote;
                        end = val.length();
                        break;
                    }
                    case '\\': {
                        backslash = true;
                        break;
                    }
                    case ',': 
                    case ':': 
                    case ';': 
                    case '=': {
                        if (!quote) break block5;
                    }
                    default: {
                        val.append(c);
                        if (Character.isWhitespace(c)) break;
                        end = val.length();
                    }
                }
            }
            ++this.pos;
        }
        if (quote || backslash || end == 0) {
            return null;
        }
        char[] res = new char[end];
        val.getChars(0, end, res, 0);
        return new String(res);
    }

    String getKey() {
        String res;
        if (this.pos >= this.length) {
            return null;
        }
        int save = this.pos;
        if (this.s.charAt(this.pos) == ';') {
            ++this.pos;
        }
        if ((res = this.getWord()) != null) {
            if (this.pos == this.length) {
                return res;
            }
            char c = this.s.charAt(this.pos);
            if (c == ';' || c == ',') {
                return res;
            }
        }
        this.pos = save;
        return null;
    }

    String getParam() {
        if (this.pos == this.length || this.s.charAt(this.pos) != ';') {
            return null;
        }
        int save = this.pos++;
        String res = this.getWord();
        if (res != null) {
            if (this.pos < this.length && this.s.charAt(this.pos) == '=') {
                return res;
            }
            if (this.pos + 1 < this.length && this.s.charAt(this.pos) == ':' && this.s.charAt(this.pos + 1) == '=') {
                return res;
            }
        }
        this.pos = save;
        return null;
    }

    boolean isDirective() {
        if (this.pos + 1 < this.length && this.s.charAt(this.pos) == ':') {
            ++this.pos;
            return true;
        }
        return false;
    }

    String getValue() {
        if (this.s.charAt(this.pos) != '=') {
            return null;
        }
        int save = this.pos++;
        this.skipWhite();
        String val = this.getWord();
        if (val == null) {
            this.pos = save;
            return null;
        }
        return val;
    }

    boolean getEntryEnd() {
        int save = this.pos;
        this.skipWhite();
        if (this.pos == this.length) {
            return true;
        }
        if (this.s.charAt(this.pos) == ',') {
            ++this.pos;
            return true;
        }
        this.pos = save;
        return false;
    }

    boolean getEnd() {
        int save = this.pos;
        this.skipWhite();
        if (this.pos == this.length) {
            return true;
        }
        this.pos = save;
        return false;
    }

    String getRest() {
        String res = this.s.substring(this.pos).trim();
        return res.length() == 0 ? "<END OF LINE>" : res;
    }

    private void skipWhite() {
        while (this.pos < this.length && Character.isWhitespace(this.s.charAt(this.pos))) {
            ++this.pos;
        }
    }
}

