/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Dictionary;
import java.util.List;
import org.knopflerfish.framework.BundleImpl;
import org.knopflerfish.framework.FilterImpl;
import org.knopflerfish.framework.Framework;
import org.knopflerfish.framework.ServiceReferenceImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleListener;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

public class BundleContextImpl
implements BundleContext {
    private final Framework framework;
    private BundleImpl bundle;

    public BundleContextImpl(BundleImpl bundle) {
        this.bundle = bundle;
        this.framework = bundle.framework;
    }

    public String getProperty(String key) {
        this.isBCvalid();
        return Framework.getProperty(key);
    }

    public Bundle installBundle(String location) throws BundleException {
        this.isBCvalid();
        return this.framework.bundles.install(location, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bundle installBundle(String location, InputStream in) throws BundleException {
        BundleImpl bundleImpl;
        block5: {
            try {
                this.isBCvalid();
                bundleImpl = this.framework.bundles.install(location, in);
                Object var5_4 = null;
                if (in == null) break block5;
            }
            catch (Throwable throwable) {
                block6: {
                    Object var5_5 = null;
                    if (in == null) break block6;
                    try {
                        in.close();
                    }
                    catch (IOException ignore) {}
                }
                throw throwable;
            }
            try {
                in.close();
            }
            catch (IOException ignore) {
                // empty catch block
            }
        }
        return bundleImpl;
    }

    public Bundle getBundle() {
        this.isBCvalid();
        return this.bundle;
    }

    public Bundle getBundle(long id) {
        return this.framework.bundles.getBundle(id);
    }

    public Bundle[] getBundles() {
        List bl = this.framework.bundles.getBundles();
        return bl.toArray(new Bundle[bl.size()]);
    }

    public void addServiceListener(ServiceListener listener, String filter) throws InvalidSyntaxException {
        this.isBCvalid();
        this.framework.listeners.addServiceListener(this.bundle, listener, filter);
    }

    public void addServiceListener(ServiceListener listener) {
        this.isBCvalid();
        try {
            this.framework.listeners.addServiceListener(this.bundle, listener, null);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            // empty catch block
        }
    }

    public void removeServiceListener(ServiceListener listener) {
        this.isBCvalid();
        this.framework.listeners.removeServiceListener(this.bundle, listener);
    }

    public void addBundleListener(BundleListener listener) {
        this.isBCvalid();
        this.framework.listeners.addBundleListener(this.bundle, listener);
    }

    public void removeBundleListener(BundleListener listener) {
        this.isBCvalid();
        this.framework.listeners.removeBundleListener(this.bundle, listener);
    }

    public void addFrameworkListener(FrameworkListener listener) {
        this.isBCvalid();
        this.framework.listeners.addFrameworkListener(this.bundle, listener);
    }

    public void removeFrameworkListener(FrameworkListener listener) {
        this.isBCvalid();
        this.framework.listeners.removeFrameworkListener(this.bundle, listener);
    }

    public ServiceRegistration registerService(String[] clazzes, Object service, Dictionary properties) {
        this.isBCvalid();
        String[] classes = (String[])clazzes.clone();
        return this.framework.services.register(this.bundle, classes, service, properties);
    }

    public ServiceRegistration registerService(String clazz, Object service, Dictionary properties) {
        this.isBCvalid();
        String[] classes = new String[]{clazz};
        return this.framework.services.register(this.bundle, classes, service, properties);
    }

    public ServiceReference[] getServiceReferences(String clazz, String filter) throws InvalidSyntaxException {
        this.isBCvalid();
        return this.framework.services.get(clazz, filter, this.bundle, true);
    }

    public ServiceReference[] getAllServiceReferences(String clazz, String filter) throws InvalidSyntaxException {
        this.isBCvalid();
        return this.framework.services.get(clazz, filter, null, false);
    }

    public ServiceReference getServiceReference(String clazz) {
        this.isBCvalid();
        if (this.framework.perm.okGetServicePerm(clazz)) {
            return this.framework.services.get(this.bundle, clazz);
        }
        return null;
    }

    public Object getService(ServiceReference reference) {
        this.isBCvalid();
        if (reference == null) {
            throw new NullPointerException("null ServiceReference is not valid input to getService()");
        }
        return ((ServiceReferenceImpl)reference).getService(this.bundle);
    }

    public boolean ungetService(ServiceReference reference) {
        this.isBCvalid();
        if (reference == null) {
            throw new NullPointerException("null ServiceReference is not valid input to ungetService()");
        }
        return ((ServiceReferenceImpl)reference).ungetService(this.bundle, true);
    }

    public File getDataFile(String filename) {
        this.isBCvalid();
        File dataRoot = this.bundle.getDataRoot();
        if (dataRoot != null) {
            if (!dataRoot.exists()) {
                dataRoot.mkdirs();
            }
            return new File(dataRoot, filename);
        }
        return null;
    }

    public Filter createFilter(String filter) throws InvalidSyntaxException {
        this.isBCvalid();
        return new FilterImpl(filter);
    }

    void invalidate() {
        this.bundle = null;
    }

    void isBCvalid() {
        if (this.bundle == null) {
            throw new IllegalStateException("This bundle context is no longer valid");
        }
    }
}

