/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework;

import java.util.Dictionary;
import java.util.Hashtable;
import org.knopflerfish.framework.LDAPExpr;
import org.knopflerfish.framework.PropertiesDictionary;
import org.knopflerfish.framework.ServiceReferenceImpl;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class FilterImpl
implements Filter {
    private String filter = null;
    private LDAPExpr ldap;

    public FilterImpl(String filter) throws InvalidSyntaxException {
        this.ldap = new LDAPExpr(filter);
    }

    public boolean match(ServiceReference reference) {
        if (reference instanceof ServiceReferenceImpl) {
            return this.ldap.evaluate(((ServiceReferenceImpl)reference).getProperties(), false);
        }
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        String[] keys = reference.getPropertyKeys();
        for (int i = 0; i < keys.length; ++i) {
            props.put(keys[i], reference.getProperty(keys[i]));
        }
        return this.ldap.evaluate(props, false);
    }

    public boolean match(Dictionary dictionary) {
        return this.ldap.evaluate(new PropertiesDictionary(dictionary), false);
    }

    public boolean matchCase(Dictionary dictionary) {
        return this.ldap.evaluate(new PropertiesDictionary(dictionary), true);
    }

    public String toString() {
        if (this.filter == null) {
            this.filter = this.ldap.toString();
        }
        return this.filter;
    }

    public boolean equals(Object obj) {
        return this.toString().equals(obj.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }
}

