/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.URL;
import java.net.URLConnection;
import java.security.ProtectionDomain;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.knopflerfish.framework.BundleContextImpl;
import org.knopflerfish.framework.BundleImpl;
import org.knopflerfish.framework.BundleStorage;
import org.knopflerfish.framework.BundleURLStreamHandler;
import org.knopflerfish.framework.Bundles;
import org.knopflerfish.framework.Debug;
import org.knopflerfish.framework.FileTree;
import org.knopflerfish.framework.Listeners;
import org.knopflerfish.framework.PackageAdminImpl;
import org.knopflerfish.framework.Packages;
import org.knopflerfish.framework.PermissionOps;
import org.knopflerfish.framework.ReferenceURLStreamHandler;
import org.knopflerfish.framework.SecurePermissionOps;
import org.knopflerfish.framework.ServiceContentHandlerFactory;
import org.knopflerfish.framework.ServiceURLStreamHandlerFactory;
import org.knopflerfish.framework.Services;
import org.knopflerfish.framework.StartLevelImpl;
import org.knopflerfish.framework.SystemBundle;
import org.knopflerfish.framework.Util;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkEvent;

public class Framework {
    protected static Map props = new HashMap();
    private static Set volatileProperties = new HashSet();
    static final String SPEC_VERSION = "1.3";
    boolean active;
    boolean shuttingdown;
    public Bundles bundles;
    Listeners listeners;
    Packages packages;
    Services services;
    PermissionOps perm;
    SystemBundle systemBundle;
    BundleContextImpl systemBC;
    BundleStorage storage;
    FileTree dataStorage;
    Object mainHandle;
    StartLevelImpl startLevelService;
    ServiceURLStreamHandlerFactory urlStreamHandlerFactory;
    ServiceContentHandlerFactory contentHandlerFactory;
    static final String TRUE = "true";
    static final String FALSE = "false";
    static final boolean EXIT_ON_SHUTDOWN;
    static final boolean USING_WRAPPER_SCRIPT;
    static final String osArch;
    static final String osName;
    static String osVersion;
    public static final boolean UNREGISTERSERVICE_VALID_DURING_UNREGISTERING;
    static final boolean SETCONTEXTCLASSLOADER;
    static final boolean REGISTERSERVICEURLHANDLER;
    static boolean bIsMemoryStorage;
    static String whichStorageImpl;
    private static final String USESTARTLEVEL_PROP = "org.knopflerfish.startlevel.use";
    private static final String CLASSPATH_DIR = "classpath";
    private static final String BOOT_CLASSPATH_FILE = "boot";
    private static final String FRAMEWORK_CLASSPATH_FILE = "framework";
    private Set eeCacheSet = new HashSet();
    private String eeCache = null;
    static boolean SUPPORTS_EXTENSION_BUNDLES;
    static final int EXIT_CODE_NORMAL = 0;
    static final int EXIT_CODE_RESTART = 200;
    public static int javaVersionMajor;
    public static int javaVersionMinor;
    public static int javaVersionMicro;
    public static final boolean isDoubleCheckedLockingSafe;
    static /* synthetic */ Class class$org$osgi$service$packageadmin$PackageAdmin;
    static /* synthetic */ Class class$org$osgi$service$startlevel$StartLevel;

    public Framework(Object m) throws Exception {
        ProtectionDomain pd = null;
        if (System.getSecurityManager() != null) {
            block7: {
                try {
                    pd = this.getClass().getProtectionDomain();
                }
                catch (Throwable t) {
                    if (!Debug.classLoader) break block7;
                    Debug.println("Failed to get protection domain: " + t);
                }
            }
            this.perm = new SecurePermissionOps(this);
        } else {
            this.perm = new PermissionOps();
        }
        Class<?> storageImpl = Class.forName(whichStorageImpl);
        this.storage = (BundleStorage)storageImpl.newInstance();
        this.dataStorage = Util.getFileStorage("data");
        this.packages = new Packages(this);
        this.listeners = new Listeners(this.perm);
        this.services = new Services(this.perm);
        this.systemBundle = new SystemBundle(this, pd);
        this.systemBC = new BundleContextImpl(this.systemBundle);
        this.bundles = new Bundles(this);
        this.systemBundle.setBundleContext(this.systemBC);
        this.perm.registerService();
        String[] classes = new String[]{(class$org$osgi$service$packageadmin$PackageAdmin == null ? (class$org$osgi$service$packageadmin$PackageAdmin = Framework.class$("org.osgi.service.packageadmin.PackageAdmin")) : class$org$osgi$service$packageadmin$PackageAdmin).getName()};
        this.services.register(this.systemBundle, classes, new PackageAdminImpl(this), null);
        this.registerStartLevel();
        this.urlStreamHandlerFactory = new ServiceURLStreamHandlerFactory(this);
        this.contentHandlerFactory = new ServiceContentHandlerFactory(this);
        this.urlStreamHandlerFactory.setURLStreamHandler("bundle", new BundleURLStreamHandler(this.bundles, this.perm));
        this.urlStreamHandlerFactory.setURLStreamHandler("reference", new ReferenceURLStreamHandler());
        if (REGISTERSERVICEURLHANDLER) {
            try {
                URL.setURLStreamHandlerFactory(this.urlStreamHandlerFactory);
                URLConnection.setContentHandlerFactory(this.contentHandlerFactory);
            }
            catch (Throwable e) {
                Debug.println("Cannot set global URL handlers, continuing without OSGi service URL handler (" + e + ")");
                e.printStackTrace();
            }
        }
        this.bundles.load();
        this.mainHandle = m;
    }

    private void registerStartLevel() {
        String useStartLevel = Framework.getProperty(USESTARTLEVEL_PROP, TRUE);
        if (TRUE.equals(useStartLevel)) {
            if (Debug.startlevel) {
                Debug.println("[using startlevel service]");
            }
            this.startLevelService = new StartLevelImpl(this);
            this.startLevelService.restoreState();
            this.services.register(this.systemBundle, new String[]{(class$org$osgi$service$startlevel$StartLevel == null ? (class$org$osgi$service$startlevel$StartLevel = Framework.class$("org.osgi.service.startlevel.StartLevel")) : class$org$osgi$service$startlevel$StartLevel).getName()}, this.startLevelService, null);
        }
    }

    public void launch(long startBundle) throws BundleException {
        if (!this.active) {
            this.active = true;
            if (startBundle > 0L) {
                this.startBundle(startBundle);
            } else {
                Iterator i = this.storage.getStartOnLaunchBundles().iterator();
                while (i.hasNext()) {
                    Bundle b = this.bundles.getBundle((String)i.next());
                    try {
                        b.start();
                    }
                    catch (BundleException be) {
                        this.listeners.frameworkError(b, be);
                    }
                }
            }
            if (this.startLevelService != null) {
                this.startLevelService.open();
            }
            this.systemBundle.systemActive();
            this.listeners.frameworkEvent(new FrameworkEvent(1, this.systemBundle, null));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Iterator i;
        if (this.active) {
            this.active = false;
            List slist = this.storage.getStartOnLaunchBundles();
            this.shuttingdown = true;
            this.systemBundle.systemShuttingdown();
            if (this.startLevelService != null) {
                this.startLevelService.shutdown();
            }
            for (int i2 = slist.size() - 1; i2 >= 0; --i2) {
                Bundle b = this.bundles.getBundle((String)slist.get(i2));
                try {
                    if (b == null) continue;
                    Bundle bundle = b;
                    synchronized (bundle) {
                        if (b.getState() == 32) {
                            b.stop();
                        }
                        continue;
                    }
                }
                catch (BundleException be) {
                    this.listeners.frameworkEvent(new FrameworkEvent(2, b, be));
                }
            }
            this.shuttingdown = false;
            List all = this.bundles.getBundles();
            i = all.iterator();
            while (i.hasNext()) {
                ((BundleImpl)i.next()).purge();
            }
        }
        StringBuffer bootClasspath = new StringBuffer();
        StringBuffer frameworkClasspath = new StringBuffer();
        i = this.bundles.getFragmentBundles(this.systemBundle).iterator();
        while (i.hasNext()) {
            BundleImpl eb = (BundleImpl)i.next();
            String path = eb.archive.getJarLocation();
            StringBuffer sb = eb.isBootClassPathExtension() ? bootClasspath : frameworkClasspath;
            sb.append(path);
            if (!i.hasNext()) continue;
            sb.append(File.pathSeparator);
        }
        try {
            FileTree storage = Util.getFileStorage(CLASSPATH_DIR);
            File bcpf = new File(storage, BOOT_CLASSPATH_FILE);
            File fcpf = new File(storage, FRAMEWORK_CLASSPATH_FILE);
            if (bootClasspath.length() > 0) {
                this.saveStringBuffer(bcpf, bootClasspath);
            } else {
                bcpf.delete();
            }
            if (frameworkClasspath.length() > 0) {
                this.saveStringBuffer(fcpf, frameworkClasspath);
            } else {
                fcpf.delete();
            }
        }
        catch (IOException e) {
            System.err.println("Could not save classpath " + e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveStringBuffer(File f, StringBuffer content) throws IOException {
        PrintStream out = null;
        try {
            out = new PrintStream(new FileOutputStream(f));
            out.println(content.toString());
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    public long installBundle(String location, InputStream in) throws BundleException {
        return this.bundles.install((String)location, (InputStream)in).id;
    }

    public void startBundle(long id) throws BundleException {
        Bundle b = this.bundles.getBundle(id);
        if (b == null) {
            throw new BundleException("No such bundle: " + id);
        }
        b.start();
    }

    public void stopBundle(long id) throws BundleException {
        Bundle b = this.bundles.getBundle(id);
        if (b == null) {
            throw new BundleException("No such bundle: " + id);
        }
        b.stop();
    }

    public void uninstallBundle(long id) throws BundleException {
        Bundle b = this.bundles.getBundle(id);
        if (b == null) {
            throw new BundleException("No such bundle: " + id);
        }
        b.uninstall();
    }

    public void updateBundle(long id) throws BundleException {
        Bundle b = this.bundles.getBundle(id);
        if (b == null) {
            throw new BundleException("No such bundle: " + id);
        }
        b.update();
    }

    public String getBundleLocation(long id) {
        Bundle b = this.bundles.getBundle(id);
        if (b != null) {
            return b.getLocation();
        }
        return null;
    }

    public long getBundleId(String location) {
        Bundle b = this.bundles.getBundle(location);
        if (b != null) {
            return b.getBundleId();
        }
        return -1L;
    }

    public FileTree getDataStorage(long id) {
        if (this.dataStorage != null) {
            return new FileTree(this.dataStorage, Long.toString(id));
        }
        return null;
    }

    boolean isValidEE(String ee) {
        int i;
        if ((ee = ee.trim()) == null || "".equals(ee)) {
            return true;
        }
        String fwEE = Framework.getProperty("org.osgi.framework.executionenvironment");
        if (fwEE == null) {
            return true;
        }
        if (!fwEE.equals(this.eeCache)) {
            this.eeCacheSet.clear();
            String[] l = Util.splitwords(fwEE, ",");
            for (i = 0; i < l.length; ++i) {
                this.eeCacheSet.add(l[i]);
            }
            this.eeCache = fwEE;
        }
        String[] eel = Util.splitwords(ee, ",");
        for (i = 0; i < eel.length; ++i) {
            if (!this.eeCacheSet.contains(eel[i])) continue;
            return true;
        }
        return false;
    }

    public static String getProperty(String key) {
        return Framework.getProperty(key, null);
    }

    public static String getProperty(String key, String def) {
        String v = (String)props.get(key);
        if (v != null) {
            return v;
        }
        return System.getProperty(key, def);
    }

    public static void setProperty(String key, String val) {
        if (volatileProperties.contains(key)) {
            System.setProperty(key, val);
        } else {
            props.put(key, val);
        }
    }

    public static void setProperties(Dictionary newProps) {
        Enumeration it = newProps.keys();
        while (it.hasMoreElements()) {
            String key = (String)it.nextElement();
            Framework.setProperty(key, (String)newProps.get(key));
        }
    }

    public static Dictionary getProperties() {
        Hashtable<Object, Object> p = new Hashtable<Object, Object>();
        p.putAll(System.getProperties());
        p.putAll(props);
        return p;
    }

    public static Properties getSystemProperties() {
        return (Properties)((Hashtable)System.getProperties()).clone();
    }

    protected static void initProperties() {
        props = new HashMap();
        whichStorageImpl = "org.knopflerfish.framework.bundlestorage." + Framework.getProperty("org.knopflerfish.framework.bundlestorage", "file") + ".BundleStorageImpl";
        bIsMemoryStorage = whichStorageImpl.equals("org.knopflerfish.framework.bundlestorage.memory.BundleStorageImpl");
        SUPPORTS_EXTENSION_BUNDLES = !bIsMemoryStorage && EXIT_ON_SHUTDOWN && USING_WRAPPER_SCRIPT;
        Framework.setProperty("org.osgi.framework.os.name", System.getProperty("os.name"));
        Framework.setProperty("org.osgi.framework.processor", System.getProperty("os.arch"));
        String ver = System.getProperty("os.version");
        if (ver != null) {
            char c;
            int i;
            int dots = 0;
            for (i = 0; i < ver.length() && (Character.isDigit(c = ver.charAt(i)) || c == '.' && ++dots < 3); ++i) {
            }
            osVersion = ver.substring(0, i);
        }
        Framework.setProperty("org.osgi.framework.os.version", osVersion);
        Framework.setProperty("org.osgi.framework.version", SPEC_VERSION);
        Framework.setProperty("org.osgi.framework.vendor", "Knopflerfish");
        Framework.setProperty("org.osgi.framework.language", Locale.getDefault().getLanguage());
        Framework.setProperty("org.osgi.supports.framework.requirebundle", TRUE);
        Framework.setProperty("org.osgi.supports.framework.fragment", TRUE);
        Framework.setProperty("org.osgi.supports.framework.extension", SUPPORTS_EXTENSION_BUNDLES ? TRUE : FALSE);
        Framework.setProperty("org.osgi.supports.bootclasspath.extension", SUPPORTS_EXTENSION_BUNDLES ? TRUE : FALSE);
        Properties sysProps = Framework.getSystemProperties();
        Framework.setProperties(sysProps);
    }

    public BundleContext getSystemBundleContext() {
        return this.systemBC;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        volatileProperties.add("org.osgi.framework.executionenvironment");
        EXIT_ON_SHUTDOWN = TRUE.equals(Framework.getProperty("org.knopflerfish.framework.exitonshutdown", TRUE));
        USING_WRAPPER_SCRIPT = TRUE.equals(Framework.getProperty("org.knopflerfish.framework.usingwrapperscript", FALSE));
        Framework.initProperties();
        osArch = Framework.getProperty("os.arch");
        osName = Framework.getProperty("os.name");
        UNREGISTERSERVICE_VALID_DURING_UNREGISTERING = TRUE.equals(Framework.getProperty("org.knopflerfish.servicereference.valid.during.unregistering", TRUE));
        SETCONTEXTCLASSLOADER = TRUE.equals(Framework.getProperty("org.knopflerfish.osgi.setcontextclassloader", FALSE));
        REGISTERSERVICEURLHANDLER = TRUE.equals(Framework.getProperty("org.knopflerfish.osgi.registerserviceurlhandler", TRUE));
        javaVersionMajor = -1;
        javaVersionMinor = -1;
        javaVersionMicro = -1;
        String javaVersion = Framework.getProperty("java.version");
        if (null != javaVersion) {
            int endPos;
            int startPos = 0;
            int max = javaVersion.length();
            for (endPos = 0; endPos < max && Character.isDigit(javaVersion.charAt(endPos)); ++endPos) {
            }
            if (startPos < endPos) {
                try {
                    javaVersionMajor = Integer.parseInt(javaVersion.substring(startPos, endPos));
                    for (endPos = startPos = endPos + 1; endPos < max && Character.isDigit(javaVersion.charAt(endPos)); ++endPos) {
                    }
                    if (startPos < endPos) {
                        javaVersionMinor = Integer.parseInt(javaVersion.substring(startPos, endPos));
                        for (endPos = startPos = endPos + 1; endPos < max && Character.isDigit(javaVersion.charAt(endPos)); ++endPos) {
                        }
                        if (startPos < endPos) {
                            javaVersionMicro = Integer.parseInt(javaVersion.substring(startPos, endPos));
                        }
                    }
                }
                catch (NumberFormatException _nfe) {
                    // empty catch block
                }
            }
        }
        isDoubleCheckedLockingSafe = TRUE.equals(Framework.getProperty("org.knopflerfish.framework.is_doublechecked_locking_safe", javaVersionMajor >= 1 && javaVersionMinor >= 5 ? TRUE : FALSE));
    }
}

