/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.knopflerfish.framework.BundleImpl;
import org.knopflerfish.framework.BundlePackages;
import org.knopflerfish.framework.Debug;
import org.knopflerfish.framework.ExportPkg;
import org.knopflerfish.framework.Framework;
import org.knopflerfish.framework.ImportPkg;
import org.knopflerfish.framework.Pkg;
import org.knopflerfish.framework.RequireBundle;
import org.osgi.framework.Bundle;

class Packages {
    final Framework framework;
    private Hashtable packages = new Hashtable();
    private HashSet tempResolved = null;
    private HashMap tempProvider = null;
    private HashMap tempRequired = null;
    private HashSet tempBlackList = null;
    private HashSet tempBackTracked = null;
    int tempBlackListChecks = 0;
    int tempBlackListHits = 0;

    Packages(Framework fw) {
        this.framework = fw;
    }

    synchronized void registerPackages(Iterator exports, Iterator imports) {
        Pkg p;
        Object pe;
        while (exports.hasNext()) {
            pe = (ExportPkg)exports.next();
            p = (Pkg)this.packages.get(((ExportPkg)pe).name);
            if (p == null) {
                p = new Pkg(((ExportPkg)pe).name);
                this.packages.put(((ExportPkg)pe).name, p);
            }
            p.addExporter((ExportPkg)pe);
            if (!Debug.packages) continue;
            Debug.println("registerPackages: export, " + pe);
        }
        while (imports.hasNext()) {
            pe = (ImportPkg)imports.next();
            p = (Pkg)this.packages.get(((ImportPkg)pe).name);
            if (p == null) {
                p = new Pkg(((ImportPkg)pe).name);
                this.packages.put(((ImportPkg)pe).name, p);
            }
            p.addImporter((ImportPkg)pe);
            if (!Debug.packages) continue;
            Debug.println("registerPackages: import, " + pe);
        }
    }

    synchronized ExportPkg registerDynamicImport(ImportPkg ip) {
        if (Debug.packages) {
            Debug.println("registerDynamicImport: try " + ip);
        }
        ExportPkg res = null;
        Pkg p = (Pkg)this.packages.get(ip.name);
        if (p != null) {
            this.tempResolved = new HashSet();
            this.tempProvider = new HashMap();
            this.tempRequired = new HashMap();
            this.tempBlackList = new HashSet();
            this.tempBackTracked = new HashSet();
            this.backTrackUses(ip);
            this.tempBackTracked = null;
            ArrayList<ImportPkg> pkgs = new ArrayList<ImportPkg>(1);
            pkgs.add(ip);
            p.addImporter(ip);
            List r = this.resolvePackages(((AbstractList)pkgs).iterator());
            this.tempBlackList = null;
            if (r.size() == 0) {
                this.registerNewProviders(ip.bpkgs.bundle);
                ip.provider = res = (ExportPkg)this.tempProvider.get(ip.name);
            } else {
                p.removeImporter(ip);
            }
            this.tempProvider = null;
            this.tempRequired = null;
            this.tempResolved = null;
        }
        if (Debug.packages) {
            Debug.println("registerDynamicImport: Done for " + ip.name + ", res = " + res);
        }
        return res;
    }

    synchronized boolean unregisterPackages(List exports, List imports, boolean force) {
        Pkg p;
        ExportPkg ep;
        Iterator i;
        if (!force) {
            i = exports.iterator();
            while (i.hasNext()) {
                ep = (ExportPkg)i.next();
                if (ep.bpkgs.requiredBy != null && ep.bpkgs.requiredBy.size() > 0) {
                    if (Debug.packages) {
                        Debug.println("unregisterPackages: Failed to unregister, " + ep + " is still in use via Require-Bundle.");
                    }
                    this.markAsZombies(exports);
                    return false;
                }
                p = ep.pkg;
                if (!p.providers.contains(ep)) continue;
                Iterator ii = ((AbstractList)p.importers).iterator();
                while (ii.hasNext()) {
                    ImportPkg ip = (ImportPkg)ii.next();
                    if (ep != ip.provider || ep.bpkgs == ip.bpkgs) continue;
                    if (Debug.packages) {
                        Debug.println("unregisterPackages: Failed to unregister, " + ep + " is still in use via import-package.");
                    }
                    this.markAsZombies(exports);
                    return false;
                }
            }
        }
        i = exports.iterator();
        while (i.hasNext()) {
            ep = (ExportPkg)i.next();
            p = ep.pkg;
            if (Debug.packages) {
                Debug.println("unregisterPackages: unregister export - " + ep);
            }
            p.removeExporter(ep);
            if (!p.isEmpty()) continue;
            this.packages.remove(ep.name);
        }
        i = imports.iterator();
        while (i.hasNext()) {
            ImportPkg ip = (ImportPkg)i.next();
            p = ip.pkg;
            if (Debug.packages) {
                Debug.println("unregisterPackages: unregister import - " + ip.pkgString());
            }
            p.removeImporter(ip);
            if (!p.isEmpty()) continue;
            this.packages.remove(ip.name);
        }
        return true;
    }

    synchronized String resolve(BundleImpl bundle, Iterator pkgs) {
        String res;
        if (Debug.packages) {
            Debug.println("resolve: " + bundle);
        }
        if (this.tempResolved != null) {
            if (!this.tempResolved.contains(bundle)) {
                this.framework.listeners.frameworkError(bundle, new Exception("resolve: InternalError1!"));
            }
            return null;
        }
        this.tempResolved = new HashSet();
        BundleImpl sb = this.checkBundleSingleton(bundle);
        if (sb != null) {
            this.tempResolved = null;
            return "Singleton bundle failed to resolve because " + sb + " is already resolved";
        }
        this.tempProvider = new HashMap();
        this.tempRequired = new HashMap();
        this.tempBlackList = new HashSet();
        this.tempResolved.add(bundle);
        String br = this.checkRequireBundle(bundle);
        if (br == null) {
            List failed = this.resolvePackages(pkgs);
            if (failed.size() == 0) {
                this.registerNewProviders(bundle);
                res = null;
            } else {
                StringBuffer r = new StringBuffer("missing package(s) or can not resolve all of the them: ");
                Iterator mi = failed.iterator();
                r.append(((ImportPkg)mi.next()).pkgString());
                while (mi.hasNext()) {
                    r.append(", ");
                    r.append(((ImportPkg)mi.next()).pkgString());
                }
                res = r.toString();
            }
        } else {
            res = "Failed to resolve required bundle or host: " + br;
        }
        this.tempResolved = null;
        this.tempProvider = null;
        this.tempRequired = null;
        this.tempBlackList = null;
        if (Debug.packages) {
            Debug.println("resolve: Done for " + bundle);
        }
        return res;
    }

    Pkg getPkg(String pkg) {
        return (Pkg)this.packages.get(pkg);
    }

    synchronized Collection getZombieAffected(Bundle[] bundles) {
        TreeSet<Bundle> affected = new TreeSet<Bundle>(new Comparator(){

            public int compare(Object o1, Object o2) {
                BundleImpl b1 = (BundleImpl)o1;
                BundleImpl b2 = (BundleImpl)o2;
                int dif = b1.getStartLevel() - b2.getStartLevel();
                if (dif == 0) {
                    dif = (int)(b1.getBundleId() - b2.getBundleId());
                }
                return dif;
            }

            public boolean equals(Object o) {
                return o != null && this.getClass().equals(o.getClass());
            }
        });
        if (bundles == null) {
            if (Debug.packages) {
                Debug.println("getZombieAffected: check - null");
            }
            Iterator i = this.packages.values().iterator();
            while (i.hasNext()) {
                Pkg p = (Pkg)i.next();
                Iterator ps = ((AbstractList)p.exporters).iterator();
                while (ps.hasNext()) {
                    ExportPkg ep = (ExportPkg)ps.next();
                    if (!ep.zombie) continue;
                    if (Debug.packages) {
                        Debug.println("getZombieAffected: found zombie - " + ep);
                    }
                    affected.add(ep.bpkgs.bundle);
                }
            }
        } else {
            for (int i = 0; i < bundles.length; ++i) {
                BundleImpl tmp;
                if (bundles[i] == null) continue;
                if (Debug.packages) {
                    Debug.println("getZombieAffected: check - " + bundles[i]);
                }
                if ((tmp = (BundleImpl)bundles[i]).isFragment() && tmp.isAttached() && !affected.contains(tmp.getFragmentHost())) {
                    affected.add(tmp.getFragmentHost());
                    continue;
                }
                affected.add(bundles[i]);
            }
        }
        ArrayList<Bundle> moreBundles = new ArrayList<Bundle>(affected);
        for (int i = 0; i < moreBundles.size(); ++i) {
            BundleImpl b = (BundleImpl)moreBundles.get(i);
            Iterator j = b.getExports();
            while (j.hasNext()) {
                ExportPkg ep = (ExportPkg)j.next();
                if (ep.pkg != null && ep.pkg.providers.contains(ep)) {
                    Iterator k = ep.getPackageImporters().iterator();
                    while (k.hasNext()) {
                        Bundle ib = (Bundle)k.next();
                        if (affected.contains(ib)) continue;
                        moreBundles.add(ib);
                        if (Debug.packages) {
                            Debug.println("getZombieAffected: added importing bundle - " + ib);
                        }
                        affected.add(ib);
                    }
                }
                if (ep.bpkgs.requiredBy == null) continue;
                Iterator rbi = ((AbstractList)ep.bpkgs.requiredBy).iterator();
                while (rbi.hasNext()) {
                    BundlePackages rbpkgs = (BundlePackages)rbi.next();
                    BundleImpl rb = rbpkgs.bundle;
                    if (affected.contains(rb)) continue;
                    moreBundles.add(rb);
                    if (Debug.packages) {
                        Debug.println("getZombieAffected: added requiring bundle - " + rb);
                    }
                    affected.add(rb);
                }
            }
        }
        return affected;
    }

    private boolean backTrackUses(ImportPkg ip) {
        if (Debug.packages) {
            Debug.println("backTrackUses: check - " + ip.pkgString());
        }
        if (this.tempBackTracked.contains(ip.bpkgs)) {
            return false;
        }
        this.tempBackTracked.add(ip.bpkgs);
        Iterator i = this.getPackagesProvidedBy(ip.bpkgs).iterator();
        if (i.hasNext()) {
            do {
                ExportPkg ep = (ExportPkg)i.next();
                boolean foundUses = false;
                Iterator ii = ((AbstractList)ep.pkg.importers).iterator();
                while (ii.hasNext()) {
                    ImportPkg iip = (ImportPkg)ii.next();
                    if (iip.provider != ep || !this.backTrackUses(iip)) continue;
                    foundUses = true;
                }
                if (foundUses) continue;
                this.checkUses(ep);
            } while (i.hasNext());
            return true;
        }
        return false;
    }

    private void markAsZombies(List exports) {
        Iterator i = exports.iterator();
        while (i.hasNext()) {
            ((ExportPkg)i.next()).zombie = true;
        }
    }

    private Collection getPackagesProvidedBy(BundlePackages bpkgs) {
        ArrayList<ExportPkg> res = new ArrayList<ExportPkg>();
        Iterator i = bpkgs.getExports();
        while (i.hasNext()) {
            ExportPkg ep = (ExportPkg)i.next();
            if (!ep.pkg.providers.contains(ep)) continue;
            res.add(ep);
        }
        return res;
    }

    private List resolvePackages(Iterator pkgs) {
        ArrayList<ImportPkg> res = new ArrayList<ImportPkg>();
        while (pkgs.hasNext()) {
            ExportPkg provider = null;
            ImportPkg ip = (ImportPkg)pkgs.next();
            if (ip.provider != null) {
                this.framework.listeners.frameworkError(ip.bpkgs.bundle, new Exception("resolvePackages: InternalError1!"));
            }
            if (Debug.packages) {
                Debug.println("resolvePackages: check - " + ip.pkgString());
            }
            if ((provider = (ExportPkg)this.tempProvider.get(ip.name)) != null) {
                if (Debug.packages) {
                    Debug.println("resolvePackages: " + ip.name + " - has temporary provider - " + provider);
                }
                if (provider.zombie && provider.bpkgs.bundle.state == 1) {
                    if (Debug.packages) {
                        Debug.println("resolvePackages: " + ip.name + " - provider not used since it is an uninstalled zombie - " + provider);
                    }
                    provider = null;
                } else if (!ip.okPackageVersion(provider.version)) {
                    if (Debug.packages) {
                        Debug.println("resolvePackages: " + ip.name + " - provider has wrong version - " + provider + ", need " + ip.packageRange + ", has " + provider.version);
                    }
                    provider = null;
                }
            } else {
                Iterator i = ((AbstractList)ip.pkg.providers).iterator();
                while (i.hasNext()) {
                    ExportPkg ep = (ExportPkg)i.next();
                    ++this.tempBlackListChecks;
                    if (this.tempBlackList.contains(ep)) {
                        ++this.tempBlackListHits;
                        continue;
                    }
                    if (ep.zombie || !ip.okPackageVersion(ep.version)) continue;
                    if (Debug.packages) {
                        Debug.println("resolvePackages: " + ip.name + " - has provider - " + ep);
                    }
                    HashMap oldTempProvider = (HashMap)this.tempProvider.clone();
                    if (!this.checkUses(ep)) {
                        this.tempProvider = oldTempProvider;
                        this.tempBlackList.add(ep);
                        continue;
                    }
                    provider = ep;
                    break;
                }
                if (provider == null) {
                    provider = this.pickProvider(ip);
                }
                if (provider != null) {
                    this.tempProvider.put(ip.pkg.pkg, provider);
                }
            }
            if (provider != null) continue;
            if (ip.resolution == "mandatory") {
                res.add(ip);
                continue;
            }
            if (!Debug.packages) continue;
            Debug.println("resolvePackages: Ok, no provider for optional " + ip.name);
        }
        return res;
    }

    private ExportPkg pickProvider(ImportPkg ip) {
        if (Debug.packages) {
            Debug.println("pickProvider: for - " + ip);
        }
        ExportPkg provider = null;
        Iterator i = ((AbstractList)ip.pkg.exporters).iterator();
        while (i.hasNext()) {
            ExportPkg ep = (ExportPkg)i.next();
            ++this.tempBlackListChecks;
            if (this.tempBlackList.contains(ep)) {
                ++this.tempBlackListHits;
                continue;
            }
            if (!this.checkAttributes(ep, ip)) {
                if (!Debug.packages) continue;
                Debug.println("pickProvider: attribute match failed for - " + ep);
                continue;
            }
            if (this.tempResolved.contains(ep.bpkgs.bundle)) {
                provider = ep;
                break;
            }
            if ((ep.bpkgs.bundle.state & BundleImpl.RESOLVED_FLAGS) != 0) {
                HashMap oldTempProvider = (HashMap)this.tempProvider.clone();
                if (this.checkUses(ep)) {
                    provider = ep;
                    break;
                }
                this.tempProvider = oldTempProvider;
                this.tempBlackList.add(ep);
                continue;
            }
            if (ep.bpkgs.bundle.state != 2 || !this.checkResolve(ep.bpkgs.bundle)) continue;
            provider = ep;
            break;
        }
        if (Debug.packages) {
            if (provider != null) {
                Debug.println("pickProvider: " + ip + " - got provider - " + provider);
            } else {
                Debug.println("pickProvider: " + ip + " - found no provider");
            }
        }
        return provider;
    }

    private boolean checkAttributes(ExportPkg ep, ImportPkg ip) {
        if (!ip.checkMandatory(ep.mandatory)) {
            return false;
        }
        if (!ip.okPackageVersion(ep.version) || ip.bundleSymbolicName != null && !ip.bundleSymbolicName.equals(ep.bpkgs.bundle.symbolicName) || !ip.bundleRange.withinRange(ep.bpkgs.bundle.version)) {
            return false;
        }
        Iterator i = ip.attributes.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry e = i.next();
            String a = (String)ep.attributes.get(e.getKey());
            if (a != null && a.equals(e.getValue())) continue;
            return false;
        }
        return true;
    }

    private boolean checkResolve(BundleImpl b) {
        ArrayList okImports = new ArrayList();
        if (this.framework.perm.missingMandatoryPackagePermissions(b.bpkgs, okImports) == null && this.checkBundleSingleton(b) == null) {
            List r;
            HashSet oldTempResolved = (HashSet)this.tempResolved.clone();
            HashMap oldTempProvider = (HashMap)this.tempProvider.clone();
            HashMap oldTempRequired = (HashMap)this.tempRequired.clone();
            HashSet oldTempBlackList = (HashSet)this.tempBlackList.clone();
            this.tempResolved.add(b);
            if (this.checkRequireBundle(b) == null && (r = this.resolvePackages(((AbstractList)okImports).iterator())).size() == 0) {
                return true;
            }
            this.tempResolved = oldTempResolved;
            this.tempProvider = oldTempProvider;
            this.tempRequired = oldTempRequired;
            this.tempBlackList = oldTempBlackList;
        }
        return false;
    }

    private boolean checkUses(ExportPkg pkg) {
        Iterator ui = null;
        String next_uses = null;
        if (Debug.packages) {
            Debug.println("checkUses: check if packages used by " + pkg + " is okay.");
        }
        if (pkg.uses != null && (ui = ((AbstractList)pkg.uses).iterator()).hasNext()) {
            next_uses = (String)ui.next();
        }
        if (Debug.packages) {
            Debug.println("checkUses: provider with bpkgs=" + pkg.bpkgs);
        }
        ArrayList<ExportPkg> checkList = new ArrayList<ExportPkg>();
        Iterator i = pkg.bpkgs.getActiveImports();
        while (i.hasNext()) {
            ImportPkg ip = (ImportPkg)i.next();
            if (ui != null) {
                if (next_uses == null || !ip.pkg.pkg.equals(next_uses)) continue;
                next_uses = ui.hasNext() ? (String)ui.next() : null;
            }
            ExportPkg ep = (ExportPkg)this.tempProvider.get(ip.pkg.pkg);
            if (Debug.packages) {
                Debug.println("checkUses: check import, " + ip + " with provider, " + ip.provider);
            }
            if (ep == null) {
                this.tempProvider.put(ip.pkg.pkg, ip.provider);
                checkList.add(ip.provider);
                continue;
            }
            if (ep == ip.provider) continue;
            if (Debug.packages) {
                Debug.println("checkUses: mismatch in providers for, " + ip.pkg.pkg);
            }
            return false;
        }
        i = ((AbstractList)checkList).iterator();
        while (i.hasNext()) {
            if (this.checkUses((ExportPkg)i.next())) continue;
            return false;
        }
        if (Debug.packages) {
            Debug.println("checkUses: package " + pkg + " is okay.");
        }
        return true;
    }

    private BundleImpl checkBundleSingleton(BundleImpl b) {
        if (b.symbolicName != null && b.singleton) {
            List bl;
            if (Debug.packages) {
                Debug.println("checkBundleSingleton: check singleton bundle " + b);
            }
            if ((bl = this.framework.bundles.getBundles(b.symbolicName)).size() > 1) {
                Iterator i = bl.iterator();
                while (i.hasNext()) {
                    BundleImpl b2 = (BundleImpl)i.next();
                    if (!b2.singleton || (b2.state & BundleImpl.RESOLVED_FLAGS) == 0 && !this.tempResolved.contains(b2)) continue;
                    if (Debug.packages) {
                        Debug.println("checkBundleSingleton: Reject resolve because of bundle: " + b2);
                    }
                    return b2;
                }
            }
        }
        return null;
    }

    private String checkRequireBundle(BundleImpl b) {
        if (b.bpkgs.require != null) {
            if (Debug.packages) {
                Debug.println("checkRequireBundle: check requiring bundle " + b);
            }
            if (!this.framework.perm.okRequireBundlePerm(b)) {
                return b.symbolicName;
            }
            HashMap<RequireBundle, BundlePackages> res = new HashMap<RequireBundle, BundlePackages>();
            Iterator i = ((AbstractList)b.bpkgs.require).iterator();
            while (i.hasNext()) {
                RequireBundle br = (RequireBundle)i.next();
                List bl = this.framework.bundles.getBundles(br.name, br.bundleRange);
                BundleImpl ok = null;
                Iterator bci = bl.iterator();
                while (bci.hasNext() && ok == null) {
                    BundleImpl b2 = (BundleImpl)bci.next();
                    if (this.tempResolved.contains(b2)) {
                        ok = b2;
                        continue;
                    }
                    if ((b2.state & BundleImpl.RESOLVED_FLAGS) != 0) {
                        HashMap oldTempProvider = (HashMap)this.tempProvider.clone();
                        ok = b2;
                        Iterator epi = b2.bpkgs.getExports();
                        while (epi.hasNext()) {
                            ExportPkg ep = (ExportPkg)epi.next();
                            if (this.checkUses(ep)) continue;
                            this.tempProvider = oldTempProvider;
                            this.tempBlackList.add(ep);
                            ok = null;
                        }
                        continue;
                    }
                    if (b2.state != 2 || !this.framework.perm.okProvideBundlePerm(b2) || !this.checkResolve(b2)) continue;
                    ok = b2;
                }
                if (ok != null) {
                    if (Debug.packages) {
                        Debug.println("checkRequireBundle: added required bundle " + ok);
                    }
                    res.put(br, ok.bpkgs);
                    continue;
                }
                if (br.resolution != "mandatory") continue;
                if (Debug.packages) {
                    Debug.println("checkRequireBundle: failed to satisfy: " + br.name);
                }
                return br.name;
            }
            this.tempRequired.putAll(res);
        }
        return null;
    }

    private void registerNewProviders(BundleImpl bundle) {
        Iterator<Object> i = this.tempProvider.values().iterator();
        while (i.hasNext()) {
            ExportPkg ep = (ExportPkg)i.next();
            ep.pkg.addProvider(ep);
        }
        i = this.tempRequired.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry e = (Map.Entry)i.next();
            BundlePackages bpkgs = (BundlePackages)e.getValue();
            RequireBundle br = (RequireBundle)e.getKey();
            br.bpkgs = bpkgs;
            if (bpkgs.requiredBy == null) {
                bpkgs.requiredBy = new ArrayList(1);
            }
            bpkgs.requiredBy.add(br.requestor);
            if (Debug.packages) {
                Debug.println("registerNewProviders: 'Require-Bundle: " + br.name + "' for " + br.requestor.bundle.getBundleId() + " bound to (id=" + bpkgs.bundle.getBundleId() + ",gen=" + bpkgs.generation + ")");
            }
            if (br.visibility != "reexport") continue;
            Iterator be = bpkgs.getExports();
            while (be.hasNext()) {
                ExportPkg ep = (ExportPkg)be.next();
                br.requestor.checkReExport(ep);
                if (!Debug.packages) continue;
                Debug.println("registerNewProviders: " + br.requestor.bundle.getBundleId() + " reexports package " + ep.name);
            }
        }
        i = this.tempResolved.iterator();
        while (i.hasNext()) {
            BundleImpl bs = (BundleImpl)i.next();
            if (bs.getState() != 2) continue;
            Iterator bi = bs.bpkgs.getImports();
            while (bi.hasNext()) {
                ImportPkg ip = (ImportPkg)bi.next();
                ip.provider = (ExportPkg)this.tempProvider.get(ip.name);
            }
            if (bs == bundle || bs.getUpdatedState() != 2) continue;
            this.framework.listeners.frameworkError(bs, new Exception("registerNewProviders: InternalError!"));
        }
    }
}

