/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework;

import java.util.Dictionary;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.knopflerfish.framework.BundleImpl;
import org.knopflerfish.framework.PropertiesDictionary;
import org.knopflerfish.framework.ServiceReferenceImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

public class ServiceRegistrationImpl
implements ServiceRegistration {
    BundleImpl bundle;
    Object service;
    ServiceReferenceImpl reference;
    PropertiesDictionary properties;
    HashMap dependents = new HashMap();
    HashMap serviceInstances = new HashMap();
    volatile boolean available;
    private Object eventLock = new Object();
    volatile boolean unregistering = false;

    ServiceRegistrationImpl(BundleImpl b, Object s, PropertiesDictionary props) {
        this.bundle = b;
        this.service = s;
        this.properties = props;
        this.reference = new ServiceReferenceImpl(this);
        this.available = true;
    }

    public ServiceReference getReference() {
        ServiceReferenceImpl res = this.reference;
        if (res != null) {
            return res;
        }
        throw new IllegalStateException("Service is unregistered");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProperties(Dictionary props) {
        Object object = this.eventLock;
        synchronized (object) {
            PropertiesDictionary propertiesDictionary = this.properties;
            synchronized (propertiesDictionary) {
                if (!this.available) {
                    throw new IllegalStateException("Service is unregistered");
                }
                String[] classes = (String[])this.properties.get("objectClass");
                Long sid = (Long)this.properties.get("service.id");
                this.properties = new PropertiesDictionary(props, classes, sid);
            }
            this.bundle.framework.listeners.serviceChanged(new ServiceEvent(2, this.reference));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister() {
        PropertiesDictionary propertiesDictionary;
        if (this.unregistering) {
            return;
        }
        Object object = this.eventLock;
        synchronized (object) {
            if (this.unregistering) {
                return;
            }
            this.unregistering = true;
            propertiesDictionary = this.properties;
            synchronized (propertiesDictionary) {
                if (this.available) {
                    if (null != this.bundle) {
                        this.bundle.framework.services.removeServiceRegistration(this);
                    }
                } else {
                    throw new IllegalStateException("Service is unregistered");
                }
            }
        }
        if (null != this.bundle) {
            this.bundle.framework.listeners.serviceChanged(new ServiceEvent(4, this.reference));
        }
        object = this.eventLock;
        synchronized (object) {
            propertiesDictionary = this.properties;
            synchronized (propertiesDictionary) {
                this.available = false;
                if (null != this.bundle) {
                    this.bundle.framework.perm.callUnregister0(this);
                }
                this.bundle = null;
                this.dependents = null;
                this.reference = null;
                this.service = null;
                this.serviceInstances = null;
                this.unregistering = false;
            }
        }
    }

    void unregister0() {
        Iterator i = this.serviceInstances.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry e = i.next();
            try {
                ((ServiceFactory)this.service).ungetService((Bundle)e.getKey(), this, e.getValue());
            }
            catch (Throwable ue) {
                this.bundle.framework.listeners.frameworkEvent(new FrameworkEvent(2, this.bundle, ue));
            }
        }
    }

    boolean isUsedByBundle(Bundle b) {
        HashMap deps = this.dependents;
        if (deps != null) {
            return deps.containsKey(b);
        }
        return false;
    }
}

