/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework;

import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.util.HashMap;
import java.util.Map;
import org.knopflerfish.framework.Debug;
import org.knopflerfish.framework.Framework;
import org.knopflerfish.framework.URLStreamHandlerWrapper;
import org.knopflerfish.framework.Util;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class ServiceURLStreamHandlerFactory
implements URLStreamHandlerFactory {
    Framework framework;
    Map handlers = new HashMap();
    String[] jvmPkgs = null;
    Map wrapMap = new HashMap();
    static /* synthetic */ Class class$org$osgi$service$url$URLStreamHandlerService;

    ServiceURLStreamHandlerFactory(Framework fw) {
        this.framework = fw;
        String s = Framework.getProperty("java.protocol.handler.pkgs", "");
        this.jvmPkgs = Util.splitwords(s, "|");
        for (int i = 0; i < this.jvmPkgs.length; ++i) {
            this.jvmPkgs[i] = this.jvmPkgs[i].trim();
            if (!Debug.url) continue;
            Debug.println("JVMClassPath - URLHandler jvmPkgs[" + i + "]=" + this.jvmPkgs[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URLStreamHandler createURLStreamHandler(String protocol) {
        Map map = this.handlers;
        synchronized (map) {
            URLStreamHandler handler;
            if (Debug.url) {
                Debug.println("createURLStreamHandler protocol=" + protocol);
            }
            if ((handler = this.getJVMClassPathHandler(protocol)) != null) {
                if (Debug.url) {
                    Debug.println("using JVMClassPath handler for " + protocol);
                }
                return handler;
            }
            handler = (URLStreamHandler)this.handlers.get(protocol);
            if (handler != null) {
                if (Debug.url) {
                    Debug.println("using predefined handler for " + protocol);
                }
                return handler;
            }
            handler = this.getServiceHandler(protocol);
            if (handler != null) {
                if (Debug.url) {
                    Debug.println("Using service URLHandler for " + protocol);
                }
                return handler;
            }
            if (Debug.url) {
                Debug.println("Using default URLHandler for " + protocol);
            }
            return null;
        }
    }

    URLStreamHandler getServiceHandler(String protocol) {
        try {
            String filter = "(url.handler.protocol=" + protocol + ")";
            ServiceReference[] srl = this.framework.services.get((class$org$osgi$service$url$URLStreamHandlerService == null ? (class$org$osgi$service$url$URLStreamHandlerService = ServiceURLStreamHandlerFactory.class$("org.osgi.service.url.URLStreamHandlerService")) : class$org$osgi$service$url$URLStreamHandlerService).getName(), filter, null, false);
            if (srl != null && srl.length > 0) {
                URLStreamHandlerWrapper wrapper = (URLStreamHandlerWrapper)this.wrapMap.get(protocol);
                if (wrapper == null) {
                    wrapper = new URLStreamHandlerWrapper(this.framework, protocol);
                    this.wrapMap.put(protocol, wrapper);
                }
                return wrapper;
            }
        }
        catch (InvalidSyntaxException e) {
            throw new RuntimeException("Failed to get service: " + e);
        }
        return null;
    }

    URLStreamHandler getJVMClassPathHandler(String protocol) {
        for (int i = 0; i < this.jvmPkgs.length; ++i) {
            String className = this.jvmPkgs[i] + "." + protocol + ".Handler";
            try {
                if (Debug.url) {
                    Debug.println("JVMClassPath - trying URLHandler class=" + className);
                }
                Class<?> clazz = Class.forName(className);
                URLStreamHandler handler = (URLStreamHandler)clazz.newInstance();
                if (Debug.url) {
                    Debug.println("JVMClassPath - created URLHandler class=" + className);
                }
                return handler;
            }
            catch (Throwable t) {
                if (!Debug.url) continue;
                Debug.println("JVMClassPath - no URLHandler class " + className);
                continue;
            }
        }
        if (Debug.url) {
            Debug.println("JVMClassPath - no URLHandler for " + protocol);
        }
        return null;
    }

    void setURLStreamHandler(String protocol, URLStreamHandler handler) {
        this.handlers.put(protocol, handler);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

