/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.modeshape;

import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.junit.AfterClass;
import org.junit.Assert;
import org.komodo.modeshape.teiid.TeiidSqlNodeVisitor;
import org.komodo.spi.query.JoinTypeTypes;
import org.komodo.spi.runtime.version.DefaultTeiidVersion;
import org.komodo.spi.runtime.version.TeiidVersion;
import org.komodo.spi.runtime.version.TeiidVersionProvider;
import org.komodo.test.utils.AbstractSequencerTest;

public abstract class AbstractTSqlSequencerTest
extends AbstractSequencerTest {
    public AbstractTSqlSequencerTest(TeiidVersion teiidVersion) {
        TeiidVersionProvider.getInstance().setTeiidVersion(teiidVersion);
    }

    @AfterClass
    public static void resetTeiidVersionProvider() {
        TeiidVersionProvider.getInstance().setTeiidVersion(null);
    }

    protected String getTestConfigurationPath() {
        return "test-repository-config.json";
    }

    protected void verifyVersionType(Node node) throws RepositoryException {
        Property property = node.getProperty("tsql:teiidVersion");
        Value value = property.getValue();
        DefaultTeiidVersion version = new DefaultTeiidVersion(value.getString());
        Assert.assertEquals((Object)this.getTeiidVersion(), (Object)version);
    }

    protected void verifyBaseProperties(Node node, String primaryType, String mixinType) throws RepositoryException {
        super.verifyBaseProperties(node, primaryType, mixinType);
        if (mixinType != null && mixinType.startsWith("tsql")) {
            this.verifyVersionType(node);
        }
    }

    protected String deriveProcPrefix(boolean useNewLine) {
        StringBuilder builder = new StringBuilder();
        if (this.getTeiidVersion().isLessThan(DefaultTeiidVersion.Version.TEIID_8_4.get())) {
            builder.append("CREATE VIRTUAL PROCEDURE");
            if (useNewLine) {
                builder.append("\n");
            } else {
                builder.append(" ");
            }
        }
        builder.append("BEGIN");
        if (!useNewLine) {
            builder.append(" ");
        }
        return builder.toString();
    }

    protected void verifyJoin(Node joinPredicate, JoinTypeTypes joinType) throws Exception {
        Node joinNode = this.verify(joinPredicate, "tsql:joinType", "tsql:joinType");
        this.verifyProperty(joinNode, "tsql:kind", joinType.name());
    }

    protected void verifyUnaryFromClauseGroup(Node jpNode, String refName, int refIndex, String ... gSymbolProps) throws Exception {
        Node refNode = this.verify(jpNode, refName, refIndex, "tsql:unaryFromClause");
        Node groupNode = this.verify(refNode, "tsql:group", "tsql:groupSymbol");
        String name = gSymbolProps[0];
        this.verifyProperty(groupNode, "tsql:name", name);
        if (gSymbolProps.length > 1) {
            String definition = gSymbolProps[1];
            this.verifyProperty(groupNode, "tsql:definition", definition);
        }
    }

    protected void verifyUnaryFromClauseGroup(Node jpNode, String refName, String ... gSymbolProps) throws Exception {
        this.verifyUnaryFromClauseGroup(jpNode, refName, -1, gSymbolProps);
    }

    protected void verifyConstant(Node parentNode, String refName, int refIndex, String literal) throws Exception {
        Node constantNode = this.verify(parentNode, refName, refIndex, "tsql:constant");
        this.verifyProperty(constantNode, "tsql:value", literal);
    }

    protected void verifyConstant(Node parentNode, String refName, String literal) throws Exception {
        this.verifyConstant(parentNode, refName, -1, literal);
    }

    protected void verifyConstant(Node parentNode, String refName, int refIndex, int literal) throws Exception {
        Node constantNode = this.verify(parentNode, refName, refIndex, "tsql:constant");
        this.verifyProperty(constantNode, "tsql:value", literal);
    }

    protected void verifyConstant(Node parentNode, String refName, int literal) throws Exception {
        this.verifyConstant(parentNode, refName, -1, literal);
    }

    protected void verifyElementSymbol(Node parentNode, String refName, int refIndex, String elementSymbolName) throws Exception {
        Node elementSymbolNode = this.verify(parentNode, refName, refIndex, "tsql:elementSymbol");
        this.verifyProperty(elementSymbolNode, "tsql:name", elementSymbolName);
    }

    protected void verifyElementSymbol(Node parentNode, String refName, String elementSymbolName) throws Exception {
        this.verifyElementSymbol(parentNode, refName, -1, elementSymbolName);
    }

    protected Node verifyAliasSymbol(Node parentNode, String refName, int refIndex, String aliasName, String symbolId) throws Exception {
        Node aliasNode = this.verify(parentNode, refName, refIndex, "tsql:aliasSymbol");
        this.verifyProperty(aliasNode, "tsql:name", aliasName);
        return this.verify(aliasNode, "tsql:symbol", symbolId);
    }

    protected Node verifyAliasSymbol(Node parentNode, String refName, String aliasName, String symbolId) throws Exception {
        return this.verifyAliasSymbol(parentNode, refName, -1, aliasName, symbolId);
    }

    protected void verifyAliasSymbolWithElementSymbol(Node parentNode, String refName, int refIndex, String aliasName, String elementSymbolName) throws Exception {
        Node aliasNode = this.verify(parentNode, refName, refIndex, "tsql:aliasSymbol");
        this.verifyProperty(aliasNode, "tsql:name", aliasName);
        Node elementSymbolNode = this.verify(aliasNode, "tsql:symbol", "tsql:elementSymbol");
        this.verifyProperty(elementSymbolNode, "tsql:name", elementSymbolName);
    }

    protected Node verifyExpressionSymbol(Node parentNode, String refName, int refIndex, String expSymbolExpressionId) throws Exception {
        Node expSymbolNode = this.verify(parentNode, refName, refIndex, "tsql:expressionSymbol");
        Property property = expSymbolNode.getProperty("tsql:name");
        Value value = property.isMultiple() ? property.getValues()[0] : property.getValue();
        Assert.assertTrue((boolean)value.toString().startsWith("expr"));
        return this.verify(expSymbolNode, "tsql:expression", expSymbolExpressionId);
    }

    protected Node verifyExpressionSymbol(Node parentNode, String refName, String expSymbolExpressionId) throws Exception {
        return this.verifyExpressionSymbol(parentNode, refName, -1, expSymbolExpressionId);
    }

    protected void verifySql(String expectedSql, Node topNode) throws Exception {
        TeiidSqlNodeVisitor visitor = new TeiidSqlNodeVisitor(this.getTeiidVersion());
        String actualSql = visitor.getTeiidSql(topNode);
        Assert.assertEquals((Object)expectedSql, (Object)actualSql);
    }
}

