/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.modeshape.teiid.sequencer;

import javax.jcr.Node;
import org.junit.Assert;
import org.junit.Test;
import org.komodo.modeshape.AbstractTSqlSequencerTest;
import org.komodo.repository.KSequencerController;
import org.komodo.spi.query.JoinTypeTypes;
import org.komodo.spi.runtime.version.TeiidVersion;

public abstract class AbstractTestSequencers
extends AbstractTSqlSequencerTest {
    public AbstractTestSequencers(TeiidVersion teiidVersion) {
        super(teiidVersion);
    }

    @Test(timeout=5000000L)
    public void testBasicDDLStatement() throws Exception {
        String ddl = "CREATE VIEW Tweet AS select * FROM twitterview.getTweets;";
        Node fileNode = this.prepareSequence(ddl, KSequencerController.SequencerType.DDL);
        Node tweetNode = fileNode.getNode("Tweet");
        Assert.assertNotNull((Object)tweetNode);
        Node queryNode = this.verify(tweetNode, "tsql:query", "tsql:query");
        Node selectNode = this.verify(queryNode, "tsql:select", "tsql:select");
        this.verify(selectNode, "tsql:symbols", "tsql:multipleElementSymbol");
        Node fromNode = this.verify(queryNode, "tsql:from", "tsql:from");
        this.verifyUnaryFromClauseGroup(fromNode, "tsql:clauses", 1, "twitterview.getTweets");
    }

    @Test(timeout=5000000L)
    public void testComplexDDLStatement() throws Exception {
        StringBuffer ddl = new StringBuffer();
        ddl.append("CREATE VIRTUAL PROCEDURE getTweets(query varchar) RETURNS (created_on varchar(25), from_user varchar(25), to_user varchar(25), ").append("profile_image_url varchar(25), source varchar(25), text varchar(140)) AS ").append("select tweet.* from ").append("(call twitter.invokeHTTP(action => 'GET', endpoint =>querystring('',query as \"q\"))) w,  ").append("XMLTABLE('results' passing JSONTOXML('myxml', w.result) columns ").append("created_on string PATH 'created_at', ").append("from_user string PATH 'from_user', ").append("to_user string PATH 'to_user', ").append("profile_image_url string PATH 'profile_image_url', ").append("source string PATH 'source', ").append("text string PATH 'text') tweet; ").append("CREATE VIEW Tweet AS select * FROM twitterview.getTweets; ").append("CREATE FOREIGN TABLE PARTSSUPPLIER.PART (id integer PRIMARY KEY,  name   varchar(25), color varchar(25),  weight integer); ").append("CREATE VIEW PARTS_VIEWS.PARTS ( ").append("PART_ID integer PRIMARY KEY, ").append("PART_NAME varchar(255), ").append("PART_COLOR varchar(30), ").append("PART_WEIGHT varchar(255) ").append(") AS ").append("SELECT ").append("a.id as PART_ID, ").append("a.name as PART_NAME, ").append("b.color as PART_COLOR, ").append("b.weight as PART_WEIGHT ").append("FROM PARTSSUPPLIER.part a, PARTSSUPPLIER.part b WHERE a.id = b.id; ").append("CREATE FOREIGN TABLE PRODUCT.Customer ( ").append("id integer PRIMARY KEY, ").append("firstname  varchar(25), ").append("lastname varchar(25), ").append("dob timestamp); ").append("CREATE FOREIGN TABLE PRODUCT.Order ( ").append("id integer PRIMARY KEY, ").append("customerid  integer, ").append("saledate date, ").append("amount decimal(25,4), ").append("CONSTRAINT CUSTOMER_FK FOREIGN KEY(customerid) REFERENCES PRODUCT.Customer(id)); ").append("CREATE VIEW PRODUCT_VIEWS.CustomerOrders ( ").append("name varchar(50), ").append("saledate date, ").append("amount decimal) OPTIONS (CARDINALITY 100, ANNOTATION 'Example') ").append("AS ").append("SELECT ").append("concat(c.firstname, c.lastname) as name, ").append("o.saledate as saledate, ").append("o.amount as amount ").append("FROM Customer C INNER JOIN o ON c.id = o.customerid; ");
        Node fileNode = this.prepareSequence(ddl.toString(), KSequencerController.SequencerType.DDL);
        Node tweetNode = fileNode.getNode("Tweet");
        Assert.assertNotNull((Object)tweetNode);
        Node queryNode = this.verify(tweetNode, "tsql:query", "tsql:query");
        Node selectNode = this.verify(queryNode, "tsql:select", "tsql:select");
        this.verify(selectNode, "tsql:symbols", "tsql:multipleElementSymbol");
        Node fromNode = this.verify(queryNode, "tsql:from", "tsql:from");
        this.verifyUnaryFromClauseGroup(fromNode, "tsql:clauses", 1, "twitterview.getTweets");
        Node partsNode = fileNode.getNode("PARTS_VIEWS.PARTS");
        Assert.assertNotNull((Object)partsNode);
        queryNode = this.verify(partsNode, "tsql:query", "tsql:query");
        selectNode = this.verify(queryNode, "tsql:select", "tsql:select");
        this.verifyAliasSymbol(selectNode, "tsql:symbols", 1, "PART_ID", "tsql:elementSymbol");
        this.verifyAliasSymbol(selectNode, "tsql:symbols", 2, "PART_NAME", "tsql:elementSymbol");
        this.verifyAliasSymbol(selectNode, "tsql:symbols", 3, "PART_COLOR", "tsql:elementSymbol");
        this.verifyAliasSymbol(selectNode, "tsql:symbols", 4, "PART_WEIGHT", "tsql:elementSymbol");
        fromNode = this.verify(queryNode, "tsql:from", "tsql:from");
        this.verifyUnaryFromClauseGroup(fromNode, "tsql:clauses", 1, "a");
        this.verifyUnaryFromClauseGroup(fromNode, "tsql:clauses", 2, "b");
        Node criteriaNode = this.verify(queryNode, "tsql:criteria", "tsql:compareCriteria");
        this.verifyElementSymbol(criteriaNode, "tsql:rightExpression", "b.id");
        this.verifyElementSymbol(criteriaNode, "tsql:leftExpression", "a.id");
        Node productNode = fileNode.getNode("PRODUCT_VIEWS.CustomerOrders");
        Assert.assertNotNull((Object)productNode);
        queryNode = this.verify(productNode, "tsql:query", "tsql:query");
        selectNode = this.verify(queryNode, "tsql:select", "tsql:select");
        this.verifyAliasSymbol(selectNode, "tsql:symbols", 1, "name", "tsql:function");
        this.verifyAliasSymbol(selectNode, "tsql:symbols", 2, "saledate", "tsql:elementSymbol");
        this.verifyAliasSymbol(selectNode, "tsql:symbols", 3, "amount", "tsql:elementSymbol");
        fromNode = this.verify(queryNode, "tsql:from", "tsql:from");
        Node fromClause = this.verify(fromNode, "tsql:clauses", "tsql:joinPredicate");
        this.verifyJoin(fromClause, JoinTypeTypes.JOIN_INNER);
        criteriaNode = this.verify(fromClause, "tsql:joinCriteria", "tsql:compareCriteria");
        this.verifyElementSymbol(criteriaNode, "tsql:rightExpression", "o.customerid");
        this.verifyElementSymbol(criteriaNode, "tsql:leftExpression", "c.id");
        this.verifyUnaryFromClauseGroup(fromClause, "tsql:rightClause", "o");
        this.verifyUnaryFromClauseGroup(fromClause, "tsql:leftClause", "C");
    }

    @Test(timeout=300000L)
    public void testMaterializedStatement() throws Exception {
        StringBuffer ddl = new StringBuffer();
        ddl.append("CREATE view stockPricesMatView (").append("product_id integer, ").append("symbol string, ").append("price bigdecimal, ").append("company_name   varchar(256) ").append(") OPTIONS (MATERIALIZED 'TRUE', UPDATABLE 'TRUE', ").append("MATERIALIZED_TABLE 'Accounts.h2_stock_mat', ").append("\"teiid_rel:MATVIEW_TTL\" 120000, ").append("\"teiid_rel:MATVIEW_BEFORE_LOAD_SCRIPT\" 'execute accounts.native(''truncate table h2_stock_mat'');', ").append("\"teiid_rel:MATVIEW_AFTER_LOAD_SCRIPT\"  'execute accounts.native('''')', ").append("\"teiid_rel:ON_VDB_DROP_SCRIPT\" 'DELETE FROM Accounts.status WHERE Name=''stock'' AND schemaname = ''Stocks''', ").append("\"teiid_rel:MATERIALIZED_STAGE_TABLE\" 'Accounts.h2_stock_mat', ").append("\"teiid_rel:ALLOW_MATVIEW_MANAGEMENT\" 'true', ").append("\"teiid_rel:MATVIEW_STATUS_TABLE\" 'status', ").append("\"teiid_rel:MATVIEW_SHARE_SCOPE\" 'NONE', ").append("\"teiid_rel:MATVIEW_ONERROR_ACTION\" 'THROW_EXCEPTION') ").append("AS SELECT  A.ID, S.symbol, S.price, A.COMPANY_NAME ").append("FROM Stocks.StockPrices AS S, Accounts.PRODUCT AS A ").append("WHERE S.symbol = A.SYMBOL;");
        Node fileNode = this.prepareSequence(ddl.toString(), KSequencerController.SequencerType.DDL);
        Node stockViewNode = this.verify(fileNode, "stockPricesMatView", "teiidddl:createView");
        Node option = this.verify(stockViewNode, this.enc("teiid_rel:ALLOW_MATVIEW_MANAGEMENT"), "ddl:statementOption");
        this.verifyProperty(option, "ddl:value", Boolean.TRUE.toString().toLowerCase());
        option = this.verify(stockViewNode, this.enc("teiid_rel:MATVIEW_SHARE_SCOPE"), "ddl:statementOption");
        this.verifyProperty(option, "ddl:value", "NONE");
        option = this.verify(stockViewNode, this.enc("teiid_rel:MATVIEW_AFTER_LOAD_SCRIPT"), "ddl:statementOption");
        this.verifyProperty(option, "ddl:value", "execute accounts.native('''')");
        option = this.verify(stockViewNode, this.enc("teiid_rel:MATVIEW_TTL"), "ddl:statementOption");
        this.verifyProperty(option, "ddl:value", 120000L);
        option = this.verify(stockViewNode, this.enc("teiid_rel:ON_VDB_DROP_SCRIPT"), "ddl:statementOption");
        this.verifyProperty(option, "ddl:value", "DELETE FROM Accounts.status WHERE Name=''stock'' AND schemaname = ''Stocks''");
        option = this.verify(stockViewNode, this.enc("teiid_rel:MATERIALIZED_STAGE_TABLE"), "ddl:statementOption");
        this.verifyProperty(option, "ddl:value", "Accounts.h2_stock_mat");
        option = this.verify(stockViewNode, this.enc("MATERIALIZED_TABLE"), "ddl:statementOption");
        this.verifyProperty(option, "ddl:value", "Accounts.h2_stock_mat");
        option = this.verify(stockViewNode, this.enc("UPDATABLE"), "ddl:statementOption");
        this.verifyProperty(option, "ddl:value", Boolean.TRUE.toString().toUpperCase());
        option = this.verify(stockViewNode, this.enc("teiid_rel:MATVIEW_BEFORE_LOAD_SCRIPT"), "ddl:statementOption");
        this.verifyProperty(option, "ddl:value", "execute accounts.native(''truncate table h2_stock_mat'');");
        option = this.verify(stockViewNode, this.enc("teiid_rel:MATVIEW_STATUS_TABLE"), "ddl:statementOption");
        this.verifyProperty(option, "ddl:value", "status");
        option = this.verify(stockViewNode, this.enc("teiid_rel:MATVIEW_ONERROR_ACTION"), "ddl:statementOption");
        this.verifyProperty(option, "ddl:value", "THROW_EXCEPTION");
        option = this.verify(stockViewNode, this.enc("MATERIALIZED"), "ddl:statementOption");
        this.verifyProperty(option, "ddl:value", Boolean.TRUE.toString().toUpperCase());
        Node queryNode = this.verify(stockViewNode, "tsql:query", "tsql:query");
        this.verify(queryNode, "tsql:select", "tsql:select");
    }

    private static interface MaterializedOptions {
        public static final String MATERIALIZED = "MATERIALIZED";
        public static final String MATERIALIZED_TABLE = "MATERIALIZED_TABLE";
        public static final String UPDATABLE = "UPDATABLE";
        public static final String ALLOW_MATVIEW_MANAGEMENT = "teiid_rel:ALLOW_MATVIEW_MANAGEMENT";
        public static final String MATVIEW_STATUS_TABLE = "teiid_rel:MATVIEW_STATUS_TABLE";
        public static final String MATVIEW_BEFORE_LOAD_SCRIPT = "teiid_rel:MATVIEW_BEFORE_LOAD_SCRIPT";
        public static final String MATVIEW_LOAD_SCRIPT = "teiid_rel:MATVIEW_LOAD_SCRIPT";
        public static final String MATVIEW_AFTER_LOAD_SCRIPT = "teiid_rel:MATVIEW_AFTER_LOAD_SCRIPT";
        public static final String MATVIEW_SHARE_SCOPE = "teiid_rel:MATVIEW_SHARE_SCOPE";
        public static final String MATERIALIZED_STAGE_TABLE = "teiid_rel:MATERIALIZED_STAGE_TABLE";
        public static final String ON_VDB_START_SCRIPT = "teiid_rel:ON_VDB_START_SCRIPT";
        public static final String ON_VDB_DROP_SCRIPT = "teiid_rel:ON_VDB_DROP_SCRIPT";
        public static final String MATVIEW_ONERROR_ACTION = "teiid_rel:MATVIEW_ONERROR_ACTION";
        public static final String MATVIEW_TTL = "teiid_rel:MATVIEW_TTL";
    }
}

