/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.modeshape.teiid.sequencer;

import java.sql.Date;
import java.sql.Time;
import javax.jcr.Node;
import org.junit.Assert;
import org.junit.Test;
import org.komodo.modeshape.AbstractTSqlSequencerTest;
import org.komodo.modeshape.teiid.language.SortSpecification;
import org.komodo.repository.KSequencerController;
import org.komodo.spi.query.CriteriaOperator;
import org.komodo.spi.query.JoinTypeTypes;
import org.komodo.spi.query.Operation;
import org.komodo.spi.runtime.version.TeiidVersion;
import org.komodo.spi.type.DataTypeManager;

public abstract class AbstractTestTeiidSqlSequencer
extends AbstractTSqlSequencerTest {
    protected static final String TSQL_QUERY = "\\/tsql[0-9]+\\.tsql\\/tsql:query";
    protected static final String TSQL_PROC_CMD = "\\/tsql[0-9]+\\.tsql\\/tsql:createProcedureCommand";
    protected static final String TSQL_INSERT = "\\/tsql[0-9]+\\.tsql\\/tsql:insert";

    public AbstractTestTeiidSqlSequencer(TeiidVersion teiidVersion) {
        super(teiidVersion);
    }

    protected Node sequenceSql(String text, String seqRegEx) throws Exception {
        Node node = this.prepareSequence(text, KSequencerController.SequencerType.TSQL);
        return node;
    }

    @Test
    public void testInnerJoin() throws Exception {
        String sql = "SELECT * FROM g1 inner join g2 on g1.a1=g2.a2";
        Node fileNode = this.sequenceSql(sql, TSQL_QUERY);
        Node queryNode = this.verify(fileNode, "tsql:query", "tsql:query");
        Node selectNode = this.verify(queryNode, "tsql:select", "tsql:select");
        this.verify(selectNode, "tsql:symbols", "tsql:multipleElementSymbol");
        Node fromNode = this.verify(queryNode, "tsql:from", "tsql:from");
        Node jpNode = this.verify(fromNode, "tsql:clauses", "tsql:joinPredicate");
        this.verifyJoin(jpNode, JoinTypeTypes.JOIN_INNER);
        this.verifyUnaryFromClauseGroup(jpNode, "tsql:leftClause", "g1");
        this.verifyUnaryFromClauseGroup(jpNode, "tsql:rightClause", "g2");
        Node criteriaNode = this.verify(jpNode, "tsql:joinCriteria", "tsql:compareCriteria");
        this.verifyProperty(criteriaNode, "tsql:operator", CriteriaOperator.Operator.EQ.name());
        Node leftExpression = this.verify(criteriaNode, "tsql:leftExpression", "tsql:elementSymbol");
        this.verifyProperty(leftExpression, "tsql:name", "g1.a1");
        Node rightExpression = this.verify(criteriaNode, "tsql:rightExpression", "tsql:elementSymbol");
        this.verifyProperty(rightExpression, "tsql:name", "g2.a2");
        this.verifySql("SELECT * FROM g1 INNER JOIN g2 ON g1.a1 = g2.a2", fileNode);
    }

    @Test
    public void testCrossJoin() throws Exception {
        String sql = "SELECT * FROM g1 cross join g2";
        Node fileNode = this.sequenceSql(sql, TSQL_QUERY);
        Node queryNode = this.verify(fileNode, "tsql:query", "tsql:query");
        Node selectNode = this.verify(queryNode, "tsql:select", "tsql:select");
        this.verify(selectNode, "tsql:symbols", "tsql:multipleElementSymbol");
        Node fromNode = this.verify(queryNode, "tsql:from", "tsql:from");
        Node jpNode = this.verify(fromNode, "tsql:clauses", "tsql:joinPredicate");
        this.verifyJoin(jpNode, JoinTypeTypes.JOIN_CROSS);
        this.verifyUnaryFromClauseGroup(jpNode, "tsql:leftClause", "g1");
        this.verifyUnaryFromClauseGroup(jpNode, "tsql:rightClause", "g2");
        this.verifySql("SELECT * FROM g1 CROSS JOIN g2", fileNode);
    }

    @Test
    public void testFromClauses() throws Exception {
        String sql = "SELECT * FROM (g1 cross join g2), g3";
        Node fileNode = this.sequenceSql(sql, TSQL_QUERY);
        Node queryNode = this.verify(fileNode, "tsql:query", "tsql:query");
        Node selectNode = this.verify(queryNode, "tsql:select", "tsql:select");
        this.verify(selectNode, "tsql:symbols", "tsql:multipleElementSymbol");
        Node fromNode = this.verify(queryNode, "tsql:from", "tsql:from");
        Node jpNode = this.verify(fromNode, "tsql:clauses", 1, "tsql:joinPredicate");
        this.verifyJoin(jpNode, JoinTypeTypes.JOIN_CROSS);
        this.verifyUnaryFromClauseGroup(jpNode, "tsql:leftClause", "g1");
        this.verifyUnaryFromClauseGroup(jpNode, "tsql:rightClause", "g2");
        this.verifyUnaryFromClauseGroup(fromNode, "tsql:clauses", 2, "g3");
        this.verifySql("SELECT * FROM g1 CROSS JOIN g2, g3", fileNode);
    }

    @Test
    public void testMultiCrossJoin() throws Exception {
        String sql = "SELECT * FROM (g1 cross join g2) cross join g3";
        Node fileNode = this.sequenceSql(sql, TSQL_QUERY);
        Node queryNode = this.verify(fileNode, "tsql:query", "tsql:query");
        Node selectNode = this.verify(queryNode, "tsql:select", "tsql:select");
        this.verify(selectNode, "tsql:symbols", "tsql:multipleElementSymbol");
        Node fromNode = this.verify(queryNode, "tsql:from", "tsql:from");
        Node jpNode1 = this.verify(fromNode, "tsql:clauses", "tsql:joinPredicate");
        this.verifyJoin(jpNode1, JoinTypeTypes.JOIN_CROSS);
        Node jpNode2 = this.verify(jpNode1, "tsql:leftClause", "tsql:joinPredicate");
        this.verifyJoin(jpNode2, JoinTypeTypes.JOIN_CROSS);
        this.verifyUnaryFromClauseGroup(jpNode2, "tsql:leftClause", "g1");
        this.verifyUnaryFromClauseGroup(jpNode2, "tsql:rightClause", "g2");
        this.verifyUnaryFromClauseGroup(jpNode1, "tsql:rightClause", "g3");
        this.verifySql("SELECT * FROM (g1 CROSS JOIN g2) CROSS JOIN g3", fileNode);
    }

    @Test
    public void testMultiCrossJoin2() throws Exception {
        String sql = "SELECT * FROM (g1 cross join g2) cross join (g3 cross join g4)";
        Node fileNode = this.sequenceSql(sql, TSQL_QUERY);
        Node queryNode = this.verify(fileNode, "tsql:query", "tsql:query");
        Node selectNode = this.verify(queryNode, "tsql:select", "tsql:select");
        this.verify(selectNode, "tsql:symbols", "tsql:multipleElementSymbol");
        Node fromNode = this.verify(queryNode, "tsql:from", "tsql:from");
        Node jpNode1 = this.verify(fromNode, "tsql:clauses", "tsql:joinPredicate");
        this.verifyJoin(jpNode1, JoinTypeTypes.JOIN_CROSS);
        Node jpNode2 = this.verify(jpNode1, "tsql:leftClause", "tsql:joinPredicate");
        this.verifyJoin(jpNode2, JoinTypeTypes.JOIN_CROSS);
        Node jpNode3 = this.verify(jpNode1, "tsql:rightClause", "tsql:joinPredicate");
        this.verifyJoin(jpNode3, JoinTypeTypes.JOIN_CROSS);
        this.verifyUnaryFromClauseGroup(jpNode2, "tsql:leftClause", "g1");
        this.verifyUnaryFromClauseGroup(jpNode2, "tsql:rightClause", "g2");
        this.verifyUnaryFromClauseGroup(jpNode3, "tsql:leftClause", "g3");
        this.verifyUnaryFromClauseGroup(jpNode3, "tsql:rightClause", "g4");
        this.verifySql("SELECT * FROM (g1 CROSS JOIN g2) CROSS JOIN (g3 CROSS JOIN g4)", fileNode);
    }

    @Test
    public void testMultiCrossJoin3() throws Exception {
        String sql = "SELECT * FROM g1 cross join (g2 cross join g3)";
        Node fileNode = this.sequenceSql(sql, TSQL_QUERY);
        Node queryNode = this.verify(fileNode, "tsql:query", "tsql:query");
        Node selectNode = this.verify(queryNode, "tsql:select", "tsql:select");
        this.verify(selectNode, "tsql:symbols", "tsql:multipleElementSymbol");
        Node fromNode = this.verify(queryNode, "tsql:from", "tsql:from");
        Node jpNode1 = this.verify(fromNode, "tsql:clauses", "tsql:joinPredicate");
        this.verifyJoin(jpNode1, JoinTypeTypes.JOIN_CROSS);
        Node jpNode2 = this.verify(jpNode1, "tsql:rightClause", "tsql:joinPredicate");
        this.verifyJoin(jpNode2, JoinTypeTypes.JOIN_CROSS);
        this.verifyUnaryFromClauseGroup(jpNode1, "tsql:leftClause", "g1");
        this.verifyUnaryFromClauseGroup(jpNode2, "tsql:leftClause", "g2");
        this.verifyUnaryFromClauseGroup(jpNode2, "tsql:rightClause", "g3");
        this.verifySql("SELECT * FROM g1 CROSS JOIN (g2 CROSS JOIN g3)", fileNode);
    }

    @Test
    public void testMixedJoin() throws Exception {
        String sql = "SELECT * FROM g1 cross join (g2 cross join g3), g4";
        Node fileNode = this.sequenceSql(sql, TSQL_QUERY);
        Node queryNode = this.verify(fileNode, "tsql:query", "tsql:query");
        Node selectNode = this.verify(queryNode, "tsql:select", "tsql:select");
        this.verify(selectNode, "tsql:symbols", "tsql:multipleElementSymbol");
        Node fromNode = this.verify(queryNode, "tsql:from", "tsql:from");
        Node jpNode1 = this.verify(fromNode, "tsql:clauses", "tsql:joinPredicate");
        this.verifyJoin(jpNode1, JoinTypeTypes.JOIN_CROSS);
        Node jpNode2 = this.verify(jpNode1, "tsql:rightClause", "tsql:joinPredicate");
        this.verifyJoin(jpNode2, JoinTypeTypes.JOIN_CROSS);
        this.verifyUnaryFromClauseGroup(jpNode1, "tsql:leftClause", "g1");
        this.verifyUnaryFromClauseGroup(jpNode2, "tsql:leftClause", "g2");
        this.verifyUnaryFromClauseGroup(jpNode2, "tsql:rightClause", "g3");
        this.verifyUnaryFromClauseGroup(fromNode, "tsql:clauses", 2, "g4");
        this.verifySql("SELECT * FROM g1 CROSS JOIN (g2 CROSS JOIN g3), g4", fileNode);
    }

    @Test
    public void testMixedJoin2() throws Exception {
        String sql = "SELECT * FROM g1 cross join (g2 cross join g3), g4, g5 cross join g6";
        Node fileNode = this.sequenceSql(sql, TSQL_QUERY);
        Node queryNode = this.verify(fileNode, "tsql:query", "tsql:query");
        Node selectNode = this.verify(queryNode, "tsql:select", "tsql:select");
        this.verify(selectNode, "tsql:symbols", "tsql:multipleElementSymbol");
        Node fromNode = this.verify(queryNode, "tsql:from", "tsql:from");
        Node jpNode1 = this.verify(fromNode, "tsql:clauses", 1, "tsql:joinPredicate");
        this.verifyJoin(jpNode1, JoinTypeTypes.JOIN_CROSS);
        this.verifyUnaryFromClauseGroup(jpNode1, "tsql:leftClause", "g1");
        Node jpNode2 = this.verify(jpNode1, "tsql:rightClause", "tsql:joinPredicate");
        this.verifyJoin(jpNode2, JoinTypeTypes.JOIN_CROSS);
        this.verifyUnaryFromClauseGroup(jpNode2, "tsql:leftClause", "g2");
        this.verifyUnaryFromClauseGroup(jpNode2, "tsql:rightClause", "g3");
        this.verifyUnaryFromClauseGroup(fromNode, "tsql:clauses", 2, "g4");
        Node jpNode3 = this.verify(fromNode, "tsql:clauses", 3, "tsql:joinPredicate");
        this.verifyJoin(jpNode3, JoinTypeTypes.JOIN_CROSS);
        this.verifyUnaryFromClauseGroup(jpNode3, "tsql:leftClause", "g5");
        this.verifyUnaryFromClauseGroup(jpNode3, "tsql:rightClause", "g6");
        this.verifySql("SELECT * FROM g1 CROSS JOIN (g2 CROSS JOIN g3), g4, g5 CROSS JOIN g6", fileNode);
    }

    @Test
    public void testMixedJoin3() throws Exception {
        String sql = "SELECT * FROM g1, g2 inner join g3 on g2.a=g3.a";
        Node fileNode = this.sequenceSql(sql, TSQL_QUERY);
        Node queryNode = this.verify(fileNode, "tsql:query", "tsql:query");
        Node selectNode = this.verify(queryNode, "tsql:select", "tsql:select");
        this.verify(selectNode, "tsql:symbols", "tsql:multipleElementSymbol");
        Node fromNode = this.verify(queryNode, "tsql:from", "tsql:from");
        this.verifyUnaryFromClauseGroup(fromNode, "tsql:clauses", 1, "g1");
        Node jpNode = this.verify(fromNode, "tsql:clauses", 2, "tsql:joinPredicate");
        this.verifyJoin(jpNode, JoinTypeTypes.JOIN_INNER);
        this.verifyUnaryFromClauseGroup(jpNode, "tsql:leftClause", "g2");
        this.verifyUnaryFromClauseGroup(jpNode, "tsql:rightClause", "g3");
        Node criteriaNode = this.verify(jpNode, "tsql:joinCriteria", "tsql:compareCriteria");
        this.verifyProperty(criteriaNode, "tsql:operator", CriteriaOperator.Operator.EQ.name());
        Node leftExpression = this.verify(criteriaNode, "tsql:leftExpression", "tsql:elementSymbol");
        this.verifyProperty(leftExpression, "tsql:name", "g2.a");
        Node rightExpression = this.verify(criteriaNode, "tsql:rightExpression", "tsql:elementSymbol");
        this.verifyProperty(rightExpression, "tsql:name", "g3.a");
        this.verifySql("SELECT * FROM g1, g2 INNER JOIN g3 ON g2.a = g3.a", fileNode);
    }

    @Test
    public void testRightOuterJoinWithAliases() throws Exception {
        String sql = "Select myG.a myA, myH.b from g myG right outer join h myH on myG.x=myH.x";
        Node fileNode = this.sequenceSql(sql, TSQL_QUERY);
        Node queryNode = this.verify(fileNode, "tsql:query", "tsql:query");
        Node selectNode = this.verify(queryNode, "tsql:select", "tsql:select");
        this.verifyAliasSymbolWithElementSymbol(selectNode, "tsql:symbols", 1, "myA", "myG.a");
        this.verifyElementSymbol(selectNode, "tsql:symbols", 2, "myH.b");
        Node fromNode = this.verify(queryNode, "tsql:from", "tsql:from");
        Node jpNode = this.verify(fromNode, "tsql:clauses", "tsql:joinPredicate");
        this.verifyJoin(jpNode, JoinTypeTypes.JOIN_RIGHT_OUTER);
        this.verifyUnaryFromClauseGroup(jpNode, "tsql:leftClause", "myG", "g");
        this.verifyUnaryFromClauseGroup(jpNode, "tsql:rightClause", "myH", "h");
        Node criteriaNode = this.verify(jpNode, "tsql:joinCriteria", "tsql:compareCriteria");
        this.verifyProperty(criteriaNode, "tsql:operator", CriteriaOperator.Operator.EQ.name());
        Node leftExpression = this.verify(criteriaNode, "tsql:leftExpression", "tsql:elementSymbol");
        this.verifyProperty(leftExpression, "tsql:name", "myG.x");
        Node rightExpression = this.verify(criteriaNode, "tsql:rightExpression", "tsql:elementSymbol");
        this.verifyProperty(rightExpression, "tsql:name", "myH.x");
        this.verifySql("SELECT myG.a AS myA, myH.b FROM g AS myG RIGHT OUTER JOIN h AS myH ON myG.x = myH.x", fileNode);
    }

    @Test
    public void testRightJoinWithAliases() throws Exception {
        String sql = "Select myG.a myA, myH.b from g myG right join h myH on myG.x=myH.x";
        Node fileNode = this.sequenceSql(sql, TSQL_QUERY);
        Node queryNode = this.verify(fileNode, "tsql:query", "tsql:query");
        Node selectNode = this.verify(queryNode, "tsql:select", "tsql:select");
        this.verifyAliasSymbolWithElementSymbol(selectNode, "tsql:symbols", 1, "myA", "myG.a");
        this.verifyElementSymbol(selectNode, "tsql:symbols", 2, "myH.b");
        Node fromNode = this.verify(queryNode, "tsql:from", "tsql:from");
        Node jpNode = this.verify(fromNode, "tsql:clauses", "tsql:joinPredicate");
        this.verifyJoin(jpNode, JoinTypeTypes.JOIN_RIGHT_OUTER);
        this.verifyUnaryFromClauseGroup(jpNode, "tsql:leftClause", "myG", "g");
        this.verifyUnaryFromClauseGroup(jpNode, "tsql:rightClause", "myH", "h");
        Node criteriaNode = this.verify(jpNode, "tsql:joinCriteria", "tsql:compareCriteria");
        this.verifyProperty(criteriaNode, "tsql:operator", CriteriaOperator.Operator.EQ.name());
        Node leftExpression = this.verify(criteriaNode, "tsql:leftExpression", "tsql:elementSymbol");
        this.verifyProperty(leftExpression, "tsql:name", "myG.x");
        Node rightExpression = this.verify(criteriaNode, "tsql:rightExpression", "tsql:elementSymbol");
        this.verifyProperty(rightExpression, "tsql:name", "myH.x");
        this.verifySql("SELECT myG.a AS myA, myH.b FROM g AS myG RIGHT OUTER JOIN h AS myH ON myG.x = myH.x", fileNode);
    }

    @Test
    public void testLeftOuterJoinWithAliases() throws Exception {
        String sql = "Select myG.a myA, myH.b from g myG left outer join h myH on myG.x=myH.x";
        Node fileNode = this.sequenceSql(sql, TSQL_QUERY);
        Node queryNode = this.verify(fileNode, "tsql:query", "tsql:query");
        Node selectNode = this.verify(queryNode, "tsql:select", "tsql:select");
        this.verifyAliasSymbolWithElementSymbol(selectNode, "tsql:symbols", 1, "myA", "myG.a");
        this.verifyElementSymbol(selectNode, "tsql:symbols", 2, "myH.b");
        Node fromNode = this.verify(queryNode, "tsql:from", "tsql:from");
        Node jpNode = this.verify(fromNode, "tsql:clauses", "tsql:joinPredicate");
        this.verifyJoin(jpNode, JoinTypeTypes.JOIN_LEFT_OUTER);
        this.verifyUnaryFromClauseGroup(jpNode, "tsql:leftClause", "myG", "g");
        this.verifyUnaryFromClauseGroup(jpNode, "tsql:rightClause", "myH", "h");
        Node criteriaNode = this.verify(jpNode, "tsql:joinCriteria", "tsql:compareCriteria");
        this.verifyProperty(criteriaNode, "tsql:operator", CriteriaOperator.Operator.EQ.name());
        Node leftExpression = this.verify(criteriaNode, "tsql:leftExpression", "tsql:elementSymbol");
        this.verifyProperty(leftExpression, "tsql:name", "myG.x");
        Node rightExpression = this.verify(criteriaNode, "tsql:rightExpression", "tsql:elementSymbol");
        this.verifyProperty(rightExpression, "tsql:name", "myH.x");
        this.verifySql("SELECT myG.a AS myA, myH.b FROM g AS myG LEFT OUTER JOIN h AS myH ON myG.x = myH.x", fileNode);
    }

    @Test
    public void testLeftJoinWithAliases() throws Exception {
        String sql = "Select myG.a myA, myH.b from g myG left outer join h myH on myG.x=myH.x";
        Node fileNode = this.sequenceSql(sql, TSQL_QUERY);
        Node queryNode = this.verify(fileNode, "tsql:query", "tsql:query");
        Node selectNode = this.verify(queryNode, "tsql:select", "tsql:select");
        this.verifyAliasSymbolWithElementSymbol(selectNode, "tsql:symbols", 1, "myA", "myG.a");
        this.verifyElementSymbol(selectNode, "tsql:symbols", 2, "myH.b");
        Node fromNode = this.verify(queryNode, "tsql:from", "tsql:from");
        Node jpNode = this.verify(fromNode, "tsql:clauses", "tsql:joinPredicate");
        this.verifyJoin(jpNode, JoinTypeTypes.JOIN_LEFT_OUTER);
        this.verifyUnaryFromClauseGroup(jpNode, "tsql:leftClause", "myG", "g");
        this.verifyUnaryFromClauseGroup(jpNode, "tsql:rightClause", "myH", "h");
        Node criteriaNode = this.verify(jpNode, "tsql:joinCriteria", "tsql:compareCriteria");
        this.verifyProperty(criteriaNode, "tsql:operator", CriteriaOperator.Operator.EQ.name());
        Node leftExpression = this.verify(criteriaNode, "tsql:leftExpression", "tsql:elementSymbol");
        this.verifyProperty(leftExpression, "tsql:name", "myG.x");
        Node rightExpression = this.verify(criteriaNode, "tsql:rightExpression", "tsql:elementSymbol");
        this.verifyProperty(rightExpression, "tsql:name", "myH.x");
        this.verifySql("SELECT myG.a AS myA, myH.b FROM g AS myG LEFT OUTER JOIN h AS myH ON myG.x = myH.x", fileNode);
    }

    @Test
    public void testFullOuterJoinWithAliases() throws Exception {
        String sql = "Select myG.a myA, myH.b from g myG full outer join h myH on myG.x=myH.x";
        Node fileNode = this.sequenceSql(sql, TSQL_QUERY);
        Node queryNode = this.verify(fileNode, "tsql:query", "tsql:query");
        Node selectNode = this.verify(queryNode, "tsql:select", "tsql:select");
        this.verifyAliasSymbolWithElementSymbol(selectNode, "tsql:symbols", 1, "myA", "myG.a");
        this.verifyElementSymbol(selectNode, "tsql:symbols", 2, "myH.b");
        Node fromNode = this.verify(queryNode, "tsql:from", "tsql:from");
        Node jpNode = this.verify(fromNode, "tsql:clauses", "tsql:joinPredicate");
        this.verifyJoin(jpNode, JoinTypeTypes.JOIN_FULL_OUTER);
        this.verifyUnaryFromClauseGroup(jpNode, "tsql:leftClause", "myG", "g");
        this.verifyUnaryFromClauseGroup(jpNode, "tsql:rightClause", "myH", "h");
        Node criteriaNode = this.verify(jpNode, "tsql:joinCriteria", "tsql:compareCriteria");
        this.verifyProperty(criteriaNode, "tsql:operator", CriteriaOperator.Operator.EQ.name());
        Node leftExpression = this.verify(criteriaNode, "tsql:leftExpression", "tsql:elementSymbol");
        this.verifyProperty(leftExpression, "tsql:name", "myG.x");
        Node rightExpression = this.verify(criteriaNode, "tsql:rightExpression", "tsql:elementSymbol");
        this.verifyProperty(rightExpression, "tsql:name", "myH.x");
        this.verifySql("SELECT myG.a AS myA, myH.b FROM g AS myG FULL OUTER JOIN h AS myH ON myG.x = myH.x", fileNode);
    }

    @Test
    public void testFullJoin() throws Exception {
        String sql = "Select myG.a myA, myH.b from g myG full join h myH on myG.x=myH.x";
        Node fileNode = this.sequenceSql(sql, TSQL_QUERY);
        Node queryNode = this.verify(fileNode, "tsql:query", "tsql:query");
        Node selectNode = this.verify(queryNode, "tsql:select", "tsql:select");
        this.verifyAliasSymbolWithElementSymbol(selectNode, "tsql:symbols", 1, "myA", "myG.a");
        this.verifyElementSymbol(selectNode, "tsql:symbols", 2, "myH.b");
        Node fromNode = this.verify(queryNode, "tsql:from", "tsql:from");
        Node jpNode = this.verify(fromNode, "tsql:clauses", "tsql:joinPredicate");
        this.verifyJoin(jpNode, JoinTypeTypes.JOIN_FULL_OUTER);
        this.verifyUnaryFromClauseGroup(jpNode, "tsql:leftClause", "myG", "g");
        this.verifyUnaryFromClauseGroup(jpNode, "tsql:rightClause", "myH", "h");
        Node criteriaNode = this.verify(jpNode, "tsql:joinCriteria", "tsql:compareCriteria");
        this.verifyProperty(criteriaNode, "tsql:operator", CriteriaOperator.Operator.EQ.name());
        Node leftExpression = this.verify(criteriaNode, "tsql:leftExpression", "tsql:elementSymbol");
        this.verifyProperty(leftExpression, "tsql:name", "myG.x");
        Node rightExpression = this.verify(criteriaNode, "tsql:rightExpression", "tsql:elementSymbol");
        this.verifyProperty(rightExpression, "tsql:name", "myH.x");
        this.verifySql("SELECT myG.a AS myA, myH.b FROM g AS myG FULL OUTER JOIN h AS myH ON myG.x = myH.x", fileNode);
    }

    @Test
    public void testConversionFunction() throws Exception {
        String sql = "SELECT CONVERT(a, string) FROM g";
        Node fileNode = this.sequenceSql(sql, TSQL_QUERY);
        Node queryNode = this.verify(fileNode, "tsql:query", "tsql:query");
        Node selectNode = this.verify(queryNode, "tsql:select", "tsql:select");
        Node functionNode = this.verifyExpressionSymbol(selectNode, "tsql:symbols", "tsql:function");
        this.verifyProperty(functionNode, "tsql:name", "CONVERT");
        this.verifyElementSymbol(functionNode, "tsql:args", 1, "a");
        this.verifyConstant(functionNode, "tsql:args", 2, "string");
        Node fromNode = this.verify(queryNode, "tsql:from", "tsql:from");
        this.verifyUnaryFromClauseGroup(fromNode, "tsql:clauses", 1, "g");
        this.verifySql(sql, fileNode);
    }

    @Test
    public void testConversionFunction2() throws Exception {
        String sql = "SELECT CONVERT(CONVERT(a, timestamp), string) FROM g";
        Node fileNode = this.sequenceSql(sql, TSQL_QUERY);
        Node queryNode = this.verify(fileNode, "tsql:query", "tsql:query");
        Node selectNode = this.verify(queryNode, "tsql:select", "tsql:select");
        Node function1Node = this.verifyExpressionSymbol(selectNode, "tsql:symbols", "tsql:function");
        this.verifyProperty(function1Node, "tsql:name", "CONVERT");
        Node function2Node = this.verify(function1Node, "tsql:args", 1, "tsql:function");
        this.verifyProperty(function2Node, "tsql:name", "CONVERT");
        this.verifyElementSymbol(function2Node, "tsql:args", 1, "a");
        this.verifyConstant(function2Node, "tsql:args", 2, "timestamp");
        this.verifyConstant(function1Node, "tsql:args", 2, "string");
        Node fromNode = this.verify(queryNode, "tsql:from", "tsql:from");
        this.verifyUnaryFromClauseGroup(fromNode, "tsql:clauses", 1, "g");
        this.verifySql(sql, fileNode);
    }

    @Test
    public void testMultiFunction() throws Exception {
        String sql = "SELECT 5 + length(concat(a, 'x')) FROM g";
        Node fileNode = this.sequenceSql(sql, TSQL_QUERY);
        Node queryNode = this.verify(fileNode, "tsql:query", "tsql:query");
        Node selectNode = this.verify(queryNode, "tsql:select", "tsql:select");
        Node function1Node = this.verifyExpressionSymbol(selectNode, "tsql:symbols", "tsql:function");
        this.verifyProperty(function1Node, "tsql:name", "+");
        this.verifyConstant(function1Node, "tsql:args", 1, 5);
        Node function2Node = this.verify(function1Node, "tsql:args", 2, "tsql:function");
        this.verifyProperty(function2Node, "tsql:name", "length");
        Node function3Node = this.verify(function2Node, "tsql:args", "tsql:function");
        this.verifyProperty(function3Node, "tsql:name", "concat");
        this.verifyElementSymbol(function3Node, "tsql:args", 1, "a");
        this.verifyConstant(function3Node, "tsql:args", 2, "x");
        Node fromNode = this.verify(queryNode, "tsql:from", "tsql:from");
        this.verifyUnaryFromClauseGroup(fromNode, "tsql:clauses", 1, "g");
        this.verifySql("SELECT (5 + length(concat(a, 'x'))) FROM g", fileNode);
    }

    @Test
    public void testAliasedFunction() throws Exception {
        String sql = "SELECT REPLACE(a, 'x', 'y') AS y FROM g";
        Node fileNode = this.sequenceSql(sql, TSQL_QUERY);
        Node queryNode = this.verify(fileNode, "tsql:query", "tsql:query");
        Node selectNode = this.verify(queryNode, "tsql:select", "tsql:select");
        Node functionNode = this.verifyAliasSymbol(selectNode, "tsql:symbols", "y", "tsql:function");
        this.verifyProperty(functionNode, "tsql:name", "REPLACE");
        this.verifyElementSymbol(functionNode, "tsql:args", 1, "a");
        this.verifyConstant(functionNode, "tsql:args", 2, "x");
        this.verifyConstant(functionNode, "tsql:args", 3, "y");
        Node fromNode = this.verify(queryNode, "tsql:from", "tsql:from");
        this.verifyUnaryFromClauseGroup(fromNode, "tsql:clauses", 1, "g");
        this.verifySql(sql, fileNode);
    }

    @Test
    public void testCastFunction() throws Exception {
        String sql = "SELECT cast(a as string) FROM g";
        Node fileNode = this.sequenceSql(sql, TSQL_QUERY);
        Node queryNode = this.verify(fileNode, "tsql:query", "tsql:query");
        Node selectNode = this.verify(queryNode, "tsql:select", "tsql:select");
        Node functionNode = this.verifyExpressionSymbol(selectNode, "tsql:symbols", "tsql:function");
        this.verifyProperty(functionNode, "tsql:name", "cast");
        this.verifyElementSymbol(functionNode, "tsql:args", 1, "a");
        this.verifyConstant(functionNode, "tsql:args", 2, "string");
        Node fromNode = this.verify(queryNode, "tsql:from", "tsql:from");
        this.verifyUnaryFromClauseGroup(fromNode, "tsql:clauses", 1, "g");
        this.verifySql("SELECT cast(a AS string) FROM g", fileNode);
    }

    @Test
    public void testMultiCastFunction() throws Exception {
        String sql = "SELECT cast(cast(a as timestamp) as string) FROM g";
        Node fileNode = this.sequenceSql(sql, TSQL_QUERY);
        Node queryNode = this.verify(fileNode, "tsql:query", "tsql:query");
        Node selectNode = this.verify(queryNode, "tsql:select", "tsql:select");
        Node function1Node = this.verifyExpressionSymbol(selectNode, "tsql:symbols", "tsql:function");
        this.verifyProperty(function1Node, "tsql:name", "cast");
        Node function2Node = this.verify(function1Node, "tsql:args", 1, "tsql:function");
        this.verifyConstant(function1Node, "tsql:args", 2, "string");
        this.verifyElementSymbol(function2Node, "tsql:args", 1, "a");
        this.verifyConstant(function2Node, "tsql:args", 2, "timestamp");
        Node fromNode = this.verify(queryNode, "tsql:from", "tsql:from");
        this.verifyUnaryFromClauseGroup(fromNode, "tsql:clauses", 1, "g");
        this.verifySql("SELECT cast(cast(a AS timestamp) AS string) FROM g", fileNode);
    }

    @Test
    public void testLeftFunction() throws Exception {
        String sql = "SELECT left(fullname, 3) as x FROM sys.groups";
        Node fileNode = this.sequenceSql(sql, TSQL_QUERY);
        Node queryNode = this.verify(fileNode, "tsql:query", "tsql:query");
        Node selectNode = this.verify(queryNode, "tsql:select", "tsql:select");
        Node functionNode = this.verifyAliasSymbol(selectNode, "tsql:symbols", "x", "tsql:function");
        this.verifyProperty(functionNode, "tsql:name", "left");
        this.verifyElementSymbol(functionNode, "tsql:args", 1, "fullname");
        this.verifyConstant(functionNode, "tsql:args", 2, 3);
        Node fromNode = this.verify(queryNode, "tsql:from", "tsql:from");
        this.verifyUnaryFromClauseGroup(fromNode, "tsql:clauses", 1, "sys.groups");
        this.verifySql("SELECT left(fullname, 3) AS x FROM sys.groups", fileNode);
    }

    @Test
    public void testRightFunction() throws Exception {
        String sql = "SELECT right(fullname, 3) AS x FROM sys.groups";
        Node fileNode = this.sequenceSql(sql, TSQL_QUERY);
        Node queryNode = this.verify(fileNode, "tsql:query", "tsql:query");
        Node selectNode = this.verify(queryNode, "tsql:select", "tsql:select");
        Node functionNode = this.verifyAliasSymbol(selectNode, "tsql:symbols", "x", "tsql:function");
        this.verifyProperty(functionNode, "tsql:name", "right");
        this.verifyElementSymbol(functionNode, "tsql:args", 1, "fullname");
        this.verifyConstant(functionNode, "tsql:args", 2, 3);
        Node fromNode = this.verify(queryNode, "tsql:from", "tsql:from");
        this.verifyUnaryFromClauseGroup(fromNode, "tsql:clauses", 1, "sys.groups");
        this.verifySql(sql, fileNode);
    }

    @Test
    public void testInsertIntoSelect() throws Exception {
        String sql = "insert into tempA SELECT 1";
        Node fileNode = this.sequenceSql(sql, TSQL_INSERT);
        Node insertNode = this.verify(fileNode, "tsql:insert", "tsql:insert");
        Node gsNode = this.verify(insertNode, "tsql:group", "tsql:groupSymbol");
        this.verifyProperty(gsNode, "tsql:name", "tempA");
        Node queryNode = this.verify(insertNode, "tsql:queryExpression", "tsql:query");
        Node selectNode = this.verify(queryNode, "tsql:select", "tsql:select");
        Node constantNode = this.verifyExpressionSymbol(selectNode, "tsql:symbols", "tsql:constant");
        this.verifyProperty(constantNode, "tsql:value", 1L);
        this.verifySql("INSERT INTO tempA SELECT 1", fileNode);
    }

    @Test
    public void testGroupByHaving() throws Exception {
        String sql = "SELECT a FROM m.g GROUP BY b, c HAVING b=5";
        Node fileNode = this.sequenceSql(sql, TSQL_QUERY);
        Node queryNode = this.verify(fileNode, "tsql:query", "tsql:query");
        Node selectNode = this.verify(queryNode, "tsql:select", "tsql:select");
        this.verifyElementSymbol(selectNode, "tsql:symbols", "a");
        Node fromNode = this.verify(queryNode, "tsql:from", "tsql:from");
        this.verifyUnaryFromClauseGroup(fromNode, "tsql:clauses", 1, "m.g");
        Node groupByNode = this.verify(queryNode, "tsql:groupBy", "tsql:groupBy");
        this.verifyElementSymbol(groupByNode, "tsql:symbols", 1, "b");
        this.verifyElementSymbol(groupByNode, "tsql:symbols", 2, "c");
        Node havingNode = this.verify(queryNode, "tsql:having", "tsql:compareCriteria");
        this.verifyProperty(havingNode, "tsql:operator", CriteriaOperator.Operator.EQ.name());
        this.verifyElementSymbol(havingNode, "tsql:leftExpression", "b");
        this.verifyConstant(havingNode, "tsql:rightExpression", 5);
        this.verifySql("SELECT a FROM m.g GROUP BY b, c HAVING b = 5", fileNode);
    }

    @Test
    public void testAggregateFunction() throws Exception {
        String sql = "SELECT COUNT(a) AS c FROM m.g";
        Node fileNode = this.sequenceSql(sql, TSQL_QUERY);
        Node queryNode = this.verify(fileNode, "tsql:query", "tsql:query");
        Node selectNode = this.verify(queryNode, "tsql:select", "tsql:select");
        Node aggregateNode = this.verifyAliasSymbol(selectNode, "tsql:symbols", "c", "tsql:aggregateSymbol");
        this.verifyProperty(aggregateNode, "tsql:aggregateFunction", "COUNT");
        this.verifyProperty(aggregateNode, "tsql:distinct", false);
        this.verifyElementSymbol(aggregateNode, "tsql:args", "a");
        Node fromNode = this.verify(queryNode, "tsql:from", "tsql:from");
        this.verifyUnaryFromClauseGroup(fromNode, "tsql:clauses", 1, "m.g");
        this.verifySql(sql, fileNode);
    }

    @Test
    public void testHavingFunction() throws Exception {
        String sql = "SELECT a FROM m.g GROUP BY a HAVING COUNT(b) > 0";
        Node fileNode = this.sequenceSql(sql, TSQL_QUERY);
        Node queryNode = this.verify(fileNode, "tsql:query", "tsql:query");
        Node selectNode = this.verify(queryNode, "tsql:select", "tsql:select");
        this.verifyElementSymbol(selectNode, "tsql:symbols", "a");
        Node fromNode = this.verify(queryNode, "tsql:from", "tsql:from");
        this.verifyUnaryFromClauseGroup(fromNode, "tsql:clauses", 1, "m.g");
        Node groupByNode = this.verify(queryNode, "tsql:groupBy", "tsql:groupBy");
        this.verifyElementSymbol(groupByNode, "tsql:symbols", 1, "a");
        Node havingNode = this.verify(queryNode, "tsql:having", "tsql:compareCriteria");
        this.verifyProperty(havingNode, "tsql:operator", CriteriaOperator.Operator.GT.name());
        Node aggregateNode = this.verify(havingNode, "tsql:leftExpression", "tsql:aggregateSymbol");
        this.verifyProperty(aggregateNode, "tsql:aggregateFunction", "COUNT");
        this.verifyProperty(aggregateNode, "tsql:distinct", false);
        this.verifyElementSymbol(aggregateNode, "tsql:args", "b");
        this.verifyConstant(havingNode, "tsql:rightExpression", 0);
        this.verifySql(sql, fileNode);
    }

    @Test
    public void testArithmeticNullFunction() throws Exception {
        String sql = "SELECT 5-null, a.g1.c1 FROM a.g1";
        Node fileNode = this.sequenceSql(sql, TSQL_QUERY);
        Node queryNode = this.verify(fileNode, "tsql:query", "tsql:query");
        Node selectNode = this.verify(queryNode, "tsql:select", "tsql:select");
        Node functionNode = this.verifyExpressionSymbol(selectNode, "tsql:symbols", 1, "tsql:function");
        this.verifyElementSymbol(selectNode, "tsql:symbols", 2, "a.g1.c1");
        this.verifyProperty(functionNode, "tsql:name", "-");
        this.verifyConstant(functionNode, "tsql:args", 1, 5);
        Node fromNode = this.verify(queryNode, "tsql:from", "tsql:from");
        this.verifyUnaryFromClauseGroup(fromNode, "tsql:clauses", 1, "a.g1");
        this.verifySql("SELECT (5 - null), a.g1.c1 FROM a.g1", fileNode);
    }

    @Test
    public void testStringLiteral() throws Exception {
        String sql = "SELECT 'abc' FROM a.g1";
        Node fileNode = this.sequenceSql(sql, TSQL_QUERY);
        Node queryNode = this.verify(fileNode, "tsql:query", "tsql:query");
        Node selectNode = this.verify(queryNode, "tsql:select", "tsql:select");
        Node constantNode = this.verifyExpressionSymbol(selectNode, "tsql:symbols", 1, "tsql:constant");
        this.verifyProperty(constantNode, "tsql:value", "abc");
        Node fromNode = this.verify(queryNode, "tsql:from", "tsql:from");
        this.verifyUnaryFromClauseGroup(fromNode, "tsql:clauses", 1, "a.g1");
        this.verifySql(sql, fileNode);
    }

    @Test
    public void testStringLiteralEscapedTick() throws Exception {
        String sql = "SELECT 'O''Leary' FROM a.g1";
        Node fileNode = this.sequenceSql(sql, TSQL_QUERY);
        Node queryNode = this.verify(fileNode, "tsql:query", "tsql:query");
        Node selectNode = this.verify(queryNode, "tsql:select", "tsql:select");
        Node constantNode = this.verifyExpressionSymbol(selectNode, "tsql:symbols", 1, "tsql:constant");
        this.verifyProperty(constantNode, "tsql:value", "O'Leary");
        Node fromNode = this.verify(queryNode, "tsql:from", "tsql:from");
        this.verifyUnaryFromClauseGroup(fromNode, "tsql:clauses", 1, "a.g1");
        this.verifySql(sql, fileNode);
    }

    @Test
    public void testStringLiteralEscapedTick2() throws Exception {
        String sql = "SELECT '''abc''' FROM a.g1";
        Node fileNode = this.sequenceSql(sql, TSQL_QUERY);
        Node queryNode = this.verify(fileNode, "tsql:query", "tsql:query");
        Node selectNode = this.verify(queryNode, "tsql:select", "tsql:select");
        Node constantNode = this.verifyExpressionSymbol(selectNode, "tsql:symbols", 1, "tsql:constant");
        this.verifyProperty(constantNode, "tsql:value", "'abc'");
        Node fromNode = this.verify(queryNode, "tsql:from", "tsql:from");
        this.verifyUnaryFromClauseGroup(fromNode, "tsql:clauses", 1, "a.g1");
        this.verifySql(sql, fileNode);
    }

    @Test
    public void testStringLiteralEscapedTick3() throws Exception {
        String sql = "SELECT 'a''b''c' FROM a.g1";
        Node fileNode = this.sequenceSql(sql, TSQL_QUERY);
        Node queryNode = this.verify(fileNode, "tsql:query", "tsql:query");
        Node selectNode = this.verify(queryNode, "tsql:select", "tsql:select");
        Node constantNode = this.verifyExpressionSymbol(selectNode, "tsql:symbols", 1, "tsql:constant");
        this.verifyProperty(constantNode, "tsql:value", "a'b'c");
        Node fromNode = this.verify(queryNode, "tsql:from", "tsql:from");
        this.verifyUnaryFromClauseGroup(fromNode, "tsql:clauses", 1, "a.g1");
        this.verifySql(sql, fileNode);
    }

    @Test
    public void testStringLiteralEscapedTick4() throws Exception {
        String sql = "SELECT \" \"\" \" FROM a.g1";
        Node fileNode = this.sequenceSql(sql, TSQL_QUERY);
        Node queryNode = this.verify(fileNode, "tsql:query", "tsql:query");
        Node selectNode = this.verify(queryNode, "tsql:select", "tsql:select");
        this.verifyElementSymbol(selectNode, "tsql:symbols", " \" ");
        Node fromNode = this.verify(queryNode, "tsql:from", "tsql:from");
        this.verifyUnaryFromClauseGroup(fromNode, "tsql:clauses", 1, "a.g1");
        this.verifySql(sql, fileNode);
    }

    @Test
    public void testLongLiteral() throws Exception {
        String sql = "SELECT 123456789012 FROM a.g1";
        Node fileNode = this.sequenceSql(sql, TSQL_QUERY);
        Node queryNode = this.verify(fileNode, "tsql:query", "tsql:query");
        Node selectNode = this.verify(queryNode, "tsql:select", "tsql:select");
        Node constantNode = this.verifyExpressionSymbol(selectNode, "tsql:symbols", 1, "tsql:constant");
        this.verifyProperty(constantNode, "tsql:value", 123456789012L);
        Node fromNode = this.verify(queryNode, "tsql:from", "tsql:from");
        this.verifyUnaryFromClauseGroup(fromNode, "tsql:clauses", 1, "a.g1");
        this.verifySql(sql, fileNode);
    }

    @Test
    public void testDateLiteral1() throws Exception {
        String sql = "SELECT {d'2002-10-02'} FROM m.g1";
        Node fileNode = this.sequenceSql(sql, TSQL_QUERY);
        Node queryNode = this.verify(fileNode, "tsql:query", "tsql:query");
        Node selectNode = this.verify(queryNode, "tsql:select", "tsql:select");
        Node constantNode = this.verifyExpressionSymbol(selectNode, "tsql:symbols", 1, "tsql:constant");
        this.verifyProperty(constantNode, "tsql:value", Date.valueOf("2002-10-02"));
        Node fromNode = this.verify(queryNode, "tsql:from", "tsql:from");
        this.verifyUnaryFromClauseGroup(fromNode, "tsql:clauses", 1, "m.g1");
        this.verifySql(sql, fileNode);
    }

    @Test
    public void testTimeLiteral1() throws Exception {
        String sql = "SELECT {t'11:10:00'} FROM m.g1";
        Node fileNode = this.sequenceSql(sql, TSQL_QUERY);
        Node queryNode = this.verify(fileNode, "tsql:query", "tsql:query");
        Node selectNode = this.verify(queryNode, "tsql:select", "tsql:select");
        Node constantNode = this.verifyExpressionSymbol(selectNode, "tsql:symbols", 1, "tsql:constant");
        this.verifyProperty(constantNode, "tsql:value", Time.valueOf("11:10:00"));
        Node fromNode = this.verify(queryNode, "tsql:from", "tsql:from");
        this.verifyUnaryFromClauseGroup(fromNode, "tsql:clauses", 1, "m.g1");
        this.verifySql(sql, fileNode);
    }

    @Test
    public void testBooleanLiteralTrue() throws Exception {
        Boolean expected = Boolean.TRUE;
        String sql = "SELECT {b'true'}";
        Node fileNode = this.sequenceSql(sql, TSQL_QUERY);
        Node queryNode = this.verify(fileNode, "tsql:query", "tsql:query");
        Node selectNode = this.verify(queryNode, "tsql:select", "tsql:select");
        Node constantNode = this.verifyExpressionSymbol(selectNode, "tsql:symbols", "tsql:constant");
        this.verifyProperty(constantNode, "tsql:value", expected);
        this.verifyProperty(constantNode, "tsql:typeClass", DataTypeManager.DataTypeName.BOOLEAN.name());
        this.verifySql("SELECT TRUE", fileNode);
    }

    @Test
    public void testBooleanLiteralTrue2() throws Exception {
        Boolean expected = Boolean.TRUE;
        String sql = "SELECT TRUE";
        Node fileNode = this.sequenceSql(sql, TSQL_QUERY);
        Node queryNode = this.verify(fileNode, "tsql:query", "tsql:query");
        Node selectNode = this.verify(queryNode, "tsql:select", "tsql:select");
        Node constantNode = this.verifyExpressionSymbol(selectNode, "tsql:symbols", "tsql:constant");
        this.verifyProperty(constantNode, "tsql:value", expected);
        this.verifyProperty(constantNode, "tsql:typeClass", DataTypeManager.DataTypeName.BOOLEAN.name());
        this.verifySql("SELECT TRUE", fileNode);
    }

    @Test
    public void testBooleanLiteralFalse() throws Exception {
        Boolean expected = Boolean.FALSE;
        String sql = "SELECT {b'false'}";
        Node fileNode = this.sequenceSql(sql, TSQL_QUERY);
        Node queryNode = this.verify(fileNode, "tsql:query", "tsql:query");
        Node selectNode = this.verify(queryNode, "tsql:select", "tsql:select");
        Node constantNode = this.verifyExpressionSymbol(selectNode, "tsql:symbols", "tsql:constant");
        this.verifyProperty(constantNode, "tsql:value", expected);
        this.verifyProperty(constantNode, "tsql:typeClass", DataTypeManager.DataTypeName.BOOLEAN.name());
        this.verifySql("SELECT FALSE", fileNode);
    }

    @Test
    public void testBooleanLiteralFalse2() throws Exception {
        Boolean expected = Boolean.FALSE;
        String sql = "SELECT {b'false'}";
        Node fileNode = this.sequenceSql(sql, TSQL_QUERY);
        Node queryNode = this.verify(fileNode, "tsql:query", "tsql:query");
        Node selectNode = this.verify(queryNode, "tsql:select", "tsql:select");
        Node constantNode = this.verifyExpressionSymbol(selectNode, "tsql:symbols", "tsql:constant");
        this.verifyProperty(constantNode, "tsql:value", expected);
        this.verifyProperty(constantNode, "tsql:typeClass", DataTypeManager.DataTypeName.BOOLEAN.name());
        this.verifySql("SELECT FALSE", fileNode);
    }

    @Test
    public void testBooleanLiteralUnknown() throws Exception {
        String sql = "SELECT {b'unknown'}";
        Node fileNode = this.sequenceSql(sql, TSQL_QUERY);
        Node queryNode = this.verify(fileNode, "tsql:query", "tsql:query");
        Node selectNode = this.verify(queryNode, "tsql:select", "tsql:select");
        Node constantNode = this.verifyExpressionSymbol(selectNode, "tsql:symbols", "tsql:constant");
        Assert.assertFalse((boolean)constantNode.hasProperty("tsql:value"));
        this.verifyProperty(constantNode, "tsql:typeClass", DataTypeManager.DataTypeName.BOOLEAN.name());
        this.verifySql("SELECT UNKNOWN", fileNode);
    }

    @Test
    public void testSelectDistinct() throws Exception {
        String sql = "SELECT DISTINCT a FROM g";
        Node fileNode = this.sequenceSql(sql, TSQL_QUERY);
        Node queryNode = this.verify(fileNode, "tsql:query", "tsql:query");
        Node selectNode = this.verify(queryNode, "tsql:select", "tsql:select");
        this.verifyElementSymbol(selectNode, "tsql:symbols", "a");
        this.verifyProperty(selectNode, "tsql:distinct", true);
        Node fromNode = this.verify(queryNode, "tsql:from", "tsql:from");
        this.verifyUnaryFromClauseGroup(fromNode, "tsql:clauses", 1, "g");
        this.verifySql(sql, fileNode);
    }

    @Test
    public void testSelectAll() throws Exception {
        String sql = "SELECT ALL a FROM g";
        Node fileNode = this.sequenceSql(sql, TSQL_QUERY);
        Node queryNode = this.verify(fileNode, "tsql:query", "tsql:query");
        Node selectNode = this.verify(queryNode, "tsql:select", "tsql:select");
        this.verifyElementSymbol(selectNode, "tsql:symbols", "a");
        this.verifyProperty(selectNode, "tsql:distinct", false);
        Node fromNode = this.verify(queryNode, "tsql:from", "tsql:from");
        this.verifyUnaryFromClauseGroup(fromNode, "tsql:clauses", 1, "g");
        this.verifySql("SELECT a FROM g", fileNode);
    }

    @Test
    public void testAliasInFrom() throws Exception {
        String sql = "SELECT myG.a FROM g AS myG";
        Node fileNode = this.sequenceSql(sql, TSQL_QUERY);
        Node queryNode = this.verify(fileNode, "tsql:query", "tsql:query");
        Node selectNode = this.verify(queryNode, "tsql:select", "tsql:select");
        this.verifyElementSymbol(selectNode, "tsql:symbols", "myG.a");
        Node fromNode = this.verify(queryNode, "tsql:from", "tsql:from");
        this.verifyUnaryFromClauseGroup(fromNode, "tsql:clauses", 1, "myG", "g");
        this.verifySql(sql, fileNode);
    }

    @Test
    public void testAliasesInFrom() throws Exception {
        String sql = "SELECT myG.*, myH.b FROM g AS myG, h AS myH";
        Node fileNode = this.sequenceSql(sql, TSQL_QUERY);
        Node queryNode = this.verify(fileNode, "tsql:query", "tsql:query");
        Node selectNode = this.verify(queryNode, "tsql:select", "tsql:select");
        Node meSymbolNode = this.verify(selectNode, "tsql:symbols", 1, "tsql:multipleElementSymbol");
        Node groupSymbolNode = this.verify(meSymbolNode, "tsql:group", "tsql:groupSymbol");
        this.verifyProperty(groupSymbolNode, "tsql:name", "myG");
        this.verifyElementSymbol(selectNode, "tsql:symbols", 2, "myH.b");
        Node fromNode = this.verify(queryNode, "tsql:from", "tsql:from");
        this.verifyUnaryFromClauseGroup(fromNode, "tsql:clauses", 1, "myG", "g");
        this.verifyUnaryFromClauseGroup(fromNode, "tsql:clauses", 2, "myH", "h");
        this.verifySql(sql, fileNode);
    }

    @Test
    public void testHiddenAliasesInFrom() throws Exception {
        String sql = "SELECT myG.*, myH.b FROM g myG, h myH";
        Node fileNode = this.sequenceSql(sql, TSQL_QUERY);
        Node queryNode = this.verify(fileNode, "tsql:query", "tsql:query");
        Node selectNode = this.verify(queryNode, "tsql:select", "tsql:select");
        Node meSymbolNode = this.verify(selectNode, "tsql:symbols", 1, "tsql:multipleElementSymbol");
        Node groupSymbolNode = this.verify(meSymbolNode, "tsql:group", "tsql:groupSymbol");
        this.verifyProperty(groupSymbolNode, "tsql:name", "myG");
        this.verifyElementSymbol(selectNode, "tsql:symbols", 2, "myH.b");
        Node fromNode = this.verify(queryNode, "tsql:from", "tsql:from");
        this.verifyUnaryFromClauseGroup(fromNode, "tsql:clauses", 1, "myG", "g");
        this.verifyUnaryFromClauseGroup(fromNode, "tsql:clauses", 2, "myH", "h");
        this.verifySql("SELECT myG.*, myH.b FROM g AS myG, h AS myH", fileNode);
    }

    @Test
    public void testIsNullCriteria1() throws Exception {
        String sql = "Select a From db.g Where a IS NULL";
        Node fileNode = this.sequenceSql(sql, TSQL_QUERY);
        Node queryNode = this.verify(fileNode, "tsql:query", "tsql:query");
        Node selectNode = this.verify(queryNode, "tsql:select", "tsql:select");
        this.verifyElementSymbol(selectNode, "tsql:symbols", "a");
        Node fromNode = this.verify(queryNode, "tsql:from", "tsql:from");
        this.verifyUnaryFromClauseGroup(fromNode, "tsql:clauses", "db.g");
        Node criteriaNode = this.verify(queryNode, "tsql:criteria", "tsql:isNullCriteria");
        this.verifyElementSymbol(criteriaNode, "tsql:expression", "a");
        this.verifySql("SELECT a FROM db.g WHERE a IS NULL", fileNode);
    }

    @Test
    public void testIsNullCriteria2() throws Exception {
        String sql = "Select a From db.g Where a IS NOT NULL";
        Node fileNode = this.sequenceSql(sql, TSQL_QUERY);
        Node queryNode = this.verify(fileNode, "tsql:query", "tsql:query");
        Node selectNode = this.verify(queryNode, "tsql:select", "tsql:select");
        this.verifyElementSymbol(selectNode, "tsql:symbols", "a");
        Node fromNode = this.verify(queryNode, "tsql:from", "tsql:from");
        this.verifyUnaryFromClauseGroup(fromNode, "tsql:clauses", "db.g");
        Node criteriaNode = this.verify(queryNode, "tsql:criteria", "tsql:isNullCriteria");
        this.verifyElementSymbol(criteriaNode, "tsql:expression", "a");
        this.verifyProperty(criteriaNode, "tsql:negated", true);
        this.verifySql("SELECT a FROM db.g WHERE a IS NOT NULL", fileNode);
    }

    @Test
    public void testNotIsNullCriteria() throws Exception {
        String sql = "Select a From db.g Where Not a IS NULL";
        Node fileNode = this.sequenceSql(sql, TSQL_QUERY);
        Node queryNode = this.verify(fileNode, "tsql:query", "tsql:query");
        Node selectNode = this.verify(queryNode, "tsql:select", "tsql:select");
        this.verifyElementSymbol(selectNode, "tsql:symbols", "a");
        Node fromNode = this.verify(queryNode, "tsql:from", "tsql:from");
        this.verifyUnaryFromClauseGroup(fromNode, "tsql:clauses", "db.g");
        Node notCriteriaNode = this.verify(queryNode, "tsql:criteria", "tsql:notCriteria");
        Node isNullCriteriaNode = this.verify(notCriteriaNode, "tsql:criteria", "tsql:isNullCriteria");
        this.verifyElementSymbol(isNullCriteriaNode, "tsql:expression", "a");
        this.verifySql("SELECT a FROM db.g WHERE NOT (a IS NULL)", fileNode);
    }

    @Test
    public void testStringNotEqualDoubleTicks() throws Exception {
        String sql = "SELECT a from db.g where a <> \"value\"";
        Node fileNode = this.sequenceSql(sql, TSQL_QUERY);
        Node queryNode = this.verify(fileNode, "tsql:query", "tsql:query");
        Node selectNode = this.verify(queryNode, "tsql:select", "tsql:select");
        this.verifyElementSymbol(selectNode, "tsql:symbols", "a");
        Node fromNode = this.verify(queryNode, "tsql:from", "tsql:from");
        this.verifyUnaryFromClauseGroup(fromNode, "tsql:clauses", "db.g");
        Node criteriaNode = this.verify(queryNode, "tsql:criteria", "tsql:compareCriteria");
        this.verifyProperty(criteriaNode, "tsql:operator", CriteriaOperator.Operator.NE.name());
        this.verifyElementSymbol(criteriaNode, "tsql:leftExpression", "a");
        this.verifyElementSymbol(criteriaNode, "tsql:rightExpression", "value");
        this.verifySql("SELECT a FROM db.g WHERE a <> \"value\"", fileNode);
    }

    @Test
    public void testNotEquals2() throws Exception {
        String sql = "SELECT a from db.g where a != 'value'";
        Node fileNode = this.sequenceSql(sql, TSQL_QUERY);
        Node queryNode = this.verify(fileNode, "tsql:query", "tsql:query");
        Node selectNode = this.verify(queryNode, "tsql:select", "tsql:select");
        this.verifyElementSymbol(selectNode, "tsql:symbols", "a");
        Node fromNode = this.verify(queryNode, "tsql:from", "tsql:from");
        this.verifyUnaryFromClauseGroup(fromNode, "tsql:clauses", "db.g");
        Node criteriaNode = this.verify(queryNode, "tsql:criteria", "tsql:compareCriteria");
        this.verifyProperty(criteriaNode, "tsql:operator", CriteriaOperator.Operator.NE.name());
        this.verifyElementSymbol(criteriaNode, "tsql:leftExpression", "a");
        this.verifyConstant(criteriaNode, "tsql:rightExpression", "value");
        this.verifySql("SELECT a FROM db.g WHERE a <> 'value'", fileNode);
    }

    @Test
    public void testPartlyQuotedGroup() throws Exception {
        String sql = "SELECT a from db.\"g\" where a = 5";
        Node fileNode = this.sequenceSql(sql, TSQL_QUERY);
        Node queryNode = this.verify(fileNode, "tsql:query", "tsql:query");
        Node selectNode = this.verify(queryNode, "tsql:select", "tsql:select");
        this.verifyElementSymbol(selectNode, "tsql:symbols", "a");
        Node fromNode = this.verify(queryNode, "tsql:from", "tsql:from");
        this.verifyUnaryFromClauseGroup(fromNode, "tsql:clauses", "db.g");
        Node criteriaNode = this.verify(queryNode, "tsql:criteria", "tsql:compareCriteria");
        this.verifyProperty(criteriaNode, "tsql:operator", CriteriaOperator.Operator.EQ.name());
        this.verifyElementSymbol(criteriaNode, "tsql:leftExpression", "a");
        this.verifyConstant(criteriaNode, "tsql:rightExpression", 5);
        this.verifySql("SELECT a FROM db.g WHERE a = 5", fileNode);
    }

    @Test
    public void testXMLCriteriaWithAttribute() throws Exception {
        String sql = "SELECT * FROM model.doc WHERE ab.cd.@ef = 'abc'";
        Node fileNode = this.sequenceSql(sql, TSQL_QUERY);
        Node queryNode = this.verify(fileNode, "tsql:query", "tsql:query");
        Node selectNode = this.verify(queryNode, "tsql:select", "tsql:select");
        this.verify(selectNode, "tsql:symbols", "tsql:multipleElementSymbol");
        Node fromNode = this.verify(queryNode, "tsql:from", "tsql:from");
        this.verifyUnaryFromClauseGroup(fromNode, "tsql:clauses", "model.doc");
        Node criteriaNode = this.verify(queryNode, "tsql:criteria", "tsql:compareCriteria");
        this.verifyProperty(criteriaNode, "tsql:operator", CriteriaOperator.Operator.EQ.name());
        this.verifyElementSymbol(criteriaNode, "tsql:leftExpression", "ab.cd.@ef");
        this.verifyConstant(criteriaNode, "tsql:rightExpression", "abc");
        this.verifySql(sql, fileNode);
    }

    @Test
    public void testBetween1() throws Exception {
        String sql = "SELECT a from db.g where a BETWEEN 1000 AND 2000";
        Node fileNode = this.sequenceSql(sql, TSQL_QUERY);
        Node queryNode = this.verify(fileNode, "tsql:query", "tsql:query");
        Node selectNode = this.verify(queryNode, "tsql:select", "tsql:select");
        this.verifyElementSymbol(selectNode, "tsql:symbols", "a");
        Node fromNode = this.verify(queryNode, "tsql:from", "tsql:from");
        this.verifyUnaryFromClauseGroup(fromNode, "tsql:clauses", "db.g");
        Node criteriaNode = this.verify(queryNode, "tsql:criteria", "tsql:betweenCriteria");
        this.verifyElementSymbol(criteriaNode, "tsql:expression", "a");
        this.verifyConstant(criteriaNode, "tsql:lowerExpression", 1000);
        this.verifyConstant(criteriaNode, "tsql:upperExpression", 2000);
        this.verifySql("SELECT a FROM db.g WHERE a BETWEEN 1000 AND 2000", fileNode);
    }

    @Test
    public void testSetCriteria0() throws Exception {
        String sql = "SELECT a FROM db.g WHERE b IN (1000,5000)";
        Node fileNode = this.sequenceSql(sql, TSQL_QUERY);
        Node queryNode = this.verify(fileNode, "tsql:query", "tsql:query");
        Node selectNode = this.verify(queryNode, "tsql:select", "tsql:select");
        this.verifyElementSymbol(selectNode, "tsql:symbols", "a");
        Node fromNode = this.verify(queryNode, "tsql:from", "tsql:from");
        this.verifyUnaryFromClauseGroup(fromNode, "tsql:clauses", "db.g");
        Node criteriaNode = this.verify(queryNode, "tsql:criteria", "tsql:setCriteria");
        this.verifyElementSymbol(criteriaNode, "tsql:expression", "b");
        this.verifyConstant(criteriaNode, "tsql:values", 1, 1000);
        this.verifyConstant(criteriaNode, "tsql:values", 2, 5000);
        this.verifySql("SELECT a FROM db.g WHERE b IN (1000, 5000)", fileNode);
    }

    @Test
    public void testOrderByDesc() throws Exception {
        String sql = "SELECT a FROM db.g WHERE b = aString ORDER BY c desc";
        Node fileNode = this.sequenceSql(sql, TSQL_QUERY);
        Node queryNode = this.verify(fileNode, "tsql:query", "tsql:query");
        Node selectNode = this.verify(queryNode, "tsql:select", "tsql:select");
        this.verifyElementSymbol(selectNode, "tsql:symbols", "a");
        Node fromNode = this.verify(queryNode, "tsql:from", "tsql:from");
        this.verifyUnaryFromClauseGroup(fromNode, "tsql:clauses", "db.g");
        Node criteriaNode = this.verify(queryNode, "tsql:criteria", "tsql:compareCriteria");
        this.verifyProperty(criteriaNode, "tsql:operator", CriteriaOperator.Operator.EQ.name());
        this.verifyElementSymbol(criteriaNode, "tsql:leftExpression", "b");
        this.verifyElementSymbol(criteriaNode, "tsql:rightExpression", "aString");
        Node orderByNode = this.verify(queryNode, "tsql:orderBy", "tsql:orderBy");
        Node obItemNode = this.verify(orderByNode, "tsql:orderByItems", "tsql:orderByItem");
        this.verifyElementSymbol(obItemNode, "tsql:symbol", "c");
        this.verifyProperty(obItemNode, "tsql:ascending", false);
        this.verifySql("SELECT a FROM db.g WHERE b = aString ORDER BY c DESC", fileNode);
    }

    @Test
    public void testOrderByNullOrdering() throws Exception {
        String sql = "SELECT a FROM db.g WHERE b = aString ORDER BY c NULLS FIRST,d desc nulls last";
        Node fileNode = this.sequenceSql(sql, TSQL_QUERY);
        Node queryNode = this.verify(fileNode, "tsql:query", "tsql:query");
        Node selectNode = this.verify(queryNode, "tsql:select", "tsql:select");
        this.verifyElementSymbol(selectNode, "tsql:symbols", "a");
        Node fromNode = this.verify(queryNode, "tsql:from", "tsql:from");
        this.verifyUnaryFromClauseGroup(fromNode, "tsql:clauses", "db.g");
        Node criteriaNode = this.verify(queryNode, "tsql:criteria", "tsql:compareCriteria");
        this.verifyProperty(criteriaNode, "tsql:operator", CriteriaOperator.Operator.EQ.name());
        this.verifyElementSymbol(criteriaNode, "tsql:leftExpression", "b");
        this.verifyElementSymbol(criteriaNode, "tsql:rightExpression", "aString");
        Node orderByNode = this.verify(queryNode, "tsql:orderBy", "tsql:orderBy");
        Node obItem1Node = this.verify(orderByNode, "tsql:orderByItems", 1, "tsql:orderByItem");
        this.verifyElementSymbol(obItem1Node, "tsql:symbol", "c");
        this.verifyProperty(obItem1Node, "tsql:ascending", true);
        this.verifyProperty(obItem1Node, "tsql:nullOrdering", SortSpecification.NullOrdering.FIRST.name());
        Node obItem2Node = this.verify(orderByNode, "tsql:orderByItems", 2, "tsql:orderByItem");
        this.verifyElementSymbol(obItem2Node, "tsql:symbol", "d");
        this.verifyProperty(obItem2Node, "tsql:ascending", false);
        this.verifyProperty(obItem2Node, "tsql:nullOrdering", SortSpecification.NullOrdering.LAST.name());
        this.verifySql("SELECT a FROM db.g WHERE b = aString ORDER BY c NULLS FIRST, d DESC NULLS LAST", fileNode);
    }

    @Test
    public void testLikeWithEscape() throws Exception {
        String sql = "SELECT a from db.g where b like '#String' escape '#'";
        Node fileNode = this.sequenceSql(sql, TSQL_QUERY);
        Node queryNode = this.verify(fileNode, "tsql:query", "tsql:query");
        Node selectNode = this.verify(queryNode, "tsql:select", "tsql:select");
        this.verifyElementSymbol(selectNode, "tsql:symbols", "a");
        Node fromNode = this.verify(queryNode, "tsql:from", "tsql:from");
        this.verifyUnaryFromClauseGroup(fromNode, "tsql:clauses", "db.g");
        Node criteriaNode = this.verify(queryNode, "tsql:criteria", "tsql:matchCriteria");
        this.verifyProperty(criteriaNode, "tsql:escapeChar", "#");
        this.verifyElementSymbol(criteriaNode, "tsql:leftExpression", "b");
        this.verifyConstant(criteriaNode, "tsql:rightExpression", "#String");
        this.verifySql("SELECT a FROM db.g WHERE b LIKE '#String' ESCAPE '#'", fileNode);
    }

    @Test
    public void testNoFromClause() throws Exception {
        String sql = "SELECT a, 5";
        Node fileNode = this.sequenceSql(sql, TSQL_QUERY);
        Node queryNode = this.verify(fileNode, "tsql:query", "tsql:query");
        Node selectNode = this.verify(queryNode, "tsql:select", "tsql:select");
        this.verifyElementSymbol(selectNode, "tsql:symbols", "a");
        Node constantNode = this.verifyExpressionSymbol(selectNode, "tsql:symbols", 2, "tsql:constant");
        this.verifyProperty(constantNode, "tsql:value", 5L);
        this.verifyProperty(constantNode, "tsql:typeClass", DataTypeManager.DataTypeName.INTEGER.name());
        this.verifySql(sql, fileNode);
    }

    @Test
    public void testInsertWithReference() throws Exception {
        String sql = "INSERT INTO m.g (a) VALUES (?)";
        Node fileNode = this.sequenceSql(sql, TSQL_INSERT);
        Node insertNode = this.verify(fileNode, "tsql:insert", "tsql:insert");
        Node gsNode = this.verify(insertNode, "tsql:group", "tsql:groupSymbol");
        this.verifyProperty(gsNode, "tsql:name", "m.g");
        this.verifyElementSymbol(insertNode, "tsql:variables", "a");
        Node refNode = this.verify(insertNode, "tsql:values", "tsql:reference");
        this.verifyProperty(refNode, "tsql:index", 0L);
        this.verifyProperty(refNode, "tsql:positional", true);
        this.verifySql(sql, fileNode);
    }

    @Test
    public void testIfStatement() throws Exception {
        String sql = this.deriveProcPrefix(false) + "IF(c = 5) BEGIN DECLARE short a; END ELSE BEGIN DECLARE short b; END END";
        Node fileNode = this.sequenceSql(sql, TSQL_PROC_CMD);
        Node procNode = this.verify(fileNode, "tsql:createProcedureCommand", "tsql:createProcedureCommand");
        Node outerBlkNode = this.verify(procNode, "tsql:block", "tsql:block");
        Node stmtNode = this.verify(outerBlkNode, "tsql:statements", "tsql:ifStatement");
        Node ifBlockNode = this.verify(stmtNode, "tsql:ifBlock", "tsql:block");
        Node ifDecStmtNode = this.verify(ifBlockNode, "tsql:statements", "tsql:declareStatement");
        this.verifyElementSymbol(ifDecStmtNode, "tsql:variable", "a");
        this.verifyProperty(ifDecStmtNode, "tsql:variableType", "short");
        Node elseBlockNode = this.verify(stmtNode, "tsql:elseBlock", "tsql:block");
        Node elseDecStmtNode = this.verify(elseBlockNode, "tsql:statements", "tsql:declareStatement");
        this.verifyElementSymbol(elseDecStmtNode, "tsql:variable", "b");
        this.verifyProperty(ifDecStmtNode, "tsql:variableType", "short");
        Node criteriaNode = this.verify(stmtNode, "tsql:condition", "tsql:compareCriteria");
        this.verifyProperty(criteriaNode, "tsql:operator", CriteriaOperator.Operator.EQ.name());
        this.verifyElementSymbol(criteriaNode, "tsql:leftExpression", "c");
        this.verifyConstant(criteriaNode, "tsql:rightExpression", 5);
        this.verifySql(this.deriveProcPrefix(true) + "\n" + "IF(c = 5)" + "\n" + "BEGIN" + "\n" + "DECLARE short a;" + "\n" + "END" + "\n" + "ELSE" + "\n" + "BEGIN" + "\n" + "DECLARE short b;" + "\n" + "END" + "\n" + "END", fileNode);
    }

    @Test
    public void testDynamicCommandStatement() throws Exception {
        String sql = this.deriveProcPrefix(false) + "exec string 'SELECT a1 FROM g WHERE a2 = 5' as a1 string into #g; END";
        Node fileNode = this.sequenceSql(sql, TSQL_PROC_CMD);
        Node procNode = this.verify(fileNode, "tsql:createProcedureCommand", "tsql:createProcedureCommand");
        Node outerBlkNode = this.verify(procNode, "tsql:block", "tsql:block");
        Node cmdStmtNode = this.verify(outerBlkNode, "tsql:statements", "tsql:commandStatement");
        Node dynCmdNode = this.verify(cmdStmtNode, "tsql:command", "tsql:dynamicCommand");
        this.verifyConstant(dynCmdNode, "tsql:sql", "SELECT a1 FROM g WHERE a2 = 5");
        this.verifyProperty(dynCmdNode, "tsql:asClauseSet", true);
        this.verifyElementSymbol(dynCmdNode, "tsql:asColumns", "a1");
        Node intoGroupNode = this.verify(dynCmdNode, "tsql:intoGroup", "tsql:groupSymbol");
        this.verifyProperty(intoGroupNode, "tsql:name", "#g");
        this.verifySql(this.deriveProcPrefix(true) + "\n" + "EXECUTE IMMEDIATE 'SELECT a1 FROM g WHERE a2 = 5' AS a1 string INTO #g;" + "\n" + "END", fileNode);
    }

    @Test
    public void testSubquerySetCriteriaWithExec() throws Exception {
        String sql = "SELECT a FROM db.g WHERE b IN (EXEC m.sq1())";
        Node fileNode = this.sequenceSql(sql, TSQL_QUERY);
        Node queryNode = this.verify(fileNode, "tsql:query", "tsql:query");
        Node selectNode = this.verify(queryNode, "tsql:select", "tsql:select");
        this.verifyElementSymbol(selectNode, "tsql:symbols", "a");
        Node fromNode = this.verify(queryNode, "tsql:from", "tsql:from");
        this.verifyUnaryFromClauseGroup(fromNode, "tsql:clauses", "db.g");
        Node criteriaNode = this.verify(queryNode, "tsql:criteria", "tsql:subquerySetCriteria");
        this.verifyElementSymbol(criteriaNode, "tsql:expression", "b");
        Node innerQueryNode = this.verify(criteriaNode, "tsql:command", "tsql:query");
        Node innerSelectNode = this.verify(innerQueryNode, "tsql:select", "tsql:select");
        this.verify(innerSelectNode, "tsql:symbols", "tsql:multipleElementSymbol");
        Node innerFromNode = this.verify(innerQueryNode, "tsql:from", "tsql:from");
        Node sqFromClause = this.verify(innerFromNode, "tsql:clauses", "tsql:subqueryFromClause");
        this.verifyProperty(sqFromClause, "tsql:name", "x");
        Node storedProcNode = this.verify(sqFromClause, "tsql:command", "tsql:storedProcedure");
        this.verifyProperty(storedProcNode, "tsql:procedureName", "m.sq1");
        this.verifySql("SELECT a FROM db.g WHERE b IN (SELECT * FROM (EXEC m.sq1()) AS x)", fileNode);
    }

    @Test
    public void testSubquerySetCriteriaWithUnion() throws Exception {
        String sql = "SELECT a FROM db.g WHERE b IN (SELECT x1 FROM db.g2 UNION ALL SELECT x2 FROM db.g3)";
        Node fileNode = this.sequenceSql(sql, TSQL_QUERY);
        Node queryNode = this.verify(fileNode, "tsql:query", "tsql:query");
        Node selectNode = this.verify(queryNode, "tsql:select", "tsql:select");
        this.verifyElementSymbol(selectNode, "tsql:symbols", "a");
        Node fromNode = this.verify(queryNode, "tsql:from", "tsql:from");
        this.verifyUnaryFromClauseGroup(fromNode, "tsql:clauses", "db.g");
        Node criteriaNode = this.verify(queryNode, "tsql:criteria", "tsql:subquerySetCriteria");
        this.verifyElementSymbol(criteriaNode, "tsql:expression", "b");
        Node unionQueryNode = this.verify(criteriaNode, "tsql:command", "tsql:setQuery");
        this.verifyProperty(unionQueryNode, "tsql:all", true);
        this.verifyProperty(unionQueryNode, "tsql:operation", Operation.UNION.name());
        Node u1QueryNode = this.verify(unionQueryNode, "tsql:leftQuery", "tsql:query");
        Node u1SelectNode = this.verify(u1QueryNode, "tsql:select", "tsql:select");
        this.verifyElementSymbol(u1SelectNode, "tsql:symbols", "x1");
        Node u1FromNode = this.verify(u1QueryNode, "tsql:from", "tsql:from");
        this.verifyUnaryFromClauseGroup(u1FromNode, "tsql:clauses", "db.g2");
        Node u2QueryNode = this.verify(unionQueryNode, "tsql:rightQuery", "tsql:query");
        Node u2SelectNode = this.verify(u2QueryNode, "tsql:select", "tsql:select");
        this.verifyElementSymbol(u2SelectNode, "tsql:symbols", "x2");
        Node u2FromNode = this.verify(u2QueryNode, "tsql:from", "tsql:from");
        this.verifyUnaryFromClauseGroup(u2FromNode, "tsql:clauses", "db.g3");
        this.verifySql(sql, fileNode);
    }

    @Test
    public void testLoopStatement() throws Exception {
        String sql = this.deriveProcPrefix(false) + "LOOP ON (SELECT c1, c2 FROM m.g) AS mycursor BEGIN DECLARE integer x; x=mycursor.c1; END END";
        Node fileNode = this.sequenceSql(sql, TSQL_PROC_CMD);
        Node procNode = this.verify(fileNode, "tsql:createProcedureCommand", "tsql:createProcedureCommand");
        Node outerBlkNode = this.verify(procNode, "tsql:block", "tsql:block");
        Node loopStmtNode = this.verify(outerBlkNode, "tsql:statements", "tsql:loopStatement");
        this.verifyProperty(loopStmtNode, "tsql:cursorName", "mycursor");
        Node queryNode = this.verify(loopStmtNode, "tsql:command", "tsql:query");
        Node selectNode = this.verify(queryNode, "tsql:select", "tsql:select");
        this.verifyElementSymbol(selectNode, "tsql:symbols", 1, "c1");
        this.verifyElementSymbol(selectNode, "tsql:symbols", 2, "c2");
        Node fromNode = this.verify(queryNode, "tsql:from", "tsql:from");
        this.verifyUnaryFromClauseGroup(fromNode, "tsql:clauses", "m.g");
        Node blockNode = this.verify(loopStmtNode, "tsql:block", "tsql:block");
        Node decStmtNode = this.verify(blockNode, "tsql:statements", 1, "tsql:declareStatement");
        this.verifyElementSymbol(decStmtNode, "tsql:variable", "x");
        this.verifyProperty(decStmtNode, "tsql:variableType", "integer");
        Node assignStmtNode = this.verify(blockNode, "tsql:statements", 2, "tsql:assignmentStatement");
        this.verifyElementSymbol(assignStmtNode, "tsql:variable", "x");
        this.verifyElementSymbol(assignStmtNode, "tsql:value", "mycursor.c1");
        this.verifySql(this.deriveProcPrefix(true) + "\n" + "LOOP ON (SELECT c1, c2 FROM m.g) AS mycursor" + "\n" + "BEGIN" + "\n" + "DECLARE integer x;" + "\n" + "x = mycursor.c1;" + "\n" + "END" + "\n" + "END", fileNode);
    }

    @Test
    public void testXmlElement() throws Exception {
        String sql = "SELECT xmlelement(name \"table\", 'x') FROM g";
        Node fileNode = this.sequenceSql(sql, TSQL_QUERY);
        Node queryNode = this.verify(fileNode, "tsql:query", "tsql:query");
        Node selectNode = this.verify(queryNode, "tsql:select", "tsql:select");
        Node xmlElemNode = this.verifyExpressionSymbol(selectNode, "tsql:symbols", "tsql:xmlElement");
        this.verifyProperty(xmlElemNode, "tsql:name", "table");
        this.verifyConstant(xmlElemNode, "tsql:content", "x");
        Node fromNode = this.verify(queryNode, "tsql:from", "tsql:from");
        this.verifyUnaryFromClauseGroup(fromNode, "tsql:clauses", 1, "g");
        this.verifySql("SELECT XMLELEMENT(NAME \"table\", 'x') FROM g", fileNode);
    }

    @Test
    public void testXmlElementWithAttributes() throws Exception {
        String sql = "SELECT xmlelement(y, xmlattributes('a' as val)) from g";
        Node fileNode = this.sequenceSql(sql, TSQL_QUERY);
        Node queryNode = this.verify(fileNode, "tsql:query", "tsql:query");
        Node selectNode = this.verify(queryNode, "tsql:select", "tsql:select");
        Node xmlElemNode = this.verifyExpressionSymbol(selectNode, "tsql:symbols", "tsql:xmlElement");
        this.verifyProperty(xmlElemNode, "tsql:name", "y");
        Node xmlAttrNode = this.verify(xmlElemNode, "tsql:attributes", "tsql:xmlAttributes");
        Node derivedColNode = this.verify(xmlAttrNode, "tsql:args", "tsql:derivedColumn");
        this.verifyProperty(derivedColNode, "tsql:alias", "val");
        this.verifyConstant(derivedColNode, "tsql:expression", "a");
        Node fromNode = this.verify(queryNode, "tsql:from", "tsql:from");
        this.verifyUnaryFromClauseGroup(fromNode, "tsql:clauses", 1, "g");
        this.verifySql("SELECT XMLELEMENT(NAME y, XMLATTRIBUTES('a' AS val)) FROM g", fileNode);
    }

    @Test
    public void testTextTable() throws Exception {
        String sql = "SELECT * from texttable(file columns x string, y date delimiter ',' escape '\"' header skip 10) as x";
        Node fileNode = this.sequenceSql(sql, TSQL_QUERY);
        Node queryNode = this.verify(fileNode, "tsql:query", "tsql:query");
        Node selectNode = this.verify(queryNode, "tsql:select", "tsql:select");
        this.verify(selectNode, "tsql:symbols", "tsql:multipleElementSymbol");
        Node fromNode = this.verify(queryNode, "tsql:from", "tsql:from");
        Node txtTblNode = this.verify(fromNode, "tsql:clauses", "tsql:textTable");
        this.verifyElementSymbol(txtTblNode, "tsql:file", "file");
        this.verifyProperty(txtTblNode, "tsql:skip", 10L);
        this.verifyProperty(txtTblNode, "tsql:name", "x");
        this.verifyProperty(txtTblNode, "tsql:delimiter", ",");
        this.verifyProperty(txtTblNode, "tsql:quote", "\"");
        this.verifyProperty(txtTblNode, "tsql:escape", true);
        this.verifyProperty(txtTblNode, "tsql:header", 1L);
        Node txtCol1Node = this.verify(txtTblNode, "tsql:columns", 1, "tsql:textColumn");
        this.verifyProperty(txtCol1Node, "tsql:name", "x");
        this.verifyProperty(txtCol1Node, "tsql:type", "string");
        Node txtCol2Node = this.verify(txtTblNode, "tsql:columns", 2, "tsql:textColumn");
        this.verifyProperty(txtCol2Node, "tsql:name", "y");
        this.verifyProperty(txtCol2Node, "tsql:type", "date");
        this.verifySql("SELECT * FROM TEXTTABLE(file COLUMNS x string, y date DELIMITER ',' ESCAPE '\"' HEADER SKIP 10) AS x", fileNode);
    }

    @Test
    public void testWindowFunction() throws Exception {
        String sql = "select row_number() over (partition by x order by y) from g";
        Node fileNode = this.sequenceSql(sql, TSQL_QUERY);
        Node queryNode = this.verify(fileNode, "tsql:query", "tsql:query");
        Node selectNode = this.verify(queryNode, "tsql:select", "tsql:select");
        Node winFnNode = this.verifyExpressionSymbol(selectNode, "tsql:symbols", "tsql:windowFunction");
        Node aggSymbolNode = this.verify(winFnNode, "tsql:function", "tsql:aggregateSymbol");
        this.verifyProperty(aggSymbolNode, "tsql:name", "ROW_NUMBER");
        this.verifyProperty(aggSymbolNode, "tsql:distinct", false);
        Node winSpecNode = this.verify(winFnNode, "tsql:windowSpecification", "tsql:windowSpecification");
        this.verifyElementSymbol(winSpecNode, "tsql:partition", "x");
        Node orderByNode = this.verify(winSpecNode, "tsql:orderBy", "tsql:orderBy");
        Node obItem1Node = this.verify(orderByNode, "tsql:orderByItems", 1, "tsql:orderByItem");
        this.verifyElementSymbol(obItem1Node, "tsql:symbol", "y");
        Node fromNode = this.verify(queryNode, "tsql:from", "tsql:from");
        this.verifyUnaryFromClauseGroup(fromNode, "tsql:clauses", 1, "g");
        this.verifySql("SELECT ROW_NUMBER() OVER (PARTITION BY x ORDER BY y) FROM g", fileNode);
    }
}

