/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.modeshape.teiid.sequencer.v911;

import javax.jcr.Node;
import org.junit.Test;
import org.komodo.modeshape.teiid.sequencer.AbstractTestTeiidSqlSequencer;
import org.komodo.spi.runtime.version.DefaultTeiidVersion;
import org.komodo.spi.runtime.version.TeiidVersion;

public class TestTeiid911SqlSequencer
extends AbstractTestTeiidSqlSequencer {
    private static final TeiidVersion TEIID_VERSION = DefaultTeiidVersion.Version.TEIID_9_1_1.get();

    public TestTeiid911SqlSequencer() {
        super(TEIID_VERSION);
    }

    protected TestTeiid911SqlSequencer(TeiidVersion teiidVersion) {
        super(teiidVersion);
    }

    @Test
    public void testGroupByRollup() throws Exception {
        String sql = "SELECT a FROM m.g GROUP BY rollup(b, c)";
        Node fileNode = this.sequenceSql(sql, "\\/tsql[0-9]+\\.tsql\\/tsql:query");
        Node queryNode = this.verify(fileNode, "tsql:query", "tsql:query");
        Node selectNode = this.verify(queryNode, "tsql:select", "tsql:select");
        this.verifyElementSymbol(selectNode, "tsql:symbols", "a");
        Node fromNode = this.verify(queryNode, "tsql:from", "tsql:from");
        this.verifyUnaryFromClauseGroup(fromNode, "tsql:clauses", 1, "m.g");
        Node groupByNode = this.verify(queryNode, "tsql:groupBy", "tsql:groupBy");
        this.verifyElementSymbol(groupByNode, "tsql:symbols", 1, "b");
        this.verifyElementSymbol(groupByNode, "tsql:symbols", 2, "c");
        this.verifyProperty(groupByNode, "tsql:rollup", true);
    }

    @Test
    public void testStoredQuery2SanityCheck() throws Exception {
        String sql = "BEGIN exec proc1('param1'); END";
        Node fileNode = this.sequenceSql(sql, "\\/tsql[0-9]+\\.tsql\\/tsql:createProcedureCommand");
        Node createProcNode = this.verify(fileNode, "tsql:createProcedureCommand", "tsql:createProcedureCommand");
        Node outerBlkNode = this.verify(createProcNode, "tsql:block", "tsql:block");
        Node cmdStmtNode = this.verify(outerBlkNode, "tsql:statements", "tsql:commandStatement");
        Node storedProcNode = this.verify(cmdStmtNode, "tsql:command", "tsql:storedProcedure");
        this.verifyProperty(storedProcNode, "tsql:procedureName", "proc1");
        Node param1Node = this.verify(storedProcNode, "tsql:parameters", "tsql:spParameter");
        this.verifyProperty(param1Node, "tsql:parameterType", 1L);
        this.verifyProperty(param1Node, "tsql:index", 1L);
        this.verifyConstant(param1Node, "tsql:expression", "param1");
    }
}

