/* Generated By:JJTree&JavaCC: Do not edit this line. TeiidCompletionParser.java */
/*
* JBoss, Home of Professional Open Source.
* See the COPYRIGHT.txt file distributed with this work for information
* regarding copyright ownership. Some portions may be licensed
* to Red Hat, Inc. under one or more contributor license agreements.
*
* This library is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.
*
* This library is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this library; if not, write to the Free Software
* Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
* 02110-1301 USA.
*/
package org.komodo.modeshape.teiid.parser.completion;
import org.komodo.modeshape.teiid.sql.lang.*;


import java.math.BigInteger;
import java.util.*;
import java.util.regex.Matcher;
import org.komodo.modeshape.teiid.parser.AbstractTeiidParser;
import org.komodo.modeshape.teiid.parser.ParseInfo;
import org.komodo.spi.lexicon.TeiidSqlConstants;
import org.komodo.spi.runtime.version.TeiidVersion;
import org.komodo.spi.runtime.version.DefaultTeiidVersion;
import org.komodo.spi.runtime.version.DefaultTeiidVersion.Version;
import org.komodo.spi.constants.StringConstants;
import org.komodo.modeshape.teiid.Messages;
import org.komodo.utils.StringUtils;
import org.komodo.modeshape.teiid.parser.bnf.BNF;

@ SuppressWarnings({"nls", "unused", "javadoc"})
public class TeiidCompletionParser extends AbstractTeiidParser/*@bgen(jjtree)*/implements TeiidCompletionParserTreeConstants, TeiidCompletionParserConstants {/*@bgen(jjtree)*/
  protected JJTTeiidCompletionParserState jjtree = new JJTTeiidCompletionParserState();
        private Set <String> expectedTokens = new HashSet<String>();

        private BNF bnf = new BNF(getVersion());

        @ Override
        public TeiidVersion getVersion() {
                if (version == null)
                  version = new DefaultTeiidVersion("8.x.x");

                return version;
        }

        private void requiresVersionAtLeast(Version version) throws ParseException {
                if (versionAtLeast(version))
                        return;

                // Syntax is for Teiid Version $RVERSION+ while current Teiid Version is $CVERSION.
                String message = Messages.getString(Messages.TeiidParser.teiid_version_atleast_failure, version.get().toString(), getVersion().toString());
                throw new ParseException(message);
        }

        /*
	 * Appends to the proposals list the given values
	 */
        private void ppAppend(String ... values) {
                if (values == null)
                        return;

                for (Object value : values) {
                        if (value == null)
                                continue;

                        if (value instanceof String[]) {
                                expectedTokens.addAll(Arrays.asList((String[]) value));
                        } else if (value instanceof String) {
                                expectedTokens.add((String) value);
                        }
                }
        }

        /*
	 * Clears then set the proposals list to the given values
	 */
        private void ppSet(String ... values) {
                expectedTokens.clear();

                if (values == null)
                        return;

                ppAppend(values);
        }

        public Set<String> getExpected() {
                return Collections.unmodifiableSet(expectedTokens);
        }

  final public void stringVal() throws ParseException {
    jj_consume_token(STRINGVAL);
                        ppSet((String[]) null);
  }

  final public void nonReserved() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case INSTEAD:
      jj_consume_token(INSTEAD);
      break;
    case VIEW:
      jj_consume_token(VIEW);
      break;
    case ENABLED:
      jj_consume_token(ENABLED);
      break;
    case DISABLED:
      jj_consume_token(DISABLED);
      break;
    case KEY:
      jj_consume_token(KEY);
      break;
    case SERIAL:
      jj_consume_token(SERIAL);
      break;
    case TEXTAGG:
      jj_consume_token(TEXTAGG);
      break;
    case COUNT:
      jj_consume_token(COUNT);
      break;
    case ROW_NUMBER:
      jj_consume_token(ROW_NUMBER);
      break;
    case RANK:
      jj_consume_token(RANK);
      break;
    case DENSE_RANK:
      jj_consume_token(DENSE_RANK);
      break;
    case SUM:
      jj_consume_token(SUM);
      break;
    case AVG:
      jj_consume_token(AVG);
      break;
    case MIN:
      jj_consume_token(MIN);
      break;
    case MAX:
      jj_consume_token(MAX);
      break;
    case EVERY:
      jj_consume_token(EVERY);
      break;
    case STDDEV_POP:
      jj_consume_token(STDDEV_POP);
      break;
    case STDDEV_SAMP:
      jj_consume_token(STDDEV_SAMP);
      break;
    case VAR_SAMP:
      jj_consume_token(VAR_SAMP);
      break;
    case VAR_POP:
      jj_consume_token(VAR_POP);
      break;
    case DOCUMENT:
      jj_consume_token(DOCUMENT);
      break;
    case CONTENT:
      jj_consume_token(CONTENT);
      break;
    case TRIM:
      jj_consume_token(TRIM);
      break;
    case EMPTY:
      jj_consume_token(EMPTY);
      break;
    case ORDINALITY:
      jj_consume_token(ORDINALITY);
      break;
    case PATH:
      jj_consume_token(PATH);
      break;
    case FIRST:
      jj_consume_token(FIRST);
      break;
    case LAST:
      jj_consume_token(LAST);
      break;
    case NEXT:
      jj_consume_token(NEXT);
      break;
    case SUBSTRING:
      jj_consume_token(SUBSTRING);
      break;
    case EXTRACT:
      jj_consume_token(EXTRACT);
      break;
    case TO_CHARS:
      jj_consume_token(TO_CHARS);
      break;
    case TO_BYTES:
      jj_consume_token(TO_BYTES);
      break;
    case TIMESTAMPADD:
      jj_consume_token(TIMESTAMPADD);
      break;
    case TIMESTAMPDIFF:
      jj_consume_token(TIMESTAMPDIFF);
      break;
    case QUERYSTRING:
      jj_consume_token(QUERYSTRING);
      break;
    case NAMESPACE:
      jj_consume_token(NAMESPACE);
      break;
    case RESULT:
      jj_consume_token(RESULT);
      break;
    case INDEX:
      jj_consume_token(INDEX);
      break;
    case ACCESSPATTERN:
      jj_consume_token(ACCESSPATTERN);
      break;
    case AUTO_INCREMENT:
      jj_consume_token(AUTO_INCREMENT);
      break;
    case WELLFORMED:
      jj_consume_token(WELLFORMED);
      break;
    case SQL_TSI_FRAC_SECOND:
      jj_consume_token(SQL_TSI_FRAC_SECOND);
      break;
    case SQL_TSI_SECOND:
      jj_consume_token(SQL_TSI_SECOND);
      break;
    case SQL_TSI_MINUTE:
      jj_consume_token(SQL_TSI_MINUTE);
      break;
    case SQL_TSI_HOUR:
      jj_consume_token(SQL_TSI_HOUR);
      break;
    case SQL_TSI_DAY:
      jj_consume_token(SQL_TSI_DAY);
      break;
    case SQL_TSI_WEEK:
      jj_consume_token(SQL_TSI_WEEK);
      break;
    case SQL_TSI_MONTH:
      jj_consume_token(SQL_TSI_MONTH);
      break;
    case SQL_TSI_QUARTER:
      jj_consume_token(SQL_TSI_QUARTER);
      break;
    case SQL_TSI_YEAR:
      jj_consume_token(SQL_TSI_YEAR);
      break;
    case TEXTTABLE:
      jj_consume_token(TEXTTABLE);
      break;
    case ARRAYTABLE:
      jj_consume_token(ARRAYTABLE);
      break;
    case SELECTOR:
      jj_consume_token(SELECTOR);
      break;
    case SKIP_KEYWORD:
      jj_consume_token(SKIP_KEYWORD);
      break;
    case WIDTH:
      jj_consume_token(WIDTH);
      break;
    case PASSING:
      jj_consume_token(PASSING);
      break;
    case NAME:
      jj_consume_token(NAME);
      break;
    case ENCODING:
      jj_consume_token(ENCODING);
      break;
    case COLUMNS:
      jj_consume_token(COLUMNS);
      break;
    case DELIMITER:
      jj_consume_token(DELIMITER);
      break;
    case QUOTE:
      jj_consume_token(QUOTE);
      break;
    case HEADER:
      jj_consume_token(HEADER);
      break;
    case NULLS:
      jj_consume_token(NULLS);
      break;
    case OBJECTTABLE:
      jj_consume_token(OBJECTTABLE);
      break;
    case VERSION:
      jj_consume_token(VERSION);
      break;
    case INCLUDING:
      jj_consume_token(INCLUDING);
      break;
    case EXCLUDING:
      jj_consume_token(EXCLUDING);
      break;
    case XMLDECLARATION:
      jj_consume_token(XMLDECLARATION);
      break;
    case VARIADIC:
      jj_consume_token(VARIADIC);
      break;
    case RAISE:
      jj_consume_token(RAISE);
      break;
    case EXCEPTION:
      jj_consume_token(EXCEPTION);
      break;
    case CHAIN:
      jj_consume_token(CHAIN);
      break;
    case JSONARRAY_AGG:
      jj_consume_token(JSONARRAY_AGG);
      break;
    case JSONOBJECT:
      jj_consume_token(JSONOBJECT);
      break;
    default:
      jj_la1[0] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
                        ppSet((String[]) null);
  }

  final public void id() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ID:
      jj_consume_token(ID);
                                ppSet((String[]) null);
      break;
    case INSTEAD:
    case ENABLED:
    case DISABLED:
    case VIEW:
    case KEY:
    case SERIAL:
    case TEXTAGG:
    case COUNT:
    case ROW_NUMBER:
    case RANK:
    case DENSE_RANK:
    case SUM:
    case AVG:
    case MIN:
    case MAX:
    case EVERY:
    case STDDEV_POP:
    case STDDEV_SAMP:
    case VAR_SAMP:
    case VAR_POP:
    case DOCUMENT:
    case CONTENT:
    case TRIM:
    case EMPTY:
    case ORDINALITY:
    case PATH:
    case FIRST:
    case LAST:
    case NEXT:
    case SUBSTRING:
    case EXTRACT:
    case TO_CHARS:
    case TO_BYTES:
    case TIMESTAMPADD:
    case TIMESTAMPDIFF:
    case QUERYSTRING:
    case NAMESPACE:
    case RESULT:
    case INDEX:
    case ACCESSPATTERN:
    case AUTO_INCREMENT:
    case WELLFORMED:
    case SQL_TSI_FRAC_SECOND:
    case SQL_TSI_SECOND:
    case SQL_TSI_MINUTE:
    case SQL_TSI_HOUR:
    case SQL_TSI_DAY:
    case SQL_TSI_WEEK:
    case SQL_TSI_MONTH:
    case SQL_TSI_QUARTER:
    case SQL_TSI_YEAR:
    case TEXTTABLE:
    case ARRAYTABLE:
    case SELECTOR:
    case SKIP_KEYWORD:
    case WIDTH:
    case PASSING:
    case NAME:
    case ENCODING:
    case COLUMNS:
    case DELIMITER:
    case QUOTE:
    case HEADER:
    case NULLS:
    case OBJECTTABLE:
    case VERSION:
    case INCLUDING:
    case EXCLUDING:
    case XMLDECLARATION:
    case VARIADIC:
    case EXCEPTION:
    case RAISE:
    case CHAIN:
    case JSONARRAY_AGG:
    case JSONOBJECT:
      nonReserved();
      break;
    default:
      jj_la1[1] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

/*
 * Top-Level function so includes try catch
 */
  final public void command(ParseInfo info) throws ParseException {
        ppSet(bnf.command());
    try {
      if (jj_2_1(2)) {
        createProcedure(info);
                                ppAppend(bnf.command(BNF.createProcedure));
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case ALTER:
        case BEGIN:
        case CALL:
        case CREATE:
        case DELETE:
        case EXEC:
        case EXECUTE:
        case INSERT:
        case MERGE:
        case SELECT:
        case TABLE:
        case UPDATE:
        case VALUES:
        case WITH:
        case LPAREN:
          userCommand(info);
                                ppAppend(bnf.command(BNF.userCommand));
          break;
        case LBRACE:
          callableStatement(info);
                                ppAppend(bnf.command(BNF.callableStatement));
          break;
        default:
          jj_la1[2] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SEMICOLON:
        jj_consume_token(SEMICOLON);
        break;
      default:
        jj_la1[3] = jj_gen;
        ;
      }
      jj_consume_token(0);
                        ppSet((String[]) null);
    } catch (ParseException ex) {

    }
  }

/*
 * Top-Level function so includes try catch
 */
  final public void designerCommand(ParseInfo info) throws ParseException {
        ppSet(bnf.designerCommand());
    try {
      if (jj_2_2(2)) {
        createProcedure(info);
                                ppAppend(bnf.designerCommand(BNF.createProcedure));
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case FOR:
          forEachRowTriggerAction(info);
                                ppAppend(bnf.designerCommand(BNF.forEachRowTriggerAction));
          break;
        case ALTER:
        case BEGIN:
        case CALL:
        case CREATE:
        case DELETE:
        case EXEC:
        case EXECUTE:
        case INSERT:
        case MERGE:
        case SELECT:
        case TABLE:
        case UPDATE:
        case VALUES:
        case WITH:
        case LPAREN:
          userCommand(info);
                                ppAppend(bnf.designerCommand(BNF.userCommand));
          break;
        default:
          jj_la1[4] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SEMICOLON:
        jj_consume_token(SEMICOLON);
        break;
      default:
        jj_la1[5] = jj_gen;
        ;
      }
      jj_consume_token(0);
                        ppSet((String[]) null);
    } catch (ParseException ex) {

    }
  }

  final public void createTrigger(ParseInfo info) throws ParseException {
    jj_consume_token(CREATE);
                        ppSet(bnf.createTrigger(BNF.CREATE));
    jj_consume_token(TRIGGER);
                        ppSet(bnf.createTrigger(BNF.TRIGGER));
    jj_consume_token(ON);
                        ppSet(bnf.createTrigger(BNF.ON));
    id();
                        ppAppend(bnf.createTrigger(BNF.id));
    jj_consume_token(INSTEAD);
                        ppSet(bnf.createTrigger(BNF.INSTEAD));
    jj_consume_token(OF);
                        ppSet(bnf.createTrigger(BNF.OF));
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case INSERT:
      jj_consume_token(INSERT);
                                ppSet(bnf.createTrigger(BNF.INSERT));
      break;
    case UPDATE:
      jj_consume_token(UPDATE);
                                ppSet(bnf.createTrigger(BNF.UPDATE));
      break;
    case DELETE:
      jj_consume_token(DELETE);
                                ppSet(bnf.createTrigger(BNF.DELETE));
      break;
    default:
      jj_la1[6] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(AS);
                        ppSet(bnf.createTrigger(BNF.AS));
    forEachRowTriggerAction(info);
  }

  final public void alter(ParseInfo info) throws ParseException {
    jj_consume_token(ALTER);
                        ppSet(bnf.alter(BNF.ALTER));
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case VIEW:
      jj_consume_token(VIEW);
                                        ppSet(bnf.alter(BNF.VIEW));
      id();
                                        ppAppend(bnf.alter(BNF.VIEW, BNF.id));
      jj_consume_token(AS);
                                        ppSet(bnf.alter(BNF.VIEW, BNF.AS));
      queryExpression(info);
      break;
    case PROCEDURE:
      jj_consume_token(PROCEDURE);
                                        ppSet(bnf.alter(BNF.PROCEDURE));
      id();
                                        ppAppend(bnf.alter(BNF.PROCEDURE, BNF.id));
      jj_consume_token(AS);
                                        ppSet(bnf.alter(BNF.PROCEDURE, BNF.AS));
      statement(info);
      break;
    case TRIGGER:
      jj_consume_token(TRIGGER);
                                        ppSet(bnf.alter(BNF.TRIGGER));
      jj_consume_token(ON);
                                        ppSet(bnf.alter(BNF.ON));
      id();
                                        ppAppend(bnf.alter(BNF.TRIGGER, BNF.id));
      jj_consume_token(INSTEAD);
                                        ppSet(bnf.alter(BNF.INSTEAD));
      jj_consume_token(OF);
                                        ppSet(bnf.alter(BNF.OF));
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case INSERT:
        jj_consume_token(INSERT);
                                                ppSet(bnf.alter(BNF.INSERT));
        break;
      case UPDATE:
        jj_consume_token(UPDATE);
                                                ppSet(bnf.alter(BNF.UPDATE));
        break;
      case DELETE:
        jj_consume_token(DELETE);
                                                ppSet(bnf.alter(BNF.DELETE));
        break;
      default:
        jj_la1[7] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case AS:
        jj_consume_token(AS);
                                                        ppSet(bnf.alter(BNF.OF, BNF.AS));
        forEachRowTriggerAction(info);
        break;
      case ENABLED:
        jj_consume_token(ENABLED);
                                                ppSet((String[]) null);
        break;
      case DISABLED:
        jj_consume_token(DISABLED);
                                                ppSet((String[]) null);
        break;
      default:
        jj_la1[8] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[9] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void forEachRowTriggerAction(ParseInfo info) throws ParseException {
        ppAppend(bnf.forEachRowTriggerAction(0));
    jj_consume_token(FOR);
                        ppSet(bnf.forEachRowTriggerAction(BNF.FOR));
    jj_consume_token(EACH);
                        ppSet(bnf.forEachRowTriggerAction(BNF.EACH));
    jj_consume_token(ROW);
                        ppSet(bnf.forEachRowTriggerAction(BNF.ROW));
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case BEGIN:
      jj_consume_token(BEGIN);
                                        ppSet(bnf.forEachRowTriggerAction(BNF.BEGIN));
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ATOMIC:
        jj_consume_token(ATOMIC);
                                                ppSet(bnf.forEachRowTriggerAction(BNF.ATOMIC));
        break;
      default:
        jj_la1[10] = jj_gen;
        ;
      }
      label_1:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case ALTER:
        case BEGIN:
        case BREAK:
        case CALL:
        case CONTINUE:
        case CREATE:
        case DECLARE:
        case DELETE:
        case ERROR:
        case EXEC:
        case EXECUTE:
        case IF:
        case INSERT:
        case LEAVE:
        case LOOP:
        case MERGE:
        case RETURN:
        case SELECT:
        case TABLE:
        case UPDATE:
        case VALUES:
        case WITH:
        case WHILE:
        case INSTEAD:
        case ENABLED:
        case DISABLED:
        case VIEW:
        case KEY:
        case SERIAL:
        case TEXTAGG:
        case COUNT:
        case ROW_NUMBER:
        case RANK:
        case DENSE_RANK:
        case SUM:
        case AVG:
        case MIN:
        case MAX:
        case EVERY:
        case STDDEV_POP:
        case STDDEV_SAMP:
        case VAR_SAMP:
        case VAR_POP:
        case DOCUMENT:
        case CONTENT:
        case TRIM:
        case EMPTY:
        case ORDINALITY:
        case PATH:
        case FIRST:
        case LAST:
        case NEXT:
        case SUBSTRING:
        case EXTRACT:
        case TO_CHARS:
        case TO_BYTES:
        case TIMESTAMPADD:
        case TIMESTAMPDIFF:
        case QUERYSTRING:
        case NAMESPACE:
        case RESULT:
        case INDEX:
        case ACCESSPATTERN:
        case AUTO_INCREMENT:
        case WELLFORMED:
        case SQL_TSI_FRAC_SECOND:
        case SQL_TSI_SECOND:
        case SQL_TSI_MINUTE:
        case SQL_TSI_HOUR:
        case SQL_TSI_DAY:
        case SQL_TSI_WEEK:
        case SQL_TSI_MONTH:
        case SQL_TSI_QUARTER:
        case SQL_TSI_YEAR:
        case TEXTTABLE:
        case ARRAYTABLE:
        case SELECTOR:
        case SKIP_KEYWORD:
        case WIDTH:
        case PASSING:
        case NAME:
        case ENCODING:
        case COLUMNS:
        case DELIMITER:
        case QUOTE:
        case HEADER:
        case NULLS:
        case OBJECTTABLE:
        case VERSION:
        case INCLUDING:
        case EXCLUDING:
        case XMLDECLARATION:
        case VARIADIC:
        case EXCEPTION:
        case RAISE:
        case CHAIN:
        case JSONARRAY_AGG:
        case JSONOBJECT:
        case ID:
        case LPAREN:
          ;
          break;
        default:
          jj_la1[11] = jj_gen;
          break label_1;
        }
        statement(info);
                                                ppSet(bnf.forEachRowTriggerAction(BNF.statement));
      }
      jj_consume_token(END);
                                        ppSet((String[]) null);
      break;
    case ALTER:
    case BREAK:
    case CALL:
    case CONTINUE:
    case CREATE:
    case DECLARE:
    case DELETE:
    case ERROR:
    case EXEC:
    case EXECUTE:
    case IF:
    case INSERT:
    case LEAVE:
    case LOOP:
    case MERGE:
    case RETURN:
    case SELECT:
    case TABLE:
    case UPDATE:
    case VALUES:
    case WITH:
    case WHILE:
    case INSTEAD:
    case ENABLED:
    case DISABLED:
    case VIEW:
    case KEY:
    case SERIAL:
    case TEXTAGG:
    case COUNT:
    case ROW_NUMBER:
    case RANK:
    case DENSE_RANK:
    case SUM:
    case AVG:
    case MIN:
    case MAX:
    case EVERY:
    case STDDEV_POP:
    case STDDEV_SAMP:
    case VAR_SAMP:
    case VAR_POP:
    case DOCUMENT:
    case CONTENT:
    case TRIM:
    case EMPTY:
    case ORDINALITY:
    case PATH:
    case FIRST:
    case LAST:
    case NEXT:
    case SUBSTRING:
    case EXTRACT:
    case TO_CHARS:
    case TO_BYTES:
    case TIMESTAMPADD:
    case TIMESTAMPDIFF:
    case QUERYSTRING:
    case NAMESPACE:
    case RESULT:
    case INDEX:
    case ACCESSPATTERN:
    case AUTO_INCREMENT:
    case WELLFORMED:
    case SQL_TSI_FRAC_SECOND:
    case SQL_TSI_SECOND:
    case SQL_TSI_MINUTE:
    case SQL_TSI_HOUR:
    case SQL_TSI_DAY:
    case SQL_TSI_WEEK:
    case SQL_TSI_MONTH:
    case SQL_TSI_QUARTER:
    case SQL_TSI_YEAR:
    case TEXTTABLE:
    case ARRAYTABLE:
    case SELECTOR:
    case SKIP_KEYWORD:
    case WIDTH:
    case PASSING:
    case NAME:
    case ENCODING:
    case COLUMNS:
    case DELIMITER:
    case QUOTE:
    case HEADER:
    case NULLS:
    case OBJECTTABLE:
    case VERSION:
    case INCLUDING:
    case EXCLUDING:
    case XMLDECLARATION:
    case VARIADIC:
    case EXCEPTION:
    case RAISE:
    case CHAIN:
    case JSONARRAY_AGG:
    case JSONOBJECT:
    case ID:
    case LPAREN:
      statement(info);
      break;
    default:
      jj_la1[12] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void userCommand(ParseInfo info) throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SELECT:
    case TABLE:
    case VALUES:
    case WITH:
    case LPAREN:
      queryExpression(info);
      break;
    case CALL:
    case EXEC:
    case EXECUTE:
      storedProcedure(info);
      break;
    case INSERT:
    case MERGE:
      insert(info);
      break;
    case UPDATE:
      update(info);
      break;
    case DELETE:
      delete(info);
      break;
    case ALTER:
      alter(info);
      break;
    case CREATE:
      createTrigger(info);
      break;
    case BEGIN:
      compoundStatement(info);
                                requiresVersionAtLeast(Version.TEIID_8_4);
      break;
    default:
      jj_la1[13] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void errorStatement(ParseInfo info) throws ParseException {
    jj_consume_token(ERROR);
                        ppSet(bnf.errorStatement(BNF.ERROR));
    expression(info);
  }

  final public void raiseStatement(ParseInfo info) throws ParseException {
    jj_consume_token(RAISE);
                        ppSet(bnf.raiseStatement(BNF.RAISE));
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SQLWARNING:
      jj_consume_token(SQLWARNING);
                                ppSet(bnf.raiseStatement(BNF.SQLWARNING));
      break;
    default:
      jj_la1[14] = jj_gen;
      ;
    }
    exceptionReference(info);
  }

  final public void exceptionReference(ParseInfo info) throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case INSTEAD:
    case ENABLED:
    case DISABLED:
    case VIEW:
    case KEY:
    case SERIAL:
    case TEXTAGG:
    case COUNT:
    case ROW_NUMBER:
    case RANK:
    case DENSE_RANK:
    case SUM:
    case AVG:
    case MIN:
    case MAX:
    case EVERY:
    case STDDEV_POP:
    case STDDEV_SAMP:
    case VAR_SAMP:
    case VAR_POP:
    case DOCUMENT:
    case CONTENT:
    case TRIM:
    case EMPTY:
    case ORDINALITY:
    case PATH:
    case FIRST:
    case LAST:
    case NEXT:
    case SUBSTRING:
    case EXTRACT:
    case TO_CHARS:
    case TO_BYTES:
    case TIMESTAMPADD:
    case TIMESTAMPDIFF:
    case QUERYSTRING:
    case NAMESPACE:
    case RESULT:
    case INDEX:
    case ACCESSPATTERN:
    case AUTO_INCREMENT:
    case WELLFORMED:
    case SQL_TSI_FRAC_SECOND:
    case SQL_TSI_SECOND:
    case SQL_TSI_MINUTE:
    case SQL_TSI_HOUR:
    case SQL_TSI_DAY:
    case SQL_TSI_WEEK:
    case SQL_TSI_MONTH:
    case SQL_TSI_QUARTER:
    case SQL_TSI_YEAR:
    case TEXTTABLE:
    case ARRAYTABLE:
    case SELECTOR:
    case SKIP_KEYWORD:
    case WIDTH:
    case PASSING:
    case NAME:
    case ENCODING:
    case COLUMNS:
    case DELIMITER:
    case QUOTE:
    case HEADER:
    case NULLS:
    case OBJECTTABLE:
    case VERSION:
    case INCLUDING:
    case EXCLUDING:
    case XMLDECLARATION:
    case VARIADIC:
    case EXCEPTION:
    case RAISE:
    case CHAIN:
    case JSONARRAY_AGG:
    case JSONOBJECT:
    case ID:
      id();
      break;
    case SQLEXCEPTION:
      exception(info);
      break;
    default:
      jj_la1[15] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void exception(ParseInfo info) throws ParseException {
    jj_consume_token(SQLEXCEPTION);
                        ppSet(bnf.exception(BNF.SQLEXCEPTION));
    commonValueExpression(info);
                        ppAppend(bnf.exception(BNF.SQLEXCEPTION, BNF.commonValueExpression));
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SQLSTATE:
      jj_consume_token(SQLSTATE);
                                ppSet(bnf.exception(BNF.SQLSTATE));
      commonValueExpression(info);
                                ppAppend(bnf.exception(BNF.SQLSTATE, BNF.commonValueExpression));
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        jj_consume_token(COMMA);
                                        ppSet(bnf.exception(BNF.COMMA));
        commonValueExpression(info);
                                        ppAppend(bnf.exception(BNF.COMMA, BNF.commonValueExpression));
        break;
      default:
        jj_la1[16] = jj_gen;
        ;
      }
      break;
    default:
      jj_la1[17] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CHAIN:
      jj_consume_token(CHAIN);
                                ppSet(bnf.exception(BNF.CHAIN));
      exceptionReference(info);
      break;
    default:
      jj_la1[18] = jj_gen;
      ;
    }
  }

  final public void statement(ParseInfo info) throws ParseException {
        ppAppend(bnf.statement(0));
    if (jj_2_3(2)) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case INSTEAD:
      case ENABLED:
      case DISABLED:
      case VIEW:
      case KEY:
      case SERIAL:
      case TEXTAGG:
      case COUNT:
      case ROW_NUMBER:
      case RANK:
      case DENSE_RANK:
      case SUM:
      case AVG:
      case MIN:
      case MAX:
      case EVERY:
      case STDDEV_POP:
      case STDDEV_SAMP:
      case VAR_SAMP:
      case VAR_POP:
      case DOCUMENT:
      case CONTENT:
      case TRIM:
      case EMPTY:
      case ORDINALITY:
      case PATH:
      case FIRST:
      case LAST:
      case NEXT:
      case SUBSTRING:
      case EXTRACT:
      case TO_CHARS:
      case TO_BYTES:
      case TIMESTAMPADD:
      case TIMESTAMPDIFF:
      case QUERYSTRING:
      case NAMESPACE:
      case RESULT:
      case INDEX:
      case ACCESSPATTERN:
      case AUTO_INCREMENT:
      case WELLFORMED:
      case SQL_TSI_FRAC_SECOND:
      case SQL_TSI_SECOND:
      case SQL_TSI_MINUTE:
      case SQL_TSI_HOUR:
      case SQL_TSI_DAY:
      case SQL_TSI_WEEK:
      case SQL_TSI_MONTH:
      case SQL_TSI_QUARTER:
      case SQL_TSI_YEAR:
      case TEXTTABLE:
      case ARRAYTABLE:
      case SELECTOR:
      case SKIP_KEYWORD:
      case WIDTH:
      case PASSING:
      case NAME:
      case ENCODING:
      case COLUMNS:
      case DELIMITER:
      case QUOTE:
      case HEADER:
      case NULLS:
      case OBJECTTABLE:
      case VERSION:
      case INCLUDING:
      case EXCLUDING:
      case XMLDECLARATION:
      case VARIADIC:
      case EXCEPTION:
      case RAISE:
      case CHAIN:
      case JSONARRAY_AGG:
      case JSONOBJECT:
      case ID:
        id();
                                                ppAppend(bnf.statement(BNF.id));
        jj_consume_token(COLON);
                                                ppSet(bnf.statement(BNF.COLON));
        break;
      default:
        jj_la1[19] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LOOP:
        loopStatement(info);
        break;
      case WHILE:
        whileStatement(info);
        break;
      case BEGIN:
        compoundStatement(info);
        break;
      default:
        jj_la1[20] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ALTER:
      case BEGIN:
      case BREAK:
      case CALL:
      case CONTINUE:
      case CREATE:
      case DECLARE:
      case DELETE:
      case ERROR:
      case EXEC:
      case EXECUTE:
      case IF:
      case INSERT:
      case LEAVE:
      case MERGE:
      case RETURN:
      case SELECT:
      case TABLE:
      case UPDATE:
      case VALUES:
      case WITH:
      case INSTEAD:
      case ENABLED:
      case DISABLED:
      case VIEW:
      case KEY:
      case SERIAL:
      case TEXTAGG:
      case COUNT:
      case ROW_NUMBER:
      case RANK:
      case DENSE_RANK:
      case SUM:
      case AVG:
      case MIN:
      case MAX:
      case EVERY:
      case STDDEV_POP:
      case STDDEV_SAMP:
      case VAR_SAMP:
      case VAR_POP:
      case DOCUMENT:
      case CONTENT:
      case TRIM:
      case EMPTY:
      case ORDINALITY:
      case PATH:
      case FIRST:
      case LAST:
      case NEXT:
      case SUBSTRING:
      case EXTRACT:
      case TO_CHARS:
      case TO_BYTES:
      case TIMESTAMPADD:
      case TIMESTAMPDIFF:
      case QUERYSTRING:
      case NAMESPACE:
      case RESULT:
      case INDEX:
      case ACCESSPATTERN:
      case AUTO_INCREMENT:
      case WELLFORMED:
      case SQL_TSI_FRAC_SECOND:
      case SQL_TSI_SECOND:
      case SQL_TSI_MINUTE:
      case SQL_TSI_HOUR:
      case SQL_TSI_DAY:
      case SQL_TSI_WEEK:
      case SQL_TSI_MONTH:
      case SQL_TSI_QUARTER:
      case SQL_TSI_YEAR:
      case TEXTTABLE:
      case ARRAYTABLE:
      case SELECTOR:
      case SKIP_KEYWORD:
      case WIDTH:
      case PASSING:
      case NAME:
      case ENCODING:
      case COLUMNS:
      case DELIMITER:
      case QUOTE:
      case HEADER:
      case NULLS:
      case OBJECTTABLE:
      case VERSION:
      case INCLUDING:
      case EXCLUDING:
      case XMLDECLARATION:
      case VARIADIC:
      case EXCEPTION:
      case RAISE:
      case CHAIN:
      case JSONARRAY_AGG:
      case JSONOBJECT:
      case ID:
      case LPAREN:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case IF:
          ifStatement(info);
          break;
        case ALTER:
        case BEGIN:
        case BREAK:
        case CALL:
        case CONTINUE:
        case CREATE:
        case DECLARE:
        case DELETE:
        case ERROR:
        case EXEC:
        case EXECUTE:
        case INSERT:
        case LEAVE:
        case MERGE:
        case RETURN:
        case SELECT:
        case TABLE:
        case UPDATE:
        case VALUES:
        case WITH:
        case INSTEAD:
        case ENABLED:
        case DISABLED:
        case VIEW:
        case KEY:
        case SERIAL:
        case TEXTAGG:
        case COUNT:
        case ROW_NUMBER:
        case RANK:
        case DENSE_RANK:
        case SUM:
        case AVG:
        case MIN:
        case MAX:
        case EVERY:
        case STDDEV_POP:
        case STDDEV_SAMP:
        case VAR_SAMP:
        case VAR_POP:
        case DOCUMENT:
        case CONTENT:
        case TRIM:
        case EMPTY:
        case ORDINALITY:
        case PATH:
        case FIRST:
        case LAST:
        case NEXT:
        case SUBSTRING:
        case EXTRACT:
        case TO_CHARS:
        case TO_BYTES:
        case TIMESTAMPADD:
        case TIMESTAMPDIFF:
        case QUERYSTRING:
        case NAMESPACE:
        case RESULT:
        case INDEX:
        case ACCESSPATTERN:
        case AUTO_INCREMENT:
        case WELLFORMED:
        case SQL_TSI_FRAC_SECOND:
        case SQL_TSI_SECOND:
        case SQL_TSI_MINUTE:
        case SQL_TSI_HOUR:
        case SQL_TSI_DAY:
        case SQL_TSI_WEEK:
        case SQL_TSI_MONTH:
        case SQL_TSI_QUARTER:
        case SQL_TSI_YEAR:
        case TEXTTABLE:
        case ARRAYTABLE:
        case SELECTOR:
        case SKIP_KEYWORD:
        case WIDTH:
        case PASSING:
        case NAME:
        case ENCODING:
        case COLUMNS:
        case DELIMITER:
        case QUOTE:
        case HEADER:
        case NULLS:
        case OBJECTTABLE:
        case VERSION:
        case INCLUDING:
        case EXCLUDING:
        case XMLDECLARATION:
        case VARIADIC:
        case EXCEPTION:
        case RAISE:
        case CHAIN:
        case JSONARRAY_AGG:
        case JSONOBJECT:
        case ID:
        case LPAREN:
          delimitedStatement(info);
          break;
        default:
          jj_la1[21] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
      default:
        jj_la1[22] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

  final public void delimitedStatement(ParseInfo info) throws ParseException {
    if (jj_2_4(2)) {
      assignStatement(info);
                                ppAppend(bnf.delimitedStatement(BNF.assignStatement));
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ALTER:
      case BEGIN:
      case CALL:
      case CREATE:
      case DELETE:
      case EXEC:
      case EXECUTE:
      case INSERT:
      case MERGE:
      case SELECT:
      case TABLE:
      case UPDATE:
      case VALUES:
      case WITH:
      case LPAREN:
        sqlStatement(info);
                                ppAppend(bnf.delimitedStatement(BNF.sqlStatement));
        break;
      case ERROR:
        errorStatement(info);
                                ppAppend(bnf.delimitedStatement(BNF.errorStatement));
        break;
      case RAISE:
        raiseStatement(info);
                                ppAppend(bnf.delimitedStatement(BNF.raiseStatement));
        break;
      case DECLARE:
        declareStatement(info);
                                ppAppend(bnf.delimitedStatement(BNF.declareStatement));
        break;
      case BREAK:
      case CONTINUE:
      case LEAVE:
        branchingStatement(info);
                                ppAppend(bnf.delimitedStatement(BNF.branchingStatement));
        break;
      case RETURN:
        returnStatement(info);
                                ppAppend(bnf.delimitedStatement(BNF.returnStatement));
        break;
      default:
        jj_la1[23] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    jj_consume_token(SEMICOLON);
                        ppSet((String[]) null);
  }

  final public void compoundStatement(ParseInfo info) throws ParseException {
    jj_consume_token(BEGIN);
                        ppSet(bnf.compoundStatement(BNF.BEGIN));
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ATOMIC:
    case NOT:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case NOT:
        jj_consume_token(NOT);
                                        ppSet(bnf.compoundStatement(BNF.NOT));
        break;
      default:
        jj_la1[24] = jj_gen;
        ;
      }
      jj_consume_token(ATOMIC);
                                ppSet(bnf.compoundStatement(BNF.ATOMIC));
      break;
    default:
      jj_la1[25] = jj_gen;
      ;
    }
    label_2:
    while (true) {
      if (jj_2_5(2)) {
        ;
      } else {
        break label_2;
      }
      statement(info);
                                ppAppend(bnf.compoundStatement(BNF.BEGIN, BNF.statement));
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case EXCEPTION:
      jj_consume_token(EXCEPTION);
                                ppSet(bnf.compoundStatement(BNF.EXCEPTION));
      id();
                                ppAppend(bnf.compoundStatement(BNF.id));
      label_3:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case ALTER:
        case BEGIN:
        case BREAK:
        case CALL:
        case CONTINUE:
        case CREATE:
        case DECLARE:
        case DELETE:
        case ERROR:
        case EXEC:
        case EXECUTE:
        case IF:
        case INSERT:
        case LEAVE:
        case LOOP:
        case MERGE:
        case RETURN:
        case SELECT:
        case TABLE:
        case UPDATE:
        case VALUES:
        case WITH:
        case WHILE:
        case INSTEAD:
        case ENABLED:
        case DISABLED:
        case VIEW:
        case KEY:
        case SERIAL:
        case TEXTAGG:
        case COUNT:
        case ROW_NUMBER:
        case RANK:
        case DENSE_RANK:
        case SUM:
        case AVG:
        case MIN:
        case MAX:
        case EVERY:
        case STDDEV_POP:
        case STDDEV_SAMP:
        case VAR_SAMP:
        case VAR_POP:
        case DOCUMENT:
        case CONTENT:
        case TRIM:
        case EMPTY:
        case ORDINALITY:
        case PATH:
        case FIRST:
        case LAST:
        case NEXT:
        case SUBSTRING:
        case EXTRACT:
        case TO_CHARS:
        case TO_BYTES:
        case TIMESTAMPADD:
        case TIMESTAMPDIFF:
        case QUERYSTRING:
        case NAMESPACE:
        case RESULT:
        case INDEX:
        case ACCESSPATTERN:
        case AUTO_INCREMENT:
        case WELLFORMED:
        case SQL_TSI_FRAC_SECOND:
        case SQL_TSI_SECOND:
        case SQL_TSI_MINUTE:
        case SQL_TSI_HOUR:
        case SQL_TSI_DAY:
        case SQL_TSI_WEEK:
        case SQL_TSI_MONTH:
        case SQL_TSI_QUARTER:
        case SQL_TSI_YEAR:
        case TEXTTABLE:
        case ARRAYTABLE:
        case SELECTOR:
        case SKIP_KEYWORD:
        case WIDTH:
        case PASSING:
        case NAME:
        case ENCODING:
        case COLUMNS:
        case DELIMITER:
        case QUOTE:
        case HEADER:
        case NULLS:
        case OBJECTTABLE:
        case VERSION:
        case INCLUDING:
        case EXCLUDING:
        case XMLDECLARATION:
        case VARIADIC:
        case EXCEPTION:
        case RAISE:
        case CHAIN:
        case JSONARRAY_AGG:
        case JSONOBJECT:
        case ID:
        case LPAREN:
          ;
          break;
        default:
          jj_la1[26] = jj_gen;
          break label_3;
        }
        statement(info);
                                        ppAppend(bnf.compoundStatement(BNF.EXCEPTION, BNF.statement));
      }
      break;
    default:
      jj_la1[27] = jj_gen;
      ;
    }
    jj_consume_token(END);
                        ppSet((String[]) null);
  }

  final public void branchingStatement(ParseInfo info) throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case BREAK:
    case CONTINUE:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case BREAK:
        jj_consume_token(BREAK);
                                                ppSet(bnf.branchingStatement(BNF.BREAK));
        break;
      case CONTINUE:
        jj_consume_token(CONTINUE);
                                                ppSet(bnf.branchingStatement(BNF.CONTINUE));
        break;
      default:
        jj_la1[28] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case INSTEAD:
      case ENABLED:
      case DISABLED:
      case VIEW:
      case KEY:
      case SERIAL:
      case TEXTAGG:
      case COUNT:
      case ROW_NUMBER:
      case RANK:
      case DENSE_RANK:
      case SUM:
      case AVG:
      case MIN:
      case MAX:
      case EVERY:
      case STDDEV_POP:
      case STDDEV_SAMP:
      case VAR_SAMP:
      case VAR_POP:
      case DOCUMENT:
      case CONTENT:
      case TRIM:
      case EMPTY:
      case ORDINALITY:
      case PATH:
      case FIRST:
      case LAST:
      case NEXT:
      case SUBSTRING:
      case EXTRACT:
      case TO_CHARS:
      case TO_BYTES:
      case TIMESTAMPADD:
      case TIMESTAMPDIFF:
      case QUERYSTRING:
      case NAMESPACE:
      case RESULT:
      case INDEX:
      case ACCESSPATTERN:
      case AUTO_INCREMENT:
      case WELLFORMED:
      case SQL_TSI_FRAC_SECOND:
      case SQL_TSI_SECOND:
      case SQL_TSI_MINUTE:
      case SQL_TSI_HOUR:
      case SQL_TSI_DAY:
      case SQL_TSI_WEEK:
      case SQL_TSI_MONTH:
      case SQL_TSI_QUARTER:
      case SQL_TSI_YEAR:
      case TEXTTABLE:
      case ARRAYTABLE:
      case SELECTOR:
      case SKIP_KEYWORD:
      case WIDTH:
      case PASSING:
      case NAME:
      case ENCODING:
      case COLUMNS:
      case DELIMITER:
      case QUOTE:
      case HEADER:
      case NULLS:
      case OBJECTTABLE:
      case VERSION:
      case INCLUDING:
      case EXCLUDING:
      case XMLDECLARATION:
      case VARIADIC:
      case EXCEPTION:
      case RAISE:
      case CHAIN:
      case JSONARRAY_AGG:
      case JSONOBJECT:
      case ID:
        id();
        break;
      default:
        jj_la1[29] = jj_gen;
        ;
      }
      break;
    case LEAVE:
      jj_consume_token(LEAVE);
                                        ppSet(bnf.branchingStatement(BNF.LEAVE));
      id();
      break;
    default:
      jj_la1[30] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void returnStatement(ParseInfo info) throws ParseException {
    jj_consume_token(RETURN);
                        ppSet(bnf.returnStatement(BNF.RETURN));
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CHAR:
    case CAST:
    case CONVERT:
    case ANY:
    case CASE:
    case EXISTS:
    case FALSE:
    case HOUR:
    case INSERT:
    case LEFT:
    case MINUTE:
    case MONTH:
    case NOT:
    case NULL:
    case RIGHT:
    case SECOND:
    case SOME:
    case TRANSLATE:
    case TRUE:
    case UNKNOWN:
    case USER:
    case YEAR:
    case XMLAGG:
    case XMLCONCAT:
    case XMLCOMMENT:
    case XMLELEMENT:
    case XMLFOREST:
    case XMLPARSE:
    case XMLPI:
    case XMLQUERY:
    case XMLSERIALIZE:
    case INSTEAD:
    case ENABLED:
    case DISABLED:
    case VIEW:
    case KEY:
    case SERIAL:
    case TEXTAGG:
    case COUNT:
    case ROW_NUMBER:
    case RANK:
    case DENSE_RANK:
    case SUM:
    case AVG:
    case MIN:
    case MAX:
    case EVERY:
    case STDDEV_POP:
    case STDDEV_SAMP:
    case VAR_SAMP:
    case VAR_POP:
    case DOCUMENT:
    case CONTENT:
    case TRIM:
    case EMPTY:
    case ORDINALITY:
    case PATH:
    case FIRST:
    case LAST:
    case NEXT:
    case SUBSTRING:
    case EXTRACT:
    case TO_CHARS:
    case TO_BYTES:
    case TIMESTAMPADD:
    case TIMESTAMPDIFF:
    case QUERYSTRING:
    case NAMESPACE:
    case RESULT:
    case INDEX:
    case ACCESSPATTERN:
    case AUTO_INCREMENT:
    case WELLFORMED:
    case SQL_TSI_FRAC_SECOND:
    case SQL_TSI_SECOND:
    case SQL_TSI_MINUTE:
    case SQL_TSI_HOUR:
    case SQL_TSI_DAY:
    case SQL_TSI_WEEK:
    case SQL_TSI_MONTH:
    case SQL_TSI_QUARTER:
    case SQL_TSI_YEAR:
    case TEXTTABLE:
    case ARRAYTABLE:
    case SELECTOR:
    case SKIP_KEYWORD:
    case WIDTH:
    case PASSING:
    case NAME:
    case ENCODING:
    case COLUMNS:
    case DELIMITER:
    case QUOTE:
    case HEADER:
    case NULLS:
    case OBJECTTABLE:
    case VERSION:
    case INCLUDING:
    case EXCLUDING:
    case XMLDECLARATION:
    case VARIADIC:
    case EXCEPTION:
    case RAISE:
    case CHAIN:
    case JSONARRAY_AGG:
    case JSONOBJECT:
    case ID:
    case ESCAPEDFUNCTION:
    case ESCAPEDTYPE:
    case DECIMALVAL:
    case FLOATVAL:
    case STRINGVAL:
    case UNSIGNEDINTEGER:
    case BINARYSTRINGVAL:
    case LPAREN:
    case PLUS:
    case MINUS:
    case QMARK:
    case DOLLAR:
      expression(info);
      break;
    default:
      jj_la1[31] = jj_gen;
      ;
    }
  }

  final public void whileStatement(ParseInfo info) throws ParseException {
    jj_consume_token(WHILE);
                        ppSet(bnf.whileStatement(BNF.WHILE));
    jj_consume_token(LPAREN);
                        ppSet(bnf.whileStatement(BNF.LPAREN));
    criteria(info);
                        ppAppend(bnf.whileStatement(BNF.criteria));
    jj_consume_token(RPAREN);
                        ppSet(bnf.whileStatement(BNF.RPAREN));
    statement(info);
  }

  final public void loopStatement(ParseInfo info) throws ParseException {
    jj_consume_token(LOOP);
                        ppSet(bnf.loopStatement(BNF.LOOP));
    jj_consume_token(ON);
                        ppSet(bnf.loopStatement(BNF.ON));
    jj_consume_token(LPAREN);
                        ppSet(bnf.loopStatement(BNF.LPAREN));
    queryExpression(info);
                        ppAppend(bnf.loopStatement(BNF.queryExpression));
    jj_consume_token(RPAREN);
                        ppSet(bnf.loopStatement(BNF.RPAREN));
    jj_consume_token(AS);
                        ppSet(bnf.loopStatement(BNF.AS));
    id();
                        ppAppend(bnf.loopStatement(BNF.id));
    statement(info);
  }

  final public void ifStatement(ParseInfo info) throws ParseException {
    jj_consume_token(IF);
                        ppSet(bnf.ifStatement(BNF.IF));
    jj_consume_token(LPAREN);
                        ppSet(bnf.ifStatement(BNF.LPAREN));
    criteria(info);
                        ppAppend(bnf.ifStatement(BNF.criteria));
    jj_consume_token(RPAREN);
                        ppSet(bnf.ifStatement(BNF.RPAREN));
    statement(info);
                        ppAppend(bnf.ifStatement(BNF.statement));
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ELSE:
      jj_consume_token(ELSE);
                                ppSet(bnf.ifStatement(BNF.ELSE));
      statement(info);
      break;
    default:
      jj_la1[32] = jj_gen;
      ;
    }
  }

  final public void declareStatement(ParseInfo info) throws ParseException {
    jj_consume_token(DECLARE);
                        ppSet(bnf.declareStatement(BNF.DECLARE));
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case STRING:
    case VARBINARY:
    case VARCHAR:
    case BOOLEAN:
    case BYTE:
    case TINYINT:
    case SHORT:
    case SMALLINT:
    case CHAR:
    case INTEGER:
    case LONG:
    case BIGINT:
    case BIGINTEGER:
    case FLOAT:
    case REAL:
    case DOUBLE:
    case BIGDECIMAL:
    case DECIMAL:
    case DATE:
    case TIME:
    case TIMESTAMP:
    case OBJECT:
    case BLOB:
    case CLOB:
    case XML:
      parseDataType();
                                ppAppend(bnf.declareStatement(BNF.parseDataType));
      break;
    case EXCEPTION:
      jj_consume_token(EXCEPTION);
                                ppSet(bnf.declareStatement(BNF.EXCEPTION));
      break;
    default:
      jj_la1[33] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    id();
                        ppAppend(bnf.declareStatement(BNF.id));
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case EQ:
      jj_consume_token(EQ);
                                ppSet(bnf.declareStatement(BNF.EQ));
      assignStatementOperand(info);
      break;
    default:
      jj_la1[34] = jj_gen;
      ;
    }
  }

  final public void assignStatement(ParseInfo info) throws ParseException {
    id();
                        ppAppend(bnf.assignStatement(BNF.id));
    jj_consume_token(EQ);
                        ppSet(bnf.assignStatement(BNF.EQ));
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CHAR:
    case CAST:
    case CONVERT:
    case ANY:
    case CASE:
    case DELETE:
    case EXISTS:
    case FALSE:
    case HOUR:
    case INSERT:
    case LEFT:
    case MERGE:
    case MINUTE:
    case MONTH:
    case NOT:
    case NULL:
    case RIGHT:
    case SECOND:
    case SELECT:
    case SOME:
    case SQLEXCEPTION:
    case TABLE:
    case TRANSLATE:
    case TRUE:
    case UNKNOWN:
    case USER:
    case UPDATE:
    case VALUES:
    case WITH:
    case YEAR:
    case XMLAGG:
    case XMLCONCAT:
    case XMLCOMMENT:
    case XMLELEMENT:
    case XMLFOREST:
    case XMLPARSE:
    case XMLPI:
    case XMLQUERY:
    case XMLSERIALIZE:
    case INSTEAD:
    case ENABLED:
    case DISABLED:
    case VIEW:
    case KEY:
    case SERIAL:
    case TEXTAGG:
    case COUNT:
    case ROW_NUMBER:
    case RANK:
    case DENSE_RANK:
    case SUM:
    case AVG:
    case MIN:
    case MAX:
    case EVERY:
    case STDDEV_POP:
    case STDDEV_SAMP:
    case VAR_SAMP:
    case VAR_POP:
    case DOCUMENT:
    case CONTENT:
    case TRIM:
    case EMPTY:
    case ORDINALITY:
    case PATH:
    case FIRST:
    case LAST:
    case NEXT:
    case SUBSTRING:
    case EXTRACT:
    case TO_CHARS:
    case TO_BYTES:
    case TIMESTAMPADD:
    case TIMESTAMPDIFF:
    case QUERYSTRING:
    case NAMESPACE:
    case RESULT:
    case INDEX:
    case ACCESSPATTERN:
    case AUTO_INCREMENT:
    case WELLFORMED:
    case SQL_TSI_FRAC_SECOND:
    case SQL_TSI_SECOND:
    case SQL_TSI_MINUTE:
    case SQL_TSI_HOUR:
    case SQL_TSI_DAY:
    case SQL_TSI_WEEK:
    case SQL_TSI_MONTH:
    case SQL_TSI_QUARTER:
    case SQL_TSI_YEAR:
    case TEXTTABLE:
    case ARRAYTABLE:
    case SELECTOR:
    case SKIP_KEYWORD:
    case WIDTH:
    case PASSING:
    case NAME:
    case ENCODING:
    case COLUMNS:
    case DELIMITER:
    case QUOTE:
    case HEADER:
    case NULLS:
    case OBJECTTABLE:
    case VERSION:
    case INCLUDING:
    case EXCLUDING:
    case XMLDECLARATION:
    case VARIADIC:
    case EXCEPTION:
    case RAISE:
    case CHAIN:
    case JSONARRAY_AGG:
    case JSONOBJECT:
    case ID:
    case ESCAPEDFUNCTION:
    case ESCAPEDTYPE:
    case DECIMALVAL:
    case FLOATVAL:
    case STRINGVAL:
    case UNSIGNEDINTEGER:
    case BINARYSTRINGVAL:
    case LPAREN:
    case PLUS:
    case MINUS:
    case QMARK:
    case DOLLAR:
      assignStatementOperand(info);
      break;
    case CALL:
    case EXEC:
    case EXECUTE:
      storedProcedure(info);
                                        ppAppend(bnf.assignStatement(BNF.storedProcedure));
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case WITH:
      case WITHOUT:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case WITH:
          jj_consume_token(WITH);
                                                        ppSet(bnf.assignStatement(BNF.WITH));
          break;
        case WITHOUT:
          jj_consume_token(WITHOUT);
                                                        ppSet(bnf.assignStatement(BNF.WITHOUT));
          break;
        default:
          jj_la1[35] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        jj_consume_token(RETURN);
                                                ppSet((String[]) null);
        break;
      default:
        jj_la1[36] = jj_gen;
        ;
      }
      break;
    default:
      jj_la1[37] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void assignStatementOperand(ParseInfo info) throws ParseException {
    if (jj_2_6(2147483647)) {
      insert(info);
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case UPDATE:
        update(info);
        break;
      case DELETE:
        delete(info);
        break;
      case CHAR:
      case CAST:
      case CONVERT:
      case ANY:
      case CASE:
      case EXISTS:
      case FALSE:
      case HOUR:
      case INSERT:
      case LEFT:
      case MINUTE:
      case MONTH:
      case NOT:
      case NULL:
      case RIGHT:
      case SECOND:
      case SOME:
      case TRANSLATE:
      case TRUE:
      case UNKNOWN:
      case USER:
      case YEAR:
      case XMLAGG:
      case XMLCONCAT:
      case XMLCOMMENT:
      case XMLELEMENT:
      case XMLFOREST:
      case XMLPARSE:
      case XMLPI:
      case XMLQUERY:
      case XMLSERIALIZE:
      case INSTEAD:
      case ENABLED:
      case DISABLED:
      case VIEW:
      case KEY:
      case SERIAL:
      case TEXTAGG:
      case COUNT:
      case ROW_NUMBER:
      case RANK:
      case DENSE_RANK:
      case SUM:
      case AVG:
      case MIN:
      case MAX:
      case EVERY:
      case STDDEV_POP:
      case STDDEV_SAMP:
      case VAR_SAMP:
      case VAR_POP:
      case DOCUMENT:
      case CONTENT:
      case TRIM:
      case EMPTY:
      case ORDINALITY:
      case PATH:
      case FIRST:
      case LAST:
      case NEXT:
      case SUBSTRING:
      case EXTRACT:
      case TO_CHARS:
      case TO_BYTES:
      case TIMESTAMPADD:
      case TIMESTAMPDIFF:
      case QUERYSTRING:
      case NAMESPACE:
      case RESULT:
      case INDEX:
      case ACCESSPATTERN:
      case AUTO_INCREMENT:
      case WELLFORMED:
      case SQL_TSI_FRAC_SECOND:
      case SQL_TSI_SECOND:
      case SQL_TSI_MINUTE:
      case SQL_TSI_HOUR:
      case SQL_TSI_DAY:
      case SQL_TSI_WEEK:
      case SQL_TSI_MONTH:
      case SQL_TSI_QUARTER:
      case SQL_TSI_YEAR:
      case TEXTTABLE:
      case ARRAYTABLE:
      case SELECTOR:
      case SKIP_KEYWORD:
      case WIDTH:
      case PASSING:
      case NAME:
      case ENCODING:
      case COLUMNS:
      case DELIMITER:
      case QUOTE:
      case HEADER:
      case NULLS:
      case OBJECTTABLE:
      case VERSION:
      case INCLUDING:
      case EXCLUDING:
      case XMLDECLARATION:
      case VARIADIC:
      case EXCEPTION:
      case RAISE:
      case CHAIN:
      case JSONARRAY_AGG:
      case JSONOBJECT:
      case ID:
      case ESCAPEDFUNCTION:
      case ESCAPEDTYPE:
      case DECIMALVAL:
      case FLOATVAL:
      case STRINGVAL:
      case UNSIGNEDINTEGER:
      case BINARYSTRINGVAL:
      case LPAREN:
      case PLUS:
      case MINUS:
      case QMARK:
      case DOLLAR:
        expression(info);
        break;
      case SELECT:
      case TABLE:
      case VALUES:
      case WITH:
        queryExpression(info);
        break;
      case SQLEXCEPTION:
        exception(info);
        break;
      default:
        jj_la1[38] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

  final public void sqlStatement(ParseInfo info) throws ParseException {
    if (jj_2_7(2)) {
      userCommand(info);
                                ppAppend(bnf.sqlStatement(BNF.userCommand));
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case EXEC:
      case EXECUTE:
        dynamicCommand(info);
                                ppAppend(bnf.sqlStatement(BNF.dynamicCommand));
        break;
      default:
        jj_la1[39] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case WITH:
    case WITHOUT:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case WITH:
        jj_consume_token(WITH);
                                        ppSet(bnf.sqlStatement(BNF.WITH));
        break;
      case WITHOUT:
        jj_consume_token(WITHOUT);
                                        ppSet(bnf.sqlStatement(BNF.WITHOUT));
        break;
      default:
        jj_la1[40] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      jj_consume_token(RETURN);
                                ppSet((String[]) null);
      break;
    default:
      jj_la1[41] = jj_gen;
      ;
    }
  }

  final public void createProcedure(ParseInfo info) throws ParseException {
    jj_consume_token(CREATE);
                        ppSet(bnf.createProcedure(BNF.CREATE));
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case VIRTUAL:
      jj_consume_token(VIRTUAL);
                                ppSet(bnf.createProcedure(BNF.VIRTUAL));
      break;
    default:
      jj_la1[42] = jj_gen;
      ;
    }
    jj_consume_token(PROCEDURE);
                        ppSet(bnf.createProcedure(BNF.PROCEDURE));
    statement(info);
  }

/*
 * Top-Level function so includes try catch
 */
  final public void procedureBodyCommand(ParseInfo info) throws ParseException {
    try {
      if (jj_2_8(2)) {
        jj_consume_token(CREATE);
                                ppSet(bnf.procedureBodyCommand(BNF.CREATE));
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case VIRTUAL:
          jj_consume_token(VIRTUAL);
                                        ppSet(bnf.procedureBodyCommand(BNF.VIRTUAL));
          break;
        default:
          jj_la1[43] = jj_gen;
          ;
        }
        jj_consume_token(PROCEDURE);
                                ppSet(bnf.procedureBodyCommand(BNF.PROCEDURE));
      } else {
        ;
      }
      statement(info);
    } catch (ParseException ex) {

    }
  }

  final public void dynamicCommand(ParseInfo info) throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case EXECUTE:
      jj_consume_token(EXECUTE);
                                ppSet(bnf.dynamicCommand(BNF.EXECUTE));
      break;
    case EXEC:
      jj_consume_token(EXEC);
                                ppSet(bnf.dynamicCommand(BNF.EXEC));
      break;
    default:
      jj_la1[44] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case STRING:
    case IMMEDIATE:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case STRING:
        jj_consume_token(STRING);
                                        ppSet(bnf.dynamicCommand(BNF.STRING));
        break;
      case IMMEDIATE:
        jj_consume_token(IMMEDIATE);
                                        ppSet(bnf.dynamicCommand(BNF.IMMEDIATE));
        break;
      default:
        jj_la1[45] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[46] = jj_gen;
      ;
    }
    expression(info);
                        ppAppend(bnf.dynamicCommand(BNF.expression));
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case AS:
      jj_consume_token(AS);
                                ppSet(bnf.dynamicCommand(BNF.AS));
      createElementsWithTypes(info);
                                ppSet(bnf.dynamicCommand(BNF.createElementsWithTypes));
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case INTO:
        jj_consume_token(INTO);
                                        ppSet(bnf.dynamicCommand(BNF.INTO));
        id();
                                        ppSet(bnf.dynamicCommand(BNF.id));
        break;
      default:
        jj_la1[47] = jj_gen;
        ;
      }
      break;
    default:
      jj_la1[48] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case USING:
      jj_consume_token(USING);
                                ppSet(bnf.dynamicCommand(BNF.USING));
      setClauseList(info);
                                ppAppend(bnf.dynamicCommand(BNF.setClauseList));
      break;
    default:
      jj_la1[49] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case UPDATE:
      jj_consume_token(UPDATE);
                                ppSet(bnf.dynamicCommand(BNF.UPDATE));
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case UNSIGNEDINTEGER:
      case PLUS:
      case MINUS:
        intVal();
        break;
      case STAR:
        jj_consume_token(STAR);
                                        ppSet((String[]) null);
        break;
      default:
        jj_la1[50] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[51] = jj_gen;
      ;
    }
  }

  final public void setClauseList(ParseInfo info) throws ParseException {
    id();
                        ppAppend(bnf.setClauseList(BNF.id));
    jj_consume_token(EQ);
                        ppSet(bnf.setClauseList(BNF.EQ));
    expression(info);
                        ppAppend(bnf.setClauseList(BNF.expression));
    label_4:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[52] = jj_gen;
        break label_4;
      }
      jj_consume_token(COMMA);
                                ppSet(bnf.setClauseList(BNF.COMMA));
      id();
                                ppAppend(bnf.setClauseList(BNF.COMMA, BNF.id));
      jj_consume_token(EQ);
                                ppSet(bnf.setClauseList(BNF.COMMA, BNF.EQ));
      expression(info);
                                ppAppend(bnf.setClauseList(BNF.COMMA, BNF.expression));
    }
  }

  final public void createElementsWithTypes(ParseInfo info) throws ParseException {
    id();
                        ppAppend(bnf.createElementsWithTypes(BNF.id));
    parseDataType();
                        ppAppend(bnf.createElementsWithTypes(BNF.parseDataType));
    label_5:
    while (true) {
      if (jj_2_9(2)) {
        ;
      } else {
        break label_5;
      }
      jj_consume_token(COMMA);
                                ppSet(bnf.createElementsWithTypes(BNF.COMMA));
      id();
                                ppAppend(bnf.createElementsWithTypes(BNF.id));
      parseDataType();
                                ppAppend(bnf.createElementsWithTypes(BNF.parseDataType));
    }
  }

  final public void callableStatement(ParseInfo info) throws ParseException {
    jj_consume_token(LBRACE);
                        ppSet(bnf.callableStatement(BNF.LBRACE));
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case QMARK:
      jj_consume_token(QMARK);
                                ppSet(bnf.callableStatement(BNF.QMARK));
      jj_consume_token(EQ);
                                ppSet(bnf.callableStatement(BNF.EQ));
      break;
    default:
      jj_la1[53] = jj_gen;
      ;
    }
    jj_consume_token(CALL);
                        ppSet(bnf.callableStatement(BNF.CALL));
    id();
                        ppAppend(bnf.callableStatement(BNF.id));
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LPAREN:
      jj_consume_token(LPAREN);
                                ppSet(bnf.callableStatement(BNF.LPAREN));
      if (jj_2_10(2)) {
        executeNamedParams(info);
                                        ppAppend(bnf.callableStatement(BNF.executeNamedParams));
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case CHAR:
        case CAST:
        case CONVERT:
        case ANY:
        case CASE:
        case EXISTS:
        case FALSE:
        case HOUR:
        case INSERT:
        case LEFT:
        case MINUTE:
        case MONTH:
        case NOT:
        case NULL:
        case RIGHT:
        case SECOND:
        case SOME:
        case TRANSLATE:
        case TRUE:
        case UNKNOWN:
        case USER:
        case YEAR:
        case XMLAGG:
        case XMLCONCAT:
        case XMLCOMMENT:
        case XMLELEMENT:
        case XMLFOREST:
        case XMLPARSE:
        case XMLPI:
        case XMLQUERY:
        case XMLSERIALIZE:
        case INSTEAD:
        case ENABLED:
        case DISABLED:
        case VIEW:
        case KEY:
        case SERIAL:
        case TEXTAGG:
        case COUNT:
        case ROW_NUMBER:
        case RANK:
        case DENSE_RANK:
        case SUM:
        case AVG:
        case MIN:
        case MAX:
        case EVERY:
        case STDDEV_POP:
        case STDDEV_SAMP:
        case VAR_SAMP:
        case VAR_POP:
        case DOCUMENT:
        case CONTENT:
        case TRIM:
        case EMPTY:
        case ORDINALITY:
        case PATH:
        case FIRST:
        case LAST:
        case NEXT:
        case SUBSTRING:
        case EXTRACT:
        case TO_CHARS:
        case TO_BYTES:
        case TIMESTAMPADD:
        case TIMESTAMPDIFF:
        case QUERYSTRING:
        case NAMESPACE:
        case RESULT:
        case INDEX:
        case ACCESSPATTERN:
        case AUTO_INCREMENT:
        case WELLFORMED:
        case SQL_TSI_FRAC_SECOND:
        case SQL_TSI_SECOND:
        case SQL_TSI_MINUTE:
        case SQL_TSI_HOUR:
        case SQL_TSI_DAY:
        case SQL_TSI_WEEK:
        case SQL_TSI_MONTH:
        case SQL_TSI_QUARTER:
        case SQL_TSI_YEAR:
        case TEXTTABLE:
        case ARRAYTABLE:
        case SELECTOR:
        case SKIP_KEYWORD:
        case WIDTH:
        case PASSING:
        case NAME:
        case ENCODING:
        case COLUMNS:
        case DELIMITER:
        case QUOTE:
        case HEADER:
        case NULLS:
        case OBJECTTABLE:
        case VERSION:
        case INCLUDING:
        case EXCLUDING:
        case XMLDECLARATION:
        case VARIADIC:
        case EXCEPTION:
        case RAISE:
        case CHAIN:
        case JSONARRAY_AGG:
        case JSONOBJECT:
        case ID:
        case ESCAPEDFUNCTION:
        case ESCAPEDTYPE:
        case DECIMALVAL:
        case FLOATVAL:
        case STRINGVAL:
        case UNSIGNEDINTEGER:
        case BINARYSTRINGVAL:
        case LPAREN:
        case PLUS:
        case MINUS:
        case QMARK:
        case DOLLAR:
          expressionList(info);
                                                ppAppend(bnf.callableStatement(BNF.expressionList));
          break;
        default:
          jj_la1[54] = jj_gen;
          ;
        }
      }
      jj_consume_token(RPAREN);
                                ppSet(bnf.callableStatement(BNF.RPAREN));
      break;
    default:
      jj_la1[55] = jj_gen;
      ;
    }
    jj_consume_token(RBRACE);
                        ppSet(bnf.callableStatement(BNF.RBRACE));
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case OPTION:
      option(info);
      break;
    default:
      jj_la1[56] = jj_gen;
      ;
    }
  }

  final public void storedProcedure(ParseInfo info) throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case EXEC:
      jj_consume_token(EXEC);
                                        ppSet(bnf.storedProcedure(BNF.EXEC));
      break;
    case EXECUTE:
      jj_consume_token(EXECUTE);
                                        ppSet(bnf.storedProcedure(BNF.EXECUTE));
      break;
    case CALL:
      jj_consume_token(CALL);
                                        ppSet(bnf.storedProcedure(BNF.CALL));
      break;
    default:
      jj_la1[57] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    id();
                                ppAppend(bnf.storedProcedure(BNF.id));
    jj_consume_token(LPAREN);
                                ppSet(bnf.storedProcedure(BNF.LPAREN));
    if (jj_2_11(2)) {
      executeNamedParams(info);
                                        ppSet(bnf.storedProcedure(BNF.executeNamedParams));
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case CHAR:
      case CAST:
      case CONVERT:
      case ANY:
      case CASE:
      case EXISTS:
      case FALSE:
      case HOUR:
      case INSERT:
      case LEFT:
      case MINUTE:
      case MONTH:
      case NOT:
      case NULL:
      case RIGHT:
      case SECOND:
      case SOME:
      case TRANSLATE:
      case TRUE:
      case UNKNOWN:
      case USER:
      case YEAR:
      case XMLAGG:
      case XMLCONCAT:
      case XMLCOMMENT:
      case XMLELEMENT:
      case XMLFOREST:
      case XMLPARSE:
      case XMLPI:
      case XMLQUERY:
      case XMLSERIALIZE:
      case INSTEAD:
      case ENABLED:
      case DISABLED:
      case VIEW:
      case KEY:
      case SERIAL:
      case TEXTAGG:
      case COUNT:
      case ROW_NUMBER:
      case RANK:
      case DENSE_RANK:
      case SUM:
      case AVG:
      case MIN:
      case MAX:
      case EVERY:
      case STDDEV_POP:
      case STDDEV_SAMP:
      case VAR_SAMP:
      case VAR_POP:
      case DOCUMENT:
      case CONTENT:
      case TRIM:
      case EMPTY:
      case ORDINALITY:
      case PATH:
      case FIRST:
      case LAST:
      case NEXT:
      case SUBSTRING:
      case EXTRACT:
      case TO_CHARS:
      case TO_BYTES:
      case TIMESTAMPADD:
      case TIMESTAMPDIFF:
      case QUERYSTRING:
      case NAMESPACE:
      case RESULT:
      case INDEX:
      case ACCESSPATTERN:
      case AUTO_INCREMENT:
      case WELLFORMED:
      case SQL_TSI_FRAC_SECOND:
      case SQL_TSI_SECOND:
      case SQL_TSI_MINUTE:
      case SQL_TSI_HOUR:
      case SQL_TSI_DAY:
      case SQL_TSI_WEEK:
      case SQL_TSI_MONTH:
      case SQL_TSI_QUARTER:
      case SQL_TSI_YEAR:
      case TEXTTABLE:
      case ARRAYTABLE:
      case SELECTOR:
      case SKIP_KEYWORD:
      case WIDTH:
      case PASSING:
      case NAME:
      case ENCODING:
      case COLUMNS:
      case DELIMITER:
      case QUOTE:
      case HEADER:
      case NULLS:
      case OBJECTTABLE:
      case VERSION:
      case INCLUDING:
      case EXCLUDING:
      case XMLDECLARATION:
      case VARIADIC:
      case EXCEPTION:
      case RAISE:
      case CHAIN:
      case JSONARRAY_AGG:
      case JSONOBJECT:
      case ID:
      case ESCAPEDFUNCTION:
      case ESCAPEDTYPE:
      case DECIMALVAL:
      case FLOATVAL:
      case STRINGVAL:
      case UNSIGNEDINTEGER:
      case BINARYSTRINGVAL:
      case LPAREN:
      case PLUS:
      case MINUS:
      case QMARK:
      case DOLLAR:
        expressionList(info);
                                                ppAppend(bnf.storedProcedure(BNF.expressionList));
        break;
      default:
        jj_la1[58] = jj_gen;
        ;
      }
    }
    jj_consume_token(RPAREN);
                                ppSet(bnf.storedProcedure(BNF.RPAREN));
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case OPTION:
      option(info);
      break;
    default:
      jj_la1[59] = jj_gen;
      ;
    }
  }

  final public void executeNamedParams(ParseInfo info) throws ParseException {
    id();
                                ppAppend(bnf.executeNamedParams(BNF.id));
    jj_consume_token(EQ);
                                ppSet(bnf.executeNamedParams(BNF.EQ));
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case GT:
      jj_consume_token(GT);
                                        ppSet(bnf.executeNamedParams(BNF.GT));
      break;
    default:
      jj_la1[60] = jj_gen;
      ;
    }
    expression(info);
                                ppAppend(bnf.executeNamedParams(BNF.expression));
    label_6:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[61] = jj_gen;
        break label_6;
      }
      jj_consume_token(COMMA);
                                        ppSet(bnf.executeNamedParams(BNF.COMMA));
      id();
                                        ppAppend(bnf.executeNamedParams(BNF.id));
      jj_consume_token(EQ);
                                        ppSet(bnf.executeNamedParams(BNF.EQ));
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case GT:
        jj_consume_token(GT);
                                                ppSet(bnf.executeNamedParams(BNF.GT));
        break;
      default:
        jj_la1[62] = jj_gen;
        ;
      }
      expression(info);
                                        ppAppend(bnf.executeNamedParams(BNF.expression));
    }
  }

  final public void insert(ParseInfo info) throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case INSERT:
      jj_consume_token(INSERT);
                                ppSet(bnf.insert(BNF.INSERT));
      break;
    case MERGE:
      jj_consume_token(MERGE);
                                ppSet(bnf.insert(BNF.MERGE));
      break;
    default:
      jj_la1[63] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(INTO);
                        ppSet(bnf.insert(BNF.INTO));
    id();
                        ppAppend(bnf.insert(BNF.id));
    if (jj_2_12(2147483647)) {
      columnList();
                                ppAppend(bnf.insert(BNF.columnList));
    } else {
      ;
    }
    queryExpression(info);
                                ppAppend(bnf.insert(BNF.queryExpression));
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case OPTION:
      option(info);
      break;
    default:
      jj_la1[64] = jj_gen;
      ;
    }
  }

  final public void expressionList(ParseInfo info) throws ParseException {
    expression(info);
                        ppAppend(bnf.expressionList(BNF.expression));
    label_7:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[65] = jj_gen;
        break label_7;
      }
      jj_consume_token(COMMA);
                                ppSet(bnf.expressionList(BNF.COMMA));
      expression(info);
                                ppAppend(bnf.expressionList(BNF.expression));
    }
  }

  final public void update(ParseInfo info) throws ParseException {
    jj_consume_token(UPDATE);
                        ppSet(bnf.update(BNF.UPDATE));
    id();
                        ppAppend(bnf.update(BNF.id));
    jj_consume_token(SET);
                        ppSet(bnf.update(BNF.SET));
    setClauseList(info);
                        ppAppend(bnf.update(BNF.setClauseList));
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case WHERE:
      where(info);
                                ppAppend(bnf.update(BNF.where));
      break;
    default:
      jj_la1[66] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case OPTION:
      option(info);
      break;
    default:
      jj_la1[67] = jj_gen;
      ;
    }
  }

  final public void delete(ParseInfo info) throws ParseException {
    jj_consume_token(DELETE);
                        ppSet(bnf.delete(BNF.DELETE));
    jj_consume_token(FROM);
                        ppSet(bnf.delete(BNF.FROM));
    id();
                        ppAppend(bnf.delete(BNF.id));
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case WHERE:
      where(info);
                                ppAppend(bnf.delete(BNF.where));
      break;
    default:
      jj_la1[68] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case OPTION:
      option(info);
      break;
    default:
      jj_la1[69] = jj_gen;
      ;
    }
  }

  final public void queryExpression(ParseInfo info) throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case WITH:
      jj_consume_token(WITH);
                                ppSet(bnf.queryExpression(BNF.WITH));
      withListElement(info);
                                ppAppend(bnf.queryExpression(BNF.withListElement));
      label_8:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[70] = jj_gen;
          break label_8;
        }
        jj_consume_token(COMMA);
                                        ppSet(bnf.queryExpression(BNF.COMMA));
        withListElement(info);
                                        ppAppend(bnf.queryExpression(BNF.withListElement));
      }
      break;
    default:
      jj_la1[71] = jj_gen;
      ;
    }
    queryExpressionBody(info);
  }

  final public void withListElement(ParseInfo info) throws ParseException {
    id();
                        ppAppend(bnf.withListElement(BNF.id));
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LPAREN:
      columnList();
      break;
    default:
      jj_la1[72] = jj_gen;
      ;
    }
    jj_consume_token(AS);
                        ppSet(bnf.withListElement(BNF.AS));
    jj_consume_token(LPAREN);
                        ppSet(bnf.withListElement(BNF.LPAREN));
    queryExpression(info);
                        ppAppend(bnf.withListElement(BNF.queryExpression));
    jj_consume_token(RPAREN);
                        ppSet((String[]) null);
  }

  final public void queryExpressionBody(ParseInfo info) throws ParseException {
    queryTerm(info);
                        ppAppend(bnf.queryExpressionBody(BNF.queryTerm));
    label_9:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case EXCEPT:
      case UNION:
        ;
        break;
      default:
        jj_la1[73] = jj_gen;
        break label_9;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case UNION:
        jj_consume_token(UNION);
                                        ppSet(bnf.queryExpressionBody(BNF.UNION));
        break;
      case EXCEPT:
        jj_consume_token(EXCEPT);
                                        ppSet(bnf.queryExpressionBody(BNF.EXCEPT));
        break;
      default:
        jj_la1[74] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ALL:
      case DISTINCT:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case ALL:
          jj_consume_token(ALL);
                                        ppSet(bnf.queryExpressionBody(BNF.ALL));
          break;
        case DISTINCT:
          jj_consume_token(DISTINCT);
                                        ppSet(bnf.queryExpressionBody(BNF.DISTINCT));
          break;
        default:
          jj_la1[75] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
      default:
        jj_la1[76] = jj_gen;
        ;
      }
      queryTerm(info);
                                ppAppend(bnf.queryExpressionBody(BNF.queryTerm));
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ORDER:
      orderby(info);
                                ppAppend(bnf.queryExpressionBody(BNF.orderby));
      break;
    default:
      jj_la1[77] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case FETCH:
    case LIMIT:
    case OFFSET:
      limit(info);
                                ppAppend(bnf.queryExpressionBody(BNF.limit));
      break;
    default:
      jj_la1[78] = jj_gen;
      ;
    }
    if (jj_2_13(2147483647)) {
      option(info);
    } else {
      ;
    }
  }

  final public void queryTerm(ParseInfo info) throws ParseException {
    queryPrimary(info);
                        ppAppend(bnf.queryTerm(BNF.queryPrimary));
    label_10:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case INTERSECT:
        ;
        break;
      default:
        jj_la1[79] = jj_gen;
        break label_10;
      }
      jj_consume_token(INTERSECT);
                                ppSet(bnf.queryTerm(BNF.INTERSECT));
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ALL:
      case DISTINCT:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case ALL:
          jj_consume_token(ALL);
                                        ppSet(bnf.queryTerm(BNF.ALL));
          break;
        case DISTINCT:
          jj_consume_token(DISTINCT);
                                        ppSet(bnf.queryTerm(BNF.DISTINCT));
          break;
        default:
          jj_la1[80] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
      default:
        jj_la1[81] = jj_gen;
        ;
      }
      queryPrimary(info);
                                ppAppend(bnf.queryTerm(BNF.queryPrimary));
    }
  }

  final public void queryPrimary(ParseInfo info) throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SELECT:
      query(info);
      break;
    case VALUES:
      jj_consume_token(VALUES);
                                        ppSet(bnf.queryPrimary(BNF.VALUES));
      jj_consume_token(LPAREN);
                                        ppSet(bnf.queryPrimary(BNF.VALUES, BNF.LPAREN));
      expressionList(info);
                                        ppAppend(bnf.queryPrimary(BNF.expressionList));
      jj_consume_token(RPAREN);
                                        ppSet(bnf.queryPrimary(BNF.VALUES, BNF.RPAREN));
      label_11:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[82] = jj_gen;
          break label_11;
        }
        jj_consume_token(COMMA);
                                                ppSet(bnf.queryPrimary(BNF.COMMA));
                                                requiresVersionAtLeast(Version.TEIID_8_6);
        jj_consume_token(LPAREN);
                                                ppSet(bnf.queryPrimary(BNF.VALUES, BNF.LPAREN));
        expressionList(info);
                                                ppAppend(bnf.queryPrimary(BNF.expressionList));
        jj_consume_token(RPAREN);
                                                ppSet(bnf.queryPrimary(BNF.VALUES, BNF.RPAREN));
      }
      break;
    case TABLE:
      jj_consume_token(TABLE);
                                        ppSet(bnf.queryPrimary(BNF.TABLE));
      id();
      break;
    case LPAREN:
      jj_consume_token(LPAREN);
                                        ppSet(bnf.queryPrimary(BNF.LPAREN));
      queryExpressionBody(info);
                                        ppAppend(bnf.queryPrimary(BNF.queryExpressionBody));
      jj_consume_token(RPAREN);
                                        ppSet((String[]) null);
      break;
    default:
      jj_la1[83] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void query(ParseInfo info) throws ParseException {
    select(info);
                        ppAppend(bnf.query(BNF.select));
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case INTO:
      into(info);
                                ppAppend(bnf.query(BNF.into));
      break;
    default:
      jj_la1[84] = jj_gen;
      ;
    }
    from(info);
                        ppAppend(bnf.query(BNF.from));
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case WHERE:
      where(info);
                                ppAppend(bnf.query(BNF.where));
      break;
    default:
      jj_la1[85] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case GROUP:
      groupBy(info);
                                ppAppend(bnf.query(BNF.groupBy));
      break;
    default:
      jj_la1[86] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case HAVING:
      having(info);
                                ppAppend(bnf.query(BNF.having));
      break;
    default:
      jj_la1[87] = jj_gen;
      ;
    }
  }

  final public void into(ParseInfo info) throws ParseException {
    jj_consume_token(INTO);
                        ppSet(bnf.into(BNF.INTO));
    id();
  }

  final public void select(ParseInfo info) throws ParseException {
    jj_consume_token(SELECT);
                        ppSet(bnf.select(BNF.SELECT));
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ALL:
    case DISTINCT:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ALL:
        jj_consume_token(ALL);
                                ppSet(bnf.select(BNF.ALL));
        break;
      case DISTINCT:
        jj_consume_token(DISTINCT);
                                ppSet(bnf.select(BNF.DISTINCT));
        break;
      default:
        jj_la1[88] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[89] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case STAR:
      jj_consume_token(STAR);
                                ppSet((String[]) null);
      break;
    case CHAR:
    case CAST:
    case CONVERT:
    case ANY:
    case CASE:
    case EXISTS:
    case FALSE:
    case HOUR:
    case INSERT:
    case LEFT:
    case MINUTE:
    case MONTH:
    case NOT:
    case NULL:
    case RIGHT:
    case SECOND:
    case SOME:
    case TRANSLATE:
    case TRUE:
    case UNKNOWN:
    case USER:
    case YEAR:
    case XMLAGG:
    case XMLCONCAT:
    case XMLCOMMENT:
    case XMLELEMENT:
    case XMLFOREST:
    case XMLPARSE:
    case XMLPI:
    case XMLQUERY:
    case XMLSERIALIZE:
    case INSTEAD:
    case ENABLED:
    case DISABLED:
    case VIEW:
    case KEY:
    case SERIAL:
    case TEXTAGG:
    case COUNT:
    case ROW_NUMBER:
    case RANK:
    case DENSE_RANK:
    case SUM:
    case AVG:
    case MIN:
    case MAX:
    case EVERY:
    case STDDEV_POP:
    case STDDEV_SAMP:
    case VAR_SAMP:
    case VAR_POP:
    case DOCUMENT:
    case CONTENT:
    case TRIM:
    case EMPTY:
    case ORDINALITY:
    case PATH:
    case FIRST:
    case LAST:
    case NEXT:
    case SUBSTRING:
    case EXTRACT:
    case TO_CHARS:
    case TO_BYTES:
    case TIMESTAMPADD:
    case TIMESTAMPDIFF:
    case QUERYSTRING:
    case NAMESPACE:
    case RESULT:
    case INDEX:
    case ACCESSPATTERN:
    case AUTO_INCREMENT:
    case WELLFORMED:
    case SQL_TSI_FRAC_SECOND:
    case SQL_TSI_SECOND:
    case SQL_TSI_MINUTE:
    case SQL_TSI_HOUR:
    case SQL_TSI_DAY:
    case SQL_TSI_WEEK:
    case SQL_TSI_MONTH:
    case SQL_TSI_QUARTER:
    case SQL_TSI_YEAR:
    case TEXTTABLE:
    case ARRAYTABLE:
    case SELECTOR:
    case SKIP_KEYWORD:
    case WIDTH:
    case PASSING:
    case NAME:
    case ENCODING:
    case COLUMNS:
    case DELIMITER:
    case QUOTE:
    case HEADER:
    case NULLS:
    case OBJECTTABLE:
    case VERSION:
    case INCLUDING:
    case EXCLUDING:
    case XMLDECLARATION:
    case VARIADIC:
    case EXCEPTION:
    case RAISE:
    case CHAIN:
    case JSONARRAY_AGG:
    case JSONOBJECT:
    case ALL_IN_GROUP:
    case ID:
    case ESCAPEDFUNCTION:
    case ESCAPEDTYPE:
    case DECIMALVAL:
    case FLOATVAL:
    case STRINGVAL:
    case UNSIGNEDINTEGER:
    case BINARYSTRINGVAL:
    case LPAREN:
    case PLUS:
    case MINUS:
    case QMARK:
    case DOLLAR:
      selectSymbol(info);
                                        ppAppend(bnf.select(BNF.selectSymbol));
      label_12:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[90] = jj_gen;
          break label_12;
        }
        jj_consume_token(COMMA);
                                                ppSet(bnf.select(BNF.COMMA));
        selectSymbol(info);
                                                ppAppend(bnf.select(BNF.COMMA, BNF.selectSymbol));
      }
      break;
    default:
      jj_la1[91] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void selectSymbol(ParseInfo info) throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CHAR:
    case CAST:
    case CONVERT:
    case ANY:
    case CASE:
    case EXISTS:
    case FALSE:
    case HOUR:
    case INSERT:
    case LEFT:
    case MINUTE:
    case MONTH:
    case NOT:
    case NULL:
    case RIGHT:
    case SECOND:
    case SOME:
    case TRANSLATE:
    case TRUE:
    case UNKNOWN:
    case USER:
    case YEAR:
    case XMLAGG:
    case XMLCONCAT:
    case XMLCOMMENT:
    case XMLELEMENT:
    case XMLFOREST:
    case XMLPARSE:
    case XMLPI:
    case XMLQUERY:
    case XMLSERIALIZE:
    case INSTEAD:
    case ENABLED:
    case DISABLED:
    case VIEW:
    case KEY:
    case SERIAL:
    case TEXTAGG:
    case COUNT:
    case ROW_NUMBER:
    case RANK:
    case DENSE_RANK:
    case SUM:
    case AVG:
    case MIN:
    case MAX:
    case EVERY:
    case STDDEV_POP:
    case STDDEV_SAMP:
    case VAR_SAMP:
    case VAR_POP:
    case DOCUMENT:
    case CONTENT:
    case TRIM:
    case EMPTY:
    case ORDINALITY:
    case PATH:
    case FIRST:
    case LAST:
    case NEXT:
    case SUBSTRING:
    case EXTRACT:
    case TO_CHARS:
    case TO_BYTES:
    case TIMESTAMPADD:
    case TIMESTAMPDIFF:
    case QUERYSTRING:
    case NAMESPACE:
    case RESULT:
    case INDEX:
    case ACCESSPATTERN:
    case AUTO_INCREMENT:
    case WELLFORMED:
    case SQL_TSI_FRAC_SECOND:
    case SQL_TSI_SECOND:
    case SQL_TSI_MINUTE:
    case SQL_TSI_HOUR:
    case SQL_TSI_DAY:
    case SQL_TSI_WEEK:
    case SQL_TSI_MONTH:
    case SQL_TSI_QUARTER:
    case SQL_TSI_YEAR:
    case TEXTTABLE:
    case ARRAYTABLE:
    case SELECTOR:
    case SKIP_KEYWORD:
    case WIDTH:
    case PASSING:
    case NAME:
    case ENCODING:
    case COLUMNS:
    case DELIMITER:
    case QUOTE:
    case HEADER:
    case NULLS:
    case OBJECTTABLE:
    case VERSION:
    case INCLUDING:
    case EXCLUDING:
    case XMLDECLARATION:
    case VARIADIC:
    case EXCEPTION:
    case RAISE:
    case CHAIN:
    case JSONARRAY_AGG:
    case JSONOBJECT:
    case ID:
    case ESCAPEDFUNCTION:
    case ESCAPEDTYPE:
    case DECIMALVAL:
    case FLOATVAL:
    case STRINGVAL:
    case UNSIGNEDINTEGER:
    case BINARYSTRINGVAL:
    case LPAREN:
    case PLUS:
    case MINUS:
    case QMARK:
    case DOLLAR:
      selectExpression(info);
      break;
    case ALL_IN_GROUP:
      allInGroupSymbol();
      break;
    default:
      jj_la1[92] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void selectExpression(ParseInfo info) throws ParseException {
    expression(info);
                                ppAppend(bnf.selectExpression(BNF.expression));
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case AS:
    case INSTEAD:
    case ENABLED:
    case DISABLED:
    case VIEW:
    case KEY:
    case SERIAL:
    case TEXTAGG:
    case COUNT:
    case ROW_NUMBER:
    case RANK:
    case DENSE_RANK:
    case SUM:
    case AVG:
    case MIN:
    case MAX:
    case EVERY:
    case STDDEV_POP:
    case STDDEV_SAMP:
    case VAR_SAMP:
    case VAR_POP:
    case DOCUMENT:
    case CONTENT:
    case TRIM:
    case EMPTY:
    case ORDINALITY:
    case PATH:
    case FIRST:
    case LAST:
    case NEXT:
    case SUBSTRING:
    case EXTRACT:
    case TO_CHARS:
    case TO_BYTES:
    case TIMESTAMPADD:
    case TIMESTAMPDIFF:
    case QUERYSTRING:
    case NAMESPACE:
    case RESULT:
    case INDEX:
    case ACCESSPATTERN:
    case AUTO_INCREMENT:
    case WELLFORMED:
    case SQL_TSI_FRAC_SECOND:
    case SQL_TSI_SECOND:
    case SQL_TSI_MINUTE:
    case SQL_TSI_HOUR:
    case SQL_TSI_DAY:
    case SQL_TSI_WEEK:
    case SQL_TSI_MONTH:
    case SQL_TSI_QUARTER:
    case SQL_TSI_YEAR:
    case TEXTTABLE:
    case ARRAYTABLE:
    case SELECTOR:
    case SKIP_KEYWORD:
    case WIDTH:
    case PASSING:
    case NAME:
    case ENCODING:
    case COLUMNS:
    case DELIMITER:
    case QUOTE:
    case HEADER:
    case NULLS:
    case OBJECTTABLE:
    case VERSION:
    case INCLUDING:
    case EXCLUDING:
    case XMLDECLARATION:
    case VARIADIC:
    case EXCEPTION:
    case RAISE:
    case CHAIN:
    case JSONARRAY_AGG:
    case JSONOBJECT:
    case ID:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case AS:
        jj_consume_token(AS);
                                                ppSet(bnf.selectExpression(BNF.AS));
        break;
      default:
        jj_la1[93] = jj_gen;
        ;
      }
      id();
      break;
    default:
      jj_la1[94] = jj_gen;
      ;
    }
  }

  final public void derivedColumn(ParseInfo info) throws ParseException {
    expression(info);
                                ppAppend(bnf.derivedColumn(BNF.expression));
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case AS:
      jj_consume_token(AS);
                                        ppSet(bnf.derivedColumn(BNF.AS));
      id();
      break;
    default:
      jj_la1[95] = jj_gen;
      ;
    }
  }

  final public void allInGroupSymbol() throws ParseException {
    jj_consume_token(ALL_IN_GROUP);
                        ppSet((String[]) null);
  }

  final public void orderedAgg(ParseInfo info) throws ParseException {
    jj_consume_token(XMLAGG);
                                ppSet(bnf.orderedAgg(BNF.XMLAGG));
    jj_consume_token(ARRAY_AGG);
                                ppSet(bnf.orderedAgg(BNF.ARRAY_AGG));
    jj_consume_token(JSONARRAY_AGG);
                                ppSet(bnf.orderedAgg(BNF.JSONARRAY_AGG));
    jj_consume_token(LPAREN);
                        ppSet(bnf.orderedAgg(BNF.LPAREN));
    expression(info);
                        ppAppend(bnf.orderedAgg(BNF.expression));
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ORDER:
      orderby(info);
                                ppAppend(bnf.orderedAgg(BNF.orderby));
      break;
    default:
      jj_la1[96] = jj_gen;
      ;
    }
    jj_consume_token(RPAREN);
                        ppSet((String[]) null);
  }

  final public void textAgg(ParseInfo info) throws ParseException {
    jj_consume_token(TEXTAGG);
                        ppSet(bnf.textAgg(BNF.TEXTAGG));
    jj_consume_token(LPAREN);
                        ppSet(bnf.textAgg(BNF.LPAREN));
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case FOR:
      jj_consume_token(FOR);
                                ppSet(bnf.textAgg(BNF.FOR));
      break;
    default:
      jj_la1[97] = jj_gen;
      ;
    }
    derivedColumn(info);
                        ppAppend(bnf.textAgg(BNF.derivedColumn));
    label_13:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[98] = jj_gen;
        break label_13;
      }
      jj_consume_token(COMMA);
                                ppSet(bnf.textAgg(BNF.COMMA));
      derivedColumn(info);
                                ppAppend(bnf.textAgg(BNF.derivedColumn));
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DELIMITER:
      jj_consume_token(DELIMITER);
                                ppSet(bnf.textAgg(BNF.DELIMITER));
      charVal(info, "DELMITER");
                                ppAppend(bnf.textAgg(BNF.DELIMITER, BNF.charVal));
      break;
    default:
      jj_la1[99] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case QUOTE:
      jj_consume_token(QUOTE);
                                ppSet(bnf.textAgg(BNF.QUOTE));
      charVal(info, "QUOTE");
                                ppAppend(bnf.textAgg(BNF.QUOTE, BNF.charVal));
      break;
    default:
      jj_la1[100] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case HEADER:
      jj_consume_token(HEADER);
                                ppSet(bnf.textAgg(BNF.HEADER));
      break;
    default:
      jj_la1[101] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ENCODING:
      jj_consume_token(ENCODING);
                                ppSet(bnf.textAgg(BNF.ENCODING));
      id();
                                ppAppend(bnf.textAgg(BNF.id));
      break;
    default:
      jj_la1[102] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ORDER:
      orderby(info);
                                ppAppend(bnf.textAgg(BNF.orderby));
      break;
    default:
      jj_la1[103] = jj_gen;
      ;
    }
    jj_consume_token(RPAREN);
                        ppSet((String[]) null);
  }

  final public void aggregateSymbol(ParseInfo info) throws ParseException {
    if (jj_2_14(3)) {
      jj_consume_token(COUNT);
                                        ppSet(bnf.aggregateSymbol(BNF.COUNT));
      jj_consume_token(LPAREN);
                                        ppSet(bnf.aggregateSymbol(BNF.COUNT, BNF.LPAREN));
      jj_consume_token(STAR);
                                        ppSet(bnf.aggregateSymbol(BNF.STAR));
      jj_consume_token(RPAREN);
                                        ppSet((String[]) null);
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ANY:
      case SOME:
      case COUNT:
      case SUM:
      case AVG:
      case MIN:
      case MAX:
      case EVERY:
      case STDDEV_POP:
      case STDDEV_SAMP:
      case VAR_SAMP:
      case VAR_POP:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COUNT:
          jj_consume_token(COUNT);
                                                ppSet(bnf.aggregateSymbol(BNF.COUNT));
          break;
        case SUM:
          jj_consume_token(SUM);
                                                ppSet(bnf.aggregateSymbol(BNF.SUM));
          break;
        case AVG:
          jj_consume_token(AVG);
                                                ppSet(bnf.aggregateSymbol(BNF.AVG));
          break;
        case MIN:
          jj_consume_token(MIN);
                                                ppSet(bnf.aggregateSymbol(BNF.MIN));
          break;
        case MAX:
          jj_consume_token(MAX);
                                                ppSet(bnf.aggregateSymbol(BNF.MAX));
          break;
        case EVERY:
          jj_consume_token(EVERY);
                                                ppSet(bnf.aggregateSymbol(BNF.EVERY));
          break;
        case STDDEV_POP:
          jj_consume_token(STDDEV_POP);
                                                ppSet(bnf.aggregateSymbol(BNF.STDDEV_POP));
          break;
        case STDDEV_SAMP:
          jj_consume_token(STDDEV_SAMP);
                                                ppSet(bnf.aggregateSymbol(BNF.STDDEV_SAMP));
          break;
        case VAR_SAMP:
          jj_consume_token(VAR_SAMP);
                                                ppSet(bnf.aggregateSymbol(BNF.VAR_SAMP));
          break;
        case VAR_POP:
          jj_consume_token(VAR_POP);
                                                ppSet(bnf.aggregateSymbol(BNF.VAR_POP));
          break;
        case SOME:
          jj_consume_token(SOME);
                                                ppSet(bnf.aggregateSymbol(BNF.SOME));
          break;
        case ANY:
          jj_consume_token(ANY);
                                                ppSet(bnf.aggregateSymbol(BNF.ANY));
          break;
        default:
          jj_la1[104] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        jj_consume_token(LPAREN);
                                        ppSet(bnf.aggregateSymbol(BNF.LPAREN));
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case ALL:
        case DISTINCT:
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case DISTINCT:
            jj_consume_token(DISTINCT);
                                                ppSet(bnf.aggregateSymbol(BNF.DISTINCT));
            break;
          case ALL:
            jj_consume_token(ALL);
                                                ppSet(bnf.aggregateSymbol(BNF.ALL));
            break;
          default:
            jj_la1[105] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          break;
        default:
          jj_la1[106] = jj_gen;
          ;
        }
        expression(info);
                                        ppAppend(bnf.aggregateSymbol(BNF.expression));
        jj_consume_token(RPAREN);
                                        ppSet((String[]) null);
        break;
      default:
        jj_la1[107] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

  final public void analyticAggregateSymbol(ParseInfo info) throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ROW_NUMBER:
      jj_consume_token(ROW_NUMBER);
                                ppSet(bnf.analyticAggregateSymbol(BNF.ROW_NUMBER));
      break;
    case RANK:
      jj_consume_token(RANK);
                                ppSet(bnf.analyticAggregateSymbol(BNF.RANK));
      break;
    case DENSE_RANK:
      jj_consume_token(DENSE_RANK);
                                ppSet(bnf.analyticAggregateSymbol(BNF.DENSE_RANK));
      break;
    default:
      jj_la1[108] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(LPAREN);
                        ppSet(bnf.analyticAggregateSymbol(BNF.LPAREN));
    jj_consume_token(RPAREN);
                        ppSet((String[]) null);
  }

  final public void filterClause(ParseInfo info) throws ParseException {
    jj_consume_token(FILTER);
                        ppSet(bnf.filterClause(BNF.FILTER));
    jj_consume_token(LPAREN);
                        ppSet(bnf.filterClause(BNF.LPAREN));
    jj_consume_token(WHERE);
                        ppSet(bnf.filterClause(BNF.WHERE));
    booleanPrimary(info);
                        ppAppend(bnf.filterClause(BNF.booleanPrimary));
    jj_consume_token(RPAREN);
                        ppSet((String[]) null);
  }

  final public void from(ParseInfo info) throws ParseException {
    jj_consume_token(FROM);
                        ppSet(bnf.from(BNF.FROM));
    tableReference(info);
                                ppAppend(bnf.from(BNF.tableReference));
    label_14:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[109] = jj_gen;
        break label_14;
      }
      jj_consume_token(COMMA);
                                        ppSet(bnf.from(BNF.COMMA));
      tableReference(info);
                                        ppAppend(bnf.from(BNF.tableReference));
    }
  }

  final public void tableReference(ParseInfo info) throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ESCAPEDJOIN:
      jj_consume_token(ESCAPEDJOIN);
                                        ppSet(bnf.tableReference(BNF.ESCAPEDJOIN));
      joinedTable(info);
                                        ppAppend(bnf.tableReference(BNF.ESCAPEDJOIN, BNF.joinedTable));
      jj_consume_token(RBRACE);
                                        ppSet((String[]) null);
      break;
    case TABLE:
    case LATERAL:
    case XMLTABLE:
    case INSTEAD:
    case ENABLED:
    case DISABLED:
    case VIEW:
    case KEY:
    case SERIAL:
    case TEXTAGG:
    case COUNT:
    case ROW_NUMBER:
    case RANK:
    case DENSE_RANK:
    case SUM:
    case AVG:
    case MIN:
    case MAX:
    case EVERY:
    case STDDEV_POP:
    case STDDEV_SAMP:
    case VAR_SAMP:
    case VAR_POP:
    case DOCUMENT:
    case CONTENT:
    case TRIM:
    case EMPTY:
    case ORDINALITY:
    case PATH:
    case FIRST:
    case LAST:
    case NEXT:
    case SUBSTRING:
    case EXTRACT:
    case TO_CHARS:
    case TO_BYTES:
    case TIMESTAMPADD:
    case TIMESTAMPDIFF:
    case QUERYSTRING:
    case NAMESPACE:
    case RESULT:
    case INDEX:
    case ACCESSPATTERN:
    case AUTO_INCREMENT:
    case WELLFORMED:
    case SQL_TSI_FRAC_SECOND:
    case SQL_TSI_SECOND:
    case SQL_TSI_MINUTE:
    case SQL_TSI_HOUR:
    case SQL_TSI_DAY:
    case SQL_TSI_WEEK:
    case SQL_TSI_MONTH:
    case SQL_TSI_QUARTER:
    case SQL_TSI_YEAR:
    case TEXTTABLE:
    case ARRAYTABLE:
    case SELECTOR:
    case SKIP_KEYWORD:
    case WIDTH:
    case PASSING:
    case NAME:
    case ENCODING:
    case COLUMNS:
    case DELIMITER:
    case QUOTE:
    case HEADER:
    case NULLS:
    case OBJECTTABLE:
    case VERSION:
    case INCLUDING:
    case EXCLUDING:
    case XMLDECLARATION:
    case VARIADIC:
    case EXCEPTION:
    case RAISE:
    case CHAIN:
    case JSONARRAY_AGG:
    case JSONOBJECT:
    case ID:
    case LPAREN:
      joinedTable(info);
      break;
    default:
      jj_la1[110] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void joinedTable(ParseInfo info) throws ParseException {
    tablePrimary(info);
                        ppAppend(bnf.joinedTable(BNF.tablePrimary));
    label_15:
    while (true) {
      if (jj_2_15(2)) {
        ;
      } else {
        break label_15;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case CROSS:
      case UNION:
        crossJoin(info);
                                        ppAppend(bnf.joinedTable(BNF.crossJoin));
        break;
      case FULL:
      case INNER:
      case JOIN:
      case LEFT:
      case RIGHT:
        qualifiedJoin(info);
                                        ppAppend(bnf.joinedTable(BNF.qualifiedJoin));
        break;
      default:
        jj_la1[111] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

  final public void crossJoin(ParseInfo info) throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CROSS:
      jj_consume_token(CROSS);
                                        ppSet(bnf.crossJoin(BNF.CROSS));
      break;
    case UNION:
      jj_consume_token(UNION);
                                        ppSet(bnf.crossJoin(BNF.UNION));
      break;
    default:
      jj_la1[112] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(JOIN);
                                ppSet(bnf.crossJoin(BNF.JOIN));
    tablePrimary(info);
  }

  final public void qualifiedJoin(ParseInfo info) throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case FULL:
    case INNER:
    case LEFT:
    case RIGHT:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case RIGHT:
        jj_consume_token(RIGHT);
                                                ppSet(bnf.qualifiedJoin(BNF.RIGHT));
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case OUTER:
          jj_consume_token(OUTER);
                                                        ppSet(bnf.qualifiedJoin(BNF.OUTER));
          break;
        default:
          jj_la1[113] = jj_gen;
          ;
        }
        break;
      case LEFT:
        jj_consume_token(LEFT);
                                                ppSet(bnf.qualifiedJoin(BNF.LEFT));
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case OUTER:
          jj_consume_token(OUTER);
                                                        ppSet(bnf.qualifiedJoin(BNF.OUTER));
          break;
        default:
          jj_la1[114] = jj_gen;
          ;
        }
        break;
      case FULL:
        jj_consume_token(FULL);
                                                ppSet(bnf.qualifiedJoin(BNF.FULL));
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case OUTER:
          jj_consume_token(OUTER);
                                                        ppSet(bnf.qualifiedJoin(BNF.OUTER));
          break;
        default:
          jj_la1[115] = jj_gen;
          ;
        }
        break;
      case INNER:
        jj_consume_token(INNER);
                                                ppSet(bnf.qualifiedJoin(BNF.INNER));
        break;
      default:
        jj_la1[116] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[117] = jj_gen;
      ;
    }
    jj_consume_token(JOIN);
                                ppSet(bnf.qualifiedJoin(BNF.JOIN));
    tableReference(info);
                                ppAppend(bnf.qualifiedJoin(BNF.tableReference));
    jj_consume_token(ON);
                                ppSet(bnf.qualifiedJoin(BNF.ON));
    criteria(info);
  }

  final public void tablePrimary(ParseInfo info) throws ParseException {
    if (jj_2_16(2)) {
      textTable(info);
                                ppAppend(bnf.tablePrimary(BNF.textTable));
    } else if (jj_2_17(2)) {
      arrayTable(info);
                                ppAppend(bnf.tablePrimary(BNF.arrayTable));
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case XMLTABLE:
        xmlTable(info);
                                ppAppend(bnf.tablePrimary(BNF.xmlTable));
        break;
      default:
        jj_la1[118] = jj_gen;
        if (jj_2_18(2)) {
          objectTable(info);
                                ppAppend(bnf.tablePrimary(BNF.objectTable));
        } else {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case INSTEAD:
          case ENABLED:
          case DISABLED:
          case VIEW:
          case KEY:
          case SERIAL:
          case TEXTAGG:
          case COUNT:
          case ROW_NUMBER:
          case RANK:
          case DENSE_RANK:
          case SUM:
          case AVG:
          case MIN:
          case MAX:
          case EVERY:
          case STDDEV_POP:
          case STDDEV_SAMP:
          case VAR_SAMP:
          case VAR_POP:
          case DOCUMENT:
          case CONTENT:
          case TRIM:
          case EMPTY:
          case ORDINALITY:
          case PATH:
          case FIRST:
          case LAST:
          case NEXT:
          case SUBSTRING:
          case EXTRACT:
          case TO_CHARS:
          case TO_BYTES:
          case TIMESTAMPADD:
          case TIMESTAMPDIFF:
          case QUERYSTRING:
          case NAMESPACE:
          case RESULT:
          case INDEX:
          case ACCESSPATTERN:
          case AUTO_INCREMENT:
          case WELLFORMED:
          case SQL_TSI_FRAC_SECOND:
          case SQL_TSI_SECOND:
          case SQL_TSI_MINUTE:
          case SQL_TSI_HOUR:
          case SQL_TSI_DAY:
          case SQL_TSI_WEEK:
          case SQL_TSI_MONTH:
          case SQL_TSI_QUARTER:
          case SQL_TSI_YEAR:
          case TEXTTABLE:
          case ARRAYTABLE:
          case SELECTOR:
          case SKIP_KEYWORD:
          case WIDTH:
          case PASSING:
          case NAME:
          case ENCODING:
          case COLUMNS:
          case DELIMITER:
          case QUOTE:
          case HEADER:
          case NULLS:
          case OBJECTTABLE:
          case VERSION:
          case INCLUDING:
          case EXCLUDING:
          case XMLDECLARATION:
          case VARIADIC:
          case EXCEPTION:
          case RAISE:
          case CHAIN:
          case JSONARRAY_AGG:
          case JSONOBJECT:
          case ID:
            unaryFromClause(info);
                                ppAppend(bnf.tablePrimary(BNF.unaryFromClause));
            break;
          default:
            jj_la1[119] = jj_gen;
            if (jj_2_19(2147483647)) {
              subqueryFromClause(info);
                                ppAppend(bnf.tablePrimary(BNF.subqueryFromClause));
            } else {
              switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
              case LPAREN:
                jj_consume_token(LPAREN);
                                        ppSet(bnf.tablePrimary(BNF.LPAREN));
                joinedTable(info);
                                        ppAppend(bnf.tablePrimary(BNF.joinedTable));
                jj_consume_token(RPAREN);
                                        ppSet(bnf.tablePrimary(BNF.RPAREN));
                break;
              default:
                jj_la1[120] = jj_gen;
                jj_consume_token(-1);
                throw new ParseException();
              }
            }
          }
        }
      }
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case MAKEDEP:
    case MAKENOTDEP:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case MAKEDEP:
        jj_consume_token(MAKEDEP);
                                        ppSet((String[]) null);
        break;
      case MAKENOTDEP:
        jj_consume_token(MAKENOTDEP);
                                        ppSet((String[]) null);
        break;
      default:
        jj_la1[121] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[122] = jj_gen;
      ;
    }
  }

  final public void xmlSerialize(ParseInfo info) throws ParseException {
    jj_consume_token(XMLSERIALIZE);
                        ppSet(bnf.xmlSerialize(BNF.XMLSERIALIZE));
    jj_consume_token(LPAREN);
                        ppSet(bnf.xmlSerialize(BNF.LPAREN));
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DOCUMENT:
    case CONTENT:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case DOCUMENT:
        jj_consume_token(DOCUMENT);
                                        ppSet(bnf.xmlSerialize(BNF.DOCUMENT));
        break;
      case CONTENT:
        jj_consume_token(CONTENT);
                                        ppSet(bnf.xmlSerialize(BNF.CONTENT));
        break;
      default:
        jj_la1[123] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[124] = jj_gen;
      ;
    }
    expression(info);
                        ppAppend(bnf.xmlSerialize(BNF.expression));
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case AS:
      jj_consume_token(AS);
                                ppSet(bnf.xmlSerialize(BNF.AS));
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case STRING:
        jj_consume_token(STRING);
                                        ppSet(bnf.xmlSerialize(BNF.STRING));
        break;
      case VARCHAR:
        jj_consume_token(VARCHAR);
                                        ppSet(bnf.xmlSerialize(BNF.VARCHAR));
        break;
      case CLOB:
        jj_consume_token(CLOB);
                                        ppSet(bnf.xmlSerialize(BNF.CLOB));
        break;
      case VARBINARY:
        jj_consume_token(VARBINARY);
                                        ppSet(bnf.xmlSerialize(BNF.VARBINARY));
        break;
      case BLOB:
        jj_consume_token(BLOB);
                                        ppSet(bnf.xmlSerialize(BNF.BLOB));
        break;
      default:
        jj_la1[125] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[126] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ENCODING:
      jj_consume_token(ENCODING);
                                ppSet(bnf.xmlSerialize(BNF.ENCODING));
      id();
                                ppSet(bnf.xmlSerialize(BNF.id));
      break;
    default:
      jj_la1[127] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case VERSION:
      jj_consume_token(VERSION);
                                ppSet(bnf.xmlSerialize(BNF.VERSION));
      stringVal();
                                ppSet(bnf.xmlSerialize(BNF.stringVal));
      break;
    default:
      jj_la1[128] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case INCLUDING:
    case EXCLUDING:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case INCLUDING:
        jj_consume_token(INCLUDING);
                                        ppSet(bnf.xmlSerialize(BNF.INCLUDING));
        break;
      case EXCLUDING:
        jj_consume_token(EXCLUDING);
                                        ppSet(bnf.xmlSerialize(BNF.EXCLUDING));
        break;
      default:
        jj_la1[129] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      jj_consume_token(XMLDECLARATION);
                                ppSet(bnf.xmlSerialize(BNF.XMLDECLARATION));
      break;
    default:
      jj_la1[130] = jj_gen;
      ;
    }
    jj_consume_token(RPAREN);
                        ppSet((String[]) null);
  }

  final public void arrayTable(ParseInfo info) throws ParseException {
    jj_consume_token(ARRAYTABLE);
                        ppSet(bnf.arrayTable(BNF.ARRAYTABLE));
    jj_consume_token(LPAREN);
                        ppSet(bnf.arrayTable(BNF.LPAREN));
    valueExpressionPrimary(info);
                        ppAppend(bnf.arrayTable(BNF.valueExpressionPrimary));
    jj_consume_token(COLUMNS);
                        ppSet(bnf.arrayTable(BNF.COLUMNS));
    createElementsWithTypes(info);
                        ppAppend(bnf.arrayTable(BNF.createElementsWithTypes));
    jj_consume_token(RPAREN);
                        ppSet(bnf.arrayTable(BNF.RPAREN));
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case AS:
      jj_consume_token(AS);
                                ppSet(bnf.arrayTable(BNF.AS));
      break;
    default:
      jj_la1[131] = jj_gen;
      ;
    }
    id();
  }

  final public void textTable(ParseInfo info) throws ParseException {
    jj_consume_token(TEXTTABLE);
                        ppSet(bnf.textTable(BNF.TEXTTABLE));
    jj_consume_token(LPAREN);
                        ppSet(bnf.textTable(BNF.LPAREN));
    commonValueExpression(info);
                        ppAppend(bnf.textTable(BNF.commonValueExpression));
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SELECTOR:
      jj_consume_token(SELECTOR);
                                ppSet(bnf.textTable(BNF.SELECTOR));
      stringVal();
                                ppSet(bnf.textTable(BNF.stringVal));
      break;
    default:
      jj_la1[132] = jj_gen;
      ;
    }
    jj_consume_token(COLUMNS);
                        ppSet(bnf.textTable(BNF.COLUMNS));
    textColumn(info);
                        ppAppend(bnf.textTable(BNF.textColumn));
    label_16:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[133] = jj_gen;
        break label_16;
      }
      jj_consume_token(COMMA);
                                ppSet(bnf.textTable(BNF.COMMA));
      textColumn(info);
                                ppAppend(bnf.textTable(BNF.textColumn));
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NO:
      jj_consume_token(NO);
                                ppSet(bnf.textTable(BNF.NO));
      jj_consume_token(ROW);
                                ppSet(bnf.textTable(BNF.ROW));
      jj_consume_token(DELIMITER);
                                ppSet(bnf.textTable(BNF.NO, BNF.DELIMITER));
      break;
    default:
      jj_la1[134] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DELIMITER:
      jj_consume_token(DELIMITER);
                                ppSet(bnf.textTable(BNF.DELIMITER));
      charVal(info, "DELMITER");
                                ppAppend(bnf.textTable(BNF.DELIMITER, BNF.charVal));
      break;
    default:
      jj_la1[135] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ESCAPE:
    case QUOTE:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ESCAPE:
        jj_consume_token(ESCAPE);
                                        ppSet(bnf.textTable(BNF.ESCAPE));
        charVal(info, "ESCAPE");
                                        ppAppend(bnf.textTable(BNF.ESCAPE, BNF.charVal));
        break;
      case QUOTE:
        jj_consume_token(QUOTE);
                                        ppSet(bnf.textTable(BNF.QUOTE));
        charVal(info, "QUOTE");
                                        ppAppend(bnf.textTable(BNF.QUOTE, BNF.charVal));
        break;
      default:
        jj_la1[136] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[137] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case HEADER:
      jj_consume_token(HEADER);
                                ppSet(bnf.textTable(BNF.HEADER));
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case UNSIGNEDINTEGER:
      case PLUS:
      case MINUS:
        intVal();
                                        ppAppend(bnf.textTable(BNF.intVal));
        break;
      default:
        jj_la1[138] = jj_gen;
        ;
      }
      break;
    default:
      jj_la1[139] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SKIP_KEYWORD:
      jj_consume_token(SKIP_KEYWORD);
                                ppSet(bnf.textTable(BNF.SKIP_KEYWORD));
      intVal();
                                ppAppend(bnf.textTable(BNF.intVal));
      break;
    default:
      jj_la1[140] = jj_gen;
      ;
    }
    jj_consume_token(RPAREN);
                        ppSet(bnf.textTable(BNF.RPAREN));
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case AS:
      jj_consume_token(AS);
                                ppSet(bnf.textTable(BNF.AS));
      break;
    default:
      jj_la1[141] = jj_gen;
      ;
    }
    id();
  }

  final public void textColumn(ParseInfo info) throws ParseException {
    id();
                        ppSet(bnf.textColumn(BNF.id));
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case FOR:
      jj_consume_token(FOR);
                                        ppSet(bnf.textColumn(BNF.FOR));
      jj_consume_token(ORDINALITY);
                                        ppSet((String[]) null);
                                        requiresVersionAtLeast(Version.TEIID_8_7);
      break;
    case STRING:
    case VARBINARY:
    case VARCHAR:
    case BOOLEAN:
    case BYTE:
    case TINYINT:
    case SHORT:
    case SMALLINT:
    case CHAR:
    case INTEGER:
    case LONG:
    case BIGINT:
    case BIGINTEGER:
    case FLOAT:
    case REAL:
    case DOUBLE:
    case BIGDECIMAL:
    case DECIMAL:
    case DATE:
    case TIME:
    case TIMESTAMP:
    case OBJECT:
    case BLOB:
    case CLOB:
    case XML:
      parseDataType();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case WIDTH:
        jj_consume_token(WIDTH);
                                                ppSet(bnf.textColumn(BNF.WIDTH));
        intVal();
                                                ppAppend(bnf.textColumn(BNF.intVal));
        if (jj_2_20(2)) {
          jj_consume_token(NO);
                                                        ppSet(bnf.textColumn(BNF.NO));
          jj_consume_token(TRIM);
                                                        ppSet(bnf.textColumn(BNF.TRIM));
        } else {
          ;
        }
        break;
      default:
        jj_la1[142] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SELECTOR:
        jj_consume_token(SELECTOR);
                                                ppSet(bnf.textColumn(BNF.SELECTOR));
        stringVal();
                                                ppAppend(bnf.textColumn(BNF.SELECTOR, BNF.stringVal));
        intVal();
                                                ppSet((String[]) null);
        break;
      default:
        jj_la1[143] = jj_gen;
        ;
      }
      break;
    default:
      jj_la1[144] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void xmlQuery(ParseInfo info) throws ParseException {
    jj_consume_token(XMLQUERY);
                        ppSet(bnf.xmlQuery(BNF.XMLQUERY));
    jj_consume_token(LPAREN);
                        ppSet(bnf.xmlQuery(BNF.LPAREN));
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case XMLNAMESPACES:
      xmlNamespaces(info);
                                ppAppend(bnf.xmlQuery(BNF.xmlNamespaces));
      jj_consume_token(COMMA);
                                ppSet(bnf.xmlQuery(BNF.COMMA));
      break;
    default:
      jj_la1[145] = jj_gen;
      ;
    }
    stringVal();
                        ppAppend(bnf.xmlQuery(BNF.stringVal));
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case PASSING:
      jj_consume_token(PASSING);
                                ppSet(bnf.xmlQuery(BNF.PASSING));
      derivedColumn(info);
                                ppAppend(bnf.xmlQuery(BNF.derivedColumn));
      label_17:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[146] = jj_gen;
          break label_17;
        }
        jj_consume_token(COMMA);
                                        ppSet(bnf.xmlQuery(BNF.COMMA));
        derivedColumn(info);
                                        ppAppend(bnf.xmlQuery(BNF.derivedColumn));
      }
      break;
    default:
      jj_la1[147] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NULL:
    case EMPTY:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case NULL:
        jj_consume_token(NULL);
                                        ppSet(bnf.xmlQuery(BNF.NULL));
        break;
      case EMPTY:
        jj_consume_token(EMPTY);
                                        ppSet(bnf.xmlQuery(BNF.EMPTY));
        break;
      default:
        jj_la1[148] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      jj_consume_token(ON);
                                ppSet(bnf.xmlQuery(BNF.ON));
      jj_consume_token(EMPTY);
                                ppSet(bnf.xmlQuery(BNF.ON, BNF.EMPTY));
      break;
    default:
      jj_la1[149] = jj_gen;
      ;
    }
    jj_consume_token(RPAREN);
                        ppSet((String[]) null);
  }

  final public void objectTable(ParseInfo info) throws ParseException {
    jj_consume_token(OBJECTTABLE);
                        ppSet(bnf.objectTable(BNF.OBJECTTABLE));
    jj_consume_token(LPAREN);
                        ppSet(bnf.objectTable(BNF.LPAREN));
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LANGUAGE:
      jj_consume_token(LANGUAGE);
                                ppSet(bnf.objectTable(BNF.LANGUAGE));
      stringVal();
                                ppAppend(bnf.objectTable(BNF.LANGUAGE, BNF.stringVal));
      break;
    default:
      jj_la1[150] = jj_gen;
      ;
    }
    stringVal();
                        ppAppend(bnf.objectTable(BNF.stringVal));
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case PASSING:
      jj_consume_token(PASSING);
                                ppSet(bnf.objectTable(BNF.PASSING));
      derivedColumn(info);
                                ppAppend(bnf.objectTable(BNF.derivedColumn));
      label_18:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[151] = jj_gen;
          break label_18;
        }
        jj_consume_token(COMMA);
                                        ppSet(bnf.objectTable(BNF.derivedColumn, BNF.COMMA));
        derivedColumn(info);
                                        ppAppend(bnf.objectTable(BNF.derivedColumn));
      }
      break;
    default:
      jj_la1[152] = jj_gen;
      ;
    }
    jj_consume_token(COLUMNS);
                        ppSet(bnf.objectTable(BNF.COLUMNS));
    objectColumn(info);
                        ppAppend(bnf.objectTable(BNF.objectColumn));
    label_19:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[153] = jj_gen;
        break label_19;
      }
      jj_consume_token(COMMA);
                                ppSet(bnf.objectTable(BNF.objectColumn, BNF.COMMA));
      objectColumn(info);
                                ppAppend(bnf.objectTable(BNF.objectColumn));
    }
    jj_consume_token(RPAREN);
                        ppSet(bnf.objectTable(BNF.RPAREN));
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case AS:
      jj_consume_token(AS);
                                ppSet(bnf.objectTable(BNF.AS));
      break;
    default:
      jj_la1[154] = jj_gen;
      ;
    }
    id();
  }

  final public void objectColumn(ParseInfo info) throws ParseException {
    id();
                        ppSet(bnf.objectColumn(BNF.id));
    parseDataType();
                        ppSet(bnf.objectColumn(BNF.parseDataType));
    stringVal();
                        ppSet(bnf.objectColumn(BNF.stringVal));
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DEFAULT_KEYWORD:
      jj_consume_token(DEFAULT_KEYWORD);
                                ppSet(bnf.objectColumn(BNF.DEFAULT_KEYWORD));
      expression(info);
                                ppAppend(bnf.objectColumn(BNF.expression));
      break;
    default:
      jj_la1[155] = jj_gen;
      ;
    }
  }

  final public void xmlTable(ParseInfo info) throws ParseException {
    jj_consume_token(XMLTABLE);
                        ppSet(bnf.xmlTable(BNF.XMLTABLE));
    jj_consume_token(LPAREN);
                        ppSet(bnf.xmlTable(BNF.LPAREN));
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case XMLNAMESPACES:
      xmlNamespaces(info);
                                ppAppend(bnf.xmlTable(BNF.xmlNamespaces));
      jj_consume_token(COMMA);
                                ppSet(bnf.xmlTable(BNF.xmlNamespaces, BNF.COMMA));
      break;
    default:
      jj_la1[156] = jj_gen;
      ;
    }
    stringVal();
                        ppSet(bnf.xmlTable(BNF.stringVal));
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case PASSING:
      jj_consume_token(PASSING);
                                ppSet(bnf.xmlTable(BNF.PASSING));
      derivedColumn(info);
                                ppAppend(bnf.xmlTable(BNF.derivedColumn));
      label_20:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[157] = jj_gen;
          break label_20;
        }
        jj_consume_token(COMMA);
                                        ppSet(bnf.xmlTable(BNF.COMMA));
        derivedColumn(info);
                                        ppAppend(bnf.xmlTable(BNF.derivedColumn));
      }
      break;
    default:
      jj_la1[158] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case COLUMNS:
      jj_consume_token(COLUMNS);
                                ppSet(bnf.xmlTable(BNF.COLUMNS));
      xmlColumn(info);
                                ppAppend(bnf.xmlTable(BNF.xmlColumn));
      label_21:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[159] = jj_gen;
          break label_21;
        }
        jj_consume_token(COMMA);
                                        ppSet(bnf.xmlTable(BNF.xmlColumn, BNF.COMMA));
        xmlColumn(info);
                                        ppAppend(bnf.xmlTable(BNF.xmlColumn));
      }
      break;
    default:
      jj_la1[160] = jj_gen;
      ;
    }
    jj_consume_token(RPAREN);
                        ppSet(bnf.xmlTable(BNF.RPAREN));
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case AS:
      jj_consume_token(AS);
                                ppSet(bnf.xmlTable(BNF.AS));
      break;
    default:
      jj_la1[161] = jj_gen;
      ;
    }
    id();
  }

  final public void xmlColumn(ParseInfo info) throws ParseException {
    id();
                        ppSet(bnf.xmlColumn(BNF.id));
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case FOR:
      jj_consume_token(FOR);
                                        ppSet(bnf.xmlColumn(BNF.FOR));
      jj_consume_token(ORDINALITY);
                                        ppSet((String[]) null);
      break;
    case STRING:
    case VARBINARY:
    case VARCHAR:
    case BOOLEAN:
    case BYTE:
    case TINYINT:
    case SHORT:
    case SMALLINT:
    case CHAR:
    case INTEGER:
    case LONG:
    case BIGINT:
    case BIGINTEGER:
    case FLOAT:
    case REAL:
    case DOUBLE:
    case BIGDECIMAL:
    case DECIMAL:
    case DATE:
    case TIME:
    case TIMESTAMP:
    case OBJECT:
    case BLOB:
    case CLOB:
    case XML:
      parseDataType();
                                        ppSet(bnf.xmlColumn(BNF.parseDataType));
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case DEFAULT_KEYWORD:
        jj_consume_token(DEFAULT_KEYWORD);
                                                ppSet(bnf.xmlColumn(BNF.DEFAULT_KEYWORD));
        expression(info);
                                                ppAppend(bnf.xmlColumn(BNF.expression));
        break;
      default:
        jj_la1[162] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PATH:
        jj_consume_token(PATH);
                                                ppSet(bnf.xmlColumn(BNF.PATH));
        stringVal();
        break;
      default:
        jj_la1[163] = jj_gen;
        ;
      }
      break;
    default:
      jj_la1[164] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void intVal() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case PLUS:
    case MINUS:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PLUS:
        jj_consume_token(PLUS);
                                        ppSet(bnf.intVal(BNF.PLUS));
        break;
      case MINUS:
        jj_consume_token(MINUS);
                                        ppSet(bnf.intVal(BNF.MINUS));
        break;
      default:
        jj_la1[165] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[166] = jj_gen;
      ;
    }
    jj_consume_token(UNSIGNEDINTEGER);
  }

  final public void subqueryFromClause(ParseInfo info) throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TABLE:
    case LATERAL:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case TABLE:
        jj_consume_token(TABLE);
                                        ppSet(bnf.subqueryFromClause(BNF.TABLE));
        break;
      case LATERAL:
        jj_consume_token(LATERAL);
                                        ppSet(bnf.subqueryFromClause(BNF.LATERAL));
        break;
      default:
        jj_la1[167] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[168] = jj_gen;
      ;
    }
    jj_consume_token(LPAREN);
                        ppSet(bnf.subqueryFromClause(BNF.LPAREN));
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SELECT:
    case TABLE:
    case VALUES:
    case WITH:
    case LPAREN:
      queryExpression(info);
                                ppAppend(bnf.subqueryFromClause(BNF.queryExpression));
      break;
    case CALL:
    case EXEC:
    case EXECUTE:
      storedProcedure(info);
                                ppAppend(bnf.subqueryFromClause(BNF.storedProcedure));
      break;
    default:
      jj_la1[169] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(RPAREN);
                        ppSet(bnf.subqueryFromClause(BNF.RPAREN));
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case AS:
      jj_consume_token(AS);
                                ppSet(bnf.subqueryFromClause(BNF.AS));
      break;
    default:
      jj_la1[170] = jj_gen;
      ;
    }
    id();
  }

  final public void unaryFromClause(ParseInfo info) throws ParseException {
    id();
                                ppAppend(bnf.unaryFromClause(BNF.id));
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case AS:
    case INSTEAD:
    case ENABLED:
    case DISABLED:
    case VIEW:
    case KEY:
    case SERIAL:
    case TEXTAGG:
    case COUNT:
    case ROW_NUMBER:
    case RANK:
    case DENSE_RANK:
    case SUM:
    case AVG:
    case MIN:
    case MAX:
    case EVERY:
    case STDDEV_POP:
    case STDDEV_SAMP:
    case VAR_SAMP:
    case VAR_POP:
    case DOCUMENT:
    case CONTENT:
    case TRIM:
    case EMPTY:
    case ORDINALITY:
    case PATH:
    case FIRST:
    case LAST:
    case NEXT:
    case SUBSTRING:
    case EXTRACT:
    case TO_CHARS:
    case TO_BYTES:
    case TIMESTAMPADD:
    case TIMESTAMPDIFF:
    case QUERYSTRING:
    case NAMESPACE:
    case RESULT:
    case INDEX:
    case ACCESSPATTERN:
    case AUTO_INCREMENT:
    case WELLFORMED:
    case SQL_TSI_FRAC_SECOND:
    case SQL_TSI_SECOND:
    case SQL_TSI_MINUTE:
    case SQL_TSI_HOUR:
    case SQL_TSI_DAY:
    case SQL_TSI_WEEK:
    case SQL_TSI_MONTH:
    case SQL_TSI_QUARTER:
    case SQL_TSI_YEAR:
    case TEXTTABLE:
    case ARRAYTABLE:
    case SELECTOR:
    case SKIP_KEYWORD:
    case WIDTH:
    case PASSING:
    case NAME:
    case ENCODING:
    case COLUMNS:
    case DELIMITER:
    case QUOTE:
    case HEADER:
    case NULLS:
    case OBJECTTABLE:
    case VERSION:
    case INCLUDING:
    case EXCLUDING:
    case XMLDECLARATION:
    case VARIADIC:
    case EXCEPTION:
    case RAISE:
    case CHAIN:
    case JSONARRAY_AGG:
    case JSONOBJECT:
    case ID:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case AS:
        jj_consume_token(AS);
                                                ppSet(bnf.unaryFromClause(BNF.AS));
        break;
      default:
        jj_la1[171] = jj_gen;
        ;
      }
      id();
      break;
    default:
      jj_la1[172] = jj_gen;
      ;
    }
  }

  final public void where(ParseInfo info) throws ParseException {
    jj_consume_token(WHERE);
                        ppSet(bnf.where(BNF.WHERE));
    criteria(info);
  }

  final public void criteria(ParseInfo info) throws ParseException {
    compoundCritOr(info);
  }

  final public void compoundCritOr(ParseInfo info) throws ParseException {
    compoundCritAnd(info);
                        ppAppend(bnf.compoundCritOr(BNF.compoundCritAnd));
    label_22:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case OR:
        ;
        break;
      default:
        jj_la1[173] = jj_gen;
        break label_22;
      }
      jj_consume_token(OR);
                                ppSet(bnf.compoundCritOr(BNF.OR));
      compoundCritAnd(info);
                                ppAppend(bnf.compoundCritOr(BNF.compoundCritAnd));
    }
  }

  final public void compoundCritAnd(ParseInfo info) throws ParseException {
    notCrit(info);
                        ppAppend(bnf.compoundCritAnd(BNF.notCrit));
    label_23:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case AND:
        ;
        break;
      default:
        jj_la1[174] = jj_gen;
        break label_23;
      }
      jj_consume_token(AND);
                                ppSet(bnf.compoundCritAnd(BNF.AND));
      notCrit(info);
                                ppAppend(bnf.compoundCritAnd(BNF.notCrit));
    }
  }

  final public void notCrit(ParseInfo info) throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NOT:
      jj_consume_token(NOT);
                                ppSet(bnf.notCrit(BNF.NOT));
      break;
    default:
      jj_la1[175] = jj_gen;
      ;
    }
    booleanPrimary(info);
  }

  final public void booleanPrimary(ParseInfo info) throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CHAR:
    case CAST:
    case CONVERT:
    case ANY:
    case CASE:
    case FALSE:
    case HOUR:
    case INSERT:
    case LEFT:
    case MINUTE:
    case MONTH:
    case NULL:
    case RIGHT:
    case SECOND:
    case SOME:
    case TRANSLATE:
    case TRUE:
    case UNKNOWN:
    case USER:
    case YEAR:
    case XMLAGG:
    case XMLCONCAT:
    case XMLCOMMENT:
    case XMLELEMENT:
    case XMLFOREST:
    case XMLPARSE:
    case XMLPI:
    case XMLQUERY:
    case XMLSERIALIZE:
    case INSTEAD:
    case ENABLED:
    case DISABLED:
    case VIEW:
    case KEY:
    case SERIAL:
    case TEXTAGG:
    case COUNT:
    case ROW_NUMBER:
    case RANK:
    case DENSE_RANK:
    case SUM:
    case AVG:
    case MIN:
    case MAX:
    case EVERY:
    case STDDEV_POP:
    case STDDEV_SAMP:
    case VAR_SAMP:
    case VAR_POP:
    case DOCUMENT:
    case CONTENT:
    case TRIM:
    case EMPTY:
    case ORDINALITY:
    case PATH:
    case FIRST:
    case LAST:
    case NEXT:
    case SUBSTRING:
    case EXTRACT:
    case TO_CHARS:
    case TO_BYTES:
    case TIMESTAMPADD:
    case TIMESTAMPDIFF:
    case QUERYSTRING:
    case NAMESPACE:
    case RESULT:
    case INDEX:
    case ACCESSPATTERN:
    case AUTO_INCREMENT:
    case WELLFORMED:
    case SQL_TSI_FRAC_SECOND:
    case SQL_TSI_SECOND:
    case SQL_TSI_MINUTE:
    case SQL_TSI_HOUR:
    case SQL_TSI_DAY:
    case SQL_TSI_WEEK:
    case SQL_TSI_MONTH:
    case SQL_TSI_QUARTER:
    case SQL_TSI_YEAR:
    case TEXTTABLE:
    case ARRAYTABLE:
    case SELECTOR:
    case SKIP_KEYWORD:
    case WIDTH:
    case PASSING:
    case NAME:
    case ENCODING:
    case COLUMNS:
    case DELIMITER:
    case QUOTE:
    case HEADER:
    case NULLS:
    case OBJECTTABLE:
    case VERSION:
    case INCLUDING:
    case EXCLUDING:
    case XMLDECLARATION:
    case VARIADIC:
    case EXCEPTION:
    case RAISE:
    case CHAIN:
    case JSONARRAY_AGG:
    case JSONOBJECT:
    case ID:
    case ESCAPEDFUNCTION:
    case ESCAPEDTYPE:
    case DECIMALVAL:
    case FLOATVAL:
    case STRINGVAL:
    case UNSIGNEDINTEGER:
    case BINARYSTRINGVAL:
    case LPAREN:
    case PLUS:
    case MINUS:
    case QMARK:
    case DOLLAR:
      commonValueExpression(info);
                                        ppAppend(bnf.booleanPrimary(BNF.commonValueExpression));
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case BETWEEN:
      case IN:
      case IS:
      case LIKE:
      case LIKE_REGEX:
      case NOT:
      case SIMILAR:
      case EQ:
      case NE:
      case NE2:
      case LT:
      case LE:
      case GT:
      case GE:
        if (jj_2_21(2)) {
          betweenCrit(info);
        } else if (jj_2_22(2)) {
          matchCrit(info);
        } else if (jj_2_23(2)) {
          regexMatchCrit(info);
        } else {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case IN:
          case NOT:
            setCrit(info);
            break;
          case IS:
            isNullCrit(info);
            break;
          default:
            jj_la1[176] = jj_gen;
            if (jj_2_24(2147483647)) {
              subqueryCompareCriteria(info);
            } else {
              switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
              case EQ:
              case NE:
              case NE2:
              case LT:
              case LE:
              case GT:
              case GE:
                compareCrit(info);
                break;
              default:
                jj_la1[177] = jj_gen;
                jj_consume_token(-1);
                throw new ParseException();
              }
            }
          }
        }
        break;
      default:
        jj_la1[178] = jj_gen;
        ;
      }
      break;
    case EXISTS:
      existsCriteria(info);
      break;
    default:
      jj_la1[179] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void operator() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case EQ:
      jj_consume_token(EQ);
      break;
    case NE:
      jj_consume_token(NE);
      break;
    case NE2:
      jj_consume_token(NE2);
      break;
    case LT:
      jj_consume_token(LT);
      break;
    case LE:
      jj_consume_token(LE);
      break;
    case GT:
      jj_consume_token(GT);
      break;
    case GE:
      jj_consume_token(GE);
      break;
    default:
      jj_la1[180] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
                        ppSet((String[]) null);
  }

  final public void compareCrit(ParseInfo info) throws ParseException {
    operator();
                        ppAppend(bnf.compareCrit(BNF.operator));
    commonValueExpression(info);
  }

  final public void subquery(ParseInfo info) throws ParseException {
    jj_consume_token(LPAREN);
                        ppSet(bnf.subquery(BNF.LPAREN));
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SELECT:
    case TABLE:
    case VALUES:
    case WITH:
    case LPAREN:
      queryExpression(info);
                                ppAppend(bnf.subquery(BNF.queryExpression));
      break;
    case CALL:
    case EXEC:
    case EXECUTE:
      storedProcedure(info);
                                        ppAppend(bnf.subquery(BNF.storedProcedure));
      break;
    default:
      jj_la1[181] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(RPAREN);
                        ppSet((String[]) null);
  }

  final public void subqueryCompareCriteria(ParseInfo info) throws ParseException {
    operator();
                        ppAppend(bnf.subqueryCompareCriteria(BNF.operator));
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ANY:
      jj_consume_token(ANY);
                                ppSet(bnf.subqueryCompareCriteria(BNF.ANY));
      break;
    case SOME:
      jj_consume_token(SOME);
                                ppSet(bnf.subqueryCompareCriteria(BNF.SOME));
      break;
    case ALL:
      jj_consume_token(ALL);
                                ppSet(bnf.subqueryCompareCriteria(BNF.ALL));
      break;
    default:
      jj_la1[182] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    subquery(info);
  }

  final public void matchCrit(ParseInfo info) throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NOT:
      jj_consume_token(NOT);
                                ppSet(bnf.matchCrit(BNF.NOT));
      break;
    default:
      jj_la1[183] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LIKE:
      jj_consume_token(LIKE);
                                ppSet(bnf.matchCrit(BNF.LIKE));
      break;
    case SIMILAR:
      jj_consume_token(SIMILAR);
                                        ppSet(bnf.matchCrit(BNF.SIMILAR));
      jj_consume_token(TO);
                                        ppSet(bnf.matchCrit(BNF.TO));
      break;
    default:
      jj_la1[184] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    commonValueExpression(info);
                        ppAppend(bnf.matchCrit(BNF.commonValueExpression));
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ESCAPE:
    case LBRACE:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ESCAPE:
        jj_consume_token(ESCAPE);
                                ppSet(bnf.matchCrit(BNF.ESCAPE));
        charVal(info, "LIKE/SIMILAR TO ESCAPE");
        break;
      case LBRACE:
        jj_consume_token(LBRACE);
                                        ppSet(bnf.matchCrit(BNF.LBRACE));
        jj_consume_token(ESCAPE);
                                        ppSet(bnf.matchCrit(BNF.ESCAPE));
        charVal(info, "LIKE/SIMILAR TO ESCAPE");
                                        ppAppend(bnf.matchCrit(BNF.charVal));
        jj_consume_token(RBRACE);
                                        ppSet((String[]) null);
        break;
      default:
        jj_la1[185] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[186] = jj_gen;
      ;
    }
  }

  final public void regexMatchCrit(ParseInfo info) throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NOT:
      jj_consume_token(NOT);
                                ppSet(bnf.regexMatchCrit(BNF.NOT));
      break;
    default:
      jj_la1[187] = jj_gen;
      ;
    }
    jj_consume_token(LIKE_REGEX);
                        ppSet(bnf.regexMatchCrit(BNF.LIKE_REGEX));
    commonValueExpression(info);
  }

  final public void charVal(ParseInfo info, String type) throws ParseException {
    stringVal();
  }

  final public void betweenCrit(ParseInfo info) throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NOT:
      jj_consume_token(NOT);
                                ppSet(bnf.betweenCrit(BNF.NOT));
      break;
    default:
      jj_la1[188] = jj_gen;
      ;
    }
    jj_consume_token(BETWEEN);
                        ppSet(bnf.betweenCrit(BNF.BETWEEN));
    commonValueExpression(info);
                        ppAppend(bnf.betweenCrit(BNF.commonValueExpression));
    jj_consume_token(AND);
                        ppSet(bnf.betweenCrit(BNF.AND));
    commonValueExpression(info);
  }

  final public void isNullCrit(ParseInfo info) throws ParseException {
    jj_consume_token(IS);
                        ppSet(bnf.isNullCrit(BNF.IS));
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NOT:
      jj_consume_token(NOT);
                                ppSet(bnf.isNullCrit(BNF.NOT));
      break;
    default:
      jj_la1[189] = jj_gen;
      ;
    }
    jj_consume_token(NULL);
                        ppSet((String[]) null);
  }

  final public void setCrit(ParseInfo info) throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NOT:
      jj_consume_token(NOT);
                                ppSet(bnf.setCrit(BNF.NOT));
      break;
    default:
      jj_la1[190] = jj_gen;
      ;
    }
    jj_consume_token(IN);
                        ppSet(bnf.setCrit(BNF.IN));
    if (jj_2_25(2147483647)) {
      subquery(info);
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LPAREN:
        jj_consume_token(LPAREN);
                                        ppSet(bnf.setCrit(BNF.LPAREN));
        commonValueExpression(info);
                                        ppAppend(bnf.setCrit(BNF.commonValueExpression));
        label_24:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case COMMA:
            ;
            break;
          default:
            jj_la1[191] = jj_gen;
            break label_24;
          }
          jj_consume_token(COMMA);
                                                ppSet(bnf.setCrit(BNF.COMMA));
          commonValueExpression(info);
                                                ppAppend(bnf.setCrit(BNF.commonValueExpression));
        }
        jj_consume_token(RPAREN);
                                        ppSet((String[]) null);
        break;
      default:
        jj_la1[192] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

  final public void existsCriteria(ParseInfo info) throws ParseException {
    jj_consume_token(EXISTS);
                        ppSet(bnf.existsCriteria(BNF.EXISTS));
    subquery(info);
  }

  final public void groupBy(ParseInfo info) throws ParseException {
    jj_consume_token(GROUP);
                        ppSet(bnf.groupBy(BNF.GROUP));
    jj_consume_token(BY);
                        ppSet(bnf.groupBy(BNF.BY));
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ROLLUP:
      jj_consume_token(ROLLUP);
                                ppSet(bnf.groupBy(BNF.ROLLUP));
                                requiresVersionAtLeast(Version.TEIID_8_5);
      jj_consume_token(LPAREN);
                                ppSet(bnf.groupBy(BNF.LPAREN));
      expressionList(info);
                                ppAppend(bnf.groupBy(BNF.expressionList));
      jj_consume_token(RPAREN);
                                ppSet(bnf.groupBy(BNF.RPAREN));
      break;
    case CHAR:
    case CAST:
    case CONVERT:
    case ANY:
    case CASE:
    case EXISTS:
    case FALSE:
    case HOUR:
    case INSERT:
    case LEFT:
    case MINUTE:
    case MONTH:
    case NOT:
    case NULL:
    case RIGHT:
    case SECOND:
    case SOME:
    case TRANSLATE:
    case TRUE:
    case UNKNOWN:
    case USER:
    case YEAR:
    case XMLAGG:
    case XMLCONCAT:
    case XMLCOMMENT:
    case XMLELEMENT:
    case XMLFOREST:
    case XMLPARSE:
    case XMLPI:
    case XMLQUERY:
    case XMLSERIALIZE:
    case INSTEAD:
    case ENABLED:
    case DISABLED:
    case VIEW:
    case KEY:
    case SERIAL:
    case TEXTAGG:
    case COUNT:
    case ROW_NUMBER:
    case RANK:
    case DENSE_RANK:
    case SUM:
    case AVG:
    case MIN:
    case MAX:
    case EVERY:
    case STDDEV_POP:
    case STDDEV_SAMP:
    case VAR_SAMP:
    case VAR_POP:
    case DOCUMENT:
    case CONTENT:
    case TRIM:
    case EMPTY:
    case ORDINALITY:
    case PATH:
    case FIRST:
    case LAST:
    case NEXT:
    case SUBSTRING:
    case EXTRACT:
    case TO_CHARS:
    case TO_BYTES:
    case TIMESTAMPADD:
    case TIMESTAMPDIFF:
    case QUERYSTRING:
    case NAMESPACE:
    case RESULT:
    case INDEX:
    case ACCESSPATTERN:
    case AUTO_INCREMENT:
    case WELLFORMED:
    case SQL_TSI_FRAC_SECOND:
    case SQL_TSI_SECOND:
    case SQL_TSI_MINUTE:
    case SQL_TSI_HOUR:
    case SQL_TSI_DAY:
    case SQL_TSI_WEEK:
    case SQL_TSI_MONTH:
    case SQL_TSI_QUARTER:
    case SQL_TSI_YEAR:
    case TEXTTABLE:
    case ARRAYTABLE:
    case SELECTOR:
    case SKIP_KEYWORD:
    case WIDTH:
    case PASSING:
    case NAME:
    case ENCODING:
    case COLUMNS:
    case DELIMITER:
    case QUOTE:
    case HEADER:
    case NULLS:
    case OBJECTTABLE:
    case VERSION:
    case INCLUDING:
    case EXCLUDING:
    case XMLDECLARATION:
    case VARIADIC:
    case EXCEPTION:
    case RAISE:
    case CHAIN:
    case JSONARRAY_AGG:
    case JSONOBJECT:
    case ID:
    case ESCAPEDFUNCTION:
    case ESCAPEDTYPE:
    case DECIMALVAL:
    case FLOATVAL:
    case STRINGVAL:
    case UNSIGNEDINTEGER:
    case BINARYSTRINGVAL:
    case LPAREN:
    case PLUS:
    case MINUS:
    case QMARK:
    case DOLLAR:
      expressionList(info);
      break;
    default:
      jj_la1[193] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void having(ParseInfo info) throws ParseException {
    jj_consume_token(HAVING);
                        ppSet(bnf.having(BNF.HAVING));
    criteria(info);
                        ppAppend(bnf.having(BNF.criteria));
  }

  final public void orderby(ParseInfo info) throws ParseException {
    jj_consume_token(ORDER);
                        ppSet(bnf.orderby(BNF.ORDER));
    jj_consume_token(BY);
                        ppSet(bnf.orderby(BNF.BY));
    sortSpecification(info);
                        ppAppend(bnf.orderby(BNF.sortSpecification));
    label_25:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[194] = jj_gen;
        break label_25;
      }
      jj_consume_token(COMMA);
                                ppSet(bnf.orderby(BNF.COMMA));
      sortSpecification(info);
                                ppAppend(bnf.orderby(BNF.sortSpecification));
    }
  }

  final public void sortSpecification(ParseInfo info) throws ParseException {
    sortKey(info);
                        ppAppend(bnf.sortSpecification(BNF.sortKey));
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ASC:
    case DESC:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ASC:
        jj_consume_token(ASC);
                                ppSet(bnf.sortSpecification(BNF.ASC));
        break;
      case DESC:
        jj_consume_token(DESC);
                                ppSet(bnf.sortSpecification(BNF.DESC));
        break;
      default:
        jj_la1[195] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[196] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NULLS:
      jj_consume_token(NULLS);
                                ppSet(bnf.sortSpecification(BNF.NULLS));
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case FIRST:
        jj_consume_token(FIRST);
                                        ppSet((String[]) null);
        break;
      case LAST:
        jj_consume_token(LAST);
                                        ppSet((String[]) null);
        break;
      default:
        jj_la1[197] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[198] = jj_gen;
      ;
    }
  }

  final public void sortKey(ParseInfo info) throws ParseException {
    expression(info);
  }

  final public void intParam(ParseInfo info) throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case UNSIGNEDINTEGER:
    case PLUS:
    case MINUS:
      intVal();
      break;
    case CHAR:
    case CAST:
    case CONVERT:
    case ANY:
    case CASE:
    case HOUR:
    case INSERT:
    case LEFT:
    case MINUTE:
    case MONTH:
    case RIGHT:
    case SECOND:
    case SOME:
    case TRANSLATE:
    case USER:
    case YEAR:
    case XMLAGG:
    case XMLCONCAT:
    case XMLCOMMENT:
    case XMLELEMENT:
    case XMLFOREST:
    case XMLPARSE:
    case XMLPI:
    case XMLQUERY:
    case XMLSERIALIZE:
    case INSTEAD:
    case ENABLED:
    case DISABLED:
    case VIEW:
    case KEY:
    case SERIAL:
    case TEXTAGG:
    case COUNT:
    case ROW_NUMBER:
    case RANK:
    case DENSE_RANK:
    case SUM:
    case AVG:
    case MIN:
    case MAX:
    case EVERY:
    case STDDEV_POP:
    case STDDEV_SAMP:
    case VAR_SAMP:
    case VAR_POP:
    case DOCUMENT:
    case CONTENT:
    case TRIM:
    case EMPTY:
    case ORDINALITY:
    case PATH:
    case FIRST:
    case LAST:
    case NEXT:
    case SUBSTRING:
    case EXTRACT:
    case TO_CHARS:
    case TO_BYTES:
    case TIMESTAMPADD:
    case TIMESTAMPDIFF:
    case QUERYSTRING:
    case NAMESPACE:
    case RESULT:
    case INDEX:
    case ACCESSPATTERN:
    case AUTO_INCREMENT:
    case WELLFORMED:
    case SQL_TSI_FRAC_SECOND:
    case SQL_TSI_SECOND:
    case SQL_TSI_MINUTE:
    case SQL_TSI_HOUR:
    case SQL_TSI_DAY:
    case SQL_TSI_WEEK:
    case SQL_TSI_MONTH:
    case SQL_TSI_QUARTER:
    case SQL_TSI_YEAR:
    case TEXTTABLE:
    case ARRAYTABLE:
    case SELECTOR:
    case SKIP_KEYWORD:
    case WIDTH:
    case PASSING:
    case NAME:
    case ENCODING:
    case COLUMNS:
    case DELIMITER:
    case QUOTE:
    case HEADER:
    case NULLS:
    case OBJECTTABLE:
    case VERSION:
    case INCLUDING:
    case EXCLUDING:
    case XMLDECLARATION:
    case VARIADIC:
    case EXCEPTION:
    case RAISE:
    case CHAIN:
    case JSONARRAY_AGG:
    case JSONOBJECT:
    case ID:
    case ESCAPEDFUNCTION:
    case LPAREN:
    case QMARK:
    case DOLLAR:
      unsignedValueExpressionPrimary(info);
      break;
    default:
      jj_la1[199] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void limit(ParseInfo info) throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LIMIT:
      jj_consume_token(LIMIT);
                                        ppSet(bnf.limit(BNF.LIMIT));
      intParam(info);
                                        ppAppend(bnf.limit(BNF.LIMIT, BNF.intParam));
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        jj_consume_token(COMMA);
                                                ppSet(bnf.limit(BNF.COMMA));
        intParam(info);
                                                ppSet((String[]) null);
        break;
      default:
        jj_la1[200] = jj_gen;
        ;
      }
      break;
    case OFFSET:
      jj_consume_token(OFFSET);
                                        ppSet(bnf.limit(BNF.OFFSET));
      intParam(info);
                                        ppAppend(bnf.limit(BNF.OFFSET, BNF.intParam));
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ROW:
        jj_consume_token(ROW);
                                                ppSet(bnf.limit(BNF.ROW));
        break;
      case ROWS:
        jj_consume_token(ROWS);
                                                ppSet(bnf.limit(BNF.ROWS));
        break;
      default:
        jj_la1[201] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case FETCH:
        fetchLimit(info);
                                                ppSet((String[]) null);
        break;
      default:
        jj_la1[202] = jj_gen;
        ;
      }
      break;
    case FETCH:
      fetchLimit(info);
                                        ppSet((String[]) null);
      break;
    default:
      jj_la1[203] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void fetchLimit(ParseInfo info) throws ParseException {
    jj_consume_token(FETCH);
                        ppSet(bnf.fetchLimit(BNF.FETCH));
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case FIRST:
      jj_consume_token(FIRST);
                                ppSet(bnf.fetchLimit(BNF.FIRST));
      break;
    case NEXT:
      jj_consume_token(NEXT);
                                ppSet(bnf.fetchLimit(BNF.NEXT));
      break;
    default:
      jj_la1[204] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CHAR:
    case CAST:
    case CONVERT:
    case ANY:
    case CASE:
    case HOUR:
    case INSERT:
    case LEFT:
    case MINUTE:
    case MONTH:
    case RIGHT:
    case SECOND:
    case SOME:
    case TRANSLATE:
    case USER:
    case YEAR:
    case XMLAGG:
    case XMLCONCAT:
    case XMLCOMMENT:
    case XMLELEMENT:
    case XMLFOREST:
    case XMLPARSE:
    case XMLPI:
    case XMLQUERY:
    case XMLSERIALIZE:
    case INSTEAD:
    case ENABLED:
    case DISABLED:
    case VIEW:
    case KEY:
    case SERIAL:
    case TEXTAGG:
    case COUNT:
    case ROW_NUMBER:
    case RANK:
    case DENSE_RANK:
    case SUM:
    case AVG:
    case MIN:
    case MAX:
    case EVERY:
    case STDDEV_POP:
    case STDDEV_SAMP:
    case VAR_SAMP:
    case VAR_POP:
    case DOCUMENT:
    case CONTENT:
    case TRIM:
    case EMPTY:
    case ORDINALITY:
    case PATH:
    case FIRST:
    case LAST:
    case NEXT:
    case SUBSTRING:
    case EXTRACT:
    case TO_CHARS:
    case TO_BYTES:
    case TIMESTAMPADD:
    case TIMESTAMPDIFF:
    case QUERYSTRING:
    case NAMESPACE:
    case RESULT:
    case INDEX:
    case ACCESSPATTERN:
    case AUTO_INCREMENT:
    case WELLFORMED:
    case SQL_TSI_FRAC_SECOND:
    case SQL_TSI_SECOND:
    case SQL_TSI_MINUTE:
    case SQL_TSI_HOUR:
    case SQL_TSI_DAY:
    case SQL_TSI_WEEK:
    case SQL_TSI_MONTH:
    case SQL_TSI_QUARTER:
    case SQL_TSI_YEAR:
    case TEXTTABLE:
    case ARRAYTABLE:
    case SELECTOR:
    case SKIP_KEYWORD:
    case WIDTH:
    case PASSING:
    case NAME:
    case ENCODING:
    case COLUMNS:
    case DELIMITER:
    case QUOTE:
    case HEADER:
    case NULLS:
    case OBJECTTABLE:
    case VERSION:
    case INCLUDING:
    case EXCLUDING:
    case XMLDECLARATION:
    case VARIADIC:
    case EXCEPTION:
    case RAISE:
    case CHAIN:
    case JSONARRAY_AGG:
    case JSONOBJECT:
    case ID:
    case ESCAPEDFUNCTION:
    case UNSIGNEDINTEGER:
    case LPAREN:
    case PLUS:
    case MINUS:
    case QMARK:
    case DOLLAR:
      intParam(info);
                                ppAppend(bnf.fetchLimit(BNF.intParam));
      break;
    default:
      jj_la1[205] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ROW:
      jj_consume_token(ROW);
                                ppSet(bnf.fetchLimit(BNF.ROW));
      break;
    case ROWS:
      jj_consume_token(ROWS);
                                ppSet(bnf.fetchLimit(BNF.ROWS));
      break;
    default:
      jj_la1[206] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(ONLY);
                        ppSet((String[]) null);
  }

  final public void option(ParseInfo info) throws ParseException {
    jj_consume_token(OPTION);
                        ppSet(bnf.option(BNF.OPTION));
    label_26:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case MAKEDEP:
      case MAKENOTDEP:
      case NOCACHE:
        ;
        break;
      default:
        jj_la1[207] = jj_gen;
        break label_26;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case MAKEDEP:
        jj_consume_token(MAKEDEP);
                                ppSet(bnf.option(BNF.MAKEDEP));
        id();
                                ppAppend(bnf.option(BNF.MAKEDEP, BNF.id));
        label_27:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case COMMA:
            ;
            break;
          default:
            jj_la1[208] = jj_gen;
            break label_27;
          }
          jj_consume_token(COMMA);
                                        ppSet(bnf.option(BNF.MAKEDEP, BNF.COMMA));
          id();
                                        ppAppend(bnf.option(BNF.MAKEDEP, BNF.COMMA, BNF.id));
        }
        break;
      case MAKENOTDEP:
        jj_consume_token(MAKENOTDEP);
                                ppSet(bnf.option(BNF.MAKENOTDEP));
        id();
                                ppAppend(bnf.option(BNF.MAKENOTDEP, BNF.id));
        label_28:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case COMMA:
            ;
            break;
          default:
            jj_la1[209] = jj_gen;
            break label_28;
          }
          jj_consume_token(COMMA);
                                        ppSet(bnf.option(BNF.MAKENOTDEP, BNF.COMMA));
          id();
                                        ppAppend(bnf.option(BNF.MAKENOTDEP, BNF.COMMA, BNF.id));
        }
        break;
      case NOCACHE:
        jj_consume_token(NOCACHE);
                                ppSet(bnf.option(BNF.NOCACHE));
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case INSTEAD:
        case ENABLED:
        case DISABLED:
        case VIEW:
        case KEY:
        case SERIAL:
        case TEXTAGG:
        case COUNT:
        case ROW_NUMBER:
        case RANK:
        case DENSE_RANK:
        case SUM:
        case AVG:
        case MIN:
        case MAX:
        case EVERY:
        case STDDEV_POP:
        case STDDEV_SAMP:
        case VAR_SAMP:
        case VAR_POP:
        case DOCUMENT:
        case CONTENT:
        case TRIM:
        case EMPTY:
        case ORDINALITY:
        case PATH:
        case FIRST:
        case LAST:
        case NEXT:
        case SUBSTRING:
        case EXTRACT:
        case TO_CHARS:
        case TO_BYTES:
        case TIMESTAMPADD:
        case TIMESTAMPDIFF:
        case QUERYSTRING:
        case NAMESPACE:
        case RESULT:
        case INDEX:
        case ACCESSPATTERN:
        case AUTO_INCREMENT:
        case WELLFORMED:
        case SQL_TSI_FRAC_SECOND:
        case SQL_TSI_SECOND:
        case SQL_TSI_MINUTE:
        case SQL_TSI_HOUR:
        case SQL_TSI_DAY:
        case SQL_TSI_WEEK:
        case SQL_TSI_MONTH:
        case SQL_TSI_QUARTER:
        case SQL_TSI_YEAR:
        case TEXTTABLE:
        case ARRAYTABLE:
        case SELECTOR:
        case SKIP_KEYWORD:
        case WIDTH:
        case PASSING:
        case NAME:
        case ENCODING:
        case COLUMNS:
        case DELIMITER:
        case QUOTE:
        case HEADER:
        case NULLS:
        case OBJECTTABLE:
        case VERSION:
        case INCLUDING:
        case EXCLUDING:
        case XMLDECLARATION:
        case VARIADIC:
        case EXCEPTION:
        case RAISE:
        case CHAIN:
        case JSONARRAY_AGG:
        case JSONOBJECT:
        case ID:
          id();
                                        ppAppend(bnf.option(BNF.NOCACHE, BNF.id));
          label_29:
          while (true) {
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case COMMA:
              ;
              break;
            default:
              jj_la1[210] = jj_gen;
              break label_29;
            }
            jj_consume_token(COMMA);
                                                ppSet(bnf.option(BNF.NOCACHE, BNF.COMMA));
            id();
                                                ppAppend(bnf.option(BNF.NOCACHE, BNF.COMMA, BNF.id));
          }
          break;
        default:
          jj_la1[211] = jj_gen;
          ;
        }
        break;
      default:
        jj_la1[212] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

  final public void expression(ParseInfo info) throws ParseException {
    criteria(info);
  }

  final public void commonValueExpression(ParseInfo info) throws ParseException {
    plusExpression(info);
                                ppAppend(bnf.commonValueExpression(BNF.plusExpression));
    label_30:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case CONCAT_OP:
        ;
        break;
      default:
        jj_la1[213] = jj_gen;
        break label_30;
      }
      jj_consume_token(CONCAT_OP);
                                        ppSet(bnf.commonValueExpression(BNF.CONCAT_OP));
      plusExpression(info);
                                        ppAppend(bnf.commonValueExpression(BNF.plusExpression));
    }
  }

  final public void plusExpression(ParseInfo info) throws ParseException {
    timesExpression(info);
                                ppAppend(bnf.plusExpression(BNF.timesExpression));
    label_31:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PLUS:
      case MINUS:
        ;
        break;
      default:
        jj_la1[214] = jj_gen;
        break label_31;
      }
      plusMinus();
                                        ppAppend(bnf.plusExpression(BNF.plusMinus));
      timesExpression(info);
                                        ppAppend(bnf.plusExpression(BNF.timesExpression));
    }
  }

  final public void plusMinus() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case PLUS:
      jj_consume_token(PLUS);
      break;
    case MINUS:
      jj_consume_token(MINUS);
      break;
    default:
      jj_la1[215] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void timesExpression(ParseInfo info) throws ParseException {
    valueExpressionPrimary(info);
                                ppAppend(bnf.timesExpression(BNF.valueExpressionPrimary));
    label_32:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case STAR:
      case SLASH:
        ;
        break;
      default:
        jj_la1[216] = jj_gen;
        break label_32;
      }
      timesOperator();
                                        ppAppend(bnf.timesExpression(BNF.timesOperator));
      valueExpressionPrimary(info);
                                        ppAppend(bnf.timesExpression(BNF.valueExpressionPrimary));
    }
  }

  final public void timesOperator() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case STAR:
      jj_consume_token(STAR);
      break;
    case SLASH:
      jj_consume_token(SLASH);
      break;
    default:
      jj_la1[217] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
                        ppSet((String[]) null);
  }

  final public void valueExpressionPrimary(ParseInfo info) throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case FALSE:
    case NULL:
    case TRUE:
    case UNKNOWN:
    case ESCAPEDTYPE:
    case STRINGVAL:
    case BINARYSTRINGVAL:
      nonNumericLiteral();
      break;
    case CHAR:
    case CAST:
    case CONVERT:
    case ANY:
    case CASE:
    case HOUR:
    case INSERT:
    case LEFT:
    case MINUTE:
    case MONTH:
    case RIGHT:
    case SECOND:
    case SOME:
    case TRANSLATE:
    case USER:
    case YEAR:
    case XMLAGG:
    case XMLCONCAT:
    case XMLCOMMENT:
    case XMLELEMENT:
    case XMLFOREST:
    case XMLPARSE:
    case XMLPI:
    case XMLQUERY:
    case XMLSERIALIZE:
    case INSTEAD:
    case ENABLED:
    case DISABLED:
    case VIEW:
    case KEY:
    case SERIAL:
    case TEXTAGG:
    case COUNT:
    case ROW_NUMBER:
    case RANK:
    case DENSE_RANK:
    case SUM:
    case AVG:
    case MIN:
    case MAX:
    case EVERY:
    case STDDEV_POP:
    case STDDEV_SAMP:
    case VAR_SAMP:
    case VAR_POP:
    case DOCUMENT:
    case CONTENT:
    case TRIM:
    case EMPTY:
    case ORDINALITY:
    case PATH:
    case FIRST:
    case LAST:
    case NEXT:
    case SUBSTRING:
    case EXTRACT:
    case TO_CHARS:
    case TO_BYTES:
    case TIMESTAMPADD:
    case TIMESTAMPDIFF:
    case QUERYSTRING:
    case NAMESPACE:
    case RESULT:
    case INDEX:
    case ACCESSPATTERN:
    case AUTO_INCREMENT:
    case WELLFORMED:
    case SQL_TSI_FRAC_SECOND:
    case SQL_TSI_SECOND:
    case SQL_TSI_MINUTE:
    case SQL_TSI_HOUR:
    case SQL_TSI_DAY:
    case SQL_TSI_WEEK:
    case SQL_TSI_MONTH:
    case SQL_TSI_QUARTER:
    case SQL_TSI_YEAR:
    case TEXTTABLE:
    case ARRAYTABLE:
    case SELECTOR:
    case SKIP_KEYWORD:
    case WIDTH:
    case PASSING:
    case NAME:
    case ENCODING:
    case COLUMNS:
    case DELIMITER:
    case QUOTE:
    case HEADER:
    case NULLS:
    case OBJECTTABLE:
    case VERSION:
    case INCLUDING:
    case EXCLUDING:
    case XMLDECLARATION:
    case VARIADIC:
    case EXCEPTION:
    case RAISE:
    case CHAIN:
    case JSONARRAY_AGG:
    case JSONOBJECT:
    case ID:
    case ESCAPEDFUNCTION:
    case DECIMALVAL:
    case FLOATVAL:
    case UNSIGNEDINTEGER:
    case LPAREN:
    case PLUS:
    case MINUS:
    case QMARK:
    case DOLLAR:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PLUS:
      case MINUS:
        plusMinus();
                                        ppAppend(bnf.valueExpressionPrimary(BNF.plusMinus));
        break;
      default:
        jj_la1[218] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case DECIMALVAL:
      case FLOATVAL:
      case UNSIGNEDINTEGER:
        unsignedNumericLiteral();
        break;
      case CHAR:
      case CAST:
      case CONVERT:
      case ANY:
      case CASE:
      case HOUR:
      case INSERT:
      case LEFT:
      case MINUTE:
      case MONTH:
      case RIGHT:
      case SECOND:
      case SOME:
      case TRANSLATE:
      case USER:
      case YEAR:
      case XMLAGG:
      case XMLCONCAT:
      case XMLCOMMENT:
      case XMLELEMENT:
      case XMLFOREST:
      case XMLPARSE:
      case XMLPI:
      case XMLQUERY:
      case XMLSERIALIZE:
      case INSTEAD:
      case ENABLED:
      case DISABLED:
      case VIEW:
      case KEY:
      case SERIAL:
      case TEXTAGG:
      case COUNT:
      case ROW_NUMBER:
      case RANK:
      case DENSE_RANK:
      case SUM:
      case AVG:
      case MIN:
      case MAX:
      case EVERY:
      case STDDEV_POP:
      case STDDEV_SAMP:
      case VAR_SAMP:
      case VAR_POP:
      case DOCUMENT:
      case CONTENT:
      case TRIM:
      case EMPTY:
      case ORDINALITY:
      case PATH:
      case FIRST:
      case LAST:
      case NEXT:
      case SUBSTRING:
      case EXTRACT:
      case TO_CHARS:
      case TO_BYTES:
      case TIMESTAMPADD:
      case TIMESTAMPDIFF:
      case QUERYSTRING:
      case NAMESPACE:
      case RESULT:
      case INDEX:
      case ACCESSPATTERN:
      case AUTO_INCREMENT:
      case WELLFORMED:
      case SQL_TSI_FRAC_SECOND:
      case SQL_TSI_SECOND:
      case SQL_TSI_MINUTE:
      case SQL_TSI_HOUR:
      case SQL_TSI_DAY:
      case SQL_TSI_WEEK:
      case SQL_TSI_MONTH:
      case SQL_TSI_QUARTER:
      case SQL_TSI_YEAR:
      case TEXTTABLE:
      case ARRAYTABLE:
      case SELECTOR:
      case SKIP_KEYWORD:
      case WIDTH:
      case PASSING:
      case NAME:
      case ENCODING:
      case COLUMNS:
      case DELIMITER:
      case QUOTE:
      case HEADER:
      case NULLS:
      case OBJECTTABLE:
      case VERSION:
      case INCLUDING:
      case EXCLUDING:
      case XMLDECLARATION:
      case VARIADIC:
      case EXCEPTION:
      case RAISE:
      case CHAIN:
      case JSONARRAY_AGG:
      case JSONOBJECT:
      case ID:
      case ESCAPEDFUNCTION:
      case LPAREN:
      case QMARK:
      case DOLLAR:
        unsignedValueExpressionPrimary(info);
                                                ppAppend(bnf.valueExpressionPrimary(BNF.unsignedValueExpressionPrimary));
        label_33:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case LSBRACE:
            ;
            break;
          default:
            jj_la1[219] = jj_gen;
            break label_33;
          }
          jj_consume_token(LSBRACE);
                                                        ppSet(bnf.valueExpressionPrimary(BNF.LSBRACE));
          plusExpression(info);
                                                        ppAppend(bnf.valueExpressionPrimary(BNF.plusExpression));
          jj_consume_token(RSBRACE);
                                                        ppSet(bnf.valueExpressionPrimary(BNF.RSBRACE));
        }
        break;
      default:
        jj_la1[220] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[221] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void parameterReference(ParseInfo info) throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case QMARK:
      jj_consume_token(QMARK);
                        ppSet((String[]) null);
      break;
    case DOLLAR:
      jj_consume_token(DOLLAR);
                                ppSet(bnf.parameterReference(BNF.DOLLAR));
      intVal();
      break;
    default:
      jj_la1[222] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void unescapedFunction(ParseInfo info) throws ParseException {
    if (jj_2_26(2)) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case TEXTAGG:
        textAgg(info);
                                                ppAppend(bnf.unescapedFunction(BNF.textAgg));
        break;
      case ANY:
      case SOME:
      case COUNT:
      case SUM:
      case AVG:
      case MIN:
      case MAX:
      case EVERY:
      case STDDEV_POP:
      case STDDEV_SAMP:
      case VAR_SAMP:
      case VAR_POP:
        aggregateSymbol(info);
                                                ppAppend(bnf.unescapedFunction(BNF.aggregateSymbol));
        break;
      case XMLAGG:
        orderedAgg(info);
                                                ppAppend(bnf.unescapedFunction(BNF.orderedAgg));
        break;
      default:
        jj_la1[223] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case FILTER:
        filterClause(info);
                                                ppAppend(bnf.unescapedFunction(BNF.filterClause));
        break;
      default:
        jj_la1[224] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case OVER:
        windowSpecification(info);
                                                ppAppend(bnf.unescapedFunction(BNF.windowSpecification));
        break;
      default:
        jj_la1[225] = jj_gen;
        ;
      }
    } else if (jj_2_27(2)) {
      analyticAggregateSymbol(info);
                                        ppAppend(bnf.unescapedFunction(BNF.analyticAggregateSymbol));
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case FILTER:
        filterClause(info);
                                                ppAppend(bnf.unescapedFunction(BNF.filterClause));
        break;
      default:
        jj_la1[226] = jj_gen;
        ;
      }
      windowSpecification(info);
                                        ppAppend(bnf.unescapedFunction(BNF.windowSpecification));
    } else if (jj_2_28(2)) {
      function(info);
                                        ppAppend(bnf.unescapedFunction(BNF.function));
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case OVER:
        windowSpecification(info);
                                                ppAppend(bnf.unescapedFunction(BNF.windowSpecification));
        break;
      default:
        jj_la1[227] = jj_gen;
        ;
      }
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void nestedExpression(ParseInfo info) throws ParseException {
    jj_consume_token(LPAREN);
                                ppSet(bnf.nestedExpression(BNF.LPAREN));
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CHAR:
    case CAST:
    case CONVERT:
    case ANY:
    case CASE:
    case EXISTS:
    case FALSE:
    case HOUR:
    case INSERT:
    case LEFT:
    case MINUTE:
    case MONTH:
    case NOT:
    case NULL:
    case RIGHT:
    case SECOND:
    case SOME:
    case TRANSLATE:
    case TRUE:
    case UNKNOWN:
    case USER:
    case YEAR:
    case XMLAGG:
    case XMLCONCAT:
    case XMLCOMMENT:
    case XMLELEMENT:
    case XMLFOREST:
    case XMLPARSE:
    case XMLPI:
    case XMLQUERY:
    case XMLSERIALIZE:
    case INSTEAD:
    case ENABLED:
    case DISABLED:
    case VIEW:
    case KEY:
    case SERIAL:
    case TEXTAGG:
    case COUNT:
    case ROW_NUMBER:
    case RANK:
    case DENSE_RANK:
    case SUM:
    case AVG:
    case MIN:
    case MAX:
    case EVERY:
    case STDDEV_POP:
    case STDDEV_SAMP:
    case VAR_SAMP:
    case VAR_POP:
    case DOCUMENT:
    case CONTENT:
    case TRIM:
    case EMPTY:
    case ORDINALITY:
    case PATH:
    case FIRST:
    case LAST:
    case NEXT:
    case SUBSTRING:
    case EXTRACT:
    case TO_CHARS:
    case TO_BYTES:
    case TIMESTAMPADD:
    case TIMESTAMPDIFF:
    case QUERYSTRING:
    case NAMESPACE:
    case RESULT:
    case INDEX:
    case ACCESSPATTERN:
    case AUTO_INCREMENT:
    case WELLFORMED:
    case SQL_TSI_FRAC_SECOND:
    case SQL_TSI_SECOND:
    case SQL_TSI_MINUTE:
    case SQL_TSI_HOUR:
    case SQL_TSI_DAY:
    case SQL_TSI_WEEK:
    case SQL_TSI_MONTH:
    case SQL_TSI_QUARTER:
    case SQL_TSI_YEAR:
    case TEXTTABLE:
    case ARRAYTABLE:
    case SELECTOR:
    case SKIP_KEYWORD:
    case WIDTH:
    case PASSING:
    case NAME:
    case ENCODING:
    case COLUMNS:
    case DELIMITER:
    case QUOTE:
    case HEADER:
    case NULLS:
    case OBJECTTABLE:
    case VERSION:
    case INCLUDING:
    case EXCLUDING:
    case XMLDECLARATION:
    case VARIADIC:
    case EXCEPTION:
    case RAISE:
    case CHAIN:
    case JSONARRAY_AGG:
    case JSONOBJECT:
    case ID:
    case ESCAPEDFUNCTION:
    case ESCAPEDTYPE:
    case DECIMALVAL:
    case FLOATVAL:
    case STRINGVAL:
    case UNSIGNEDINTEGER:
    case BINARYSTRINGVAL:
    case LPAREN:
    case PLUS:
    case MINUS:
    case QMARK:
    case DOLLAR:
      expression(info);
                                        ppAppend(bnf.nestedExpression(BNF.expression));
      label_34:
      while (true) {
        if (jj_2_29(2)) {
          ;
        } else {
          break label_34;
        }
        jj_consume_token(COMMA);
                                                ppSet(bnf.nestedExpression(BNF.LPAREN, BNF.expression, BNF.COMMA));
        expression(info);
                                                ppAppend(bnf.nestedExpression(BNF.expression));
                                                requiresVersionAtLeast(Version.TEIID_8_5);
      }
      break;
    default:
      jj_la1[228] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case COMMA:
      jj_consume_token(COMMA);
                                        ppSet(bnf.nestedExpression(BNF.COMMA));
                                        requiresVersionAtLeast(Version.TEIID_8_5);
      break;
    default:
      jj_la1[229] = jj_gen;
      ;
    }
    jj_consume_token(RPAREN);
                                ppSet((String[]) null);
  }

  final public void unsignedValueExpressionPrimary(ParseInfo info) throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case QMARK:
    case DOLLAR:
      parameterReference(info);
                                ppAppend(bnf.unsignedValueExpressionPrimary(BNF.parameterReference));
      break;
    case ESCAPEDFUNCTION:
      jj_consume_token(ESCAPEDFUNCTION);
                                        ppSet(bnf.unsignedValueExpressionPrimary(BNF.ESCAPEDFUNCTION));
      function(info);
                                        ppAppend(bnf.unsignedValueExpressionPrimary(BNF.function));
      jj_consume_token(RBRACE);
                                        ppSet((String[]) null);
      break;
    default:
      jj_la1[231] = jj_gen;
      if (jj_2_30(2)) {
        unescapedFunction(info);
                                ppAppend(bnf.unsignedValueExpressionPrimary(BNF.unescapedFunction));
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case INSTEAD:
        case ENABLED:
        case DISABLED:
        case VIEW:
        case KEY:
        case SERIAL:
        case TEXTAGG:
        case COUNT:
        case ROW_NUMBER:
        case RANK:
        case DENSE_RANK:
        case SUM:
        case AVG:
        case MIN:
        case MAX:
        case EVERY:
        case STDDEV_POP:
        case STDDEV_SAMP:
        case VAR_SAMP:
        case VAR_POP:
        case DOCUMENT:
        case CONTENT:
        case TRIM:
        case EMPTY:
        case ORDINALITY:
        case PATH:
        case FIRST:
        case LAST:
        case NEXT:
        case SUBSTRING:
        case EXTRACT:
        case TO_CHARS:
        case TO_BYTES:
        case TIMESTAMPADD:
        case TIMESTAMPDIFF:
        case QUERYSTRING:
        case NAMESPACE:
        case RESULT:
        case INDEX:
        case ACCESSPATTERN:
        case AUTO_INCREMENT:
        case WELLFORMED:
        case SQL_TSI_FRAC_SECOND:
        case SQL_TSI_SECOND:
        case SQL_TSI_MINUTE:
        case SQL_TSI_HOUR:
        case SQL_TSI_DAY:
        case SQL_TSI_WEEK:
        case SQL_TSI_MONTH:
        case SQL_TSI_QUARTER:
        case SQL_TSI_YEAR:
        case TEXTTABLE:
        case ARRAYTABLE:
        case SELECTOR:
        case SKIP_KEYWORD:
        case WIDTH:
        case PASSING:
        case NAME:
        case ENCODING:
        case COLUMNS:
        case DELIMITER:
        case QUOTE:
        case HEADER:
        case NULLS:
        case OBJECTTABLE:
        case VERSION:
        case INCLUDING:
        case EXCLUDING:
        case XMLDECLARATION:
        case VARIADIC:
        case EXCEPTION:
        case RAISE:
        case CHAIN:
        case JSONARRAY_AGG:
        case JSONOBJECT:
        case ID:
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case ID:
            jj_consume_token(ID);
                                                ppSet(bnf.unsignedValueExpressionPrimary(BNF.ID));
            break;
          case INSTEAD:
          case ENABLED:
          case DISABLED:
          case VIEW:
          case KEY:
          case SERIAL:
          case TEXTAGG:
          case COUNT:
          case ROW_NUMBER:
          case RANK:
          case DENSE_RANK:
          case SUM:
          case AVG:
          case MIN:
          case MAX:
          case EVERY:
          case STDDEV_POP:
          case STDDEV_SAMP:
          case VAR_SAMP:
          case VAR_POP:
          case DOCUMENT:
          case CONTENT:
          case TRIM:
          case EMPTY:
          case ORDINALITY:
          case PATH:
          case FIRST:
          case LAST:
          case NEXT:
          case SUBSTRING:
          case EXTRACT:
          case TO_CHARS:
          case TO_BYTES:
          case TIMESTAMPADD:
          case TIMESTAMPDIFF:
          case QUERYSTRING:
          case NAMESPACE:
          case RESULT:
          case INDEX:
          case ACCESSPATTERN:
          case AUTO_INCREMENT:
          case WELLFORMED:
          case SQL_TSI_FRAC_SECOND:
          case SQL_TSI_SECOND:
          case SQL_TSI_MINUTE:
          case SQL_TSI_HOUR:
          case SQL_TSI_DAY:
          case SQL_TSI_WEEK:
          case SQL_TSI_MONTH:
          case SQL_TSI_QUARTER:
          case SQL_TSI_YEAR:
          case TEXTTABLE:
          case ARRAYTABLE:
          case SELECTOR:
          case SKIP_KEYWORD:
          case WIDTH:
          case PASSING:
          case NAME:
          case ENCODING:
          case COLUMNS:
          case DELIMITER:
          case QUOTE:
          case HEADER:
          case NULLS:
          case OBJECTTABLE:
          case VERSION:
          case INCLUDING:
          case EXCLUDING:
          case XMLDECLARATION:
          case VARIADIC:
          case EXCEPTION:
          case RAISE:
          case CHAIN:
          case JSONARRAY_AGG:
          case JSONOBJECT:
            nonReserved();
            break;
          default:
            jj_la1[230] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          break;
        default:
          jj_la1[232] = jj_gen;
          if (jj_2_31(2147483647)) {
            subquery(info);
                                ppAppend(bnf.unsignedValueExpressionPrimary(BNF.subquery));
          } else {
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case LPAREN:
              nestedExpression(info);
                                ppAppend(bnf.unsignedValueExpressionPrimary(BNF.nestedExpression));
              break;
            default:
              jj_la1[233] = jj_gen;
              if (jj_2_32(2)) {
                searchedCaseExpression(info);
                                ppAppend(bnf.unsignedValueExpressionPrimary(BNF.searchedCaseExpression));
              } else {
                switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
                case CASE:
                  caseExpression(info);
                                ppAppend(bnf.unsignedValueExpressionPrimary(BNF.caseExpression));
                  break;
                default:
                  jj_la1[234] = jj_gen;
                  jj_consume_token(-1);
                  throw new ParseException();
                }
              }
            }
          }
        }
      }
    }
  }

  final public void windowSpecification(ParseInfo info) throws ParseException {
    jj_consume_token(OVER);
                        ppSet(bnf.windowSpecification(BNF.OVER));
    jj_consume_token(LPAREN);
                        ppSet(bnf.windowSpecification(BNF.LPAREN));
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case PARTITION:
      jj_consume_token(PARTITION);
                                ppSet(bnf.windowSpecification(BNF.PARTITION));
      jj_consume_token(BY);
                                ppSet(bnf.windowSpecification(BNF.BY));
      expressionList(info);
                                ppAppend(bnf.windowSpecification(BNF.expressionList));
      break;
    default:
      jj_la1[235] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ORDER:
      orderby(info);
                                ppAppend(bnf.windowSpecification(BNF.orderby));
      break;
    default:
      jj_la1[236] = jj_gen;
      ;
    }
    jj_consume_token(RPAREN);
                        ppSet((String[]) null);
  }

  final public void caseExpression(ParseInfo info) throws ParseException {
    jj_consume_token(CASE);
                        ppSet(bnf.caseExpression(BNF.CASE));
    expression(info);
                        ppAppend(bnf.caseExpression(BNF.CASE, BNF.expression));
    label_35:
    while (true) {
      jj_consume_token(WHEN);
                                ppSet(bnf.caseExpression(BNF.WHEN));
      expression(info);
                                ppAppend(bnf.caseExpression(BNF.WHEN, BNF.expression));
      jj_consume_token(THEN);
                                ppSet(bnf.caseExpression(BNF.THEN));
      expression(info);
                                ppAppend(bnf.caseExpression(BNF.THEN, BNF.expression));
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case WHEN:
        ;
        break;
      default:
        jj_la1[237] = jj_gen;
        break label_35;
      }
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ELSE:
      jj_consume_token(ELSE);
                                ppSet(bnf.caseExpression(BNF.ELSE));
      expression(info);
                                ppAppend(bnf.caseExpression(BNF.ELSE, BNF.expression));
      break;
    default:
      jj_la1[238] = jj_gen;
      ;
    }
    jj_consume_token(END);
                        ppSet((String[]) null);
  }

  final public void searchedCaseExpression(ParseInfo info) throws ParseException {
    jj_consume_token(CASE);
                        ppSet(bnf.searchedCaseExpression(BNF.CASE));
    label_36:
    while (true) {
      jj_consume_token(WHEN);
                                ppSet(bnf.searchedCaseExpression(BNF.WHEN));
      criteria(info);
                                ppAppend(bnf.searchedCaseExpression(BNF.criteria));
      jj_consume_token(THEN);
                                ppSet(bnf.searchedCaseExpression(BNF.THEN));
      expression(info);
                                ppAppend(bnf.searchedCaseExpression(BNF.THEN, BNF.expression));
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case WHEN:
        ;
        break;
      default:
        jj_la1[239] = jj_gen;
        break label_36;
      }
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ELSE:
      jj_consume_token(ELSE);
                                ppSet(bnf.searchedCaseExpression(BNF.ELSE));
      expression(info);
                                ppAppend(bnf.searchedCaseExpression(BNF.ELSE, BNF.expression));
      break;
    default:
      jj_la1[240] = jj_gen;
      ;
    }
    jj_consume_token(END);
                        ppSet((String[]) null);
  }

  final public void function(ParseInfo info) throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CONVERT:
      jj_consume_token(CONVERT);
                                        ppSet(bnf.function(BNF.CONVERT));
      jj_consume_token(LPAREN);
                                        ppSet(bnf.function(BNF.CONVERT, BNF.LPAREN));
      expression(info);
                                        ppAppend(bnf.function(BNF.CONVERT, BNF.expression));
      jj_consume_token(COMMA);
                                        ppSet(bnf.function(BNF.CONVERT, BNF.COMMA));
      parseDataType();
                                        ppAppend(bnf.function(BNF.parseDataType));
      jj_consume_token(RPAREN);
      break;
    case CAST:
      jj_consume_token(CAST);
                                        ppSet(bnf.function(BNF.CAST));
      jj_consume_token(LPAREN);
                                        ppSet(bnf.function(BNF.CAST, BNF.LPAREN));
      expression(info);
                                        ppAppend(bnf.function(BNF.CAST, BNF.expression));
      jj_consume_token(AS);
                                        ppSet(bnf.function(BNF.AS));
      parseDataType();
                                        ppAppend(bnf.function(BNF.parseDataType));
      jj_consume_token(RPAREN);
                                        ppSet((String[]) null);
      break;
    default:
      jj_la1[261] = jj_gen;
      if (jj_2_34(2)) {
        jj_consume_token(SUBSTRING);
                                        ppSet(bnf.function(BNF.SUBSTRING));
        jj_consume_token(LPAREN);
                                        ppSet(bnf.function(BNF.SUBSTRING, BNF.LPAREN));
        expression(info);
                                        ppAppend(bnf.function(BNF.SUBSTRING, BNF.expression));
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case FROM:
          jj_consume_token(FROM);
                                                        ppSet(bnf.function(BNF.SUBSTRING, BNF.FROM));
          expression(info);
                                                        ppAppend(bnf.function(BNF.SUBSTRING, BNF.FROM, BNF.expression));
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case FOR:
            jj_consume_token(FOR);
                                                                ppSet(bnf.function(BNF.FOR));
            expression(info);
                                                                ppAppend(bnf.function(BNF.FOR, BNF.expression));
            break;
          default:
            jj_la1[241] = jj_gen;
            ;
          }
          break;
        case COMMA:
          jj_consume_token(COMMA);
                                                        ppSet(bnf.function(BNF.SUBSTRING, BNF.COMMA));
          expressionList(info);
                                                        ppAppend(bnf.function(BNF.SUBSTRING, BNF.COMMA, BNF.expressionList));
          break;
        default:
          jj_la1[242] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        jj_consume_token(RPAREN);
                                        ppSet((String[]) null);
      } else if (jj_2_35(2)) {
        jj_consume_token(EXTRACT);
                                        ppSet(bnf.function(BNF.EXTRACT));
        jj_consume_token(LPAREN);
                                        ppSet(bnf.function(BNF.EXTRACT, BNF.LPAREN));
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case YEAR:
          jj_consume_token(YEAR);
                                                ppSet(bnf.function(BNF.YEAR));
          break;
        case MONTH:
          jj_consume_token(MONTH);
                                                ppSet(bnf.function(BNF.MONTH));
          break;
        case DAY:
          jj_consume_token(DAY);
                                                ppSet(bnf.function(BNF.DAY));
          break;
        case HOUR:
          jj_consume_token(HOUR);
                                                ppSet(bnf.function(BNF.HOUR));
          break;
        case MINUTE:
          jj_consume_token(MINUTE);
                                                ppSet(bnf.function(BNF.MINUTE));
          break;
        case SECOND:
          jj_consume_token(SECOND);
                                                ppSet(bnf.function(BNF.SECOND));
          break;
        default:
          jj_la1[243] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        jj_consume_token(FROM);
                                        ppSet(bnf.function(BNF.EXTRACT, BNF.FROM));
        expression(info);
                                        ppAppend(bnf.function(BNF.EXTRACT, BNF.FROM, BNF.expression));
        jj_consume_token(RPAREN);
                                        ppSet((String[]) null);
      } else if (jj_2_36(2)) {
        jj_consume_token(TRIM);
                                        ppSet(bnf.function(BNF.TRIM));
        jj_consume_token(LPAREN);
                                        ppSet(bnf.function(BNF.TRIM, BNF.LPAREN));
        if (jj_2_33(2)) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case BOTH:
          case LEADING:
          case TRAILING:
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case LEADING:
              jj_consume_token(LEADING);
                                                                        ppSet(bnf.function(BNF.LEADING));
              break;
            case TRAILING:
              jj_consume_token(TRAILING);
                                                                        ppSet(bnf.function(BNF.TRAILING));
              break;
            case BOTH:
              jj_consume_token(BOTH);
                                                                        ppSet(bnf.function(BNF.BOTH));
              break;
            default:
              jj_la1[244] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case CHAR:
            case CAST:
            case CONVERT:
            case ANY:
            case CASE:
            case EXISTS:
            case FALSE:
            case HOUR:
            case INSERT:
            case LEFT:
            case MINUTE:
            case MONTH:
            case NOT:
            case NULL:
            case RIGHT:
            case SECOND:
            case SOME:
            case TRANSLATE:
            case TRUE:
            case UNKNOWN:
            case USER:
            case YEAR:
            case XMLAGG:
            case XMLCONCAT:
            case XMLCOMMENT:
            case XMLELEMENT:
            case XMLFOREST:
            case XMLPARSE:
            case XMLPI:
            case XMLQUERY:
            case XMLSERIALIZE:
            case INSTEAD:
            case ENABLED:
            case DISABLED:
            case VIEW:
            case KEY:
            case SERIAL:
            case TEXTAGG:
            case COUNT:
            case ROW_NUMBER:
            case RANK:
            case DENSE_RANK:
            case SUM:
            case AVG:
            case MIN:
            case MAX:
            case EVERY:
            case STDDEV_POP:
            case STDDEV_SAMP:
            case VAR_SAMP:
            case VAR_POP:
            case DOCUMENT:
            case CONTENT:
            case TRIM:
            case EMPTY:
            case ORDINALITY:
            case PATH:
            case FIRST:
            case LAST:
            case NEXT:
            case SUBSTRING:
            case EXTRACT:
            case TO_CHARS:
            case TO_BYTES:
            case TIMESTAMPADD:
            case TIMESTAMPDIFF:
            case QUERYSTRING:
            case NAMESPACE:
            case RESULT:
            case INDEX:
            case ACCESSPATTERN:
            case AUTO_INCREMENT:
            case WELLFORMED:
            case SQL_TSI_FRAC_SECOND:
            case SQL_TSI_SECOND:
            case SQL_TSI_MINUTE:
            case SQL_TSI_HOUR:
            case SQL_TSI_DAY:
            case SQL_TSI_WEEK:
            case SQL_TSI_MONTH:
            case SQL_TSI_QUARTER:
            case SQL_TSI_YEAR:
            case TEXTTABLE:
            case ARRAYTABLE:
            case SELECTOR:
            case SKIP_KEYWORD:
            case WIDTH:
            case PASSING:
            case NAME:
            case ENCODING:
            case COLUMNS:
            case DELIMITER:
            case QUOTE:
            case HEADER:
            case NULLS:
            case OBJECTTABLE:
            case VERSION:
            case INCLUDING:
            case EXCLUDING:
            case XMLDECLARATION:
            case VARIADIC:
            case EXCEPTION:
            case RAISE:
            case CHAIN:
            case JSONARRAY_AGG:
            case JSONOBJECT:
            case ID:
            case ESCAPEDFUNCTION:
            case ESCAPEDTYPE:
            case DECIMALVAL:
            case FLOATVAL:
            case STRINGVAL:
            case UNSIGNEDINTEGER:
            case BINARYSTRINGVAL:
            case LPAREN:
            case PLUS:
            case MINUS:
            case QMARK:
            case DOLLAR:
              expression(info);
                                                                        ppAppend(bnf.function(BNF.TRIM, BNF.LEADING, BNF.expression));
              break;
            default:
              jj_la1[245] = jj_gen;
              ;
            }
            break;
          case CHAR:
          case CAST:
          case CONVERT:
          case ANY:
          case CASE:
          case EXISTS:
          case FALSE:
          case HOUR:
          case INSERT:
          case LEFT:
          case MINUTE:
          case MONTH:
          case NOT:
          case NULL:
          case RIGHT:
          case SECOND:
          case SOME:
          case TRANSLATE:
          case TRUE:
          case UNKNOWN:
          case USER:
          case YEAR:
          case XMLAGG:
          case XMLCONCAT:
          case XMLCOMMENT:
          case XMLELEMENT:
          case XMLFOREST:
          case XMLPARSE:
          case XMLPI:
          case XMLQUERY:
          case XMLSERIALIZE:
          case INSTEAD:
          case ENABLED:
          case DISABLED:
          case VIEW:
          case KEY:
          case SERIAL:
          case TEXTAGG:
          case COUNT:
          case ROW_NUMBER:
          case RANK:
          case DENSE_RANK:
          case SUM:
          case AVG:
          case MIN:
          case MAX:
          case EVERY:
          case STDDEV_POP:
          case STDDEV_SAMP:
          case VAR_SAMP:
          case VAR_POP:
          case DOCUMENT:
          case CONTENT:
          case TRIM:
          case EMPTY:
          case ORDINALITY:
          case PATH:
          case FIRST:
          case LAST:
          case NEXT:
          case SUBSTRING:
          case EXTRACT:
          case TO_CHARS:
          case TO_BYTES:
          case TIMESTAMPADD:
          case TIMESTAMPDIFF:
          case QUERYSTRING:
          case NAMESPACE:
          case RESULT:
          case INDEX:
          case ACCESSPATTERN:
          case AUTO_INCREMENT:
          case WELLFORMED:
          case SQL_TSI_FRAC_SECOND:
          case SQL_TSI_SECOND:
          case SQL_TSI_MINUTE:
          case SQL_TSI_HOUR:
          case SQL_TSI_DAY:
          case SQL_TSI_WEEK:
          case SQL_TSI_MONTH:
          case SQL_TSI_QUARTER:
          case SQL_TSI_YEAR:
          case TEXTTABLE:
          case ARRAYTABLE:
          case SELECTOR:
          case SKIP_KEYWORD:
          case WIDTH:
          case PASSING:
          case NAME:
          case ENCODING:
          case COLUMNS:
          case DELIMITER:
          case QUOTE:
          case HEADER:
          case NULLS:
          case OBJECTTABLE:
          case VERSION:
          case INCLUDING:
          case EXCLUDING:
          case XMLDECLARATION:
          case VARIADIC:
          case EXCEPTION:
          case RAISE:
          case CHAIN:
          case JSONARRAY_AGG:
          case JSONOBJECT:
          case ID:
          case ESCAPEDFUNCTION:
          case ESCAPEDTYPE:
          case DECIMALVAL:
          case FLOATVAL:
          case STRINGVAL:
          case UNSIGNEDINTEGER:
          case BINARYSTRINGVAL:
          case LPAREN:
          case PLUS:
          case MINUS:
          case QMARK:
          case DOLLAR:
            expression(info);
                                                        ppAppend(bnf.function(BNF.TRIM, BNF.expression));
            break;
          default:
            jj_la1[246] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          jj_consume_token(FROM);
                                                ppSet(bnf.function(BNF.TRIM, BNF.FROM));
        } else {
          ;
        }
        expression(info);
                                        ppAppend(bnf.function(BNF.TRIM, BNF.LPAREN, BNF.expression));
        jj_consume_token(RPAREN);
                                        ppSet((String[]) null);
      } else if (jj_2_37(2)) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case TO_CHARS:
          jj_consume_token(TO_CHARS);
                                                ppSet(bnf.function(BNF.TO_CHARS));
          break;
        case TO_BYTES:
          jj_consume_token(TO_BYTES);
                                                ppSet(bnf.function(BNF.TO_BYTES));
          break;
        default:
          jj_la1[247] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        jj_consume_token(LPAREN);
                                        ppSet(bnf.function(BNF.TO_BYTES, BNF.LPAREN));
        expression(info);
                                        ppAppend(bnf.function(BNF.TO_BYTES, BNF.expression));
        jj_consume_token(COMMA);
                                        ppSet(bnf.function(BNF.TO_BYTES, BNF.COMMA));
        stringVal();
                                        ppAppend(bnf.function(BNF.stringVal));
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          jj_consume_token(COMMA);
                                                ppSet(bnf.function(BNF.TO_BYTES, BNF.stringVal, BNF.COMMA));
                                                requiresVersionAtLeast(Version.TEIID_8_6);
          expression(info);
                                                ppAppend(bnf.function(BNF.TO_BYTES, BNF.stringVal, BNF.expression));
          break;
        default:
          jj_la1[248] = jj_gen;
          ;
        }
        jj_consume_token(RPAREN);
                                        ppSet((String[]) null);
      } else if (jj_2_38(2)) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case TIMESTAMPADD:
          jj_consume_token(TIMESTAMPADD);
                                                ppSet(bnf.function(BNF.TIMESTAMPADD));
          break;
        case TIMESTAMPDIFF:
          jj_consume_token(TIMESTAMPDIFF);
                                                ppSet(bnf.function(BNF.TIMESTAMPDIFF));
          break;
        default:
          jj_la1[249] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        jj_consume_token(LPAREN);
                                        ppSet(bnf.function(BNF.TIMESTAMPADD, BNF.LPAREN));
        intervalType();
                                        ppAppend(bnf.function(BNF.intervalType));
        jj_consume_token(COMMA);
                                        ppSet(bnf.function(BNF.intervalType, BNF.COMMA));
        expression(info);
                                        ppAppend(bnf.function(BNF.intervalType, BNF.expression));
        jj_consume_token(COMMA);
                                        ppSet(bnf.function(BNF.intervalType, BNF.expression, BNF.COMMA));
        expression(info);
                                        ppAppend(bnf.function(BNF.intervalType, BNF.expression, BNF.COMMA, BNF.expression));
        jj_consume_token(RPAREN);
                                        ppSet((String[]) null);
      } else if (jj_2_39(2)) {
        queryString(info);
                                ppAppend(bnf.function(BNF.queryString));
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case CHAR:
        case HOUR:
        case LEFT:
        case MINUTE:
        case MONTH:
        case RIGHT:
        case SECOND:
        case USER:
        case YEAR:
        case XMLCONCAT:
        case XMLCOMMENT:
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case LEFT:
            jj_consume_token(LEFT);
                                                ppSet(bnf.function(BNF.LEFT));
            break;
          case RIGHT:
            jj_consume_token(RIGHT);
                                                ppSet(bnf.function(BNF.RIGHT));
            break;
          case CHAR:
            jj_consume_token(CHAR);
                                                ppSet(bnf.function(BNF.CHAR));
            break;
          case USER:
            jj_consume_token(USER);
                                                ppSet(bnf.function(BNF.USER));
            break;
          case YEAR:
            jj_consume_token(YEAR);
                                                ppSet(bnf.function(BNF.YEAR));
            break;
          case MONTH:
            jj_consume_token(MONTH);
                                                ppSet(bnf.function(BNF.MONTH));
            break;
          case HOUR:
            jj_consume_token(HOUR);
                                                ppSet(bnf.function(BNF.HOUR));
            break;
          case MINUTE:
            jj_consume_token(MINUTE);
                                                ppSet(bnf.function(BNF.MINUTE));
            break;
          case SECOND:
            jj_consume_token(SECOND);
                                                ppSet(bnf.function(BNF.SECOND));
            break;
          case XMLCONCAT:
            jj_consume_token(XMLCONCAT);
                                                ppSet(bnf.function(BNF.XMLCONCAT));
            break;
          case XMLCOMMENT:
            jj_consume_token(XMLCOMMENT);
                                                ppSet(bnf.function(BNF.XMLCOMMENT));
            break;
          default:
            jj_la1[250] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          jj_consume_token(LPAREN);
                                        ppSet(bnf.function(BNF.queryString, BNF.LPAREN));
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case CHAR:
          case CAST:
          case CONVERT:
          case ANY:
          case CASE:
          case EXISTS:
          case FALSE:
          case HOUR:
          case INSERT:
          case LEFT:
          case MINUTE:
          case MONTH:
          case NOT:
          case NULL:
          case RIGHT:
          case SECOND:
          case SOME:
          case TRANSLATE:
          case TRUE:
          case UNKNOWN:
          case USER:
          case YEAR:
          case XMLAGG:
          case XMLCONCAT:
          case XMLCOMMENT:
          case XMLELEMENT:
          case XMLFOREST:
          case XMLPARSE:
          case XMLPI:
          case XMLQUERY:
          case XMLSERIALIZE:
          case INSTEAD:
          case ENABLED:
          case DISABLED:
          case VIEW:
          case KEY:
          case SERIAL:
          case TEXTAGG:
          case COUNT:
          case ROW_NUMBER:
          case RANK:
          case DENSE_RANK:
          case SUM:
          case AVG:
          case MIN:
          case MAX:
          case EVERY:
          case STDDEV_POP:
          case STDDEV_SAMP:
          case VAR_SAMP:
          case VAR_POP:
          case DOCUMENT:
          case CONTENT:
          case TRIM:
          case EMPTY:
          case ORDINALITY:
          case PATH:
          case FIRST:
          case LAST:
          case NEXT:
          case SUBSTRING:
          case EXTRACT:
          case TO_CHARS:
          case TO_BYTES:
          case TIMESTAMPADD:
          case TIMESTAMPDIFF:
          case QUERYSTRING:
          case NAMESPACE:
          case RESULT:
          case INDEX:
          case ACCESSPATTERN:
          case AUTO_INCREMENT:
          case WELLFORMED:
          case SQL_TSI_FRAC_SECOND:
          case SQL_TSI_SECOND:
          case SQL_TSI_MINUTE:
          case SQL_TSI_HOUR:
          case SQL_TSI_DAY:
          case SQL_TSI_WEEK:
          case SQL_TSI_MONTH:
          case SQL_TSI_QUARTER:
          case SQL_TSI_YEAR:
          case TEXTTABLE:
          case ARRAYTABLE:
          case SELECTOR:
          case SKIP_KEYWORD:
          case WIDTH:
          case PASSING:
          case NAME:
          case ENCODING:
          case COLUMNS:
          case DELIMITER:
          case QUOTE:
          case HEADER:
          case NULLS:
          case OBJECTTABLE:
          case VERSION:
          case INCLUDING:
          case EXCLUDING:
          case XMLDECLARATION:
          case VARIADIC:
          case EXCEPTION:
          case RAISE:
          case CHAIN:
          case JSONARRAY_AGG:
          case JSONOBJECT:
          case ID:
          case ESCAPEDFUNCTION:
          case ESCAPEDTYPE:
          case DECIMALVAL:
          case FLOATVAL:
          case STRINGVAL:
          case UNSIGNEDINTEGER:
          case BINARYSTRINGVAL:
          case LPAREN:
          case PLUS:
          case MINUS:
          case QMARK:
          case DOLLAR:
            expressionList(info);
                                                ppAppend(bnf.function(BNF.queryString, BNF.expressionList));
            break;
          default:
            jj_la1[251] = jj_gen;
            ;
          }
          jj_consume_token(RPAREN);
                                        ppSet((String[]) null);
          break;
        default:
          jj_la1[262] = jj_gen;
          if (jj_2_40(2147483647)) {
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case TRANSLATE:
              jj_consume_token(TRANSLATE);
                                                ppSet(bnf.function(BNF.TRANSLATE));
              break;
            case INSERT:
              jj_consume_token(INSERT);
                                                ppSet(bnf.function(BNF.INSERT));
              break;
            default:
              jj_la1[252] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
            jj_consume_token(LPAREN);
                                        ppSet(bnf.function(BNF.TRANSLATE, BNF.LPAREN));
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case CHAR:
            case CAST:
            case CONVERT:
            case ANY:
            case CASE:
            case EXISTS:
            case FALSE:
            case HOUR:
            case INSERT:
            case LEFT:
            case MINUTE:
            case MONTH:
            case NOT:
            case NULL:
            case RIGHT:
            case SECOND:
            case SOME:
            case TRANSLATE:
            case TRUE:
            case UNKNOWN:
            case USER:
            case YEAR:
            case XMLAGG:
            case XMLCONCAT:
            case XMLCOMMENT:
            case XMLELEMENT:
            case XMLFOREST:
            case XMLPARSE:
            case XMLPI:
            case XMLQUERY:
            case XMLSERIALIZE:
            case INSTEAD:
            case ENABLED:
            case DISABLED:
            case VIEW:
            case KEY:
            case SERIAL:
            case TEXTAGG:
            case COUNT:
            case ROW_NUMBER:
            case RANK:
            case DENSE_RANK:
            case SUM:
            case AVG:
            case MIN:
            case MAX:
            case EVERY:
            case STDDEV_POP:
            case STDDEV_SAMP:
            case VAR_SAMP:
            case VAR_POP:
            case DOCUMENT:
            case CONTENT:
            case TRIM:
            case EMPTY:
            case ORDINALITY:
            case PATH:
            case FIRST:
            case LAST:
            case NEXT:
            case SUBSTRING:
            case EXTRACT:
            case TO_CHARS:
            case TO_BYTES:
            case TIMESTAMPADD:
            case TIMESTAMPDIFF:
            case QUERYSTRING:
            case NAMESPACE:
            case RESULT:
            case INDEX:
            case ACCESSPATTERN:
            case AUTO_INCREMENT:
            case WELLFORMED:
            case SQL_TSI_FRAC_SECOND:
            case SQL_TSI_SECOND:
            case SQL_TSI_MINUTE:
            case SQL_TSI_HOUR:
            case SQL_TSI_DAY:
            case SQL_TSI_WEEK:
            case SQL_TSI_MONTH:
            case SQL_TSI_QUARTER:
            case SQL_TSI_YEAR:
            case TEXTTABLE:
            case ARRAYTABLE:
            case SELECTOR:
            case SKIP_KEYWORD:
            case WIDTH:
            case PASSING:
            case NAME:
            case ENCODING:
            case COLUMNS:
            case DELIMITER:
            case QUOTE:
            case HEADER:
            case NULLS:
            case OBJECTTABLE:
            case VERSION:
            case INCLUDING:
            case EXCLUDING:
            case XMLDECLARATION:
            case VARIADIC:
            case EXCEPTION:
            case RAISE:
            case CHAIN:
            case JSONARRAY_AGG:
            case JSONOBJECT:
            case ID:
            case ESCAPEDFUNCTION:
            case ESCAPEDTYPE:
            case DECIMALVAL:
            case FLOATVAL:
            case STRINGVAL:
            case UNSIGNEDINTEGER:
            case BINARYSTRINGVAL:
            case LPAREN:
            case PLUS:
            case MINUS:
            case QMARK:
            case DOLLAR:
              expressionList(info);
                                                ppAppend(bnf.function(BNF.TRANSLATE, BNF.expressionList));
              break;
            default:
              jj_la1[253] = jj_gen;
              ;
            }
            jj_consume_token(RPAREN);
                                        ppSet((String[]) null);
          } else {
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case XMLPARSE:
              xmlParse(info);
                                ppAppend(bnf.function(BNF.xmlParse));
              break;
            case XMLELEMENT:
              xmlElement(info);
                                ppAppend(bnf.function(BNF.xmlElement));
              break;
            case XMLPI:
              jj_consume_token(XMLPI);
                                        ppSet(bnf.function(BNF.XMLPI));
              jj_consume_token(LPAREN);
                                        ppSet(bnf.function(BNF.XMLPI, BNF.LPAREN));
              switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
              case NAME:
                jj_consume_token(NAME);
                                                        ppSet(bnf.function(BNF.NAME));
                break;
              default:
                jj_la1[254] = jj_gen;
                ;
              }
              id();
                                                ppSet(bnf.function(BNF.XMLPI, BNF.id));
              switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
              case COMMA:
                jj_consume_token(COMMA);
                                                ppSet(bnf.function(BNF.XMLPI, BNF.COMMA));
                expression(info);
                                                ppAppend(bnf.function(BNF.XMLPI, BNF.expression));
                break;
              default:
                jj_la1[255] = jj_gen;
                ;
              }
              jj_consume_token(RPAREN);
                                        ppSet((String[]) null);
              break;
            case XMLFOREST:
              xmlForest(info);
              break;
            default:
              jj_la1[263] = jj_gen;
              if (jj_2_41(2147483647)) {
                jsonObject(info);
                                ppAppend(bnf.function(BNF.jsonObject));
              } else {
                switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
                case XMLSERIALIZE:
                  xmlSerialize(info);
                                ppAppend(bnf.function(BNF.xmlSerialize));
                  break;
                case XMLQUERY:
                  xmlQuery(info);
                                ppAppend(bnf.function(BNF.xmlQuery));
                  break;
                case INSTEAD:
                case ENABLED:
                case DISABLED:
                case VIEW:
                case KEY:
                case SERIAL:
                case TEXTAGG:
                case COUNT:
                case ROW_NUMBER:
                case RANK:
                case DENSE_RANK:
                case SUM:
                case AVG:
                case MIN:
                case MAX:
                case EVERY:
                case STDDEV_POP:
                case STDDEV_SAMP:
                case VAR_SAMP:
                case VAR_POP:
                case DOCUMENT:
                case CONTENT:
                case TRIM:
                case EMPTY:
                case ORDINALITY:
                case PATH:
                case FIRST:
                case LAST:
                case NEXT:
                case SUBSTRING:
                case EXTRACT:
                case TO_CHARS:
                case TO_BYTES:
                case TIMESTAMPADD:
                case TIMESTAMPDIFF:
                case QUERYSTRING:
                case NAMESPACE:
                case RESULT:
                case INDEX:
                case ACCESSPATTERN:
                case AUTO_INCREMENT:
                case WELLFORMED:
                case SQL_TSI_FRAC_SECOND:
                case SQL_TSI_SECOND:
                case SQL_TSI_MINUTE:
                case SQL_TSI_HOUR:
                case SQL_TSI_DAY:
                case SQL_TSI_WEEK:
                case SQL_TSI_MONTH:
                case SQL_TSI_QUARTER:
                case SQL_TSI_YEAR:
                case TEXTTABLE:
                case ARRAYTABLE:
                case SELECTOR:
                case SKIP_KEYWORD:
                case WIDTH:
                case PASSING:
                case NAME:
                case ENCODING:
                case COLUMNS:
                case DELIMITER:
                case QUOTE:
                case HEADER:
                case NULLS:
                case OBJECTTABLE:
                case VERSION:
                case INCLUDING:
                case EXCLUDING:
                case XMLDECLARATION:
                case VARIADIC:
                case EXCEPTION:
                case RAISE:
                case CHAIN:
                case JSONARRAY_AGG:
                case JSONOBJECT:
                case ID:
                  id();
                                        ppSet(bnf.function(BNF.id));
                  jj_consume_token(LPAREN);
                                        ppSet(bnf.function(BNF.id, BNF.LPAREN));
                  switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
                  case ALL:
                  case DISTINCT:
                    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
                    case ALL:
                      jj_consume_token(ALL);
                                                ppSet(bnf.function(BNF.ALL));
                      break;
                    case DISTINCT:
                      jj_consume_token(DISTINCT);
                                                ppSet(bnf.function(BNF.DISTINCT));
                      break;
                    default:
                      jj_la1[256] = jj_gen;
                      jj_consume_token(-1);
                      throw new ParseException();
                    }
                    break;
                  default:
                    jj_la1[257] = jj_gen;
                    ;
                  }
                  switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
                  case CHAR:
                  case CAST:
                  case CONVERT:
                  case ANY:
                  case CASE:
                  case EXISTS:
                  case FALSE:
                  case HOUR:
                  case INSERT:
                  case LEFT:
                  case MINUTE:
                  case MONTH:
                  case NOT:
                  case NULL:
                  case RIGHT:
                  case SECOND:
                  case SOME:
                  case TRANSLATE:
                  case TRUE:
                  case UNKNOWN:
                  case USER:
                  case YEAR:
                  case XMLAGG:
                  case XMLCONCAT:
                  case XMLCOMMENT:
                  case XMLELEMENT:
                  case XMLFOREST:
                  case XMLPARSE:
                  case XMLPI:
                  case XMLQUERY:
                  case XMLSERIALIZE:
                  case INSTEAD:
                  case ENABLED:
                  case DISABLED:
                  case VIEW:
                  case KEY:
                  case SERIAL:
                  case TEXTAGG:
                  case COUNT:
                  case ROW_NUMBER:
                  case RANK:
                  case DENSE_RANK:
                  case SUM:
                  case AVG:
                  case MIN:
                  case MAX:
                  case EVERY:
                  case STDDEV_POP:
                  case STDDEV_SAMP:
                  case VAR_SAMP:
                  case VAR_POP:
                  case DOCUMENT:
                  case CONTENT:
                  case TRIM:
                  case EMPTY:
                  case ORDINALITY:
                  case PATH:
                  case FIRST:
                  case LAST:
                  case NEXT:
                  case SUBSTRING:
                  case EXTRACT:
                  case TO_CHARS:
                  case TO_BYTES:
                  case TIMESTAMPADD:
                  case TIMESTAMPDIFF:
                  case QUERYSTRING:
                  case NAMESPACE:
                  case RESULT:
                  case INDEX:
                  case ACCESSPATTERN:
                  case AUTO_INCREMENT:
                  case WELLFORMED:
                  case SQL_TSI_FRAC_SECOND:
                  case SQL_TSI_SECOND:
                  case SQL_TSI_MINUTE:
                  case SQL_TSI_HOUR:
                  case SQL_TSI_DAY:
                  case SQL_TSI_WEEK:
                  case SQL_TSI_MONTH:
                  case SQL_TSI_QUARTER:
                  case SQL_TSI_YEAR:
                  case TEXTTABLE:
                  case ARRAYTABLE:
                  case SELECTOR:
                  case SKIP_KEYWORD:
                  case WIDTH:
                  case PASSING:
                  case NAME:
                  case ENCODING:
                  case COLUMNS:
                  case DELIMITER:
                  case QUOTE:
                  case HEADER:
                  case NULLS:
                  case OBJECTTABLE:
                  case VERSION:
                  case INCLUDING:
                  case EXCLUDING:
                  case XMLDECLARATION:
                  case VARIADIC:
                  case EXCEPTION:
                  case RAISE:
                  case CHAIN:
                  case JSONARRAY_AGG:
                  case JSONOBJECT:
                  case ID:
                  case ESCAPEDFUNCTION:
                  case ESCAPEDTYPE:
                  case DECIMALVAL:
                  case FLOATVAL:
                  case STRINGVAL:
                  case UNSIGNEDINTEGER:
                  case BINARYSTRINGVAL:
                  case LPAREN:
                  case PLUS:
                  case MINUS:
                  case QMARK:
                  case DOLLAR:
                    expressionList(info);
                                                ppAppend(bnf.function(BNF.id, BNF.expressionList));
                    break;
                  default:
                    jj_la1[258] = jj_gen;
                    ;
                  }
                  switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
                  case ORDER:
                    orderby(info);
                                                ppAppend(bnf.function(BNF.orderby));
                    break;
                  default:
                    jj_la1[259] = jj_gen;
                    ;
                  }
                  jj_consume_token(RPAREN);
                                        ppSet(bnf.function(BNF.RPAREN));
                  switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
                  case FILTER:
                    filterClause(info);
                    break;
                  default:
                    jj_la1[260] = jj_gen;
                    ;
                  }
                  break;
                default:
                  jj_la1[264] = jj_gen;
                  jj_consume_token(-1);
                  throw new ParseException();
                }
              }
            }
          }
        }
      }
    }
  }

  final public void xmlParse(ParseInfo info) throws ParseException {
    jj_consume_token(XMLPARSE);
                        ppSet(bnf.xmlParse(BNF.XMLPARSE));
    jj_consume_token(LPAREN);
                        ppSet(bnf.xmlParse(BNF.LPAREN));
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DOCUMENT:
      jj_consume_token(DOCUMENT);
                                ppSet(bnf.xmlParse(BNF.DOCUMENT));
      break;
    case CONTENT:
      jj_consume_token(CONTENT);
                                ppSet(bnf.xmlParse(BNF.CONTENT));
      break;
    default:
      jj_la1[265] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    expression(info);
                        ppAppend(bnf.xmlParse(BNF.expression));
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case WELLFORMED:
      jj_consume_token(WELLFORMED);
                                ppSet(bnf.xmlParse(BNF.WELLFORMED));
      break;
    default:
      jj_la1[266] = jj_gen;
      ;
    }
    jj_consume_token(RPAREN);
                        ppSet((String[]) null);
  }

  final public void queryString(ParseInfo info) throws ParseException {
    jj_consume_token(QUERYSTRING);
                        ppSet(bnf.queryString(BNF.QUERYSTRING));
    jj_consume_token(LPAREN);
                        ppSet(bnf.queryString(BNF.LPAREN));
    expression(info);
                        ppAppend(bnf.queryString(BNF.expression));
    label_37:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[267] = jj_gen;
        break label_37;
      }
      jj_consume_token(COMMA);
                                ppSet(bnf.queryString(BNF.COMMA));
      derivedColumn(info);
                                ppAppend(bnf.queryString(BNF.derivedColumn));
    }
    jj_consume_token(RPAREN);
                        ppSet((String[]) null);
  }

  final public void xmlElement(ParseInfo info) throws ParseException {
    jj_consume_token(XMLELEMENT);
                        ppSet(bnf.xmlElement(BNF.XMLELEMENT));
    jj_consume_token(LPAREN);
                        ppSet(bnf.xmlElement(BNF.LPAREN));
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NAME:
      jj_consume_token(NAME);
                                        ppSet(bnf.xmlElement(BNF.NAME));
      break;
    default:
      jj_la1[268] = jj_gen;
      ;
    }
    id();
                                ppAppend(bnf.xmlElement(BNF.id));
    if (jj_2_42(2)) {
      jj_consume_token(COMMA);
                                ppSet(bnf.xmlElement(BNF.NAME, BNF.COMMA));
      xmlNamespaces(info);
                                ppAppend(bnf.xmlElement(BNF.xmlNamespaces));
    } else {
      ;
    }
    if (jj_2_43(2)) {
      jj_consume_token(COMMA);
                                ppSet(bnf.xmlElement(BNF.xmlNamespaces, BNF.COMMA));
      xmlAttributes(info);
                                ppAppend(bnf.xmlElement(BNF.xmlAttributes));
    } else {
      ;
    }
    label_38:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[269] = jj_gen;
        break label_38;
      }
      jj_consume_token(COMMA);
                                ppSet(bnf.xmlElement(BNF.xmlAttributes, BNF.COMMA));
      expression(info);
                                ppAppend(bnf.xmlElement(BNF.expression));
    }
    jj_consume_token(RPAREN);
                        ppSet((String[]) null);
  }

  final public void xmlAttributes(ParseInfo info) throws ParseException {
    jj_consume_token(XMLATTRIBUTES);
                        ppSet(bnf.xmlAttributes(BNF.XMLATTRIBUTES));
    jj_consume_token(LPAREN);
                        ppSet(bnf.xmlAttributes(BNF.LPAREN));
    derivedColumn(info);
                        ppAppend(bnf.xmlAttributes(BNF.derivedColumn));
    label_39:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[270] = jj_gen;
        break label_39;
      }
      jj_consume_token(COMMA);
                                ppSet(bnf.xmlAttributes(BNF.COMMA));
      derivedColumn(info);
                                ppAppend(bnf.xmlAttributes(BNF.derivedColumn));
    }
    jj_consume_token(RPAREN);
                        ppSet((String[]) null);
  }

  final public void jsonObject(ParseInfo info) throws ParseException {
    jj_consume_token(JSONOBJECT);
                        ppSet(bnf.jsonObject(BNF.JSONOBJECT));
    jj_consume_token(LPAREN);
                        ppSet(bnf.jsonObject(BNF.LPAREN));
    derivedColumnList(info);
                        ppAppend(bnf.jsonObject(BNF.derivedColumnList));
    jj_consume_token(RPAREN);
                        ppSet((String[]) null);
  }

  final public void derivedColumnList(ParseInfo info) throws ParseException {
    derivedColumn(info);
                        ppAppend(bnf.derivedColumnList(BNF.derivedColumn));
    label_40:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[271] = jj_gen;
        break label_40;
      }
      jj_consume_token(COMMA);
                                ppSet(bnf.derivedColumnList(BNF.COMMA));
      derivedColumn(info);
                                ppAppend(bnf.derivedColumnList(BNF.derivedColumn));
    }
  }

  final public void xmlForest(ParseInfo info) throws ParseException {
    jj_consume_token(XMLFOREST);
                        ppSet(bnf.xmlForest(BNF.XMLFOREST));
    jj_consume_token(LPAREN);
                        ppSet(bnf.xmlForest(BNF.LPAREN));
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case XMLNAMESPACES:
      xmlNamespaces(info);
                                ppAppend(bnf.xmlForest(BNF.xmlNamespaces));
      jj_consume_token(COMMA);
                                ppSet(bnf.xmlForest(BNF.COMMA));
      break;
    default:
      jj_la1[272] = jj_gen;
      ;
    }
    derivedColumnList(info);
                        ppAppend(bnf.xmlForest(BNF.derivedColumnList));
    jj_consume_token(RPAREN);
                        ppSet((String[]) null);
  }

  final public void xmlNamespaces(ParseInfo info) throws ParseException {
    jj_consume_token(XMLNAMESPACES);
                        ppSet(bnf.xmlNamespaces(BNF.XMLNAMESPACES));
    jj_consume_token(LPAREN);
                        ppSet(bnf.xmlNamespaces(BNF.LPAREN));
    namespaceItem();
                        ppSet(bnf.xmlNamespaces(BNF.namespaceItem));
    label_41:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[273] = jj_gen;
        break label_41;
      }
      jj_consume_token(COMMA);
                                ppSet(bnf.xmlNamespaces(BNF.COMMA));
      namespaceItem();
                                ppSet(bnf.xmlNamespaces(BNF.namespaceItem));
    }
    jj_consume_token(RPAREN);
                        ppSet((String[]) null);
  }

  final public void namespaceItem() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case STRINGVAL:
      stringVal();
                                ppAppend(bnf.namespaceItem(BNF.stringVal));
      jj_consume_token(AS);
                                ppSet(bnf.namespaceItem(BNF.AS));
      id();
                                ppAppend(bnf.namespaceItem(BNF.id));
      break;
    case NO:
      jj_consume_token(NO);
                                ppSet(bnf.namespaceItem(BNF.NO));
      jj_consume_token(DEFAULT_KEYWORD);
                                ppSet((String[]) null);
      break;
    case DEFAULT_KEYWORD:
      jj_consume_token(DEFAULT_KEYWORD);
                                ppSet(bnf.namespaceItem(BNF.DEFAULT_KEYWORD));
      stringVal();
                                ppAppend(bnf.namespaceItem(BNF.DEFAULT_KEYWORD, BNF.stringVal));
      break;
    default:
      jj_la1[274] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void parseDataTypePrimary() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case STRING:
      jj_consume_token(STRING);
                                        ppSet(bnf.parseDataTypePrimary(BNF.STRING));
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LPAREN:
        jj_consume_token(LPAREN);
                                                        ppSet(bnf.parseDataTypePrimary(BNF.LPAREN));
        intVal();
                                                        ppAppend(bnf.parseDataTypePrimary(BNF.STRING, BNF.intVal));
        jj_consume_token(RPAREN);
                                                        ppSet((String[]) null);
        break;
      default:
        jj_la1[275] = jj_gen;
        ;
      }
      break;
    case VARCHAR:
      jj_consume_token(VARCHAR);
                                        ppSet(bnf.parseDataTypePrimary(BNF.VARCHAR));
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LPAREN:
        jj_consume_token(LPAREN);
                                                        ppSet(bnf.parseDataTypePrimary(BNF.LPAREN));
        intVal();
                                                        ppAppend(bnf.parseDataTypePrimary(BNF.VARCHAR, BNF.intVal));
        jj_consume_token(RPAREN);
                                                        ppSet((String[]) null);
        break;
      default:
        jj_la1[276] = jj_gen;
        ;
      }
      break;
    case BOOLEAN:
      jj_consume_token(BOOLEAN);
                                ppSet((String[]) null);
      break;
    case BYTE:
      jj_consume_token(BYTE);
                                ppSet((String[]) null);
      break;
    case TINYINT:
      jj_consume_token(TINYINT);
                                ppSet((String[]) null);
      break;
    case SHORT:
      jj_consume_token(SHORT);
                                ppSet((String[]) null);
      break;
    case SMALLINT:
      jj_consume_token(SMALLINT);
                                ppSet((String[]) null);
      break;
    case CHAR:
      jj_consume_token(CHAR);
                                        ppSet(bnf.parseDataTypePrimary(BNF.CHAR));
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LPAREN:
        jj_consume_token(LPAREN);
                                                        ppSet(bnf.parseDataTypePrimary(BNF.LPAREN));
        intVal();
                                                        ppAppend(bnf.parseDataTypePrimary(BNF.CHAR, BNF.intVal));
        jj_consume_token(RPAREN);
                                                        ppSet((String[]) null);
        break;
      default:
        jj_la1[277] = jj_gen;
        ;
      }
      break;
    case INTEGER:
      jj_consume_token(INTEGER);
                                ppSet((String[]) null);
      break;
    case LONG:
      jj_consume_token(LONG);
                                ppSet((String[]) null);
      break;
    case BIGINT:
      jj_consume_token(BIGINT);
                                ppSet((String[]) null);
      break;
    case BIGINTEGER:
      jj_consume_token(BIGINTEGER);
                                        ppSet(bnf.parseDataTypePrimary(BNF.BIGINTEGER));
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LPAREN:
        jj_consume_token(LPAREN);
                                                ppSet(bnf.parseDataTypePrimary(BNF.LPAREN));
        intVal();
                                                ppAppend(bnf.parseDataTypePrimary(BNF.BIGINTEGER, BNF.intVal));
        jj_consume_token(RPAREN);
                                                ppSet((String[]) null);
        break;
      default:
        jj_la1[278] = jj_gen;
        ;
      }
      break;
    case FLOAT:
      jj_consume_token(FLOAT);
                                ppSet((String[]) null);
      break;
    case REAL:
      jj_consume_token(REAL);
                                ppSet((String[]) null);
      break;
    case DOUBLE:
      jj_consume_token(DOUBLE);
                                ppSet((String[]) null);
      break;
    case BIGDECIMAL:
      jj_consume_token(BIGDECIMAL);
                                        ppSet(bnf.parseDataTypePrimary(BNF.BIGDECIMAL));
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LPAREN:
        jj_consume_token(LPAREN);
                                                ppSet(bnf.parseDataTypePrimary(BNF.LPAREN));
        intVal();
                                                ppAppend(bnf.parseDataTypePrimary(BNF.BIGDECIMAL, BNF.intVal));
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          jj_consume_token(COMMA);
                                                        ppSet(bnf.parseDataTypePrimary(BNF.COMMA));
          intVal();
                                                        ppAppend(bnf.parseDataTypePrimary(BNF.BIGDECIMAL, BNF.COMMA, BNF.intVal));
          break;
        default:
          jj_la1[279] = jj_gen;
          ;
        }
        jj_consume_token(RPAREN);
                                                ppSet((String[]) null);
        break;
      default:
        jj_la1[280] = jj_gen;
        ;
      }
      break;
    case DECIMAL:
      jj_consume_token(DECIMAL);
                                        ppSet(bnf.parseDataTypePrimary(BNF.DECIMAL));
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LPAREN:
        jj_consume_token(LPAREN);
                                                ppSet(bnf.parseDataTypePrimary(BNF.LPAREN));
        intVal();
                                                ppAppend(bnf.parseDataTypePrimary(BNF.DECIMAL, BNF.intVal));
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          jj_consume_token(COMMA);
                                                        ppSet(bnf.parseDataTypePrimary(BNF.COMMA));
          intVal();
                                                        ppAppend(bnf.parseDataTypePrimary(BNF.DECIMAL, BNF.COMMA, BNF.intVal));
          break;
        default:
          jj_la1[281] = jj_gen;
          ;
        }
        jj_consume_token(RPAREN);
                                                ppSet((String[]) null);
        break;
      default:
        jj_la1[282] = jj_gen;
        ;
      }
      break;
    case DATE:
      jj_consume_token(DATE);
                                ppSet((String[]) null);
      break;
    case TIME:
      jj_consume_token(TIME);
                                ppSet((String[]) null);
      break;
    case TIMESTAMP:
      jj_consume_token(TIMESTAMP);
                                ppSet((String[]) null);
      break;
    case OBJECT:
      jj_consume_token(OBJECT);
                                        ppSet(bnf.parseDataTypePrimary(BNF.OBJECT));
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LPAREN:
        jj_consume_token(LPAREN);
                                                        ppSet(bnf.parseDataTypePrimary(BNF.LPAREN));
        intVal();
                                                        ppAppend(bnf.parseDataTypePrimary(BNF.OBJECT, BNF.intVal));
        jj_consume_token(RPAREN);
                                                        ppSet((String[]) null);
        break;
      default:
        jj_la1[283] = jj_gen;
        ;
      }
      break;
    case BLOB:
      jj_consume_token(BLOB);
                                        ppSet(bnf.parseDataTypePrimary(BNF.BLOB));
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LPAREN:
        jj_consume_token(LPAREN);
                                                        ppSet(bnf.parseDataTypePrimary(BNF.LPAREN));
        intVal();
                                                        ppAppend(bnf.parseDataTypePrimary(BNF.BLOB, BNF.intVal));
        jj_consume_token(RPAREN);
                                                        ppSet((String[]) null);
        break;
      default:
        jj_la1[284] = jj_gen;
        ;
      }
      break;
    case CLOB:
      jj_consume_token(CLOB);
                                        ppSet(bnf.parseDataTypePrimary(BNF.CLOB));
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LPAREN:
        jj_consume_token(LPAREN);
                                                        ppSet(bnf.parseDataTypePrimary(BNF.LPAREN));
        intVal();
                                                        ppAppend(bnf.parseDataTypePrimary(BNF.CLOB, BNF.intVal));
        jj_consume_token(RPAREN);
                                                        ppSet((String[]) null);
        break;
      default:
        jj_la1[285] = jj_gen;
        ;
      }
      break;
    case VARBINARY:
      jj_consume_token(VARBINARY);
                                        ppSet(bnf.parseDataTypePrimary(BNF.VARBINARY));
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LPAREN:
        jj_consume_token(LPAREN);
                                                        ppSet(bnf.parseDataTypePrimary(BNF.LPAREN));
        intVal();
                                                        ppAppend(bnf.parseDataTypePrimary(BNF.VARBINARY, BNF.intVal));
        jj_consume_token(RPAREN);
                                                        ppSet((String[]) null);
        break;
      default:
        jj_la1[286] = jj_gen;
        ;
      }
      break;
    case XML:
      jj_consume_token(XML);
                                ppSet((String[]) null);
      break;
    default:
      jj_la1[287] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void parseDataType() throws ParseException {
    parseDataTypePrimary();
                        ppAppend(bnf.parseDataType(BNF.parseDataTypePrimary));
    label_42:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LSBRACE:
        ;
        break;
      default:
        jj_la1[288] = jj_gen;
        break label_42;
      }
      jj_consume_token(LSBRACE);
                                ppSet(bnf.parseDataType(BNF.LSBRACE));
      jj_consume_token(RSBRACE);
                                ppSet(bnf.parseDataType(BNF.RSBRACE));
                                requiresVersionAtLeast(Version.TEIID_8_5);
    }
  }

  final public void intervalType() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SQL_TSI_FRAC_SECOND:
      jj_consume_token(SQL_TSI_FRAC_SECOND);
      break;
    case SQL_TSI_SECOND:
      jj_consume_token(SQL_TSI_SECOND);
      break;
    case SQL_TSI_MINUTE:
      jj_consume_token(SQL_TSI_MINUTE);
      break;
    case SQL_TSI_HOUR:
      jj_consume_token(SQL_TSI_HOUR);
      break;
    case SQL_TSI_DAY:
      jj_consume_token(SQL_TSI_DAY);
      break;
    case SQL_TSI_WEEK:
      jj_consume_token(SQL_TSI_WEEK);
      break;
    case SQL_TSI_MONTH:
      jj_consume_token(SQL_TSI_MONTH);
      break;
    case SQL_TSI_QUARTER:
      jj_consume_token(SQL_TSI_QUARTER);
      break;
    case SQL_TSI_YEAR:
      jj_consume_token(SQL_TSI_YEAR);
      break;
    default:
      jj_la1[289] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
                        ppSet((String[]) null);
  }

  final public void nonNumericLiteral() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case STRINGVAL:
      stringVal();
                                ppAppend(bnf.nonNumericLiteral(BNF.stringVal));
      break;
    case BINARYSTRINGVAL:
      jj_consume_token(BINARYSTRINGVAL);
                                ppSet((String[]) null);
      break;
    case FALSE:
      jj_consume_token(FALSE);
                                ppSet((String[]) null);
      break;
    case TRUE:
      jj_consume_token(TRUE);
                                ppSet((String[]) null);
      break;
    case UNKNOWN:
      jj_consume_token(UNKNOWN);
                                ppSet((String[]) null);
      break;
    case NULL:
      jj_consume_token(NULL);
                                ppSet((String[]) null);
      break;
    case ESCAPEDTYPE:
      jj_consume_token(ESCAPEDTYPE);
                                        ppSet(bnf.nonNumericLiteral(BNF.ESCAPEDTYPE));
      stringVal();
                                        ppAppend(bnf.nonNumericLiteral(BNF.ESCAPEDTYPE, BNF.stringVal));
      jj_consume_token(RBRACE);
                                        ppSet((String[]) null);
      break;
    default:
      jj_la1[290] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void unsignedNumericLiteral() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case UNSIGNEDINTEGER:
      jj_consume_token(UNSIGNEDINTEGER);
      break;
    case FLOATVAL:
      jj_consume_token(FLOATVAL);
      break;
    case DECIMALVAL:
      jj_consume_token(DECIMALVAL);
      break;
    default:
      jj_la1[291] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
                        ppSet((String[]) null);
  }

  final public void columnList() throws ParseException {
    jj_consume_token(LPAREN);
                        ppSet(bnf.columnList(BNF.LPAREN));
    id();
                        ppAppend(bnf.columnList(BNF.id));
    label_43:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[292] = jj_gen;
        break label_43;
      }
      jj_consume_token(COMMA);
                                ppSet(bnf.columnList(BNF.COMMA));
      id();
                                ppAppend(bnf.columnList(BNF.id));
    }
    jj_consume_token(RPAREN);
                        ppSet((String[]) null);
  }

  private boolean jj_2_1(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_1(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(0, xla); }
  }

  private boolean jj_2_2(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_2(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(1, xla); }
  }

  private boolean jj_2_3(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_3(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(2, xla); }
  }

  private boolean jj_2_4(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_4(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(3, xla); }
  }

  private boolean jj_2_5(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_5(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(4, xla); }
  }

  private boolean jj_2_6(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_6(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(5, xla); }
  }

  private boolean jj_2_7(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_7(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(6, xla); }
  }

  private boolean jj_2_8(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_8(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(7, xla); }
  }

  private boolean jj_2_9(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_9(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(8, xla); }
  }

  private boolean jj_2_10(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_10(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(9, xla); }
  }

  private boolean jj_2_11(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_11(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(10, xla); }
  }

  private boolean jj_2_12(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_12(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(11, xla); }
  }

  private boolean jj_2_13(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_13(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(12, xla); }
  }

  private boolean jj_2_14(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_14(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(13, xla); }
  }

  private boolean jj_2_15(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_15(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(14, xla); }
  }

  private boolean jj_2_16(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_16(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(15, xla); }
  }

  private boolean jj_2_17(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_17(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(16, xla); }
  }

  private boolean jj_2_18(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_18(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(17, xla); }
  }

  private boolean jj_2_19(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_19(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(18, xla); }
  }

  private boolean jj_2_20(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_20(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(19, xla); }
  }

  private boolean jj_2_21(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_21(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(20, xla); }
  }

  private boolean jj_2_22(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_22(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(21, xla); }
  }

  private boolean jj_2_23(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_23(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(22, xla); }
  }

  private boolean jj_2_24(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_24(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(23, xla); }
  }

  private boolean jj_2_25(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_25(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(24, xla); }
  }

  private boolean jj_2_26(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_26(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(25, xla); }
  }

  private boolean jj_2_27(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_27(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(26, xla); }
  }

  private boolean jj_2_28(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_28(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(27, xla); }
  }

  private boolean jj_2_29(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_29(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(28, xla); }
  }

  private boolean jj_2_30(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_30(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(29, xla); }
  }

  private boolean jj_2_31(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_31(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(30, xla); }
  }

  private boolean jj_2_32(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_32(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(31, xla); }
  }

  private boolean jj_2_33(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_33(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(32, xla); }
  }

  private boolean jj_2_34(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_34(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(33, xla); }
  }

  private boolean jj_2_35(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_35(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(34, xla); }
  }

  private boolean jj_2_36(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_36(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(35, xla); }
  }

  private boolean jj_2_37(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_37(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(36, xla); }
  }

  private boolean jj_2_38(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_38(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(37, xla); }
  }

  private boolean jj_2_39(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_39(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(38, xla); }
  }

  private boolean jj_2_40(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_40(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(39, xla); }
  }

  private boolean jj_2_41(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_41(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(40, xla); }
  }

  private boolean jj_2_42(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_42(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(41, xla); }
  }

  private boolean jj_2_43(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_43(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(42, xla); }
  }

  private boolean jj_3R_302() {
    if (jj_scan_token(XMLTABLE)) return true;
    if (jj_scan_token(LPAREN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_499()) jj_scanpos = xsp;
    if (jj_3R_354()) return true;
    xsp = jj_scanpos;
    if (jj_3R_500()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_501()) jj_scanpos = xsp;
    if (jj_scan_token(RPAREN)) return true;
    xsp = jj_scanpos;
    if (jj_3R_502()) jj_scanpos = xsp;
    if (jj_3R_53()) return true;
    return false;
  }

  private boolean jj_3R_464() {
    if (jj_scan_token(LSBRACE)) return true;
    if (jj_scan_token(RSBRACE)) return true;
    return false;
  }

  private boolean jj_3R_360() {
    if (jj_3R_402()) return true;
    return false;
  }

  private boolean jj_3R_146() {
    if (jj_scan_token(ALTER)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_187()) {
    jj_scanpos = xsp;
    if (jj_3R_188()) {
    jj_scanpos = xsp;
    if (jj_3R_189()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_400() {
    if (jj_3R_148()) return true;
    return false;
  }

  private boolean jj_3_32() {
    if (jj_3R_73()) return true;
    return false;
  }

  private boolean jj_3_31() {
    if (jj_3R_65()) return true;
    return false;
  }

  private boolean jj_3R_548() {
    if (jj_scan_token(DEFAULT_KEYWORD)) return true;
    if (jj_3R_71()) return true;
    return false;
  }

  private boolean jj_3R_243() {
    if (jj_scan_token(INTERSECT)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_275()) jj_scanpos = xsp;
    if (jj_3R_240()) return true;
    return false;
  }

  private boolean jj_3R_399() {
    if (jj_scan_token(ID)) return true;
    return false;
  }

  private boolean jj_3R_359() {
    if (jj_3R_401()) return true;
    return false;
  }

  private boolean jj_3R_297() {
    if (jj_3R_335()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_464()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_559() {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_397()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_358() {
    if (jj_3R_65()) return true;
    return false;
  }

  private boolean jj_3_13() {
    if (jj_scan_token(OPTION)) return true;
    return false;
  }

  private boolean jj_3R_388() {
    if (jj_scan_token(XML)) return true;
    return false;
  }

  private boolean jj_3R_219() {
    if (jj_3R_240()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_243()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_228() {
    if (jj_3R_230()) return true;
    return false;
  }

  private boolean jj_3R_357() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_399()) {
    jj_scanpos = xsp;
    if (jj_3R_400()) return true;
    }
    return false;
  }

  private boolean jj_3R_505() {
    if (jj_3R_53()) return true;
    if (jj_3R_297()) return true;
    if (jj_3R_354()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_548()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_30() {
    if (jj_3R_72()) return true;
    return false;
  }

  private boolean jj_3R_227() {
    if (jj_3R_248()) return true;
    return false;
  }

  private boolean jj_3R_558() {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_397()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_507() {
    if (jj_scan_token(AS)) return true;
    return false;
  }

  private boolean jj_3R_226() {
    if (jj_3R_247()) return true;
    return false;
  }

  private boolean jj_3R_277() {
    if (jj_scan_token(DISTINCT)) return true;
    return false;
  }

  private boolean jj_3R_387() {
    if (jj_scan_token(VARBINARY)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_559()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_356() {
    if (jj_scan_token(ESCAPEDFUNCTION)) return true;
    if (jj_3R_70()) return true;
    if (jj_scan_token(RBRACE)) return true;
    return false;
  }

  private boolean jj_3R_246() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_276()) {
    jj_scanpos = xsp;
    if (jj_3R_277()) return true;
    }
    return false;
  }

  private boolean jj_3R_276() {
    if (jj_scan_token(ALL)) return true;
    return false;
  }

  private boolean jj_3R_355() {
    if (jj_3R_398()) return true;
    return false;
  }

  private boolean jj_3R_506() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_505()) return true;
    return false;
  }

  private boolean jj_3R_245() {
    if (jj_scan_token(EXCEPT)) return true;
    return false;
  }

  private boolean jj_3R_244() {
    if (jj_scan_token(UNION)) return true;
    return false;
  }

  private boolean jj_3R_329() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_355()) {
    jj_scanpos = xsp;
    if (jj_3R_356()) {
    jj_scanpos = xsp;
    if (jj_3_30()) {
    jj_scanpos = xsp;
    if (jj_3R_357()) {
    jj_scanpos = xsp;
    if (jj_3R_358()) {
    jj_scanpos = xsp;
    if (jj_3R_359()) {
    jj_scanpos = xsp;
    if (jj_3_32()) {
    jj_scanpos = xsp;
    if (jj_3R_360()) return true;
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_557() {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_397()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_147() {
    if (jj_scan_token(CREATE)) return true;
    if (jj_scan_token(TRIGGER)) return true;
    return false;
  }

  private boolean jj_3R_547() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_509()) return true;
    return false;
  }

  private boolean jj_3R_225() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_244()) {
    jj_scanpos = xsp;
    if (jj_3R_245()) return true;
    }
    xsp = jj_scanpos;
    if (jj_3R_246()) jj_scanpos = xsp;
    if (jj_3R_219()) return true;
    return false;
  }

  private boolean jj_3R_431() {
    if (jj_scan_token(COMMA)) return true;
    return false;
  }

  private boolean jj_3R_386() {
    if (jj_scan_token(CLOB)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_558()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_29() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_71()) return true;
    return false;
  }

  private boolean jj_3R_181() {
    if (jj_3R_219()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_225()) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3R_226()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_227()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_228()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_504() {
    if (jj_scan_token(PASSING)) return true;
    if (jj_3R_509()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_547()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_2() {
    if (jj_3R_44()) return true;
    return false;
  }

  private boolean jj_3R_556() {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_397()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_430() {
    if (jj_3R_71()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_29()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_385() {
    if (jj_scan_token(BLOB)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_557()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_503() {
    if (jj_scan_token(LANGUAGE)) return true;
    if (jj_3R_354()) return true;
    return false;
  }

  private boolean jj_3R_460() {
    if (jj_3R_459()) return true;
    return false;
  }

  private boolean jj_3R_242() {
    if (jj_3R_274()) return true;
    return false;
  }

  private boolean jj_3R_401() {
    if (jj_scan_token(LPAREN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_430()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_431()) jj_scanpos = xsp;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_218() {
    if (jj_3R_53()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_242()) jj_scanpos = xsp;
    if (jj_scan_token(AS)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_141()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_384() {
    if (jj_scan_token(OBJECT)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_556()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_59() {
    if (jj_scan_token(OBJECTTABLE)) return true;
    if (jj_scan_token(LPAREN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_503()) jj_scanpos = xsp;
    if (jj_3R_354()) return true;
    xsp = jj_scanpos;
    if (jj_3R_504()) jj_scanpos = xsp;
    if (jj_scan_token(COLUMNS)) return true;
    if (jj_3R_505()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_506()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(RPAREN)) return true;
    xsp = jj_scanpos;
    if (jj_3R_507()) jj_scanpos = xsp;
    if (jj_3R_53()) return true;
    return false;
  }

  private boolean jj_3R_383() {
    if (jj_scan_token(TIMESTAMP)) return true;
    return false;
  }

  private boolean jj_3_1() {
    if (jj_3R_44()) return true;
    return false;
  }

  private boolean jj_3R_224() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_218()) return true;
    return false;
  }

  private boolean jj_3R_458() {
    if (jj_3R_484()) return true;
    return false;
  }

  private boolean jj_3R_573() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_397()) return true;
    return false;
  }

  private boolean jj_3R_382() {
    if (jj_scan_token(TIME)) return true;
    return false;
  }

  private boolean jj_3_28() {
    if (jj_3R_70()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_460()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_381() {
    if (jj_scan_token(DATE)) return true;
    return false;
  }

  private boolean jj_3R_522() {
    if (jj_scan_token(EMPTY)) return true;
    return false;
  }

  private boolean jj_3R_457() {
    if (jj_3R_459()) return true;
    return false;
  }

  private boolean jj_3R_521() {
    if (jj_scan_token(NULL)) return true;
    return false;
  }

  private boolean jj_3R_98() {
    if (jj_3R_148()) return true;
    return false;
  }

  private boolean jj_3R_180() {
    if (jj_scan_token(WITH)) return true;
    if (jj_3R_218()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_224()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_555() {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_397()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_573()) jj_scanpos = xsp;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_97() {
    if (jj_scan_token(ID)) return true;
    return false;
  }

  private boolean jj_3R_456() {
    if (jj_3R_484()) return true;
    return false;
  }

  private boolean jj_3_27() {
    if (jj_3R_69()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_458()) jj_scanpos = xsp;
    if (jj_3R_459()) return true;
    return false;
  }

  private boolean jj_3R_481() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_521()) {
    jj_scanpos = xsp;
    if (jj_3R_522()) return true;
    }
    if (jj_scan_token(ON)) return true;
    if (jj_scan_token(EMPTY)) return true;
    return false;
  }

  private boolean jj_3R_141() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_180()) jj_scanpos = xsp;
    if (jj_3R_181()) return true;
    return false;
  }

  private boolean jj_3R_68() {
    if (jj_3R_115()) return true;
    return false;
  }

  private boolean jj_3R_520() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_509()) return true;
    return false;
  }

  private boolean jj_3R_53() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_97()) {
    jj_scanpos = xsp;
    if (jj_3R_98()) return true;
    }
    return false;
  }

  private boolean jj_3R_67() {
    if (jj_3R_114()) return true;
    return false;
  }

  private boolean jj_3R_572() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_397()) return true;
    return false;
  }

  private boolean jj_3R_66() {
    if (jj_3R_113()) return true;
    return false;
  }

  private boolean jj_3R_380() {
    if (jj_scan_token(DECIMAL)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_555()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_480() {
    if (jj_scan_token(PASSING)) return true;
    if (jj_3R_509()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_520()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_554() {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_397()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_572()) jj_scanpos = xsp;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3_26() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_66()) {
    jj_scanpos = xsp;
    if (jj_3R_67()) {
    jj_scanpos = xsp;
    if (jj_3R_68()) return true;
    }
    }
    xsp = jj_scanpos;
    if (jj_3R_456()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_457()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_145() {
    if (jj_scan_token(DELETE)) return true;
    if (jj_scan_token(FROM)) return true;
    return false;
  }

  private boolean jj_3R_479() {
    if (jj_3R_82()) return true;
    if (jj_scan_token(COMMA)) return true;
    return false;
  }

  private boolean jj_3R_72() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_26()) {
    jj_scanpos = xsp;
    if (jj_3_27()) {
    jj_scanpos = xsp;
    if (jj_3_28()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_379() {
    if (jj_scan_token(BIGDECIMAL)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_554()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_175() {
    if (jj_scan_token(XMLQUERY)) return true;
    if (jj_scan_token(LPAREN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_479()) jj_scanpos = xsp;
    if (jj_3R_354()) return true;
    xsp = jj_scanpos;
    if (jj_3R_480()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_481()) jj_scanpos = xsp;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_416() {
    if (jj_scan_token(DOLLAR)) return true;
    if (jj_3R_397()) return true;
    return false;
  }

  private boolean jj_3R_378() {
    if (jj_scan_token(DOUBLE)) return true;
    return false;
  }

  private boolean jj_3R_487() {
    if (jj_scan_token(LSBRACE)) return true;
    if (jj_3R_155()) return true;
    if (jj_scan_token(RSBRACE)) return true;
    return false;
  }

  private boolean jj_3R_569() {
    if (jj_scan_token(SELECTOR)) return true;
    if (jj_3R_354()) return true;
    if (jj_3R_397()) return true;
    return false;
  }

  private boolean jj_3R_398() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_415()) {
    jj_scanpos = xsp;
    if (jj_3R_416()) return true;
    }
    return false;
  }

  private boolean jj_3R_415() {
    if (jj_scan_token(QMARK)) return true;
    return false;
  }

  private boolean jj_3R_377() {
    if (jj_scan_token(REAL)) return true;
    return false;
  }

  private boolean jj_3_20() {
    if (jj_scan_token(NO)) return true;
    if (jj_scan_token(TRIM)) return true;
    return false;
  }

  private boolean jj_3R_376() {
    if (jj_scan_token(FLOAT)) return true;
    return false;
  }

  private boolean jj_3R_553() {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_397()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_144() {
    if (jj_scan_token(UPDATE)) return true;
    if (jj_3R_53()) return true;
    return false;
  }

  private boolean jj_3R_291() {
    if (jj_3R_329()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_487()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_290() {
    if (jj_3R_328()) return true;
    return false;
  }

  private boolean jj_3R_568() {
    if (jj_scan_token(WIDTH)) return true;
    if (jj_3R_397()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_20()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_284() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_71()) return true;
    return false;
  }

  private boolean jj_3R_289() {
    if (jj_3R_327()) return true;
    return false;
  }

  private boolean jj_3R_375() {
    if (jj_scan_token(BIGINTEGER)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_553()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_374() {
    if (jj_scan_token(BIGINT)) return true;
    return false;
  }

  private boolean jj_3R_552() {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_397()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_251() {
    if (jj_3R_71()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_284()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_254() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_289()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_290()) {
    jj_scanpos = xsp;
    if (jj_3R_291()) return true;
    }
    return false;
  }

  private boolean jj_3_12() {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_53()) return true;
    return false;
  }

  private boolean jj_3R_373() {
    if (jj_scan_token(LONG)) return true;
    return false;
  }

  private boolean jj_3R_253() {
    if (jj_3R_288()) return true;
    return false;
  }

  private boolean jj_3R_539() {
    if (jj_3R_297()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_568()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_569()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_372() {
    if (jj_scan_token(INTEGER)) return true;
    return false;
  }

  private boolean jj_3R_231() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_253()) {
    jj_scanpos = xsp;
    if (jj_3R_254()) return true;
    }
    return false;
  }

  private boolean jj_3R_538() {
    if (jj_scan_token(FOR)) return true;
    if (jj_scan_token(ORDINALITY)) return true;
    return false;
  }

  private boolean jj_3R_435() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(399)) {
    jj_scanpos = xsp;
    if (jj_scan_token(400)) return true;
    }
    return false;
  }

  private boolean jj_3R_371() {
    if (jj_scan_token(CHAR)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_552()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_489() {
    if (jj_3R_53()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_538()) {
    jj_scanpos = xsp;
    if (jj_3R_539()) return true;
    }
    return false;
  }

  private boolean jj_3R_186() {
    if (jj_scan_token(MERGE)) return true;
    return false;
  }

  private boolean jj_3R_426() {
    if (jj_3R_435()) return true;
    if (jj_3R_231()) return true;
    return false;
  }

  private boolean jj_3R_370() {
    if (jj_scan_token(SMALLINT)) return true;
    return false;
  }

  private boolean jj_3R_185() {
    if (jj_scan_token(INSERT)) return true;
    return false;
  }

  private boolean jj_3R_496() {
    if (jj_scan_token(AS)) return true;
    return false;
  }

  private boolean jj_3R_369() {
    if (jj_scan_token(SHORT)) return true;
    return false;
  }

  private boolean jj_3R_368() {
    if (jj_scan_token(TINYINT)) return true;
    return false;
  }

  private boolean jj_3R_283() {
    if (jj_scan_token(GT)) return true;
    return false;
  }

  private boolean jj_3R_143() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_185()) {
    jj_scanpos = xsp;
    if (jj_3R_186()) return true;
    }
    if (jj_scan_token(INTO)) return true;
    return false;
  }

  private boolean jj_3R_551() {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_397()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_367() {
    if (jj_scan_token(BYTE)) return true;
    return false;
  }

  private boolean jj_3R_366() {
    if (jj_scan_token(BOOLEAN)) return true;
    return false;
  }

  private boolean jj_3R_198() {
    if (jj_3R_231()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_426()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_543() {
    if (jj_3R_397()) return true;
    return false;
  }

  private boolean jj_3R_495() {
    if (jj_scan_token(SKIP_KEYWORD)) return true;
    if (jj_3R_397()) return true;
    return false;
  }

  private boolean jj_3R_148() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(294)) {
    jj_scanpos = xsp;
    if (jj_scan_token(297)) {
    jj_scanpos = xsp;
    if (jj_scan_token(295)) {
    jj_scanpos = xsp;
    if (jj_scan_token(296)) {
    jj_scanpos = xsp;
    if (jj_scan_token(298)) {
    jj_scanpos = xsp;
    if (jj_scan_token(299)) {
    jj_scanpos = xsp;
    if (jj_scan_token(300)) {
    jj_scanpos = xsp;
    if (jj_scan_token(301)) {
    jj_scanpos = xsp;
    if (jj_scan_token(302)) {
    jj_scanpos = xsp;
    if (jj_scan_token(303)) {
    jj_scanpos = xsp;
    if (jj_scan_token(304)) {
    jj_scanpos = xsp;
    if (jj_scan_token(305)) {
    jj_scanpos = xsp;
    if (jj_scan_token(306)) {
    jj_scanpos = xsp;
    if (jj_scan_token(307)) {
    jj_scanpos = xsp;
    if (jj_scan_token(308)) {
    jj_scanpos = xsp;
    if (jj_scan_token(309)) {
    jj_scanpos = xsp;
    if (jj_scan_token(310)) {
    jj_scanpos = xsp;
    if (jj_scan_token(311)) {
    jj_scanpos = xsp;
    if (jj_scan_token(312)) {
    jj_scanpos = xsp;
    if (jj_scan_token(313)) {
    jj_scanpos = xsp;
    if (jj_scan_token(314)) {
    jj_scanpos = xsp;
    if (jj_scan_token(315)) {
    jj_scanpos = xsp;
    if (jj_scan_token(316)) {
    jj_scanpos = xsp;
    if (jj_scan_token(317)) {
    jj_scanpos = xsp;
    if (jj_scan_token(318)) {
    jj_scanpos = xsp;
    if (jj_scan_token(319)) {
    jj_scanpos = xsp;
    if (jj_scan_token(320)) {
    jj_scanpos = xsp;
    if (jj_scan_token(321)) {
    jj_scanpos = xsp;
    if (jj_scan_token(322)) {
    jj_scanpos = xsp;
    if (jj_scan_token(323)) {
    jj_scanpos = xsp;
    if (jj_scan_token(324)) {
    jj_scanpos = xsp;
    if (jj_scan_token(325)) {
    jj_scanpos = xsp;
    if (jj_scan_token(326)) {
    jj_scanpos = xsp;
    if (jj_scan_token(327)) {
    jj_scanpos = xsp;
    if (jj_scan_token(328)) {
    jj_scanpos = xsp;
    if (jj_scan_token(329)) {
    jj_scanpos = xsp;
    if (jj_scan_token(330)) {
    jj_scanpos = xsp;
    if (jj_scan_token(331)) {
    jj_scanpos = xsp;
    if (jj_scan_token(332)) {
    jj_scanpos = xsp;
    if (jj_scan_token(333)) {
    jj_scanpos = xsp;
    if (jj_scan_token(334)) {
    jj_scanpos = xsp;
    if (jj_scan_token(335)) {
    jj_scanpos = xsp;
    if (jj_scan_token(336)) {
    jj_scanpos = xsp;
    if (jj_scan_token(337)) {
    jj_scanpos = xsp;
    if (jj_scan_token(338)) {
    jj_scanpos = xsp;
    if (jj_scan_token(339)) {
    jj_scanpos = xsp;
    if (jj_scan_token(340)) {
    jj_scanpos = xsp;
    if (jj_scan_token(341)) {
    jj_scanpos = xsp;
    if (jj_scan_token(342)) {
    jj_scanpos = xsp;
    if (jj_scan_token(343)) {
    jj_scanpos = xsp;
    if (jj_scan_token(344)) {
    jj_scanpos = xsp;
    if (jj_scan_token(345)) {
    jj_scanpos = xsp;
    if (jj_scan_token(346)) {
    jj_scanpos = xsp;
    if (jj_scan_token(347)) {
    jj_scanpos = xsp;
    if (jj_scan_token(348)) {
    jj_scanpos = xsp;
    if (jj_scan_token(349)) {
    jj_scanpos = xsp;
    if (jj_scan_token(350)) {
    jj_scanpos = xsp;
    if (jj_scan_token(351)) {
    jj_scanpos = xsp;
    if (jj_scan_token(352)) {
    jj_scanpos = xsp;
    if (jj_scan_token(353)) {
    jj_scanpos = xsp;
    if (jj_scan_token(354)) {
    jj_scanpos = xsp;
    if (jj_scan_token(355)) {
    jj_scanpos = xsp;
    if (jj_scan_token(356)) {
    jj_scanpos = xsp;
    if (jj_scan_token(357)) {
    jj_scanpos = xsp;
    if (jj_scan_token(358)) {
    jj_scanpos = xsp;
    if (jj_scan_token(359)) {
    jj_scanpos = xsp;
    if (jj_scan_token(360)) {
    jj_scanpos = xsp;
    if (jj_scan_token(361)) {
    jj_scanpos = xsp;
    if (jj_scan_token(362)) {
    jj_scanpos = xsp;
    if (jj_scan_token(363)) {
    jj_scanpos = xsp;
    if (jj_scan_token(365)) {
    jj_scanpos = xsp;
    if (jj_scan_token(364)) {
    jj_scanpos = xsp;
    if (jj_scan_token(366)) {
    jj_scanpos = xsp;
    if (jj_scan_token(367)) {
    jj_scanpos = xsp;
    if (jj_scan_token(368)) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_250() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_53()) return true;
    if (jj_scan_token(EQ)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_283()) jj_scanpos = xsp;
    if (jj_3R_71()) return true;
    return false;
  }

  private boolean jj_3R_494() {
    if (jj_scan_token(HEADER)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_543()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_327() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(401)) {
    jj_scanpos = xsp;
    if (jj_scan_token(402)) return true;
    }
    return false;
  }

  private boolean jj_3R_550() {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_397()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_417() {
    if (jj_3R_327()) return true;
    if (jj_3R_198()) return true;
    return false;
  }

  private boolean jj_3R_354() {
    if (jj_scan_token(STRINGVAL)) return true;
    return false;
  }

  private boolean jj_3R_365() {
    if (jj_scan_token(VARCHAR)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_551()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_249() {
    if (jj_scan_token(GT)) return true;
    return false;
  }

  private boolean jj_3R_542() {
    if (jj_scan_token(QUOTE)) return true;
    if (jj_3R_540()) return true;
    return false;
  }

  private boolean jj_3R_541() {
    if (jj_scan_token(ESCAPE)) return true;
    if (jj_3R_540()) return true;
    return false;
  }

  private boolean jj_3R_493() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_541()) {
    jj_scanpos = xsp;
    if (jj_3R_542()) return true;
    }
    return false;
  }

  private boolean jj_3R_155() {
    if (jj_3R_198()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_417()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_403() {
    if (jj_scan_token(CONCAT_OP)) return true;
    if (jj_3R_155()) return true;
    return false;
  }

  private boolean jj_3R_364() {
    if (jj_scan_token(STRING)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_550()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_492() {
    if (jj_scan_token(DELIMITER)) return true;
    if (jj_3R_540()) return true;
    return false;
  }

  private boolean jj_3R_54() {
    if (jj_3R_53()) return true;
    if (jj_scan_token(EQ)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_249()) jj_scanpos = xsp;
    if (jj_3R_71()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_250()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_229() {
    if (jj_3R_251()) return true;
    return false;
  }

  private boolean jj_3R_335() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_364()) {
    jj_scanpos = xsp;
    if (jj_3R_365()) {
    jj_scanpos = xsp;
    if (jj_3R_366()) {
    jj_scanpos = xsp;
    if (jj_3R_367()) {
    jj_scanpos = xsp;
    if (jj_3R_368()) {
    jj_scanpos = xsp;
    if (jj_3R_369()) {
    jj_scanpos = xsp;
    if (jj_3R_370()) {
    jj_scanpos = xsp;
    if (jj_3R_371()) {
    jj_scanpos = xsp;
    if (jj_3R_372()) {
    jj_scanpos = xsp;
    if (jj_3R_373()) {
    jj_scanpos = xsp;
    if (jj_3R_374()) {
    jj_scanpos = xsp;
    if (jj_3R_375()) {
    jj_scanpos = xsp;
    if (jj_3R_376()) {
    jj_scanpos = xsp;
    if (jj_3R_377()) {
    jj_scanpos = xsp;
    if (jj_3R_378()) {
    jj_scanpos = xsp;
    if (jj_3R_379()) {
    jj_scanpos = xsp;
    if (jj_3R_380()) {
    jj_scanpos = xsp;
    if (jj_3R_381()) {
    jj_scanpos = xsp;
    if (jj_3R_382()) {
    jj_scanpos = xsp;
    if (jj_3R_383()) {
    jj_scanpos = xsp;
    if (jj_3R_384()) {
    jj_scanpos = xsp;
    if (jj_3R_385()) {
    jj_scanpos = xsp;
    if (jj_3R_386()) {
    jj_scanpos = xsp;
    if (jj_3R_387()) {
    jj_scanpos = xsp;
    if (jj_3R_388()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_197() {
    if (jj_3R_230()) return true;
    return false;
  }

  private boolean jj_3R_196() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_229()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_11() {
    if (jj_3R_54()) return true;
    return false;
  }

  private boolean jj_3R_491() {
    if (jj_scan_token(NO)) return true;
    if (jj_scan_token(ROW)) return true;
    if (jj_scan_token(DELIMITER)) return true;
    return false;
  }

  private boolean jj_3R_106() {
    if (jj_3R_155()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_403()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_576() {
    if (jj_scan_token(DEFAULT_KEYWORD)) return true;
    if (jj_3R_354()) return true;
    return false;
  }

  private boolean jj_3R_490() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_489()) return true;
    return false;
  }

  private boolean jj_3R_353() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_53()) return true;
    return false;
  }

  private boolean jj_3R_71() {
    if (jj_3R_131()) return true;
    return false;
  }

  private boolean jj_3R_184() {
    if (jj_scan_token(CALL)) return true;
    return false;
  }

  private boolean jj_3R_183() {
    if (jj_scan_token(EXECUTE)) return true;
    return false;
  }

  private boolean jj_3R_575() {
    if (jj_scan_token(NO)) return true;
    if (jj_scan_token(DEFAULT_KEYWORD)) return true;
    return false;
  }

  private boolean jj_3R_182() {
    if (jj_scan_token(EXEC)) return true;
    return false;
  }

  private boolean jj_3R_319() {
    if (jj_3R_53()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_353()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_488() {
    if (jj_scan_token(SELECTOR)) return true;
    if (jj_3R_354()) return true;
    return false;
  }

  private boolean jj_3R_574() {
    if (jj_3R_354()) return true;
    if (jj_scan_token(AS)) return true;
    if (jj_3R_53()) return true;
    return false;
  }

  private boolean jj_3R_561() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_574()) {
    jj_scanpos = xsp;
    if (jj_3R_575()) {
    jj_scanpos = xsp;
    if (jj_3R_576()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_287() {
    if (jj_scan_token(NOCACHE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_319()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_318() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_53()) return true;
    return false;
  }

  private boolean jj_3R_142() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_182()) {
    jj_scanpos = xsp;
    if (jj_3R_183()) {
    jj_scanpos = xsp;
    if (jj_3R_184()) return true;
    }
    }
    if (jj_3R_53()) return true;
    if (jj_scan_token(LPAREN)) return true;
    xsp = jj_scanpos;
    if (jj_3_11()) {
    jj_scanpos = xsp;
    if (jj_3R_196()) return true;
    }
    if (jj_scan_token(RPAREN)) return true;
    xsp = jj_scanpos;
    if (jj_3R_197()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_562() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_561()) return true;
    return false;
  }

  private boolean jj_3R_57() {
    if (jj_scan_token(TEXTTABLE)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_106()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_488()) jj_scanpos = xsp;
    if (jj_scan_token(COLUMNS)) return true;
    if (jj_3R_489()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_490()) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3R_491()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_492()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_493()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_494()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_495()) jj_scanpos = xsp;
    if (jj_scan_token(RPAREN)) return true;
    xsp = jj_scanpos;
    if (jj_3R_496()) jj_scanpos = xsp;
    if (jj_3R_53()) return true;
    return false;
  }

  private boolean jj_3R_286() {
    if (jj_scan_token(MAKENOTDEP)) return true;
    if (jj_3R_53()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_318()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_10() {
    if (jj_3R_54()) return true;
    return false;
  }

  private boolean jj_3R_317() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_53()) return true;
    return false;
  }

  private boolean jj_3R_498() {
    if (jj_scan_token(AS)) return true;
    return false;
  }

  private boolean jj_3R_82() {
    if (jj_scan_token(XMLNAMESPACES)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_561()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_562()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_252() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_285()) {
    jj_scanpos = xsp;
    if (jj_3R_286()) {
    jj_scanpos = xsp;
    if (jj_3R_287()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_285() {
    if (jj_scan_token(MAKEDEP)) return true;
    if (jj_3R_53()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_317()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_230() {
    if (jj_scan_token(OPTION)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_252()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_472() {
    if (jj_3R_82()) return true;
    if (jj_scan_token(COMMA)) return true;
    return false;
  }

  private boolean jj_3R_58() {
    if (jj_scan_token(ARRAYTABLE)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_231()) return true;
    if (jj_scan_token(COLUMNS)) return true;
    if (jj_3R_497()) return true;
    if (jj_scan_token(RPAREN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_498()) jj_scanpos = xsp;
    if (jj_3R_53()) return true;
    return false;
  }

  private boolean jj_3R_352() {
    if (jj_scan_token(ROWS)) return true;
    return false;
  }

  private boolean jj_3R_519() {
    if (jj_scan_token(EXCLUDING)) return true;
    return false;
  }

  private boolean jj_3R_351() {
    if (jj_scan_token(ROW)) return true;
    return false;
  }

  private boolean jj_3R_518() {
    if (jj_scan_token(INCLUDING)) return true;
    return false;
  }

  private boolean jj_3R_350() {
    if (jj_3R_311()) return true;
    return false;
  }

  private boolean jj_3R_172() {
    if (jj_scan_token(XMLFOREST)) return true;
    if (jj_scan_token(LPAREN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_472()) jj_scanpos = xsp;
    if (jj_3R_473()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_478() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_518()) {
    jj_scanpos = xsp;
    if (jj_3R_519()) return true;
    }
    if (jj_scan_token(XMLDECLARATION)) return true;
    return false;
  }

  private boolean jj_3R_349() {
    if (jj_scan_token(NEXT)) return true;
    return false;
  }

  private boolean jj_3_9() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_53()) return true;
    if (jj_3R_297()) return true;
    return false;
  }

  private boolean jj_3R_348() {
    if (jj_scan_token(FIRST)) return true;
    return false;
  }

  private boolean jj_3R_510() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_509()) return true;
    return false;
  }

  private boolean jj_3R_477() {
    if (jj_scan_token(VERSION)) return true;
    if (jj_3R_354()) return true;
    return false;
  }

  private boolean jj_3R_315() {
    if (jj_3R_316()) return true;
    return false;
  }

  private boolean jj_3R_316() {
    if (jj_scan_token(FETCH)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_348()) {
    jj_scanpos = xsp;
    if (jj_3R_349()) return true;
    }
    xsp = jj_scanpos;
    if (jj_3R_350()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_351()) {
    jj_scanpos = xsp;
    if (jj_3R_352()) return true;
    }
    if (jj_scan_token(ONLY)) return true;
    return false;
  }

  private boolean jj_3R_473() {
    if (jj_3R_509()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_510()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_497() {
    if (jj_3R_53()) return true;
    if (jj_3R_297()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_9()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_517() {
    if (jj_scan_token(BLOB)) return true;
    return false;
  }

  private boolean jj_3R_476() {
    if (jj_scan_token(ENCODING)) return true;
    if (jj_3R_53()) return true;
    return false;
  }

  private boolean jj_3R_314() {
    if (jj_scan_token(ROWS)) return true;
    return false;
  }

  private boolean jj_3R_282() {
    if (jj_3R_316()) return true;
    return false;
  }

  private boolean jj_3R_516() {
    if (jj_scan_token(VARBINARY)) return true;
    return false;
  }

  private boolean jj_3R_313() {
    if (jj_scan_token(ROW)) return true;
    return false;
  }

  private boolean jj_3R_515() {
    if (jj_scan_token(CLOB)) return true;
    return false;
  }

  private boolean jj_3R_514() {
    if (jj_scan_token(VARCHAR)) return true;
    return false;
  }

  private boolean jj_3R_513() {
    if (jj_scan_token(STRING)) return true;
    return false;
  }

  private boolean jj_3R_173() {
    if (jj_scan_token(JSONOBJECT)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_473()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_312() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_311()) return true;
    return false;
  }

  private boolean jj_3R_475() {
    if (jj_scan_token(AS)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_513()) {
    jj_scanpos = xsp;
    if (jj_3R_514()) {
    jj_scanpos = xsp;
    if (jj_3R_515()) {
    jj_scanpos = xsp;
    if (jj_3R_516()) {
    jj_scanpos = xsp;
    if (jj_3R_517()) return true;
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_281() {
    if (jj_scan_token(OFFSET)) return true;
    if (jj_3R_311()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_313()) {
    jj_scanpos = xsp;
    if (jj_3R_314()) return true;
    }
    xsp = jj_scanpos;
    if (jj_3R_315()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_512() {
    if (jj_scan_token(CONTENT)) return true;
    return false;
  }

  private boolean jj_3R_563() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_509()) return true;
    return false;
  }

  private boolean jj_3R_511() {
    if (jj_scan_token(DOCUMENT)) return true;
    return false;
  }

  private boolean jj_3R_474() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_511()) {
    jj_scanpos = xsp;
    if (jj_3R_512()) return true;
    }
    return false;
  }

  private boolean jj_3R_280() {
    if (jj_scan_token(LIMIT)) return true;
    if (jj_3R_311()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_312()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_83() {
    if (jj_scan_token(XMLATTRIBUTES)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_509()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_563()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_248() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_280()) {
    jj_scanpos = xsp;
    if (jj_3R_281()) {
    jj_scanpos = xsp;
    if (jj_3R_282()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_174() {
    if (jj_scan_token(XMLSERIALIZE)) return true;
    if (jj_scan_token(LPAREN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_474()) jj_scanpos = xsp;
    if (jj_3R_71()) return true;
    xsp = jj_scanpos;
    if (jj_3R_475()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_476()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_477()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_478()) jj_scanpos = xsp;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_347() {
    if (jj_3R_329()) return true;
    return false;
  }

  private boolean jj_3R_311() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_346()) {
    jj_scanpos = xsp;
    if (jj_3R_347()) return true;
    }
    return false;
  }

  private boolean jj_3R_346() {
    if (jj_3R_397()) return true;
    return false;
  }

  private boolean jj_3R_463() {
    if (jj_scan_token(MAKENOTDEP)) return true;
    return false;
  }

  private boolean jj_3R_471() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_71()) return true;
    return false;
  }

  private boolean jj_3R_437() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_462()) {
    jj_scanpos = xsp;
    if (jj_3R_463()) return true;
    }
    return false;
  }

  private boolean jj_3R_462() {
    if (jj_scan_token(MAKEDEP)) return true;
    return false;
  }

  private boolean jj_3R_308() {
    if (jj_3R_71()) return true;
    return false;
  }

  private boolean jj_3R_345() {
    if (jj_scan_token(LAST)) return true;
    return false;
  }

  private boolean jj_3_43() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_83()) return true;
    return false;
  }

  private boolean jj_3R_344() {
    if (jj_scan_token(FIRST)) return true;
    return false;
  }

  private boolean jj_3R_363() {
    if (jj_scan_token(IMMEDIATE)) return true;
    return false;
  }

  private boolean jj_3_19() {
    if (jj_3R_60()) return true;
    return false;
  }

  private boolean jj_3R_273() {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_223()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_362() {
    if (jj_scan_token(STRING)) return true;
    return false;
  }

  private boolean jj_3_42() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_82()) return true;
    return false;
  }

  private boolean jj_3R_310() {
    if (jj_scan_token(NULLS)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_344()) {
    jj_scanpos = xsp;
    if (jj_3R_345()) return true;
    }
    return false;
  }

  private boolean jj_3R_272() {
    if (jj_3R_60()) return true;
    return false;
  }

  private boolean jj_3R_470() {
    if (jj_scan_token(NAME)) return true;
    return false;
  }

  private boolean jj_3R_333() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_362()) {
    jj_scanpos = xsp;
    if (jj_3R_363()) return true;
    }
    return false;
  }

  private boolean jj_3R_343() {
    if (jj_scan_token(DESC)) return true;
    return false;
  }

  private boolean jj_3R_271() {
    if (jj_3R_303()) return true;
    return false;
  }

  private boolean jj_3R_309() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_342()) {
    jj_scanpos = xsp;
    if (jj_3R_343()) return true;
    }
    return false;
  }

  private boolean jj_3R_342() {
    if (jj_scan_token(ASC)) return true;
    return false;
  }

  private boolean jj_3R_332() {
    if (jj_scan_token(EXEC)) return true;
    return false;
  }

  private boolean jj_3_18() {
    if (jj_3R_59()) return true;
    return false;
  }

  private boolean jj_3R_331() {
    if (jj_scan_token(EXECUTE)) return true;
    return false;
  }

  private boolean jj_3R_270() {
    if (jj_3R_302()) return true;
    return false;
  }

  private boolean jj_3_17() {
    if (jj_3R_58()) return true;
    return false;
  }

  private boolean jj_3R_278() {
    if (jj_3R_308()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_309()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_310()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_294() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_331()) {
    jj_scanpos = xsp;
    if (jj_3R_332()) return true;
    }
    xsp = jj_scanpos;
    if (jj_3R_333()) jj_scanpos = xsp;
    if (jj_3R_71()) return true;
    return false;
  }

  private boolean jj_3_16() {
    if (jj_3R_57()) return true;
    return false;
  }

  private boolean jj_3R_171() {
    if (jj_scan_token(XMLELEMENT)) return true;
    if (jj_scan_token(LPAREN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_470()) jj_scanpos = xsp;
    if (jj_3R_53()) return true;
    xsp = jj_scanpos;
    if (jj_3_42()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_43()) jj_scanpos = xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_471()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_52() {
    if (jj_scan_token(VIRTUAL)) return true;
    return false;
  }

  private boolean jj_3R_279() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_278()) return true;
    return false;
  }

  private boolean jj_3R_241() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_16()) {
    jj_scanpos = xsp;
    if (jj_3_17()) {
    jj_scanpos = xsp;
    if (jj_3R_270()) {
    jj_scanpos = xsp;
    if (jj_3_18()) {
    jj_scanpos = xsp;
    if (jj_3R_271()) {
    jj_scanpos = xsp;
    if (jj_3R_272()) {
    jj_scanpos = xsp;
    if (jj_3R_273()) return true;
    }
    }
    }
    }
    }
    }
    xsp = jj_scanpos;
    if (jj_3R_437()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_222() {
    if (jj_scan_token(OUTER)) return true;
    return false;
  }

  private boolean jj_3R_193() {
    if (jj_scan_token(INNER)) return true;
    return false;
  }

  private boolean jj_3R_466() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_509()) return true;
    return false;
  }

  private boolean jj_3_8() {
    if (jj_scan_token(CREATE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_52()) jj_scanpos = xsp;
    if (jj_scan_token(PROCEDURE)) return true;
    return false;
  }

  private boolean jj_3R_221() {
    if (jj_scan_token(OUTER)) return true;
    return false;
  }

  private boolean jj_3R_247() {
    if (jj_scan_token(ORDER)) return true;
    if (jj_scan_token(BY)) return true;
    if (jj_3R_278()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_279()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_192() {
    if (jj_scan_token(FULL)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_222()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_80() {
    if (jj_scan_token(QUERYSTRING)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_71()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_466()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_220() {
    if (jj_scan_token(OUTER)) return true;
    return false;
  }

  private boolean jj_3R_84() {
    if (jj_scan_token(VIRTUAL)) return true;
    return false;
  }

  private boolean jj_3R_396() {
    if (jj_scan_token(HAVING)) return true;
    if (jj_3R_131()) return true;
    return false;
  }

  private boolean jj_3R_191() {
    if (jj_scan_token(LEFT)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_221()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_469() {
    if (jj_scan_token(WELLFORMED)) return true;
    return false;
  }

  private boolean jj_3R_413() {
    if (jj_3R_251()) return true;
    return false;
  }

  private boolean jj_3R_44() {
    if (jj_scan_token(CREATE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_84()) jj_scanpos = xsp;
    if (jj_scan_token(PROCEDURE)) return true;
    return false;
  }

  private boolean jj_3R_468() {
    if (jj_scan_token(CONTENT)) return true;
    return false;
  }

  private boolean jj_3R_190() {
    if (jj_scan_token(RIGHT)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_220()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_151() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_190()) {
    jj_scanpos = xsp;
    if (jj_3R_191()) {
    jj_scanpos = xsp;
    if (jj_3R_192()) {
    jj_scanpos = xsp;
    if (jj_3R_193()) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_467() {
    if (jj_scan_token(DOCUMENT)) return true;
    return false;
  }

  private boolean jj_3R_412() {
    if (jj_scan_token(ROLLUP)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_251()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_455() {
    if (jj_3R_484()) return true;
    return false;
  }

  private boolean jj_3R_258() {
    if (jj_3R_294()) return true;
    return false;
  }

  private boolean jj_3R_100() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_151()) jj_scanpos = xsp;
    if (jj_scan_token(JOIN)) return true;
    if (jj_3R_152()) return true;
    if (jj_scan_token(ON)) return true;
    if (jj_3R_131()) return true;
    return false;
  }

  private boolean jj_3R_170() {
    if (jj_scan_token(XMLPARSE)) return true;
    if (jj_scan_token(LPAREN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_467()) {
    jj_scanpos = xsp;
    if (jj_3R_468()) return true;
    }
    if (jj_3R_71()) return true;
    xsp = jj_scanpos;
    if (jj_3R_469()) jj_scanpos = xsp;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3_7() {
    if (jj_3R_51()) return true;
    return false;
  }

  private boolean jj_3R_454() {
    if (jj_3R_247()) return true;
    return false;
  }

  private boolean jj_3R_150() {
    if (jj_scan_token(UNION)) return true;
    return false;
  }

  private boolean jj_3R_395() {
    if (jj_scan_token(GROUP)) return true;
    if (jj_scan_token(BY)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_412()) {
    jj_scanpos = xsp;
    if (jj_3R_413()) return true;
    }
    return false;
  }

  private boolean jj_3R_149() {
    if (jj_scan_token(CROSS)) return true;
    return false;
  }

  private boolean jj_3R_453() {
    if (jj_3R_251()) return true;
    return false;
  }

  private boolean jj_3_6() {
    if (jj_scan_token(INSERT)) return true;
    if (jj_scan_token(INTO)) return true;
    return false;
  }

  private boolean jj_3R_234() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_7()) {
    jj_scanpos = xsp;
    if (jj_3R_258()) return true;
    }
    return false;
  }

  private boolean jj_3R_483() {
    if (jj_scan_token(DISTINCT)) return true;
    return false;
  }

  private boolean jj_3R_452() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_482()) {
    jj_scanpos = xsp;
    if (jj_3R_483()) return true;
    }
    return false;
  }

  private boolean jj_3R_482() {
    if (jj_scan_token(ALL)) return true;
    return false;
  }

  private boolean jj_3R_330() {
    if (jj_scan_token(EXISTS)) return true;
    if (jj_3R_65()) return true;
    return false;
  }

  private boolean jj_3R_567() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_106()) return true;
    return false;
  }

  private boolean jj_3R_99() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_149()) {
    jj_scanpos = xsp;
    if (jj_3R_150()) return true;
    }
    if (jj_scan_token(JOIN)) return true;
    if (jj_3R_241()) return true;
    return false;
  }

  private boolean jj_3R_56() {
    if (jj_3R_100()) return true;
    return false;
  }

  private boolean jj_3R_55() {
    if (jj_3R_99()) return true;
    return false;
  }

  private boolean jj_3_15() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_55()) {
    jj_scanpos = xsp;
    if (jj_3R_56()) return true;
    }
    return false;
  }

  private boolean jj_3_25() {
    if (jj_3R_65()) return true;
    return false;
  }

  private boolean jj_3R_130() {
    if (jj_3R_53()) return true;
    if (jj_scan_token(LPAREN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_452()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_453()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_454()) jj_scanpos = xsp;
    if (jj_scan_token(RPAREN)) return true;
    xsp = jj_scanpos;
    if (jj_3R_455()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_533() {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_106()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_567()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_129() {
    if (jj_3R_175()) return true;
    return false;
  }

  private boolean jj_3_41() {
    if (jj_scan_token(JSONOBJECT)) return true;
    return false;
  }

  private boolean jj_3R_223() {
    if (jj_3R_241()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_15()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_532() {
    if (jj_3R_65()) return true;
    return false;
  }

  private boolean jj_3R_128() {
    if (jj_3R_174()) return true;
    return false;
  }

  private boolean jj_3R_195() {
    if (jj_3R_223()) return true;
    return false;
  }

  private boolean jj_3R_127() {
    if (jj_3R_173()) return true;
    return false;
  }

  private boolean jj_3R_126() {
    if (jj_3R_172()) return true;
    return false;
  }

  private boolean jj_3R_451() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_71()) return true;
    return false;
  }

  private boolean jj_3R_427() {
    if (jj_scan_token(NOT)) return true;
    return false;
  }

  private boolean jj_3R_450() {
    if (jj_scan_token(NAME)) return true;
    return false;
  }

  private boolean jj_3R_194() {
    if (jj_scan_token(ESCAPEDJOIN)) return true;
    if (jj_3R_223()) return true;
    if (jj_scan_token(RBRACE)) return true;
    return false;
  }

  private boolean jj_3R_418() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_427()) jj_scanpos = xsp;
    if (jj_scan_token(IN)) return true;
    xsp = jj_scanpos;
    if (jj_3R_532()) {
    jj_scanpos = xsp;
    if (jj_3R_533()) return true;
    }
    return false;
  }

  private boolean jj_3R_152() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_194()) {
    jj_scanpos = xsp;
    if (jj_3R_195()) return true;
    }
    return false;
  }

  private boolean jj_3R_49() {
    if (jj_3R_53()) return true;
    if (jj_scan_token(EQ)) return true;
    return false;
  }

  private boolean jj_3R_534() {
    if (jj_scan_token(NOT)) return true;
    return false;
  }

  private boolean jj_3R_393() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_152()) return true;
    return false;
  }

  private boolean jj_3R_419() {
    if (jj_scan_token(IS)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_534()) jj_scanpos = xsp;
    if (jj_scan_token(NULL)) return true;
    return false;
  }

  private boolean jj_3R_262() {
    if (jj_scan_token(EXCEPTION)) return true;
    return false;
  }

  private boolean jj_3R_125() {
    if (jj_scan_token(XMLPI)) return true;
    if (jj_scan_token(LPAREN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_450()) jj_scanpos = xsp;
    if (jj_3R_53()) return true;
    xsp = jj_scanpos;
    if (jj_3R_451()) jj_scanpos = xsp;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_261() {
    if (jj_3R_297()) return true;
    return false;
  }

  private boolean jj_3R_124() {
    if (jj_3R_171()) return true;
    return false;
  }

  private boolean jj_3R_449() {
    if (jj_3R_251()) return true;
    return false;
  }

  private boolean jj_3R_81() {
    if (jj_scan_token(INSERT)) return true;
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  private boolean jj_3R_338() {
    if (jj_scan_token(FROM)) return true;
    if (jj_3R_152()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_393()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_123() {
    if (jj_3R_170()) return true;
    return false;
  }

  private boolean jj_3R_237() {
    if (jj_scan_token(DECLARE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_261()) {
    jj_scanpos = xsp;
    if (jj_3R_262()) return true;
    }
    return false;
  }

  private boolean jj_3R_169() {
    if (jj_scan_token(INSERT)) return true;
    return false;
  }

  private boolean jj_3R_105() {
    if (jj_scan_token(NOT)) return true;
    return false;
  }

  private boolean jj_3R_168() {
    if (jj_scan_token(TRANSLATE)) return true;
    return false;
  }

  private boolean jj_3_40() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(214)) {
    jj_scanpos = xsp;
    if (jj_3R_81()) return true;
    }
    return false;
  }

  private boolean jj_3R_61() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_105()) jj_scanpos = xsp;
    if (jj_scan_token(BETWEEN)) return true;
    if (jj_3R_106()) return true;
    if (jj_scan_token(AND)) return true;
    if (jj_3R_106()) return true;
    return false;
  }

  private boolean jj_3R_448() {
    if (jj_3R_251()) return true;
    return false;
  }

  private boolean jj_3R_540() {
    if (jj_3R_354()) return true;
    return false;
  }

  private boolean jj_3R_122() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_168()) {
    jj_scanpos = xsp;
    if (jj_3R_169()) return true;
    }
    if (jj_scan_token(LPAREN)) return true;
    xsp = jj_scanpos;
    if (jj_3R_449()) jj_scanpos = xsp;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_484() {
    if (jj_scan_token(FILTER)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_scan_token(WHERE)) return true;
    if (jj_3R_256()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_167() {
    if (jj_scan_token(XMLCOMMENT)) return true;
    return false;
  }

  private boolean jj_3R_110() {
    if (jj_scan_token(NOT)) return true;
    return false;
  }

  private boolean jj_3R_166() {
    if (jj_scan_token(XMLCONCAT)) return true;
    return false;
  }

  private boolean jj_3R_118() {
    if (jj_scan_token(DENSE_RANK)) return true;
    return false;
  }

  private boolean jj_3R_165() {
    if (jj_scan_token(SECOND)) return true;
    return false;
  }

  private boolean jj_3R_178() {
    if (jj_scan_token(IF)) return true;
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  private boolean jj_3R_63() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_110()) jj_scanpos = xsp;
    if (jj_scan_token(LIKE_REGEX)) return true;
    if (jj_3R_106()) return true;
    return false;
  }

  private boolean jj_3R_117() {
    if (jj_scan_token(RANK)) return true;
    return false;
  }

  private boolean jj_3R_164() {
    if (jj_scan_token(MINUTE)) return true;
    return false;
  }

  private boolean jj_3R_116() {
    if (jj_scan_token(ROW_NUMBER)) return true;
    return false;
  }

  private boolean jj_3R_163() {
    if (jj_scan_token(HOUR)) return true;
    return false;
  }

  private boolean jj_3R_162() {
    if (jj_scan_token(MONTH)) return true;
    return false;
  }

  private boolean jj_3R_69() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_116()) {
    jj_scanpos = xsp;
    if (jj_3R_117()) {
    jj_scanpos = xsp;
    if (jj_3R_118()) return true;
    }
    }
    if (jj_scan_token(LPAREN)) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_161() {
    if (jj_scan_token(YEAR)) return true;
    return false;
  }

  private boolean jj_3R_578() {
    if (jj_scan_token(ALL)) return true;
    return false;
  }

  private boolean jj_3R_160() {
    if (jj_scan_token(USER)) return true;
    return false;
  }

  private boolean jj_3R_566() {
    if (jj_scan_token(LBRACE)) return true;
    if (jj_scan_token(ESCAPE)) return true;
    if (jj_3R_540()) return true;
    if (jj_scan_token(RBRACE)) return true;
    return false;
  }

  private boolean jj_3R_577() {
    if (jj_scan_token(DISTINCT)) return true;
    return false;
  }

  private boolean jj_3R_564() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_577()) {
    jj_scanpos = xsp;
    if (jj_3R_578()) return true;
    }
    return false;
  }

  private boolean jj_3R_159() {
    if (jj_scan_token(CHAR)) return true;
    return false;
  }

  private boolean jj_3R_565() {
    if (jj_scan_token(ESCAPE)) return true;
    if (jj_3R_540()) return true;
    return false;
  }

  private boolean jj_3R_531() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_565()) {
    jj_scanpos = xsp;
    if (jj_3R_566()) return true;
    }
    return false;
  }

  private boolean jj_3R_158() {
    if (jj_scan_token(RIGHT)) return true;
    return false;
  }

  private boolean jj_3R_210() {
    if (jj_scan_token(ANY)) return true;
    return false;
  }

  private boolean jj_3R_157() {
    if (jj_scan_token(LEFT)) return true;
    return false;
  }

  private boolean jj_3R_209() {
    if (jj_scan_token(SOME)) return true;
    return false;
  }

  private boolean jj_3R_85() {
    if (jj_scan_token(LOOP)) return true;
    if (jj_scan_token(ON)) return true;
    return false;
  }

  private boolean jj_3R_208() {
    if (jj_scan_token(VAR_POP)) return true;
    return false;
  }

  private boolean jj_3R_109() {
    if (jj_scan_token(SIMILAR)) return true;
    if (jj_scan_token(TO)) return true;
    return false;
  }

  private boolean jj_3R_207() {
    if (jj_scan_token(VAR_SAMP)) return true;
    return false;
  }

  private boolean jj_3R_108() {
    if (jj_scan_token(LIKE)) return true;
    return false;
  }

  private boolean jj_3R_121() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_157()) {
    jj_scanpos = xsp;
    if (jj_3R_158()) {
    jj_scanpos = xsp;
    if (jj_3R_159()) {
    jj_scanpos = xsp;
    if (jj_3R_160()) {
    jj_scanpos = xsp;
    if (jj_3R_161()) {
    jj_scanpos = xsp;
    if (jj_3R_162()) {
    jj_scanpos = xsp;
    if (jj_3R_163()) {
    jj_scanpos = xsp;
    if (jj_3R_164()) {
    jj_scanpos = xsp;
    if (jj_3R_165()) {
    jj_scanpos = xsp;
    if (jj_3R_166()) {
    jj_scanpos = xsp;
    if (jj_3R_167()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    if (jj_scan_token(LPAREN)) return true;
    xsp = jj_scanpos;
    if (jj_3R_448()) jj_scanpos = xsp;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_206() {
    if (jj_scan_token(STDDEV_SAMP)) return true;
    return false;
  }

  private boolean jj_3R_205() {
    if (jj_scan_token(STDDEV_POP)) return true;
    return false;
  }

  private boolean jj_3R_107() {
    if (jj_scan_token(NOT)) return true;
    return false;
  }

  private boolean jj_3_39() {
    if (jj_3R_80()) return true;
    return false;
  }

  private boolean jj_3R_204() {
    if (jj_scan_token(EVERY)) return true;
    return false;
  }

  private boolean jj_3R_62() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_107()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_108()) {
    jj_scanpos = xsp;
    if (jj_3R_109()) return true;
    }
    if (jj_3R_106()) return true;
    xsp = jj_scanpos;
    if (jj_3R_531()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_203() {
    if (jj_scan_token(MAX)) return true;
    return false;
  }

  private boolean jj_3R_202() {
    if (jj_scan_token(MIN)) return true;
    return false;
  }

  private boolean jj_3R_86() {
    if (jj_scan_token(WHILE)) return true;
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  private boolean jj_3R_537() {
    if (jj_scan_token(ALL)) return true;
    return false;
  }

  private boolean jj_3R_201() {
    if (jj_scan_token(AVG)) return true;
    return false;
  }

  private boolean jj_3R_536() {
    if (jj_scan_token(SOME)) return true;
    return false;
  }

  private boolean jj_3R_200() {
    if (jj_scan_token(SUM)) return true;
    return false;
  }

  private boolean jj_3R_265() {
    if (jj_3R_71()) return true;
    return false;
  }

  private boolean jj_3R_79() {
    if (jj_scan_token(TIMESTAMPDIFF)) return true;
    return false;
  }

  private boolean jj_3R_535() {
    if (jj_scan_token(ANY)) return true;
    return false;
  }

  private boolean jj_3R_199() {
    if (jj_scan_token(COUNT)) return true;
    return false;
  }

  private boolean jj_3R_78() {
    if (jj_scan_token(TIMESTAMPADD)) return true;
    return false;
  }

  private boolean jj_3R_239() {
    if (jj_scan_token(RETURN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_265()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_299() {
    if (jj_scan_token(CONTINUE)) return true;
    return false;
  }

  private boolean jj_3R_300() {
    if (jj_3R_53()) return true;
    return false;
  }

  private boolean jj_3R_420() {
    if (jj_3R_64()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_535()) {
    jj_scanpos = xsp;
    if (jj_3R_536()) {
    jj_scanpos = xsp;
    if (jj_3R_537()) return true;
    }
    }
    if (jj_3R_65()) return true;
    return false;
  }

  private boolean jj_3R_298() {
    if (jj_scan_token(BREAK)) return true;
    return false;
  }

  private boolean jj_3R_264() {
    if (jj_scan_token(LEAVE)) return true;
    if (jj_3R_53()) return true;
    return false;
  }

  private boolean jj_3R_156() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_199()) {
    jj_scanpos = xsp;
    if (jj_3R_200()) {
    jj_scanpos = xsp;
    if (jj_3R_201()) {
    jj_scanpos = xsp;
    if (jj_3R_202()) {
    jj_scanpos = xsp;
    if (jj_3R_203()) {
    jj_scanpos = xsp;
    if (jj_3R_204()) {
    jj_scanpos = xsp;
    if (jj_3R_205()) {
    jj_scanpos = xsp;
    if (jj_3R_206()) {
    jj_scanpos = xsp;
    if (jj_3R_207()) {
    jj_scanpos = xsp;
    if (jj_3R_208()) {
    jj_scanpos = xsp;
    if (jj_3R_209()) {
    jj_scanpos = xsp;
    if (jj_3R_210()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    if (jj_scan_token(LPAREN)) return true;
    xsp = jj_scanpos;
    if (jj_3R_564()) jj_scanpos = xsp;
    if (jj_3R_71()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3_38() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_78()) {
    jj_scanpos = xsp;
    if (jj_3R_79()) return true;
    }
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_447()) return true;
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_71()) return true;
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_71()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_112() {
    if (jj_3R_142()) return true;
    return false;
  }

  private boolean jj_3R_446() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_71()) return true;
    return false;
  }

  private boolean jj_3R_111() {
    if (jj_3R_141()) return true;
    return false;
  }

  private boolean jj_3R_263() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_298()) {
    jj_scanpos = xsp;
    if (jj_3R_299()) return true;
    }
    xsp = jj_scanpos;
    if (jj_3R_300()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_14() {
    if (jj_scan_token(COUNT)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_scan_token(STAR)) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_238() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_263()) {
    jj_scanpos = xsp;
    if (jj_3R_264()) return true;
    }
    return false;
  }

  private boolean jj_3R_65() {
    if (jj_scan_token(LPAREN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_111()) {
    jj_scanpos = xsp;
    if (jj_3R_112()) return true;
    }
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_114() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_14()) {
    jj_scanpos = xsp;
    if (jj_3R_156()) return true;
    }
    return false;
  }

  private boolean jj_3R_77() {
    if (jj_scan_token(TO_BYTES)) return true;
    return false;
  }

  private boolean jj_3R_76() {
    if (jj_scan_token(TO_CHARS)) return true;
    return false;
  }

  private boolean jj_3R_529() {
    if (jj_3R_247()) return true;
    return false;
  }

  private boolean jj_3R_421() {
    if (jj_3R_64()) return true;
    if (jj_3R_106()) return true;
    return false;
  }

  private boolean jj_3R_138() {
    if (jj_scan_token(EXCEPTION)) return true;
    return false;
  }

  private boolean jj_3R_136() {
    if (jj_3R_71()) return true;
    return false;
  }

  private boolean jj_3_24() {
    if (jj_3R_64()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(40)) {
    jj_scanpos = xsp;
    if (jj_scan_token(198)) {
    jj_scanpos = xsp;
    if (jj_scan_token(37)) return true;
    }
    }
    if (jj_3R_65()) return true;
    return false;
  }

  private boolean jj_3R_528() {
    if (jj_scan_token(ENCODING)) return true;
    if (jj_3R_53()) return true;
    return false;
  }

  private boolean jj_3_5() {
    if (jj_3R_50()) return true;
    return false;
  }

  private boolean jj_3R_135() {
    if (jj_scan_token(BOTH)) return true;
    return false;
  }

  private boolean jj_3R_407() {
    if (jj_3R_421()) return true;
    return false;
  }

  private boolean jj_3R_75() {
    if (jj_3R_71()) return true;
    return false;
  }

  private boolean jj_3_37() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_76()) {
    jj_scanpos = xsp;
    if (jj_3R_77()) return true;
    }
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_71()) return true;
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_354()) return true;
    xsp = jj_scanpos;
    if (jj_3R_446()) jj_scanpos = xsp;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_177() {
    if (jj_scan_token(NOT)) return true;
    return false;
  }

  private boolean jj_3R_406() {
    if (jj_3R_420()) return true;
    return false;
  }

  private boolean jj_3R_527() {
    if (jj_scan_token(HEADER)) return true;
    return false;
  }

  private boolean jj_3R_134() {
    if (jj_scan_token(TRAILING)) return true;
    return false;
  }

  private boolean jj_3R_405() {
    if (jj_3R_419()) return true;
    return false;
  }

  private boolean jj_3R_404() {
    if (jj_3R_418()) return true;
    return false;
  }

  private boolean jj_3R_133() {
    if (jj_scan_token(LEADING)) return true;
    return false;
  }

  private boolean jj_3_23() {
    if (jj_3R_63()) return true;
    return false;
  }

  private boolean jj_3R_137() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_177()) jj_scanpos = xsp;
    if (jj_scan_token(ATOMIC)) return true;
    return false;
  }

  private boolean jj_3_22() {
    if (jj_3R_62()) return true;
    return false;
  }

  private boolean jj_3R_64() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(392)) {
    jj_scanpos = xsp;
    if (jj_scan_token(393)) {
    jj_scanpos = xsp;
    if (jj_scan_token(394)) {
    jj_scanpos = xsp;
    if (jj_scan_token(395)) {
    jj_scanpos = xsp;
    if (jj_scan_token(396)) {
    jj_scanpos = xsp;
    if (jj_scan_token(397)) {
    jj_scanpos = xsp;
    if (jj_scan_token(398)) return true;
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_526() {
    if (jj_scan_token(QUOTE)) return true;
    if (jj_3R_540()) return true;
    return false;
  }

  private boolean jj_3_21() {
    if (jj_3R_61()) return true;
    return false;
  }

  private boolean jj_3R_293() {
    if (jj_3R_330()) return true;
    return false;
  }

  private boolean jj_3R_87() {
    if (jj_scan_token(BEGIN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_137()) jj_scanpos = xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_5()) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3R_138()) jj_scanpos = xsp;
    if (jj_scan_token(END)) return true;
    return false;
  }

  private boolean jj_3R_361() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_21()) {
    jj_scanpos = xsp;
    if (jj_3_22()) {
    jj_scanpos = xsp;
    if (jj_3_23()) {
    jj_scanpos = xsp;
    if (jj_3R_404()) {
    jj_scanpos = xsp;
    if (jj_3R_405()) {
    jj_scanpos = xsp;
    if (jj_3R_406()) {
    jj_scanpos = xsp;
    if (jj_3R_407()) return true;
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_74() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_133()) {
    jj_scanpos = xsp;
    if (jj_3R_134()) {
    jj_scanpos = xsp;
    if (jj_3R_135()) return true;
    }
    }
    xsp = jj_scanpos;
    if (jj_3R_136()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_525() {
    if (jj_scan_token(DELIMITER)) return true;
    if (jj_3R_540()) return true;
    return false;
  }

  private boolean jj_3R_217() {
    if (jj_3R_239()) return true;
    return false;
  }

  private boolean jj_3_33() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_74()) {
    jj_scanpos = xsp;
    if (jj_3R_75()) return true;
    }
    if (jj_scan_token(FROM)) return true;
    return false;
  }

  private boolean jj_3R_524() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_509()) return true;
    return false;
  }

  private boolean jj_3R_216() {
    if (jj_3R_238()) return true;
    return false;
  }

  private boolean jj_3R_215() {
    if (jj_3R_237()) return true;
    return false;
  }

  private boolean jj_3R_292() {
    if (jj_3R_106()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_361()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_523() {
    if (jj_scan_token(FOR)) return true;
    return false;
  }

  private boolean jj_3R_214() {
    if (jj_3R_236()) return true;
    return false;
  }

  private boolean jj_3R_213() {
    if (jj_3R_235()) return true;
    return false;
  }

  private boolean jj_3R_256() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_292()) {
    jj_scanpos = xsp;
    if (jj_3R_293()) return true;
    }
    return false;
  }

  private boolean jj_3R_212() {
    if (jj_3R_234()) return true;
    return false;
  }

  private boolean jj_3_36() {
    if (jj_scan_token(TRIM)) return true;
    if (jj_scan_token(LPAREN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_33()) jj_scanpos = xsp;
    if (jj_3R_71()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_255() {
    if (jj_scan_token(NOT)) return true;
    return false;
  }

  private boolean jj_3_4() {
    if (jj_3R_49()) return true;
    return false;
  }

  private boolean jj_3R_113() {
    if (jj_scan_token(TEXTAGG)) return true;
    if (jj_scan_token(LPAREN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_523()) jj_scanpos = xsp;
    if (jj_3R_509()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_524()) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3R_525()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_526()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_527()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_528()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_529()) jj_scanpos = xsp;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_445() {
    if (jj_scan_token(SECOND)) return true;
    return false;
  }

  private boolean jj_3R_48() {
    if (jj_3R_87()) return true;
    return false;
  }

  private boolean jj_3R_140() {
    if (jj_3R_179()) return true;
    return false;
  }

  private boolean jj_3R_47() {
    if (jj_3R_86()) return true;
    return false;
  }

  private boolean jj_3R_232() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_255()) jj_scanpos = xsp;
    if (jj_3R_256()) return true;
    return false;
  }

  private boolean jj_3R_444() {
    if (jj_scan_token(MINUTE)) return true;
    return false;
  }

  private boolean jj_3R_179() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_4()) {
    jj_scanpos = xsp;
    if (jj_3R_212()) {
    jj_scanpos = xsp;
    if (jj_3R_213()) {
    jj_scanpos = xsp;
    if (jj_3R_214()) {
    jj_scanpos = xsp;
    if (jj_3R_215()) {
    jj_scanpos = xsp;
    if (jj_3R_216()) {
    jj_scanpos = xsp;
    if (jj_3R_217()) return true;
    }
    }
    }
    }
    }
    }
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  private boolean jj_3R_139() {
    if (jj_3R_178()) return true;
    return false;
  }

  private boolean jj_3R_46() {
    if (jj_3R_85()) return true;
    return false;
  }

  private boolean jj_3R_443() {
    if (jj_scan_token(HOUR)) return true;
    return false;
  }

  private boolean jj_3R_530() {
    if (jj_3R_247()) return true;
    return false;
  }

  private boolean jj_3R_88() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_139()) {
    jj_scanpos = xsp;
    if (jj_3R_140()) return true;
    }
    return false;
  }

  private boolean jj_3R_442() {
    if (jj_scan_token(DAY)) return true;
    return false;
  }

  private boolean jj_3R_257() {
    if (jj_scan_token(AND)) return true;
    if (jj_3R_232()) return true;
    return false;
  }

  private boolean jj_3R_45() {
    if (jj_3R_53()) return true;
    if (jj_scan_token(COLON)) return true;
    return false;
  }

  private boolean jj_3R_441() {
    if (jj_scan_token(MONTH)) return true;
    return false;
  }

  private boolean jj_3R_440() {
    if (jj_scan_token(YEAR)) return true;
    return false;
  }

  private boolean jj_3R_211() {
    if (jj_3R_232()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_257()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_3() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_45()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_46()) {
    jj_scanpos = xsp;
    if (jj_3R_47()) {
    jj_scanpos = xsp;
    if (jj_3R_48()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_233() {
    if (jj_scan_token(OR)) return true;
    if (jj_3R_211()) return true;
    return false;
  }

  private boolean jj_3R_50() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_3()) {
    jj_scanpos = xsp;
    if (jj_3R_88()) return true;
    }
    return false;
  }

  private boolean jj_3R_115() {
    if (jj_scan_token(XMLAGG)) return true;
    if (jj_scan_token(ARRAY_AGG)) return true;
    if (jj_scan_token(JSONARRAY_AGG)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_71()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_530()) jj_scanpos = xsp;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_465() {
    if (jj_scan_token(FOR)) return true;
    if (jj_3R_71()) return true;
    return false;
  }

  private boolean jj_3_35() {
    if (jj_scan_token(EXTRACT)) return true;
    if (jj_scan_token(LPAREN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_440()) {
    jj_scanpos = xsp;
    if (jj_3R_441()) {
    jj_scanpos = xsp;
    if (jj_3R_442()) {
    jj_scanpos = xsp;
    if (jj_3R_443()) {
    jj_scanpos = xsp;
    if (jj_3R_444()) {
    jj_scanpos = xsp;
    if (jj_3R_445()) return true;
    }
    }
    }
    }
    }
    if (jj_scan_token(FROM)) return true;
    if (jj_3R_71()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_439() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_251()) return true;
    return false;
  }

  private boolean jj_3R_176() {
    if (jj_3R_211()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_233()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_429() {
    if (jj_scan_token(ALL_IN_GROUP)) return true;
    return false;
  }

  private boolean jj_3R_560() {
    if (jj_scan_token(AS)) return true;
    if (jj_3R_53()) return true;
    return false;
  }

  private boolean jj_3R_131() {
    if (jj_3R_176()) return true;
    return false;
  }

  private boolean jj_3R_438() {
    if (jj_scan_token(FROM)) return true;
    if (jj_3R_71()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_465()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_549() {
    if (jj_scan_token(AS)) return true;
    return false;
  }

  private boolean jj_3R_461() {
    if (jj_scan_token(AS)) return true;
    return false;
  }

  private boolean jj_3R_509() {
    if (jj_3R_71()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_560()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_394() {
    if (jj_scan_token(WHERE)) return true;
    if (jj_3R_131()) return true;
    return false;
  }

  private boolean jj_3R_508() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_549()) jj_scanpos = xsp;
    if (jj_3R_53()) return true;
    return false;
  }

  private boolean jj_3R_436() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_461()) jj_scanpos = xsp;
    if (jj_3R_53()) return true;
    return false;
  }

  private boolean jj_3R_334() {
    if (jj_scan_token(SQLEXCEPTION)) return true;
    return false;
  }

  private boolean jj_3R_296() {
    if (jj_3R_334()) return true;
    return false;
  }

  private boolean jj_3R_428() {
    if (jj_3R_71()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_436()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_303() {
    if (jj_3R_53()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_508()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_34() {
    if (jj_scan_token(SUBSTRING)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_71()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_438()) {
    jj_scanpos = xsp;
    if (jj_3R_439()) return true;
    }
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_260() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_295()) {
    jj_scanpos = xsp;
    if (jj_3R_296()) return true;
    }
    return false;
  }

  private boolean jj_3R_295() {
    if (jj_3R_53()) return true;
    return false;
  }

  private boolean jj_3R_423() {
    if (jj_3R_429()) return true;
    return false;
  }

  private boolean jj_3R_422() {
    if (jj_3R_428()) return true;
    return false;
  }

  private boolean jj_3R_104() {
    if (jj_scan_token(AS)) return true;
    return false;
  }

  private boolean jj_3R_259() {
    if (jj_scan_token(SQLWARNING)) return true;
    return false;
  }

  private boolean jj_3R_411() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_410()) return true;
    return false;
  }

  private boolean jj_3R_410() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_422()) {
    jj_scanpos = xsp;
    if (jj_3R_423()) return true;
    }
    return false;
  }

  private boolean jj_3R_103() {
    if (jj_3R_142()) return true;
    return false;
  }

  private boolean jj_3R_236() {
    if (jj_scan_token(RAISE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_259()) jj_scanpos = xsp;
    if (jj_3R_260()) return true;
    return false;
  }

  private boolean jj_3R_102() {
    if (jj_3R_141()) return true;
    return false;
  }

  private boolean jj_3R_154() {
    if (jj_scan_token(LATERAL)) return true;
    return false;
  }

  private boolean jj_3R_120() {
    if (jj_scan_token(CAST)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_71()) return true;
    if (jj_scan_token(AS)) return true;
    if (jj_3R_297()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_153() {
    if (jj_scan_token(TABLE)) return true;
    return false;
  }

  private boolean jj_3R_391() {
    if (jj_3R_410()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_411()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_235() {
    if (jj_scan_token(ERROR)) return true;
    if (jj_3R_71()) return true;
    return false;
  }

  private boolean jj_3R_390() {
    if (jj_scan_token(STAR)) return true;
    return false;
  }

  private boolean jj_3R_101() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_153()) {
    jj_scanpos = xsp;
    if (jj_3R_154()) return true;
    }
    return false;
  }

  private boolean jj_3R_96() {
    if (jj_3R_87()) return true;
    return false;
  }

  private boolean jj_3R_409() {
    if (jj_scan_token(DISTINCT)) return true;
    return false;
  }

  private boolean jj_3R_95() {
    if (jj_3R_147()) return true;
    return false;
  }

  private boolean jj_3R_94() {
    if (jj_3R_146()) return true;
    return false;
  }

  private boolean jj_3R_389() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_408()) {
    jj_scanpos = xsp;
    if (jj_3R_409()) return true;
    }
    return false;
  }

  private boolean jj_3R_408() {
    if (jj_scan_token(ALL)) return true;
    return false;
  }

  private boolean jj_3R_60() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_101()) jj_scanpos = xsp;
    if (jj_scan_token(LPAREN)) return true;
    xsp = jj_scanpos;
    if (jj_3R_102()) {
    jj_scanpos = xsp;
    if (jj_3R_103()) return true;
    }
    if (jj_scan_token(RPAREN)) return true;
    xsp = jj_scanpos;
    if (jj_3R_104()) jj_scanpos = xsp;
    if (jj_3R_53()) return true;
    return false;
  }

  private boolean jj_3R_93() {
    if (jj_3R_145()) return true;
    return false;
  }

  private boolean jj_3R_425() {
    if (jj_scan_token(MINUS)) return true;
    return false;
  }

  private boolean jj_3R_92() {
    if (jj_3R_144()) return true;
    return false;
  }

  private boolean jj_3R_91() {
    if (jj_3R_143()) return true;
    return false;
  }

  private boolean jj_3R_90() {
    if (jj_3R_142()) return true;
    return false;
  }

  private boolean jj_3R_424() {
    if (jj_scan_token(PLUS)) return true;
    return false;
  }

  private boolean jj_3R_119() {
    if (jj_scan_token(CONVERT)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_71()) return true;
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_297()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_89() {
    if (jj_3R_141()) return true;
    return false;
  }

  private boolean jj_3R_336() {
    if (jj_scan_token(SELECT)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_389()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_390()) {
    jj_scanpos = xsp;
    if (jj_3R_391()) return true;
    }
    return false;
  }

  private boolean jj_3R_414() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_424()) {
    jj_scanpos = xsp;
    if (jj_3R_425()) return true;
    }
    return false;
  }

  private boolean jj_3R_70() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_119()) {
    jj_scanpos = xsp;
    if (jj_3R_120()) {
    jj_scanpos = xsp;
    if (jj_3_34()) {
    jj_scanpos = xsp;
    if (jj_3_35()) {
    jj_scanpos = xsp;
    if (jj_3_36()) {
    jj_scanpos = xsp;
    if (jj_3_37()) {
    jj_scanpos = xsp;
    if (jj_3_38()) {
    jj_scanpos = xsp;
    if (jj_3_39()) {
    jj_scanpos = xsp;
    if (jj_3R_121()) {
    jj_scanpos = xsp;
    if (jj_3R_122()) {
    jj_scanpos = xsp;
    if (jj_3R_123()) {
    jj_scanpos = xsp;
    if (jj_3R_124()) {
    jj_scanpos = xsp;
    if (jj_3R_125()) {
    jj_scanpos = xsp;
    if (jj_3R_126()) {
    jj_scanpos = xsp;
    if (jj_3R_127()) {
    jj_scanpos = xsp;
    if (jj_3R_128()) {
    jj_scanpos = xsp;
    if (jj_3R_129()) {
    jj_scanpos = xsp;
    if (jj_3R_130()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_51() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_89()) {
    jj_scanpos = xsp;
    if (jj_3R_90()) {
    jj_scanpos = xsp;
    if (jj_3R_91()) {
    jj_scanpos = xsp;
    if (jj_3R_92()) {
    jj_scanpos = xsp;
    if (jj_3R_93()) {
    jj_scanpos = xsp;
    if (jj_3R_94()) {
    jj_scanpos = xsp;
    if (jj_3R_95()) {
    jj_scanpos = xsp;
    if (jj_3R_96()) return true;
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_580() {
    if (jj_scan_token(PATH)) return true;
    if (jj_3R_354()) return true;
    return false;
  }

  private boolean jj_3R_397() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_414()) jj_scanpos = xsp;
    if (jj_scan_token(UNSIGNEDINTEGER)) return true;
    return false;
  }

  private boolean jj_3R_392() {
    if (jj_scan_token(INTO)) return true;
    if (jj_3R_53()) return true;
    return false;
  }

  private boolean jj_3R_579() {
    if (jj_scan_token(DEFAULT_KEYWORD)) return true;
    if (jj_3R_71()) return true;
    return false;
  }

  private boolean jj_3R_432() {
    if (jj_scan_token(ELSE)) return true;
    if (jj_3R_71()) return true;
    return false;
  }

  private boolean jj_3R_304() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_53()) return true;
    return false;
  }

  private boolean jj_3R_341() {
    if (jj_3R_396()) return true;
    return false;
  }

  private boolean jj_3R_340() {
    if (jj_3R_395()) return true;
    return false;
  }

  private boolean jj_3R_339() {
    if (jj_3R_394()) return true;
    return false;
  }

  private boolean jj_3R_571() {
    if (jj_3R_297()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_579()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_580()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_132() {
    if (jj_scan_token(WHEN)) return true;
    if (jj_3R_131()) return true;
    if (jj_scan_token(THEN)) return true;
    if (jj_3R_71()) return true;
    return false;
  }

  private boolean jj_3R_274() {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_53()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_304()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_337() {
    if (jj_3R_392()) return true;
    return false;
  }

  private boolean jj_3R_570() {
    if (jj_scan_token(FOR)) return true;
    if (jj_scan_token(ORDINALITY)) return true;
    return false;
  }

  private boolean jj_3R_73() {
    if (jj_scan_token(CASE)) return true;
    Token xsp;
    if (jj_3R_132()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_132()) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3R_432()) jj_scanpos = xsp;
    if (jj_scan_token(END)) return true;
    return false;
  }

  private boolean jj_3R_328() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(381)) {
    jj_scanpos = xsp;
    if (jj_scan_token(377)) {
    jj_scanpos = xsp;
    if (jj_scan_token(376)) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_301() {
    if (jj_3R_336()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_337()) jj_scanpos = xsp;
    if (jj_3R_338()) return true;
    xsp = jj_scanpos;
    if (jj_3R_339()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_340()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_341()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_545() {
    if (jj_3R_53()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_570()) {
    jj_scanpos = xsp;
    if (jj_3R_571()) return true;
    }
    return false;
  }

  private boolean jj_3R_434() {
    if (jj_scan_token(ELSE)) return true;
    if (jj_3R_71()) return true;
    return false;
  }

  private boolean jj_3R_502() {
    if (jj_scan_token(AS)) return true;
    return false;
  }

  private boolean jj_3R_326() {
    if (jj_scan_token(ESCAPEDTYPE)) return true;
    if (jj_3R_354()) return true;
    if (jj_scan_token(RBRACE)) return true;
    return false;
  }

  private boolean jj_3R_269() {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_181()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_546() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_545()) return true;
    return false;
  }

  private boolean jj_3R_325() {
    if (jj_scan_token(NULL)) return true;
    return false;
  }

  private boolean jj_3R_324() {
    if (jj_scan_token(UNKNOWN)) return true;
    return false;
  }

  private boolean jj_3R_268() {
    if (jj_scan_token(TABLE)) return true;
    if (jj_3R_53()) return true;
    return false;
  }

  private boolean jj_3R_433() {
    if (jj_scan_token(WHEN)) return true;
    if (jj_3R_71()) return true;
    if (jj_scan_token(THEN)) return true;
    if (jj_3R_71()) return true;
    return false;
  }

  private boolean jj_3R_323() {
    if (jj_scan_token(TRUE)) return true;
    return false;
  }

  private boolean jj_3R_322() {
    if (jj_scan_token(FALSE)) return true;
    return false;
  }

  private boolean jj_3R_305() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_251()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_501() {
    if (jj_scan_token(COLUMNS)) return true;
    if (jj_3R_545()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_546()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_321() {
    if (jj_scan_token(BINARYSTRINGVAL)) return true;
    return false;
  }

  private boolean jj_3R_544() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_509()) return true;
    return false;
  }

  private boolean jj_3R_320() {
    if (jj_3R_354()) return true;
    return false;
  }

  private boolean jj_3R_402() {
    if (jj_scan_token(CASE)) return true;
    if (jj_3R_71()) return true;
    Token xsp;
    if (jj_3R_433()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_433()) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3R_434()) jj_scanpos = xsp;
    if (jj_scan_token(END)) return true;
    return false;
  }

  private boolean jj_3R_288() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_320()) {
    jj_scanpos = xsp;
    if (jj_3R_321()) {
    jj_scanpos = xsp;
    if (jj_3R_322()) {
    jj_scanpos = xsp;
    if (jj_3R_323()) {
    jj_scanpos = xsp;
    if (jj_3R_324()) {
    jj_scanpos = xsp;
    if (jj_3R_325()) {
    jj_scanpos = xsp;
    if (jj_3R_326()) return true;
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_189() {
    if (jj_scan_token(TRIGGER)) return true;
    return false;
  }

  private boolean jj_3R_486() {
    if (jj_3R_247()) return true;
    return false;
  }

  private boolean jj_3R_500() {
    if (jj_scan_token(PASSING)) return true;
    if (jj_3R_509()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_544()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_267() {
    if (jj_scan_token(VALUES)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_251()) return true;
    if (jj_scan_token(RPAREN)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_305()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_188() {
    if (jj_scan_token(PROCEDURE)) return true;
    return false;
  }

  private boolean jj_3R_266() {
    if (jj_3R_301()) return true;
    return false;
  }

  private boolean jj_3R_485() {
    if (jj_scan_token(PARTITION)) return true;
    if (jj_scan_token(BY)) return true;
    if (jj_3R_251()) return true;
    return false;
  }

  private boolean jj_3R_499() {
    if (jj_3R_82()) return true;
    if (jj_scan_token(COMMA)) return true;
    return false;
  }

  private boolean jj_3R_240() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_266()) {
    jj_scanpos = xsp;
    if (jj_3R_267()) {
    jj_scanpos = xsp;
    if (jj_3R_268()) {
    jj_scanpos = xsp;
    if (jj_3R_269()) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_447() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(336)) {
    jj_scanpos = xsp;
    if (jj_scan_token(337)) {
    jj_scanpos = xsp;
    if (jj_scan_token(338)) {
    jj_scanpos = xsp;
    if (jj_scan_token(339)) {
    jj_scanpos = xsp;
    if (jj_scan_token(340)) {
    jj_scanpos = xsp;
    if (jj_scan_token(341)) {
    jj_scanpos = xsp;
    if (jj_scan_token(342)) {
    jj_scanpos = xsp;
    if (jj_scan_token(343)) {
    jj_scanpos = xsp;
    if (jj_scan_token(344)) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_307() {
    if (jj_scan_token(DISTINCT)) return true;
    return false;
  }

  private boolean jj_3R_187() {
    if (jj_scan_token(VIEW)) return true;
    return false;
  }

  private boolean jj_3R_459() {
    if (jj_scan_token(OVER)) return true;
    if (jj_scan_token(LPAREN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_485()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_486()) jj_scanpos = xsp;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_275() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_306()) {
    jj_scanpos = xsp;
    if (jj_3R_307()) return true;
    }
    return false;
  }

  private boolean jj_3R_306() {
    if (jj_scan_token(ALL)) return true;
    return false;
  }

  /** Generated Token Manager. */
  public TeiidCompletionParserTokenManager token_source;
  JavaCharStream jj_input_stream;
  /** Current token. */
  public Token token;
  /** Next token. */
  public Token jj_nt;
  private int jj_ntk;
  private Token jj_scanpos, jj_lastpos;
  private int jj_la;
  private int jj_gen;
  final private int[] jj_la1 = new int[293];
  static private int[] jj_la1_0;
  static private int[] jj_la1_1;
  static private int[] jj_la1_2;
  static private int[] jj_la1_3;
  static private int[] jj_la1_4;
  static private int[] jj_la1_5;
  static private int[] jj_la1_6;
  static private int[] jj_la1_7;
  static private int[] jj_la1_8;
  static private int[] jj_la1_9;
  static private int[] jj_la1_10;
  static private int[] jj_la1_11;
  static private int[] jj_la1_12;
  static {
      jj_la1_init_0();
      jj_la1_init_1();
      jj_la1_init_2();
      jj_la1_init_3();
      jj_la1_init_4();
      jj_la1_init_5();
      jj_la1_init_6();
      jj_la1_init_7();
      jj_la1_init_8();
      jj_la1_init_9();
      jj_la1_init_10();
      jj_la1_init_11();
      jj_la1_init_12();
   }
   private static void jj_la1_init_0() {
      jj_la1_0 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20000,0x0,0xfffffe00,0x0,0x0,0x0,0x20000,0x20000,0x0,0x0,0x0,0x0,0x0,0x0,0x200,0x200,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20000,0x0,0x0,0x0,0x20000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20000,0x20000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80000e00,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xfffffe00,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xfffffe00,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20000,0x0,0x0,0x0,0x0,0x0,0x20000,0x0,0x0,0x0,0x0,0x0,0x20000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20000,0x20000,0x0,0x0,0x0,0x0,0x0,0x0,0x20000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20000,0x20000,0x0,0x0,0x0,0x20000,0x20000,0x0,0x20000,0x0,0x0,0x0,0x0,0x20000,0x0,0x0,0x0,0x20000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xfffffe00,0x0,0x0,0x0,0x0,0x0,};
   }
   private static void jj_la1_init_1() {
      jj_la1_1 = new int[] {0x0,0x0,0x208040,0x0,0x208040,0x0,0x0,0x0,0x800,0x0,0x2000,0x288040,0x288040,0x208040,0x0,0x0,0x0,0x0,0x0,0x0,0x8000,0x288040,0x288040,0x288040,0x0,0x2000,0x288040,0x0,0x80000,0x0,0x80000,0x100010c,0x0,0x3,0x0,0x0,0x0,0x120010c,0x100010c,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x800,0x0,0x0,0x0,0x0,0x0,0x100010c,0x0,0x0,0x200000,0x100010c,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20,0x20,0x0,0x0,0x0,0x20,0x20,0x0,0x0,0x0,0x0,0x0,0x0,0x20,0x20,0x0,0x100010c,0x100010c,0x800,0x800,0x800,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x100,0x20,0x20,0x100,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1,0x800,0x0,0x0,0x0,0x0,0x800,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x800,0x0,0x0,0x3,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x800,0x0,0x0,0x0,0x0,0x0,0x0,0x800,0x0,0x0,0x3,0x0,0x0,0x0,0x0,0x200000,0x800,0x800,0x800,0x0,0x80,0x0,0x0,0x0,0x10000,0x100010c,0x0,0x200000,0x120,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x100010c,0x0,0x1000,0x1000,0x0,0x0,0x100010c,0x0,0x0,0x0,0x0,0x0,0x100010c,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x100010c,0x100010c,0x0,0x100,0x0,0x0,0x0,0x0,0x100010c,0x0,0x0,0x0,0x0,0x0,0x1000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40000,0x100010c,0x104010c,0x0,0x0,0x0,0x0,0x100010c,0x0,0x100010c,0x0,0x0,0x20,0x20,0x100010c,0x0,0x0,0xc,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3,0x0,0x0,0x0,0x0,0x0,};
   }
   private static void jj_la1_init_2() {
      jj_la1_2 = new int[] {0x0,0x0,0x30008080,0x0,0x30008080,0x0,0x8000,0x8000,0x0,0x0,0x0,0x3200c082,0x3200c082,0x30008080,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3200c082,0x3200c082,0x3200c082,0x0,0x0,0x3200c082,0x0,0x2,0x0,0x2,0x80000000,0x800000,0x0,0x0,0x0,0x0,0xb0008000,0x80008000,0x30000000,0x0,0x0,0x0,0x0,0x30000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80000000,0x0,0x0,0x30000000,0x80000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8000000,0x8000000,0x100000,0x100000,0x0,0x0,0x0,0x100000,0x100000,0x0,0x0,0x0,0x0,0x0,0x0,0x100000,0x100000,0x0,0x80000000,0x80000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x100000,0x100000,0x0,0x0,0x0,0x0,0x200,0x200,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4000000,0x4000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2000,0x0,0x0,0x0,0x0,0x0,0x0,0x2000,0x0,0x0,0x0,0x0,0x0,0x0,0x30000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80000000,0x0,0x30000000,0x0,0x0,0x0,0x4000000,0x4000000,0x0,0x0,0x0,0x0,0x0,0x0,0x80000000,0x0,0x10000,0x10000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x800000,0x0,0x800000,0x0,0x0,0x800,0x0,0x80000000,0x80000000,0x0,0x0,0x0,0x0,0x80000000,0x0,0x80000000,0x0,0x0,0x100000,0x100000,0x80000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,};
   }
   private static void jj_la1_init_3() {
      jj_la1_3 = new int[] {0x0,0x0,0x2000000,0x0,0x2000008,0x0,0x2000000,0x2000000,0x0,0x0,0x0,0x2010000,0x2010000,0x2000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2010000,0x2010000,0x2000000,0x0,0x0,0x2010000,0x0,0x0,0x0,0x0,0x2008001,0x0,0x0,0x0,0x0,0x0,0x2008001,0x2008001,0x0,0x0,0x0,0x0,0x0,0x0,0x40000,0x40000,0x10000000,0x0,0x0,0x0,0x0,0x0,0x0,0x2008001,0x0,0x0,0x0,0x2008001,0x0,0x0,0x0,0x0,0x2000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2,0x4000000,0x0,0x0,0x0,0x0,0x10000000,0x0,0x800,0x2000,0x0,0x0,0x0,0x2008001,0x2008001,0x0,0x0,0x0,0x0,0x8,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80200040,0x0,0x0,0x0,0x0,0x200040,0x200040,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20080000,0x0,0x20080000,0x2008001,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2008001,0x0,0x0,0x0,0x0,0x0,0x2008000,0x0,0x0,0x2,0x2,0x0,0x2008000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2008000,0x2008001,0x0,0x0,0x4,0x0,0x4,0x0,0x2008001,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8,0x20,0x8000,0x0,0x2008001,0x2008001,0x0,0x0,0x0,0x8000,0x2008001,0x2000000,0x2008001,0x0,0x0,0x0,0x0,0x2008001,0x0,0x4,0x0,0x8000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1,0x0,0x0,};
   }
   private static void jj_la1_init_4() {
      jj_la1_4 = new int[] {0x0,0x0,0x2000,0x0,0x2000,0x0,0x0,0x0,0x0,0x0,0x0,0x2210,0x2210,0x2000,0x0,0x0,0x0,0x0,0x0,0x0,0x200,0x2010,0x2010,0x2010,0x1000000,0x1000000,0x2210,0x0,0x0,0x0,0x10,0x3048001,0x0,0x0,0x0,0x0,0x0,0x304a001,0x3048001,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3048001,0x0,0x0,0x0,0x3048001,0x0,0x0,0x0,0x0,0x2000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8000080,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3048001,0x3048001,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1,0x0,0x0,0x0,0x0,0x1,0x1,0x0,0x0,0x0,0xc00,0xc00,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x400000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2000000,0x2000000,0x2,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1000000,0x1000000,0x0,0x1000060,0x2048001,0x0,0x0,0x0,0x1000000,0x20,0x0,0x0,0x1000000,0x1000000,0x1000000,0x1000000,0x0,0x0,0x3048001,0x0,0x0,0x0,0x0,0x0,0x48001,0x0,0x0,0x0,0x8000080,0x0,0x48001,0x0,0x200c00,0x0,0x0,0x0,0x0,0x200c00,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x48001,0x2048001,0x0,0x0,0x0,0x0,0x0,0x0,0x3048001,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x48000,0x8,0x3048001,0x3048009,0x0,0x0,0x0,0x48001,0x3048001,0x0,0x3048001,0x0,0x0,0x0,0x0,0x3048001,0x0,0x0,0x0,0x48001,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x400000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2000000,0x0,0x0,};
   }
   private static void jj_la1_init_5() {
      jj_la1_5 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4000,0x0,0x100000,0x100000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x100000,0x100000,0x100000,0x0,0x0,0x100000,0x0,0x0,0x0,0x0,0x80800000,0x0,0x0,0x0,0x0,0x0,0x80800000,0x80800000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80800000,0x0,0x1,0x0,0x80800000,0x1,0x0,0x0,0x0,0x0,0x1,0x0,0x0,0x1,0x0,0x1,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80800000,0x80800000,0x0,0x0,0x0,0x8,0x0,0x0,0x0,0x0,0x0,0x0,0x8,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x800000,0x0,0x20,0x20,0x20,0x800000,0x800000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4,0x0,0x0,0x0,0x0,0x0,0x80800000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x82800000,0x0,0x0,0x0,0x0,0x0,0x80800000,0x0,0xc000000,0x0,0x0,0x0,0x80800000,0xc000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80800000,0x80800000,0x0,0x0,0x0,0x80,0x0,0x80,0x80800000,0x0,0x0,0x0,0x0,0x0,0x0,0x400,0x8,0x0,0x0,0x0,0x0,0x0,0x0,0x80000000,0x0,0x80800000,0x80800000,0x0,0x0,0x0,0x80800000,0x80800000,0x0,0x80800000,0x0,0x0,0x0,0x0,0x80800000,0x8,0x0,0x0,0x80800000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,};
   }
   private static void jj_la1_init_6() {
      jj_la1_6 = new int[] {0x0,0x0,0x20008001,0x0,0x20008001,0x0,0x20000000,0x20000000,0x0,0x800000,0x0,0x20008001,0x20008001,0x20008001,0x400,0x100,0x0,0x200,0x0,0x0,0x0,0x20008001,0x20008001,0x20008001,0x0,0x0,0x20008001,0x0,0x0,0x0,0x0,0x19400040,0x0,0x0,0x0,0x0,0x0,0x39408141,0x39408141,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40000000,0x0,0x20000000,0x0,0x0,0x19400040,0x0,0x0,0x0,0x19400040,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2000000,0x2000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8001,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x19400040,0x19400040,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40,0x0,0x0,0x40,0x0,0x0,0x8000,0x2000000,0x2000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8000,0x8000,0x8001,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10,0x19400040,0x0,0x8001,0x40,0x0,0x10,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x19400040,0x0,0x0,0x0,0x0,0x0,0x10400040,0x0,0x0,0x0,0x0,0x0,0x10400040,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10400040,0x19400040,0x0,0x40,0x0,0x0,0x0,0x0,0x19400040,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x200000,0x19400040,0x19600040,0x0,0x0,0x0,0x10000000,0x19400040,0x400000,0x19400040,0x0,0x0,0x0,0x0,0x19400040,0x0,0x0,0x0,0x10000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x9000000,0x0,0x0,};
   }
   private static void jj_la1_init_7() {
      jj_la1_7 = new int[] {0x0,0x0,0x21,0x0,0x21,0x0,0x0,0x0,0x0,0x0,0x0,0x61,0x61,0x21,0x0,0x0,0x0,0x0,0x0,0x0,0x40,0x21,0x21,0x21,0x0,0x0,0x61,0x0,0x0,0x0,0x0,0x400,0x0,0x0,0x0,0x220,0x220,0x421,0x421,0x0,0x220,0x220,0x2,0x2,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x400,0x0,0x0,0x0,0x400,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10,0x0,0x10,0x0,0x0,0x20,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1,0x0,0x10,0x0,0x0,0x0,0x0,0x0,0x400,0x400,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x400000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x400000,0x400000,0x21,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x400,0x0,0x21,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x400,0x0,0x0,0x0,0x0,0x0,0x400,0x0,0x0,0x0,0x0,0x0,0x400,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x400,0x400,0x0,0x0,0x0,0x0,0x0,0x0,0x400,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4,0x0,0x4,0x0,0x0,0x0,0x400,0x0,0x400,0x400,0x0,0x0,0x0,0x400,0x400,0x0,0x400,0x0,0x0,0x0,0x0,0x400,0x0,0x0,0x0,0x400,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,};
   }
   private static void jj_la1_init_8() {
      jj_la1_8 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3cac40,0x0,0x0,0x0,0x0,0x0,0x3cac40,0x3cac40,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3cac40,0x0,0x0,0x0,0x3cac40,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3cac40,0x3cac40,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x400000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x400000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3cac40,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3cac40,0x0,0x0,0x0,0x0,0x0,0x3cac40,0x0,0x0,0x0,0x0,0x0,0x3cac40,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3cac40,0x3cac40,0x0,0x40,0x0,0x0,0x0,0x0,0x3cac40,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3cac40,0x3cac40,0x0,0x0,0x0,0xc00,0x3cac40,0x0,0x3cac40,0x0,0x0,0x0,0x0,0x3cac40,0x0,0x0,0x0,0xc00,0xca000,0x300000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,};
   }
   private static void jj_la1_init_9() {
      jj_la1_9 = new int[] {0xffffffc0,0xffffffc0,0x0,0x0,0x0,0x0,0x0,0x0,0x180,0x200,0x0,0xffffffc0,0xffffffc0,0x0,0x0,0xffffffc0,0x0,0x0,0x0,0xffffffc0,0x0,0xffffffc0,0xffffffc0,0x0,0x0,0x0,0xffffffc0,0x0,0x0,0xffffffc0,0x0,0xffffffc0,0x0,0x0,0x0,0x0,0x0,0xffffffc0,0xffffffc0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xffffffc0,0x0,0x0,0x0,0xffffffc0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xffffffc0,0xffffffc0,0x0,0xffffffc0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3fe2000,0x0,0x0,0x3fe2000,0x1c000,0x0,0xffffffc0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xffffffc0,0x0,0x0,0x0,0xc000000,0xc000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20000000,0x20000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xffffffc0,0x0,0x0,0x0,0x0,0x0,0x0,0xffffffc0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xffffffc0,0x0,0x0,0x0,0x0,0x0,0xffffffc0,0x0,0x0,0x0,0x0,0x0,0xffffffc0,0x0,0x0,0x0,0x0,0x0,0xffffffc0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xffffffc0,0xffffffc0,0x0,0x3fe3000,0x0,0x0,0x0,0x0,0xffffffc0,0x0,0xffffffc0,0x0,0xffffffc0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xffffffc0,0xffffffc0,0x0,0x0,0x0,0x0,0xffffffc0,0x0,0xffffffc0,0x0,0x0,0x0,0x0,0xffffffc0,0x0,0x0,0x0,0x0,0x0,0xffffffc0,0xc000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,};
   }
   private static void jj_la1_init_10() {
      jj_la1_10 = new int[] {0xffffffff,0xffffffff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xffffffff,0xffffffff,0x0,0x0,0xffffffff,0x0,0x0,0x0,0xffffffff,0x0,0xffffffff,0xffffffff,0x0,0x0,0x0,0xffffffff,0x0,0x0,0xffffffff,0x0,0xffffffff,0x0,0x0,0x0,0x0,0x0,0xffffffff,0xffffffff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xffffffff,0x0,0x0,0x0,0xffffffff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xffffffff,0xffffffff,0x0,0xffffffff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xffffffff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xffffffff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10000000,0x0,0x20000000,0x8000000,0x0,0x0,0x0,0x40000000,0x0,0x0,0x0,0x0,0x40000000,0x0,0x0,0x0,0x0,0x0,0x40000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xffffffff,0x0,0x0,0x0,0x0,0x0,0x0,0xffffffff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xffffffff,0x0,0x0,0x0,0x3,0x0,0xffffffff,0x0,0x0,0x0,0x0,0x5,0xffffffff,0x0,0x0,0x0,0x0,0x0,0xffffffff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xffffffff,0xffffffff,0x0,0x0,0x0,0x0,0x0,0x0,0xffffffff,0x0,0xffffffff,0x0,0xffffffff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xffffffff,0xffffffff,0x60,0x0,0x180,0x0,0xffffffff,0x0,0xffffffff,0x80000000,0x0,0x0,0x0,0xffffffff,0x0,0x0,0x0,0x0,0x0,0xffffffff,0x0,0x8000,0x0,0x80000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1ff0000,0x0,0x0,0x0,};
   }
   private static void jj_la1_init_11() {
      jj_la1_11 = new int[] {0x1ffff,0x5ffff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x5ffff,0x5ffff,0x0,0x0,0x5ffff,0x0,0x0,0x4000,0x5ffff,0x0,0x5ffff,0x5ffff,0x2000,0x0,0x0,0x5ffff,0x1000,0x0,0x5ffff,0x0,0x67a5ffff,0x0,0x1000,0x0,0x0,0x0,0x67a5ffff,0x67a5ffff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20000000,0x0,0x0,0x0,0x67a5ffff,0x0,0x0,0x0,0x67a5ffff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x67a7ffff,0x67a7ffff,0x0,0x5ffff,0x0,0x0,0x0,0x0,0x4,0x8,0x10,0x1,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x45ffff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x5ffff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1,0x80,0x300,0x300,0x0,0x0,0x0,0x0,0x4,0x8,0x8,0x20000000,0x10,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x5ffff,0x0,0x0,0x0,0x0,0x0,0x0,0x67a5ffff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x67a5ffff,0x0,0x0,0x0,0x0,0x20,0x2025ffff,0x0,0x0,0x0,0x0,0x0,0x2025ffff,0x0,0x0,0x0,0x0,0x0,0x5ffff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2325ffff,0x67a5ffff,0x0,0x0,0x0,0x0,0x0,0x0,0x67a5ffff,0x0,0x5ffff,0x200000,0x5ffff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x67a5ffff,0x67a5ffff,0x0,0x0,0x0,0x0,0x67a5ffff,0x0,0x67a5ffff,0x0,0x0,0x0,0x0,0x67a5ffff,0x0,0x0,0x0,0x0,0x0,0x5ffff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x44800000,0x23000000,0x0,};
   }
   private static void jj_la1_init_12() {
      jj_la1_12 = new int[] {0x0,0x0,0x14,0x200000,0x4,0x200000,0x0,0x0,0x0,0x0,0x0,0x4,0x4,0x4,0x0,0x0,0x1,0x0,0x0,0x0,0x0,0x4,0x4,0x4,0x0,0x0,0x4,0x0,0x0,0x0,0x0,0x1e0004,0x0,0x0,0x100,0x0,0x0,0x1e0004,0x1e0004,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x68000,0x0,0x1,0x80000,0x1e0004,0x4,0x0,0x0,0x1e0004,0x0,0x2000,0x1,0x2000,0x0,0x0,0x1,0x0,0x0,0x0,0x0,0x1,0x0,0x4,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1,0x4,0x0,0x0,0x0,0x0,0x0,0x0,0x1,0x1e8004,0x1e0004,0x0,0x0,0x0,0x0,0x0,0x1,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1,0x4,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1,0x0,0x0,0x0,0x0,0x60000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1,0x0,0x0,0x0,0x0,0x1,0x0,0x1,0x0,0x0,0x0,0x1,0x0,0x1,0x0,0x0,0x0,0x0,0x0,0x60000,0x60000,0x0,0x0,0x4,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x7f00,0x7f00,0x1e0004,0x7f00,0x4,0x0,0x0,0x0,0x10,0x10,0x0,0x0,0x0,0x0,0x1,0x4,0x1e0004,0x1,0x0,0x0,0x0,0x0,0x1e0004,0x1,0x0,0x0,0x0,0x0,0x1e0004,0x0,0x0,0x1,0x1,0x1,0x0,0x0,0x800000,0x60000,0x60000,0x18000,0x18000,0x60000,0x40,0x180004,0x1e0004,0x180000,0x0,0x0,0x0,0x0,0x0,0x1e0004,0x1,0x0,0x180000,0x0,0x4,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1,0x0,0x0,0x1e0004,0x1e0004,0x0,0x1,0x0,0x0,0x1e0004,0x0,0x1e0004,0x0,0x1,0x0,0x0,0x1e0004,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1,0x0,0x1,0x1,0x1,0x0,0x1,0x0,0x4,0x4,0x4,0x4,0x1,0x4,0x1,0x4,0x4,0x4,0x4,0x4,0x0,0x40,0x0,0x0,0x0,0x1,};
   }
  final private JJCalls[] jj_2_rtns = new JJCalls[43];
  private boolean jj_rescan = false;
  private int jj_gc = 0;

  /** Constructor with InputStream. */
  public TeiidCompletionParser(java.io.InputStream stream) {
     this(stream, null);
  }
  /** Constructor with InputStream and supplied encoding */
  public TeiidCompletionParser(java.io.InputStream stream, String encoding) {
    try { jj_input_stream = new JavaCharStream(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source = new TeiidCompletionParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 293; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream) {
     ReInit(stream, null);
  }
  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream, String encoding) {
    try { jj_input_stream.ReInit(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jjtree.reset();
    jj_gen = 0;
    for (int i = 0; i < 293; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor. */
  public TeiidCompletionParser(java.io.Reader stream) {
    jj_input_stream = new JavaCharStream(stream, 1, 1);
    token_source = new TeiidCompletionParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 293; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(java.io.Reader stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jjtree.reset();
    jj_gen = 0;
    for (int i = 0; i < 293; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor with generated Token Manager. */
  public TeiidCompletionParser(TeiidCompletionParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 293; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(TeiidCompletionParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jjtree.reset();
    jj_gen = 0;
    for (int i = 0; i < 293; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken;
    if ((oldToken = token).next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      if (++jj_gc > 100) {
        jj_gc = 0;
        for (int i = 0; i < jj_2_rtns.length; i++) {
          JJCalls c = jj_2_rtns[i];
          while (c != null) {
            if (c.gen < jj_gen) c.first = null;
            c = c.next;
          }
        }
      }
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }

  static private final class LookaheadSuccess extends java.lang.Error { }
  final private LookaheadSuccess jj_ls = new LookaheadSuccess();
  private boolean jj_scan_token(int kind) {
    if (jj_scanpos == jj_lastpos) {
      jj_la--;
      if (jj_scanpos.next == null) {
        jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
      } else {
        jj_lastpos = jj_scanpos = jj_scanpos.next;
      }
    } else {
      jj_scanpos = jj_scanpos.next;
    }
    if (jj_rescan) {
      int i = 0; Token tok = token;
      while (tok != null && tok != jj_scanpos) { i++; tok = tok.next; }
      if (tok != null) jj_add_error_token(kind, i);
    }
    if (jj_scanpos.kind != kind) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) throw jj_ls;
    return false;
  }


/** Get the next Token. */
  final public Token getNextToken() {
    if (token.next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    jj_gen++;
    return token;
  }

/** Get the specific Token. */
  final public Token getToken(int index) {
    Token t = token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  private int jj_ntk() {
    if ((jj_nt=token.next) == null)
      return (jj_ntk = (token.next=token_source.getNextToken()).kind);
    else
      return (jj_ntk = jj_nt.kind);
  }

  private java.util.List<int[]> jj_expentries = new java.util.ArrayList<int[]>();
  private int[] jj_expentry;
  private int jj_kind = -1;
  private int[] jj_lasttokens = new int[100];
  private int jj_endpos;

  private void jj_add_error_token(int kind, int pos) {
    if (pos >= 100) return;
    if (pos == jj_endpos + 1) {
      jj_lasttokens[jj_endpos++] = kind;
    } else if (jj_endpos != 0) {
      jj_expentry = new int[jj_endpos];
      for (int i = 0; i < jj_endpos; i++) {
        jj_expentry[i] = jj_lasttokens[i];
      }
      jj_entries_loop: for (java.util.Iterator<?> it = jj_expentries.iterator(); it.hasNext();) {
        int[] oldentry = (int[])(it.next());
        if (oldentry.length == jj_expentry.length) {
          for (int i = 0; i < jj_expentry.length; i++) {
            if (oldentry[i] != jj_expentry[i]) {
              continue jj_entries_loop;
            }
          }
          jj_expentries.add(jj_expentry);
          break jj_entries_loop;
        }
      }
      if (pos != 0) jj_lasttokens[(jj_endpos = pos) - 1] = kind;
    }
  }

  /** Generate ParseException. */
  public ParseException generateParseException() {
    jj_expentries.clear();
    boolean[] la1tokens = new boolean[408];
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 293; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
          if ((jj_la1_1[i] & (1<<j)) != 0) {
            la1tokens[32+j] = true;
          }
          if ((jj_la1_2[i] & (1<<j)) != 0) {
            la1tokens[64+j] = true;
          }
          if ((jj_la1_3[i] & (1<<j)) != 0) {
            la1tokens[96+j] = true;
          }
          if ((jj_la1_4[i] & (1<<j)) != 0) {
            la1tokens[128+j] = true;
          }
          if ((jj_la1_5[i] & (1<<j)) != 0) {
            la1tokens[160+j] = true;
          }
          if ((jj_la1_6[i] & (1<<j)) != 0) {
            la1tokens[192+j] = true;
          }
          if ((jj_la1_7[i] & (1<<j)) != 0) {
            la1tokens[224+j] = true;
          }
          if ((jj_la1_8[i] & (1<<j)) != 0) {
            la1tokens[256+j] = true;
          }
          if ((jj_la1_9[i] & (1<<j)) != 0) {
            la1tokens[288+j] = true;
          }
          if ((jj_la1_10[i] & (1<<j)) != 0) {
            la1tokens[320+j] = true;
          }
          if ((jj_la1_11[i] & (1<<j)) != 0) {
            la1tokens[352+j] = true;
          }
          if ((jj_la1_12[i] & (1<<j)) != 0) {
            la1tokens[384+j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 408; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.add(jj_expentry);
      }
    }
    jj_endpos = 0;
    jj_rescan_token();
    jj_add_error_token(0, 0);
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = jj_expentries.get(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  /** Enable tracing. */
  final public void enable_tracing() {
  }

  /** Disable tracing. */
  final public void disable_tracing() {
  }

  private void jj_rescan_token() {
    jj_rescan = true;
    for (int i = 0; i < 43; i++) {
    try {
      JJCalls p = jj_2_rtns[i];
      do {
        if (p.gen > jj_gen) {
          jj_la = p.arg; jj_lastpos = jj_scanpos = p.first;
          switch (i) {
            case 0: jj_3_1(); break;
            case 1: jj_3_2(); break;
            case 2: jj_3_3(); break;
            case 3: jj_3_4(); break;
            case 4: jj_3_5(); break;
            case 5: jj_3_6(); break;
            case 6: jj_3_7(); break;
            case 7: jj_3_8(); break;
            case 8: jj_3_9(); break;
            case 9: jj_3_10(); break;
            case 10: jj_3_11(); break;
            case 11: jj_3_12(); break;
            case 12: jj_3_13(); break;
            case 13: jj_3_14(); break;
            case 14: jj_3_15(); break;
            case 15: jj_3_16(); break;
            case 16: jj_3_17(); break;
            case 17: jj_3_18(); break;
            case 18: jj_3_19(); break;
            case 19: jj_3_20(); break;
            case 20: jj_3_21(); break;
            case 21: jj_3_22(); break;
            case 22: jj_3_23(); break;
            case 23: jj_3_24(); break;
            case 24: jj_3_25(); break;
            case 25: jj_3_26(); break;
            case 26: jj_3_27(); break;
            case 27: jj_3_28(); break;
            case 28: jj_3_29(); break;
            case 29: jj_3_30(); break;
            case 30: jj_3_31(); break;
            case 31: jj_3_32(); break;
            case 32: jj_3_33(); break;
            case 33: jj_3_34(); break;
            case 34: jj_3_35(); break;
            case 35: jj_3_36(); break;
            case 36: jj_3_37(); break;
            case 37: jj_3_38(); break;
            case 38: jj_3_39(); break;
            case 39: jj_3_40(); break;
            case 40: jj_3_41(); break;
            case 41: jj_3_42(); break;
            case 42: jj_3_43(); break;
          }
        }
        p = p.next;
      } while (p != null);
      } catch(LookaheadSuccess ls) { }
    }
    jj_rescan = false;
  }

  private void jj_save(int index, int xla) {
    JJCalls p = jj_2_rtns[index];
    while (p.gen > jj_gen) {
      if (p.next == null) { p = p.next = new JJCalls(); break; }
      p = p.next;
    }
    p.gen = jj_gen + xla - jj_la; p.first = token; p.arg = xla;
  }

  static final class JJCalls {
    int gen;
    Token first;
    int arg;
    JJCalls next;
  }

}
