/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.modeshape;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.jcr.ItemVisitor;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.nodetype.NodeType;
import org.komodo.spi.query.TeiidService;
import org.komodo.spi.runtime.version.DefaultTeiidVersion;
import org.komodo.spi.runtime.version.TeiidVersion;
import org.komodo.spi.type.DataTypeManager;
import org.komodo.teiid.TeiidServiceProvider;

public abstract class AbstractNodeVisitor
implements ItemVisitor {
    private TeiidVersion version;
    private DataTypeManager dataTypeManager;

    public AbstractNodeVisitor(TeiidVersion version) {
        this.version = version == null ? DefaultTeiidVersion.Version.DEFAULT_TEIID_VERSION.get() : version;
    }

    protected boolean isTeiidVersionOrGreater(DefaultTeiidVersion.Version teiidVersion) {
        TeiidVersion minVersion = this.getVersion().getMinimumVersion();
        return minVersion.equals(teiidVersion.get()) || minVersion.isGreaterThan(teiidVersion.get());
    }

    protected boolean isLessThanTeiidVersion(DefaultTeiidVersion.Version teiidVersion) {
        TeiidVersion maxVersion = this.getVersion().getMaximumVersion();
        return maxVersion.isLessThan(teiidVersion.get());
    }

    protected boolean isTeiid87OrGreater() {
        return this.isTeiidVersionOrGreater(DefaultTeiidVersion.Version.TEIID_8_7);
    }

    public TeiidVersion getVersion() {
        return this.version;
    }

    public DataTypeManager getDataTypeManager() throws Exception {
        if (this.dataTypeManager == null) {
            TeiidService teiidService = TeiidServiceProvider.getInstance().getTeiidService(this.getVersion());
            this.dataTypeManager = teiidService.getDataTypeManager();
        }
        return this.dataTypeManager;
    }

    protected abstract String undefined();

    protected NodeType findMixinTypeByNamespace(Node node, String nspacePrefix) throws RepositoryException {
        NodeType[] mixinTypes = node.getMixinNodeTypes();
        if (mixinTypes.length == 0) {
            return null;
        }
        if (nspacePrefix == null) {
            return null;
        }
        if (!nspacePrefix.endsWith(":")) {
            nspacePrefix = nspacePrefix + ":";
        }
        for (NodeType mixinType : mixinTypes) {
            if (!mixinType.getName().startsWith(nspacePrefix)) continue;
            return mixinType;
        }
        return null;
    }

    protected NodeType findMixinTypeById(Node node, String mixinTypeId) throws RepositoryException {
        NodeType[] mixinTypes = node.getMixinNodeTypes();
        if (mixinTypes.length == 0) {
            return null;
        }
        if (mixinTypeId == null) {
            return null;
        }
        for (NodeType mixinType : mixinTypes) {
            if (!mixinType.getName().equals(mixinTypeId)) continue;
            return mixinType;
        }
        return null;
    }

    protected boolean hasMixinType(Node node, String mixinTypeId) throws RepositoryException {
        if (node == null || mixinTypeId == null) {
            return false;
        }
        String[] components = mixinTypeId.split(":");
        if (components == null) {
            return false;
        }
        NodeType mixinType = this.findMixinTypeById(node, mixinTypeId);
        return mixinType != null ? mixinType.getName().equals(mixinTypeId) : false;
    }

    protected void visitChild(Node node, String relNodePath) throws PathNotFoundException, RepositoryException {
        if (node.hasNode(relNodePath)) {
            Node child = node.getNode(relNodePath);
            child.accept((ItemVisitor)this);
        }
    }

    protected Collection<Node> getChildren(Node node) throws RepositoryException {
        ArrayList<Node> children = new ArrayList<Node>();
        NodeIterator nodeIterator = node.getNodes();
        while (nodeIterator.hasNext()) {
            Node child = nodeIterator.nextNode();
            children.add(child);
        }
        return children;
    }

    protected Collection<Node> getChildren(Node node, String mixinTypeId) throws RepositoryException {
        if (node == null) {
            return Collections.emptyList();
        }
        ArrayList<Node> children = new ArrayList<Node>();
        NodeIterator nodeIterator = node.getNodes();
        while (nodeIterator.hasNext()) {
            Node child = nodeIterator.nextNode();
            if (!this.hasMixinType(child, mixinTypeId)) continue;
            children.add(child);
        }
        return children;
    }

    protected void visitFilteredChildren(Node node, String nodeTypeName) throws PathNotFoundException, RepositoryException {
        NodeIterator nodeIterator = node.getNodes();
        while (nodeIterator.hasNext()) {
            Node child = nodeIterator.nextNode();
            NodeType nodeType = child.getPrimaryNodeType();
            if (!nodeTypeName.equals(nodeType.getName())) continue;
            child.accept((ItemVisitor)this);
        }
    }

    protected void visitChildren(Node node) throws RepositoryException {
        NodeIterator nodeIterator = node.getNodes();
        while (nodeIterator.hasNext()) {
            Node child = nodeIterator.nextNode();
            child.accept((ItemVisitor)this);
        }
    }

    protected Property property(Node node, String propName) throws RepositoryException {
        if (node == null || propName == null) {
            return null;
        }
        if (!node.hasProperty(propName)) {
            return null;
        }
        Property property = node.getProperty(propName);
        return property;
    }

    protected List<Value> multiPropertyValues(Property refProp) throws RepositoryException {
        List<Value> values = null;
        values = !refProp.isMultiple() ? Collections.singletonList(refProp.getValue()) : Arrays.asList(refProp.getValues());
        return values;
    }

    protected String toString(Property property) throws RepositoryException {
        if (property == null) {
            return this.undefined();
        }
        Value value = property.isMultiple() ? property.getValues()[0] : property.getValue();
        String valueString = null;
        switch (value.getType()) {
            case 1: {
                valueString = value.getString();
                break;
            }
            case 5: {
                valueString = value.getDate().toString();
                break;
            }
            case 2: {
                valueString = value.getBinary().toString();
                break;
            }
            case 4: {
                valueString = Double.toString(value.getDouble());
                break;
            }
            case 12: {
                valueString = value.getDecimal().toString();
                break;
            }
            case 3: {
                valueString = Long.toString(value.getLong());
                break;
            }
            case 6: {
                valueString = Boolean.toString(value.getBoolean());
                break;
            }
            case 7: {
                valueString = value.getString();
                break;
            }
            case 8: {
                valueString = value.getString();
                break;
            }
            case 9: {
                valueString = value.getString();
                break;
            }
            case 10: {
                valueString = value.getString();
                break;
            }
            case 11: {
                valueString = value.getString();
                break;
            }
            default: {
                valueString = this.undefined();
            }
        }
        return valueString;
    }
}

