/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.modeshape.teiid;

import java.sql.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.jcr.ItemVisitor;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.nodetype.NodeType;
import org.komodo.modeshape.AbstractNodeVisitor;
import org.komodo.modeshape.teiid.language.SortSpecification;
import org.komodo.spi.constants.StringConstants;
import org.komodo.spi.lexicon.TeiidSqlConstants;
import org.komodo.spi.lexicon.TeiidSqlContext;
import org.komodo.spi.lexicon.TeiidSqlLexicon;
import org.komodo.spi.query.AggregateFunctions;
import org.komodo.spi.query.BranchingMode;
import org.komodo.spi.query.CriteriaOperator;
import org.komodo.spi.query.DisplayMode;
import org.komodo.spi.query.JoinTypeTypes;
import org.komodo.spi.query.LogicalOperator;
import org.komodo.spi.query.MatchMode;
import org.komodo.spi.query.Operation;
import org.komodo.spi.query.ParameterInfo;
import org.komodo.spi.query.PredicateQuantifier;
import org.komodo.spi.query.TriggerEvent;
import org.komodo.spi.runtime.version.DefaultTeiidVersion;
import org.komodo.spi.runtime.version.TeiidVersion;
import org.komodo.spi.type.DataTypeManager;
import org.komodo.utils.ArgCheck;
import org.komodo.utils.KLog;
import org.komodo.utils.StringUtils;
import org.modeshape.common.collection.EmptyIterator;
import org.modeshape.jcr.JcrSession;

public class TeiidSqlNodeVisitor
extends AbstractNodeVisitor
implements StringConstants,
TeiidSqlConstants.NonReserved,
TeiidSqlConstants.Reserved,
TeiidSqlConstants.Tokens {
    protected static final String UNDEFINED = "<undefined>";
    protected static final String BEGIN_HINT = "/*+";
    protected static final String END_HINT = "*/";
    private static final String NODE_KEY = "node";
    private static final String KEYWORD_KEY = "keyword";
    private static final String SHORT_NAME_ONLY_KEY = "shortNameOnly";
    private KLog logger = KLog.getLogger();
    private Session session;
    private StringBuilder builder;

    public TeiidSqlNodeVisitor(TeiidVersion teiidVersion) {
        super(teiidVersion);
    }

    @Override
    protected String undefined() {
        return UNDEFINED;
    }

    public Session getSession() {
        return this.session;
    }

    public String getTeiidSql(Node node) throws Exception {
        if (node == null) {
            return this.undefined();
        }
        this.builder = new StringBuilder();
        this.session = node.getSession();
        node.accept((ItemVisitor)this);
        return this.builder.toString();
    }

    protected String encode(String path) {
        if (this.session instanceof JcrSession) {
            return ((JcrSession)this.session).encode(path);
        }
        return path;
    }

    protected void append(String value) {
        this.builder.append(value);
    }

    protected void beginClause(int level) {
        this.append(" ");
    }

    protected String stripNameSpace(String name) {
        name = name.replace("tsql", "");
        name = name.replaceAll("[\\p{C}\\p{Z}:]", "");
        return name;
    }

    protected void appendToken(String name) {
        name = this.stripNameSpace(name);
        this.append(name.toUpperCase());
    }

    protected void appendToken(Node node) throws Exception {
        String name = node.getName();
        this.appendToken(name);
    }

    protected Node reference(Node node, String refName) throws Exception {
        if (node == null || refName == null) {
            return null;
        }
        if (!node.hasNode(refName = this.encode(refName))) {
            return null;
        }
        return node.getNode(refName);
    }

    protected int size(Node node, String refName) throws Exception {
        if (node == null || refName == null) {
            return 0;
        }
        if (!node.hasNode(refName = this.encode(refName))) {
            return 0;
        }
        NodeIterator nodes = node.getNodes(refName);
        int size = 0;
        size = 0;
        while (nodes.hasNext()) {
            nodes.next();
            ++size;
        }
        return size;
    }

    protected Iterator<Node> references(Node node, String refName) throws Exception {
        if (node == null || refName == null) {
            return null;
        }
        if (!node.hasNode(refName = this.encode(refName))) {
            return new EmptyIterator();
        }
        return node.getNodes(refName);
    }

    protected void iterate(Iterator<Node> nodes) throws Exception {
        int i = 0;
        while (nodes.hasNext()) {
            if (i > 0) {
                this.append(", ");
            }
            Node node = nodes.next();
            this.visit(node);
            ++i;
        }
    }

    protected void iterate(Node node, String refName) throws Exception {
        Iterator<Node> nodes = this.references(node, refName);
        int i = 0;
        while (nodes.hasNext()) {
            if (i > 0) {
                this.append(", ");
            }
            Node childNode = nodes.next();
            this.visit(childNode);
            ++i;
        }
    }

    protected boolean propertyBoolean(Node node, String propName) throws Exception {
        Property property = this.property(node, propName);
        if (property == null) {
            return false;
        }
        Boolean value = (Boolean)this.propertyValue(property, DataTypeManager.DataTypeName.BOOLEAN);
        return value;
    }

    protected String propertyString(Node node, String propName) throws Exception {
        Property property = this.property(node, propName);
        if (property == null) {
            return null;
        }
        String value = (String)this.propertyValue(property, DataTypeManager.DataTypeName.STRING);
        return value;
    }

    protected long propertyLong(Node node, String propName) throws Exception {
        Property property = this.property(node, propName);
        if (property == null) {
            return -1L;
        }
        Long value = (Long)this.propertyValue(property, DataTypeManager.DataTypeName.LONG);
        return value;
    }

    protected <T> T propertyValue(Value value, DataTypeManager.DataTypeName dataTypeName) throws RepositoryException {
        ArgCheck.isNotNull((Object)dataTypeName, (String)"dataTypeName");
        Object valueObject = null;
        switch (dataTypeName) {
            case STRING: 
            case CHAR: 
            case VARCHAR: 
            case XML: 
            case DATE: 
            case TIME: 
            case TIMESTAMP: {
                valueObject = value.getString();
                break;
            }
            case DOUBLE: 
            case FLOAT: {
                valueObject = value.getDouble();
                break;
            }
            case DECIMAL: 
            case BIGDECIMAL: {
                valueObject = value.getDecimal();
                break;
            }
            case LONG: 
            case BYTE: 
            case INTEGER: 
            case REAL: 
            case BIGINT: 
            case SHORT: 
            case TINYINT: 
            case SMALLINT: 
            case BIGINTEGER: {
                valueObject = value.getLong();
                break;
            }
            case BOOLEAN: {
                valueObject = value.getBoolean();
                break;
            }
            case BLOB: 
            case CLOB: 
            case OBJECT: 
            case VARBINARY: {
                valueObject = value.getBinary();
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        return (T)valueObject;
    }

    private <T> T propertyValue(Property property, DataTypeManager.DataTypeName dataTypeName) throws RepositoryException {
        if (property == null) {
            return null;
        }
        Value value = property.isMultiple() ? property.getValues()[0] : property.getValue();
        return this.propertyValue(value, dataTypeName);
    }

    protected <T> T propertyValue(Node node, String propName, DataTypeManager.DataTypeName dataTypeName) throws RepositoryException {
        Property property = this.property(node, propName);
        if (property == null) {
            return null;
        }
        T value = this.propertyValue(property, dataTypeName);
        return value;
    }

    protected <T> Collection<T> propertyValues(Node node, String propName, DataTypeManager.DataTypeName dataTypeName) throws RepositoryException {
        Collection collection = Collections.emptyList();
        Property property = this.property(node, propName);
        if (property == null) {
            return collection;
        }
        if (!property.isMultiple()) {
            T value = this.propertyValue(property, dataTypeName);
            if (value != null) {
                collection = Collections.singleton(value);
            }
        } else {
            ArrayList values = new ArrayList();
            for (Value valueObject : property.getValues()) {
                T value = this.propertyValue(valueObject, dataTypeName);
                if (value == null) continue;
                values.add(value);
            }
            collection = values;
        }
        return collection;
    }

    protected boolean isTeiidSqlType(NodeType nodeType) {
        if (nodeType == null) {
            return false;
        }
        return nodeType.getName().startsWith("tsql:");
    }

    protected boolean instanceOf(Node node, TeiidSqlLexicon.LexTokens superTypeToken) throws Exception {
        NodeType[] superTypes;
        if (node == null) {
            return false;
        }
        NodeType tsqlType = this.findTeiidSqlType(node);
        if (tsqlType == null) {
            return false;
        }
        TeiidSqlLexicon.LexTokens stToken = TeiidSqlLexicon.LexTokens.findClass((String)tsqlType.getName());
        if (superTypeToken.equals((Object)stToken)) {
            return true;
        }
        for (NodeType superType : superTypes = tsqlType.getSupertypes()) {
            if (!this.isTeiidSqlType(superType) || !superTypeToken.equals((Object)(stToken = TeiidSqlLexicon.LexTokens.findClass((String)superType.getName())))) continue;
            return true;
        }
        return false;
    }

    protected NodeType findTeiidSqlType(Node node) throws RepositoryException {
        NodeType[] mixinTypes = node.getMixinNodeTypes();
        if (mixinTypes.length == 0) {
            return null;
        }
        NodeType tsqlMixinType = null;
        for (NodeType mixinType : mixinTypes) {
            if (!this.isTeiidSqlType(mixinType)) continue;
            tsqlMixinType = mixinType;
            break;
        }
        return tsqlMixinType;
    }

    protected void addWithClause(Node node) throws Exception {
        Iterator<Node> withNodes = this.references(node, "tsql:with");
        if (!withNodes.hasNext()) {
            return;
        }
        this.appendToken("tsql:with");
        this.append(" ");
        this.iterate(node, "tsql:with");
        this.beginClause(0);
    }

    protected boolean hasHint(Node node) throws Exception {
        boolean optional = this.propertyBoolean(node, "tsql:optional");
        boolean makeInd = this.propertyBoolean(node, "tsql:makeInd");
        boolean makeNotDep = this.propertyBoolean(node, "tsql:makeNotDep");
        boolean noUnnest = this.propertyBoolean(node, "tsql:noUnnest");
        boolean preserve = this.propertyBoolean(node, "tsql:preserve");
        Node makeDep = this.reference(node, "tsql:makeDependency");
        return optional || makeInd || makeNotDep || noUnnest || preserve || makeDep != null;
    }

    protected boolean isMakeDepSimple(Node makeDep) throws Exception {
        if (makeDep == null) {
            return false;
        }
        boolean hasMax = makeDep.hasProperty("tsql:max");
        boolean join = this.propertyBoolean(makeDep, "tsql:join");
        return !hasMax && !join;
    }

    protected void addHintComment(Node node) throws Exception {
        boolean optional = this.propertyBoolean(node, "tsql:optional");
        boolean makeInd = this.propertyBoolean(node, "tsql:makeInd");
        boolean makeNotDep = this.propertyBoolean(node, "tsql:makeNotDep");
        boolean noUnnest = this.propertyBoolean(node, "tsql:noUnnest");
        boolean preserve = this.propertyBoolean(node, "tsql:preserve");
        Node makeDep = this.reference(node, "tsql:makeDependency");
        if (this.hasHint(node)) {
            this.append(BEGIN_HINT);
            this.append(" ");
            if (optional) {
                this.append("OPTIONAL");
                this.append(" ");
            }
            if (makeDep != null && this.isMakeDepSimple(makeDep)) {
                this.append("MAKEDEP");
                this.append(" ");
            }
            if (makeNotDep) {
                this.append("MAKENOTDEP");
                this.append(" ");
            }
            if (makeInd) {
                this.append("MAKEIND");
                this.append(" ");
            }
            if (noUnnest) {
                this.append("NO_UNNEST");
                this.append(" ");
            }
            if (preserve) {
                this.append("PRESERVE");
                this.append(" ");
            }
            this.append(END_HINT);
            this.append(" ");
        }
    }

    protected void addMakeDep(Node node) throws Exception {
        if (this.isLessThanTeiidVersion(DefaultTeiidVersion.Version.TEIID_8_5)) {
            return;
        }
        Node makeDep = this.reference(node, "tsql:makeDependency");
        if (makeDep != null && !this.isMakeDepSimple(makeDep)) {
            this.append(" ");
            this.append("MAKEDEP");
            this.visit(makeDep);
        }
    }

    protected String escapeStringValue(String str, String tick) {
        return StringUtils.replaceAll((String)str, (String)tick, (String)(tick + tick));
    }

    protected String escapeSinglePart(String token) {
        if (TeiidSqlConstants.isReservedWord((TeiidVersion)this.getVersion(), (String)token)) {
            return "\"" + token + "\"";
        }
        boolean escape = true;
        char start = token.charAt(0);
        if (start == '#' || start == '@' || StringUtils.isLetter((char)start)) {
            escape = false;
            for (int i = 1; !escape && i < token.length(); ++i) {
                char c = token.charAt(i);
                escape = !StringUtils.isLetterOrDigit((char)c) && c != '_';
            }
        }
        if (escape) {
            return "\"" + this.escapeStringValue(token, "\"") + "\"";
        }
        return token;
    }

    protected void appendDisplayName(String name) {
        String[] pathParts = name.split("\\.");
        for (int i = 0; i < pathParts.length; ++i) {
            if (i > 0) {
                this.append(".");
            }
            this.append(this.escapeSinglePart(pathParts[i]));
        }
    }

    protected String shortName(String name) {
        int index = name.lastIndexOf(".");
        if (index >= 0) {
            return name.substring(index + 1);
        }
        return name;
    }

    protected String outputName(Node node) throws Exception {
        String name = this.propertyString(node, "tsql:name");
        String outputName = this.propertyString(node, "tsql:outputName");
        return outputName == null ? name : outputName;
    }

    protected void appendNested(Node node) throws Exception {
        boolean useParens = this.instanceOf(node, TeiidSqlLexicon.LexTokens.CRITERIA);
        if (useParens) {
            this.append("(");
        }
        this.visit(node);
        if (useParens) {
            this.append(")");
        }
    }

    protected void appendLiteral(Class<?> type, boolean multiValued, Object value) throws Exception {
        Class booleanClass = this.getDataTypeManager().getDefaultDataClass(DataTypeManager.DataTypeName.BOOLEAN);
        String[] constantParts = null;
        if (multiValued) {
            constantParts = new String[]{"?"};
        } else if (value == null) {
            constantParts = booleanClass.equals(type) ? new String[]{"UNKNOWN"} : new String[]{"NULL".toLowerCase()};
        } else {
            if (this.isTeiid87OrGreater() && value instanceof Array) {
                Array av = (Array)value;
                this.append("(");
                try {
                    Object[] values = (Object[])av.getArray();
                    for (int i = 0; i < values.length; ++i) {
                        Object value2;
                        if (i > 0) {
                            this.append(",");
                            this.append(" ");
                        }
                        this.appendLiteral((value2 = values[i]) != null ? value2.getClass() : values.getClass().getComponentType(), multiValued, value2);
                    }
                }
                catch (Exception ex) {
                    this.logger.error(ex.getMessage(), (Throwable)ex, new Object[0]);
                    this.append("ERROR");
                }
                this.append(")");
                return;
            }
            if (Number.class.isAssignableFrom(type)) {
                constantParts = new String[]{value.toString()};
            } else if (booleanClass.equals(type)) {
                constantParts = new String[]{value.equals(Boolean.TRUE) ? "TRUE" : "FALSE"};
            } else if (type.equals(this.getDataTypeManager().getDefaultDataClass(DataTypeManager.DataTypeName.TIMESTAMP))) {
                constantParts = new String[]{"{ts'", value.toString(), "'}"};
            } else if (type.equals(this.getDataTypeManager().getDefaultDataClass(DataTypeManager.DataTypeName.TIME))) {
                constantParts = new String[]{"{t'", value.toString(), "'}"};
            } else if (type.equals(this.getDataTypeManager().getDefaultDataClass(DataTypeManager.DataTypeName.DATE))) {
                constantParts = new String[]{"{d'", value.toString(), "'}"};
            } else if (type.equals(this.getDataTypeManager().getDefaultDataClass(DataTypeManager.DataTypeName.VARBINARY))) {
                constantParts = new String[]{"X'", value.toString(), "'"};
            }
            if (constantParts == null) {
                if (this.getDataTypeManager().isLOB(type)) {
                    constantParts = new String[]{"?"};
                } else {
                    String strValue = value.toString();
                    strValue = this.escapeStringValue(strValue, "'");
                    constantParts = new String[]{"'", strValue, "'"};
                }
            }
        }
        for (String string : constantParts) {
            this.append(string);
        }
    }

    protected void appendLabel(Node node) throws Exception {
        String label = this.propertyString(node, "tsql:label");
        if (label != null) {
            this.appendDisplayName(label);
            this.append(" ");
            this.append(":");
            this.append(" ");
        }
    }

    protected void appendStatements(Node node, String refName) throws Exception {
        Iterator<Node> statements = this.references(node, refName);
        while (statements.hasNext()) {
            this.visit(statements.next());
            this.append("\n");
        }
    }

    public void visit(Property property) {
    }

    protected void visit(Node node, TeiidSqlContext context) throws RepositoryException {
        if (node == null) {
            this.append(this.undefined());
            return;
        }
        NodeType tsqlMixinType = this.findTeiidSqlType(node);
        if (tsqlMixinType == null) {
            this.visitChildren(node);
            return;
        }
        TeiidSqlLexicon.LexTokens LexEnum = TeiidSqlLexicon.LexTokens.findClass((String)tsqlMixinType.getName());
        try {
            switch (LexEnum) {
                case CRITERIA: {
                    this.criteria(context);
                    break;
                }
                case COMPARE_CRITERIA: {
                    this.compareCriteria(context);
                    break;
                }
                case SUBQUERY_COMPARE_CRITERIA: {
                    this.subqueryCompareCriteria(context);
                    break;
                }
                case SET_CRITERIA: {
                    this.setCriteria(context);
                    break;
                }
                case SUBQUERY_SET_CRITERIA: {
                    this.subquerySetCriteria(context);
                    break;
                }
                case BETWEEN_CRITERIA: {
                    this.betweenCriteria(context);
                    break;
                }
                case COMPOUND_CRITERIA: {
                    this.compoundCriteria(context);
                    break;
                }
                case EXISTS_CRITERIA: {
                    this.existsCriteria(context);
                    break;
                }
                case EXPRESSION_CRITERIA: {
                    this.expressionCriteria(context);
                    break;
                }
                case IS_NULL_CRITERIA: {
                    this.isNullCriteria(context);
                    break;
                }
                case MATCH_CRITERIA: {
                    this.matchCriteria(context);
                    break;
                }
                case NOT_CRITERIA: {
                    this.notCriteria(context);
                    break;
                }
                case ALTER_PROCEDURE: {
                    this.alterProcedure(context);
                    break;
                }
                case ALTER_TRIGGER: {
                    this.alterTrigger(context);
                    break;
                }
                case ALTER_VIEW: {
                    this.alterView(context);
                    break;
                }
                case DELETE: {
                    this.delete(context);
                    break;
                }
                case INSERT: {
                    this.insert(context);
                    break;
                }
                case STORED_PROCEDURE: {
                    this.storedProcedure(context);
                    break;
                }
                case UPDATE: {
                    this.update(context);
                    break;
                }
                case DYNAMIC_COMMAND: {
                    this.dynamicCommand(context);
                    break;
                }
                case QUERY: {
                    this.query(context);
                    break;
                }
                case SET_QUERY: {
                    this.setQuery(context);
                    break;
                }
                case CREATE_PROCEDURE_COMMAND: {
                    this.createProcedureCommand(context);
                    break;
                }
                case TRIGGER_ACTION: {
                    this.triggerAction(context);
                    break;
                }
                case ARRAY_TABLE: {
                    this.arrayTable(context);
                    break;
                }
                case OBJECT_TABLE: {
                    this.objectTable(context);
                    break;
                }
                case TEXT_TABLE: {
                    this.textTable(context);
                    break;
                }
                case XML_TABLE: {
                    this.xmlTable(context);
                    break;
                }
                case JOIN_PREDICATE: {
                    this.joinPredicate(context);
                    break;
                }
                case SUBQUERY_FROM_CLAUSE: {
                    this.subqueryFromClause(context);
                    break;
                }
                case UNARY_FROM_CLAUSE: {
                    this.unaryFromClause(context);
                    break;
                }
                case FROM: {
                    this.from(context);
                    break;
                }
                case GROUP_BY: {
                    this.groupBy(context);
                    break;
                }
                case INTO: {
                    this.into(context);
                    break;
                }
                case JOIN_TYPE: {
                    this.joinType(context);
                    break;
                }
                case LIMIT: {
                    this.limit(context);
                    break;
                }
                case MAKE_DEP: {
                    this.makeDep(context);
                    break;
                }
                case NAMESPACE_ITEM: {
                    this.namespaceItem(context);
                    break;
                }
                case NULL_NODE: {
                    this.nullNode(context);
                    break;
                }
                case PROJECTED_COLUMN: {
                    this.projectedColumn(context);
                    break;
                }
                case OBJECT_COLUMN: {
                    this.objectColumn(context);
                    break;
                }
                case TEXT_COLUMN: {
                    this.textColumn(context);
                    break;
                }
                case XML_COLUMN: {
                    this.xmlColumn(context);
                    break;
                }
                case OPTION: {
                    this.option(context);
                    break;
                }
                case ORDER_BY: {
                    this.orderBy(context);
                    break;
                }
                case ORDER_BY_ITEM: {
                    this.orderByItem(context);
                    break;
                }
                case SP_PARAMETER: {
                    this.spParameter(context);
                    break;
                }
                case SELECT: {
                    this.select(context);
                    break;
                }
                case SET_CLAUSE: {
                    this.setClause(context);
                    break;
                }
                case SET_CLAUSE_LIST: {
                    this.setClauseList(context);
                    break;
                }
                case SOURCE_HINT: {
                    this.sourceHint(context);
                    break;
                }
                case SPECIFIC_HINT: {
                    this.specificHint(context);
                    break;
                }
                case SUBQUERY_HINT: {
                    this.subqueryHint(context);
                    break;
                }
                case WITH_QUERY_COMMAND: {
                    this.withQueryCommand(context);
                    break;
                }
                case ASSIGNMENT_STATEMENT: {
                    this.assignmentStatement(context);
                    break;
                }
                case DECLARE_STATEMENT: {
                    this.declareStatement(context);
                    break;
                }
                case RETURN_STATEMENT: {
                    this.returnStatement(context);
                    break;
                }
                case BLOCK: {
                    this.block(context);
                    break;
                }
                case BRANCHING_STATEMENT: {
                    this.branchingStatement(context);
                    break;
                }
                case COMMAND_STATEMENT: {
                    this.commandStatement(context);
                    break;
                }
                case IF_STATEMENT: {
                    this.ifStatement(context);
                    break;
                }
                case LOOP_STATEMENT: {
                    this.loopStatement(context);
                    break;
                }
                case RAISE_STATEMENT: {
                    this.raiseStatement(context);
                    break;
                }
                case WHILE_STATEMENT: {
                    this.whileStatement(context);
                    break;
                }
                case EXCEPTION_EXPRESSION: {
                    this.exceptionExpression(context);
                    break;
                }
                case FUNCTION: {
                    this.function(context);
                    break;
                }
                case AGGREGATE_SYMBOL: {
                    this.aggregateSymbol(context);
                    break;
                }
                case ALIAS_SYMBOL: {
                    this.aliasSymbol(context);
                    break;
                }
                case ELEMENT_SYMBOL: {
                    this.elementSymbol(context);
                    break;
                }
                case EXPRESSION_SYMBOL: {
                    this.expressionSymbol(context);
                    break;
                }
                case GROUP_SYMBOL: {
                    this.groupSymbol(context);
                    break;
                }
                case ARRAY_SYMBOL: {
                    this.arraySymbol(context);
                    break;
                }
                case CASE_EXPRESSION: {
                    this.caseExpression(context);
                    break;
                }
                case CONSTANT: {
                    this.constant(context);
                    break;
                }
                case DERIVED_COLUMN: {
                    this.derivedColumn(context);
                    break;
                }
                case JSON_OBJECT: {
                    this.jsonObject(context);
                    break;
                }
                case MULTIPLE_ELEMENT_SYMBOL: {
                    this.multipleElementSymbol(context);
                    break;
                }
                case QUERY_STRING: {
                    this.queryString(context);
                    break;
                }
                case REFERENCE: {
                    this.reference(context);
                    break;
                }
                case SCALAR_SUBQUERY: {
                    this.scalarSubquery(context);
                    break;
                }
                case SEARCHED_CASE_EXPRESSION: {
                    this.searchedCaseExpression(context);
                    break;
                }
                case TEXT_LINE: {
                    this.textLine(context);
                    break;
                }
                case WINDOW_FUNCTION: {
                    this.windowFunction(context);
                    break;
                }
                case WINDOW_SPECIFICATION: {
                    this.windowSpecification(context);
                    break;
                }
                case XML_ATTRIBUTES: {
                    this.xmlAttributes(context);
                    break;
                }
                case XML_ELEMENT: {
                    this.xmlElement(context);
                    break;
                }
                case XML_FOREST: {
                    this.xmlForest(context);
                    break;
                }
                case XML_NAMESPACES: {
                    this.xmlNamespaces(context);
                    break;
                }
                case XML_PARSE: {
                    this.xmlParse(context);
                    break;
                }
                case XML_QUERY: {
                    this.xmlQuery(context);
                    break;
                }
                case XML_SERIALIZE: {
                    this.xmlSerialize(context);
                    break;
                }
                case CACHE_HINT: {
                    this.cacheHint(context);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
        }
        catch (RepositoryException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RepositoryException((Throwable)ex);
        }
    }

    public void visit(Node node) throws RepositoryException {
        this.visit(node, new TeiidSqlNodeContext(node));
    }

    public Object nullNode(TeiidSqlContext context) throws Exception {
        this.append(this.undefined());
        return null;
    }

    public Object criteria(TeiidSqlContext context) throws Exception {
        Node node = (Node)context.get(NODE_KEY);
        String keyword = (String)context.get(KEYWORD_KEY);
        if (keyword != null) {
            this.append(keyword);
            this.append(" ");
        }
        this.visit(node);
        return null;
    }

    public Object compareCriteria(TeiidSqlContext context) throws Exception {
        Node node = (Node)context.get(NODE_KEY);
        Node leftExp = this.reference(node, "tsql:leftExpression");
        this.visit(leftExp);
        this.append(" ");
        String opString = this.propertyString(node, "tsql:operator");
        CriteriaOperator.Operator operator = CriteriaOperator.Operator.findOperator((String)opString);
        this.append((String)operator.getSymbols().iterator().next());
        this.append(" ");
        Node rightExp = this.reference(node, "tsql:rightExpression");
        this.visit(rightExp);
        return null;
    }

    public Object subqueryCompareCriteria(TeiidSqlContext context) throws Exception {
        Node node = (Node)context.get(NODE_KEY);
        Node leftExp = this.reference(node, "tsql:leftExpression");
        this.visit(leftExp);
        String opString = this.propertyString(node, "tsql:operator");
        CriteriaOperator.Operator operator = CriteriaOperator.Operator.findOperator((String)opString);
        String quantString = this.propertyString(node, "tsql:predicateQuantifier");
        PredicateQuantifier quantifier = PredicateQuantifier.findPredicateQuantifier((String)quantString);
        this.append(" ");
        this.append((String)operator.getSymbols().iterator().next());
        this.append(" ");
        this.append(quantifier.name());
        this.append(" ");
        this.append("(");
        Node command = this.reference(node, "tsql:command");
        this.visit(command);
        this.append(")");
        return null;
    }

    public Object setCriteria(TeiidSqlContext context) throws Exception {
        Node node = (Node)context.get(NODE_KEY);
        Node expression = this.reference(node, "tsql:expression");
        this.appendNested(expression);
        this.append(" ");
        boolean negated = this.propertyBoolean(node, "tsql:negated");
        if (negated) {
            this.append("NOT");
            this.append(" ");
        }
        this.append("IN");
        this.append(" (");
        this.iterate(node, "tsql:values");
        this.append(")");
        return null;
    }

    public Object subquerySetCriteria(TeiidSqlContext context) throws Exception {
        Node node = (Node)context.get(NODE_KEY);
        Node expression = this.reference(node, "tsql:expression");
        this.visit(expression);
        this.append(" ");
        boolean negated = this.propertyBoolean(node, "tsql:negated");
        if (negated) {
            this.append("NOT");
            this.append(" ");
        }
        this.append("IN");
        Node subqueryHint = this.reference(node, "tsql:subqueryHint");
        this.visit(subqueryHint);
        this.append(" (");
        Node command = this.reference(node, "tsql:command");
        this.visit(command);
        this.append(")");
        return null;
    }

    public Object betweenCriteria(TeiidSqlContext context) throws Exception {
        Node node = (Node)context.get(NODE_KEY);
        Node expression = this.reference(node, "tsql:expression");
        this.visit(expression);
        this.append(" ");
        boolean negated = this.propertyBoolean(node, "tsql:negated");
        if (negated) {
            this.append("NOT");
            this.append(" ");
        }
        this.append("BETWEEN");
        this.append(" ");
        Node lowerExpression = this.reference(node, "tsql:lowerExpression");
        this.visit(lowerExpression);
        this.append(" ");
        this.append("AND");
        this.append(" ");
        Node upperExpression = this.reference(node, "tsql:upperExpression");
        this.visit(upperExpression);
        return null;
    }

    public Object compoundCriteria(TeiidSqlContext context) throws Exception {
        Node node = (Node)context.get(NODE_KEY);
        long operator = this.propertyLong(node, "tsql:operator");
        String operatorStr = "";
        if (operator == (long)LogicalOperator.AND.ordinal()) {
            operatorStr = "AND";
        } else if (operator == (long)LogicalOperator.OR.ordinal()) {
            operatorStr = "OR";
        }
        Iterator<Node> criteria = this.references(node, "tsql:criteria");
        int size = this.size(node, "tsql:criteria");
        if (size == 1) {
            this.visit(criteria.next());
        } else {
            int i = 0;
            while (criteria.hasNext()) {
                if (i > 0) {
                    this.append(" ");
                    this.append(operatorStr);
                    this.append(" ");
                }
                Node crit = criteria.next();
                this.append("(");
                this.visit(crit);
                this.append(")");
                ++i;
            }
        }
        return null;
    }

    public Object existsCriteria(TeiidSqlContext context) throws Exception {
        Node node = (Node)context.get(NODE_KEY);
        boolean negated = this.propertyBoolean(node, "tsql:negated");
        if (negated) {
            this.append("NOT");
            this.append(" ");
        }
        this.append("EXISTS");
        Node subqueryHint = this.reference(node, "tsql:subqueryHint");
        this.visit(subqueryHint);
        this.append(" (");
        Node command = this.reference(node, "tsql:command");
        this.visit(command);
        this.append(")");
        return null;
    }

    public Object expressionCriteria(TeiidSqlContext context) throws Exception {
        Node node = (Node)context.get(NODE_KEY);
        Node expression = this.reference(node, "tsql:expression");
        this.visit(expression);
        return null;
    }

    public Object isNullCriteria(TeiidSqlContext context) throws Exception {
        Node node = (Node)context.get(NODE_KEY);
        Node expression = this.reference(node, "tsql:expression");
        this.appendNested(expression);
        this.append(" ");
        this.append("IS");
        this.append(" ");
        boolean negated = this.propertyBoolean(node, "tsql:negated");
        if (negated) {
            this.append("NOT");
            this.append(" ");
        }
        this.append("NULL");
        return null;
    }

    public Object matchCriteria(TeiidSqlContext context) throws Exception {
        Node node = (Node)context.get(NODE_KEY);
        Node leftExpression = this.reference(node, "tsql:leftExpression");
        this.visit(leftExpression);
        this.append(" ");
        boolean negated = this.propertyBoolean(node, "tsql:negated");
        if (negated) {
            this.append("NOT");
            this.append(" ");
        }
        String modeString = this.propertyString(node, "tsql:mode");
        MatchMode mode = MatchMode.findMatchMode((String)modeString);
        switch (mode) {
            case SIMILAR: {
                this.append("SIMILAR");
                this.append(" ");
                this.append("TO");
                break;
            }
            case LIKE: {
                this.append("LIKE");
                break;
            }
            case REGEX: {
                this.append("LIKE_REGEX");
            }
        }
        this.append(" ");
        Node rightExpression = this.reference(node, "tsql:rightExpression");
        this.visit(rightExpression);
        String escapeChar = this.propertyString(node, "tsql:escapeChar");
        if (!Character.toString('\u0000').equals(escapeChar)) {
            this.append(" ");
            this.append("ESCAPE");
            this.append(" ");
            this.appendLiteral(String.class, false, escapeChar);
        }
        return null;
    }

    public Object notCriteria(TeiidSqlContext context) throws Exception {
        Node node = (Node)context.get(NODE_KEY);
        this.append("NOT");
        this.append(" (");
        Node criteria = this.reference(node, "tsql:criteria");
        this.visit(criteria);
        this.append(")");
        return null;
    }

    public Object alterProcedure(TeiidSqlContext context) throws Exception {
        Node node = (Node)context.get(NODE_KEY);
        this.append("ALTER");
        this.append(" ");
        this.append("PROCEDURE");
        this.append(" ");
        Node target = this.reference(node, "tsql:target");
        this.visit(target);
        this.beginClause(1);
        this.append("AS");
        Node definition = this.reference(node, "tsql:definition");
        if (this.instanceOf(definition, TeiidSqlLexicon.LexTokens.CREATE_PROCEDURE_COMMAND)) {
            Node defnBlock = this.reference(definition, "tsql:block");
            this.visit(defnBlock);
        }
        return null;
    }

    public Object alterTrigger(TeiidSqlContext context) throws Exception {
        Node node = (Node)context.get(NODE_KEY);
        boolean create = this.propertyBoolean(node, "tsql:create");
        if (create) {
            this.append("CREATE");
        } else {
            this.append("ALTER");
        }
        this.append(" ");
        this.append("TRIGGER");
        this.append(" ");
        this.append("ON");
        this.append(" ");
        Node target = this.reference(node, "tsql:target");
        this.visit(target);
        this.beginClause(0);
        this.append("INSTEAD");
        this.append(" ");
        this.append("OF");
        this.append(" ");
        String eventName = this.propertyString(node, "tsql:event");
        TriggerEvent triggerEvent = TriggerEvent.findTriggerEvent((String)eventName);
        this.append(triggerEvent.name());
        Node definition = this.reference(node, "tsql:definition");
        if (definition != null) {
            this.beginClause(0);
            this.append("AS");
            this.append("\n");
            this.visit(definition);
        } else {
            this.append(" ");
            boolean enabled = this.propertyBoolean(node, "tsql:enabled");
            this.append(enabled ? "ENABLED" : "DISABLED");
        }
        return null;
    }

    public Object alterView(TeiidSqlContext context) throws Exception {
        Node node = (Node)context.get(NODE_KEY);
        this.append("ALTER");
        this.append(" ");
        this.append("VIEW");
        this.append(" ");
        Node target = this.reference(node, "tsql:target");
        this.visit(target);
        this.beginClause(0);
        this.append("AS");
        this.append("\n");
        Node definition = this.reference(node, "tsql:definition");
        this.visit(definition);
        return null;
    }

    public Object delete(TeiidSqlContext context) throws Exception {
        Node option;
        Node node = (Node)context.get(NODE_KEY);
        this.append("DELETE");
        Node sourceHint = this.reference(node, "tsql:sourceHint");
        if (sourceHint != null) {
            this.visit(sourceHint);
        }
        this.append(" ");
        this.append("FROM");
        this.append(" ");
        Node group = this.reference(node, "tsql:group");
        this.visit(group);
        Node criteria = this.reference(node, "tsql:criteria");
        if (criteria != null) {
            this.beginClause(0);
            TeiidSqlNodeContext ccontext = new TeiidSqlNodeContext(criteria);
            ccontext.add(KEYWORD_KEY, "WHERE");
            this.criteria(ccontext);
        }
        if ((option = this.reference(node, "tsql:option")) != null) {
            this.beginClause(0);
            this.visit(option);
        }
        return null;
    }

    public Object insert(TeiidSqlContext context) throws Exception {
        Node node = (Node)context.get(NODE_KEY);
        boolean merge = this.propertyBoolean(node, "tsql:merge");
        if (merge) {
            this.append("MERGE");
        } else {
            this.append("INSERT");
        }
        Node sourceHint = this.reference(node, "tsql:sourceHint");
        if (sourceHint != null) {
            this.visit(sourceHint);
        }
        this.append(" ");
        this.append("INTO");
        this.append(" ");
        Node group = this.reference(node, "tsql:group");
        this.visit(group);
        Iterator<Node> variables = this.references(node, "tsql:variables");
        int size = this.size(node, "tsql:variables");
        if (size > 0) {
            this.beginClause(2);
            this.append("(");
            int i = 0;
            while (variables.hasNext()) {
                Node variable = variables.next();
                if (i > 0) {
                    this.append(", ");
                }
                TeiidSqlNodeContext varContext = new TeiidSqlNodeContext(variable);
                varContext.add(SHORT_NAME_ONLY_KEY, true);
                this.visit(variable, varContext);
                ++i;
            }
            this.append(")");
        }
        this.beginClause(1);
        Node queryExp = this.reference(node, "tsql:queryExpression");
        Iterator<Node> values = this.references(node, "tsql:values");
        if (queryExp != null) {
            this.visit(queryExp);
        } else if (values.hasNext()) {
            this.append("VALUES");
            this.beginClause(2);
            this.append("(");
            this.iterate(node, "tsql:values");
            this.append(")");
        }
        Node option = this.reference(node, "tsql:option");
        if (option != null) {
            this.beginClause(1);
            this.visit(option);
        }
        return null;
    }

    public Object storedProcedure(TeiidSqlContext context) throws Exception {
        Node node = (Node)context.get(NODE_KEY);
        boolean calledWithReturn = this.propertyBoolean(node, "tsql:calledWithReturn");
        boolean displayNamedParams = this.propertyBoolean(node, "tsql:displayNamedParameters");
        if (calledWithReturn) {
            Iterator<Node> parameters = this.references(node, "tsql:parameters");
            while (parameters.hasNext()) {
                Node parameter = parameters.next();
                long paramType = this.propertyLong(parameter, "tsql:parameterType");
                if (paramType != (long)ParameterInfo.RETURN_VALUE.index()) continue;
                Node expression = this.reference(parameter, "tsql:expression");
                if (expression == null) {
                    this.append("?");
                    continue;
                }
                this.visit(expression);
            }
            this.append(" ");
            this.append("=");
            this.append(" ");
        }
        this.append("EXEC");
        this.append(" ");
        String procedureName = this.propertyString(node, "tsql:procedureName");
        this.append(procedureName);
        this.append("(");
        boolean first = true;
        Iterator<Node> parameters = this.references(node, "tsql:parameters");
        while (parameters.hasNext()) {
            boolean addParens;
            Node parameter = parameters.next();
            boolean usingDefault = this.propertyBoolean(parameter, "tsql:usingDefault");
            long paramType = this.propertyLong(parameter, "tsql:parameterType");
            Node expression = this.reference(parameter, "tsql:expression");
            if (usingDefault || paramType == (long)ParameterInfo.RETURN_VALUE.index() || paramType == (long)ParameterInfo.RESULT_SET.index() || expression == null) continue;
            if (first) {
                first = false;
            } else {
                this.append(", ");
            }
            if (displayNamedParams) {
                String paramName = this.propertyString(parameter, "tsql:name");
                this.append(this.escapeSinglePart(this.shortName(paramName)));
                this.append(" => ");
            }
            boolean bl = addParens = displayNamedParams && this.instanceOf(expression, TeiidSqlLexicon.LexTokens.COMPARE_CRITERIA);
            if (addParens) {
                this.append("(");
            }
            this.visit(expression);
            if (!addParens) continue;
            this.append(")");
        }
        this.append(")");
        Node option = this.reference(node, "tsql:option");
        if (option != null) {
            this.beginClause(1);
            this.visit(option);
        }
        return null;
    }

    public Object update(TeiidSqlContext context) throws Exception {
        Node option;
        Node node = (Node)context.get(NODE_KEY);
        this.append("UPDATE");
        Node sourceHint = this.reference(node, "tsql:sourceHint");
        if (sourceHint != null) {
            this.visit(sourceHint);
        }
        this.append(" ");
        Node group = this.reference(node, "tsql:group");
        this.visit(group);
        this.beginClause(1);
        this.append("SET");
        this.beginClause(2);
        Node changeList = this.reference(node, "tsql:changeList");
        this.visit(changeList);
        Node criteria = this.reference(node, "tsql:criteria");
        if (criteria != null) {
            this.beginClause(0);
            TeiidSqlNodeContext ccontext = new TeiidSqlNodeContext(criteria);
            ccontext.add(KEYWORD_KEY, "WHERE");
            this.criteria(ccontext);
        }
        if ((option = this.reference(node, "tsql:option")) != null) {
            this.beginClause(1);
            this.visit(option);
        }
        return null;
    }

    public Object dynamicCommand(TeiidSqlContext context) throws Exception {
        long updatingModelCount;
        Node intoGroup;
        Node node = (Node)context.get(NODE_KEY);
        this.append("EXECUTE");
        this.append(" ");
        this.append("IMMEDIATE");
        this.append(" ");
        Node sql = this.reference(node, "tsql:sql");
        this.visit(sql);
        boolean asClauseSet = this.propertyBoolean(node, "tsql:asClauseSet");
        if (asClauseSet) {
            this.beginClause(1);
            this.append("AS");
            this.append(" ");
            Iterator<Node> asColumns = this.references(node, "tsql:asColumns");
            int i = 0;
            while (asColumns.hasNext()) {
                if (i > 0) {
                    this.append(", ");
                }
                Node asColumn = asColumns.next();
                String asColName = this.propertyString(asColumn, "tsql:name");
                this.append(this.shortName(asColName));
                this.append(" ");
                String typeName = this.propertyString(asColumn, "tsql:typeClass");
                DataTypeManager.DataTypeName dataTypeName = DataTypeManager.DataTypeName.findDataTypeName((String)typeName);
                Class dataTypeClass = this.getDataTypeManager().getDefaultDataClass(dataTypeName);
                this.append(this.getDataTypeManager().getDataTypeName(dataTypeClass));
                ++i;
            }
        }
        if ((intoGroup = this.reference(node, "tsql:intoGroup")) != null) {
            this.beginClause(1);
            this.append("INTO");
            this.append(" ");
            this.visit(intoGroup);
        }
        Node using = this.reference(node, "tsql:using");
        Iterator<Node> usingList = this.references(using, "tsql:setClauses");
        if (using != null && usingList.hasNext()) {
            this.beginClause(1);
            this.append("USING");
            this.append(" ");
            this.visit(using);
        }
        if ((updatingModelCount = this.propertyLong(node, "tsql:updatingModelCount")) > 0L) {
            this.beginClause(1);
            this.append("UPDATE");
            this.append(" ");
            if (updatingModelCount > 1L) {
                this.append("*");
            } else {
                this.append(Integer.toString(1));
            }
        }
        return null;
    }

    public Object query(TeiidSqlContext context) throws Exception {
        Node option;
        Node limit;
        Node orderBy;
        Node having;
        Node groupBy;
        Node criteria;
        Node from;
        Node into;
        Node select;
        Node node = (Node)context.get(NODE_KEY);
        this.addWithClause(node);
        this.appendToken("tsql:select");
        Node sourceHint = this.reference(node, "tsql:sourceHint");
        if (sourceHint != null) {
            this.visit(sourceHint);
        }
        if ((select = this.reference(node, "tsql:select")) != null) {
            this.visit(select);
        }
        if ((into = this.reference(node, "tsql:into")) != null) {
            this.beginClause(1);
            this.visit(into);
        }
        if ((from = this.reference(node, "tsql:from")) != null) {
            this.beginClause(1);
            this.visit(from);
        }
        if ((criteria = this.reference(node, "tsql:criteria")) != null) {
            this.beginClause(1);
            TeiidSqlNodeContext ccontext = new TeiidSqlNodeContext(criteria);
            ccontext.add(KEYWORD_KEY, "WHERE");
            this.criteria(ccontext);
        }
        if ((groupBy = this.reference(node, "tsql:groupBy")) != null) {
            this.beginClause(1);
            this.visit(groupBy);
        }
        if ((having = this.reference(node, "tsql:having")) != null) {
            this.beginClause(1);
            TeiidSqlNodeContext hcontext = new TeiidSqlNodeContext(having);
            hcontext.add(KEYWORD_KEY, "HAVING");
            this.criteria(hcontext);
        }
        if ((orderBy = this.reference(node, "tsql:orderBy")) != null) {
            this.beginClause(1);
            this.visit(orderBy);
        }
        if ((limit = this.reference(node, "tsql:limit")) != null) {
            this.beginClause(1);
            this.visit(limit);
        }
        if ((option = this.reference(node, "tsql:option")) != null) {
            this.beginClause(1);
            this.visit(option);
        }
        return null;
    }

    protected void appendSetQuery(Node parent, Node queryCommand, boolean right) throws Exception {
        Node limit = this.reference(queryCommand, "tsql:limit");
        Node orderBy = this.reference(queryCommand, "tsql:orderBy");
        boolean isSetQuery = this.instanceOf(queryCommand, TeiidSqlLexicon.LexTokens.SET_QUERY);
        boolean parentIsAll = this.propertyBoolean(parent, "tsql:all");
        boolean cmdIsAll = this.propertyBoolean(queryCommand, "tsql:all");
        String parentOpName = this.propertyString(parent, "tsql:operation");
        Operation parentOp = Operation.findOperation((String)parentOpName);
        String cmdOpName = this.propertyString(queryCommand, "tsql:operation");
        Operation cmdOp = Operation.findOperation((String)cmdOpName);
        if (limit != null || orderBy != null || right && isSetQuery && (parentIsAll && !cmdIsAll || parentOp.equals((Object)cmdOp))) {
            this.append("(");
            this.visit(queryCommand);
            this.append(")");
        } else {
            this.visit(queryCommand);
        }
    }

    public Object setQuery(TeiidSqlContext context) throws Exception {
        Node option;
        Node limit;
        Node node = (Node)context.get(NODE_KEY);
        this.addWithClause(node);
        Node queryCommand = this.reference(node, "tsql:leftQuery");
        this.appendSetQuery(node, queryCommand, false);
        this.beginClause(0);
        String opName = this.propertyString(node, "tsql:operation");
        Operation op = Operation.findOperation((String)opName);
        this.append(op.name());
        boolean isAll = this.propertyBoolean(node, "tsql:all");
        if (isAll) {
            this.append(" ");
            this.append("ALL");
        }
        this.beginClause(0);
        Node rightQuery = this.reference(node, "tsql:rightQuery");
        this.appendSetQuery(node, rightQuery, true);
        Node orderBy = this.reference(node, "tsql:orderBy");
        if (orderBy != null) {
            this.beginClause(1);
            this.visit(orderBy);
        }
        if ((limit = this.reference(node, "tsql:limit")) != null) {
            this.beginClause(1);
            this.visit(limit);
        }
        if ((option = this.reference(node, "tsql:option")) != null) {
            this.beginClause(1);
            this.visit(option);
        }
        return null;
    }

    public Object createProcedureCommand(TeiidSqlContext context) throws Exception {
        Node node = (Node)context.get(NODE_KEY);
        if (this.isLessThanTeiidVersion(DefaultTeiidVersion.Version.TEIID_8_4)) {
            this.append("CREATE");
            this.append(" ");
            this.append("VIRTUAL");
            this.append(" ");
            this.append("PROCEDURE");
            this.append("\n");
        }
        Node block = this.reference(node, "tsql:block");
        this.visit(block);
        return null;
    }

    public Object triggerAction(TeiidSqlContext context) throws Exception {
        Node node = (Node)context.get(NODE_KEY);
        this.append("FOR");
        this.append(" ");
        this.append("EACH");
        this.append(" ");
        this.append("ROW");
        this.append("\n");
        Node block = this.reference(node, "tsql:block");
        this.visit(block);
        return null;
    }

    public Object arrayTable(TeiidSqlContext context) throws Exception {
        Node node = (Node)context.get(NODE_KEY);
        this.addHintComment(node);
        this.append("ARRAYTABLE");
        this.append("(");
        Node arrayValue = this.reference(node, "tsql:arrayValue");
        this.visit(arrayValue);
        this.append(" ");
        this.append("COLUMNS");
        this.iterate(node, "tsql:columns");
        this.append(")");
        this.append(" ");
        this.append("AS");
        this.append(" ");
        String name = this.propertyString(node, "tsql:name");
        this.appendDisplayName(name);
        this.addMakeDep(node);
        return null;
    }

    public Object objectTable(TeiidSqlContext context) throws Exception {
        Node node = (Node)context.get(NODE_KEY);
        this.addHintComment(node);
        this.append("OBJECTTABLE");
        this.append("(");
        String scriptLanguage = this.propertyString(node, "tsql:scriptingLanguage");
        if (scriptLanguage != null) {
            this.append("LANGUAGE");
            this.append(" ");
            this.append(scriptLanguage);
            this.append(" ");
        }
        String rowScript = this.propertyString(node, "tsql:rowScript");
        this.appendLiteral(String.class, false, rowScript);
        Iterator<Node> passings = this.references(node, "tsql:passing");
        if (passings.hasNext()) {
            this.append(" ");
            this.append("PASSING");
            this.append(" ");
            this.iterate(node, "tsql:passing");
        }
        this.append(" ");
        this.append("COLUMNS");
        Iterator<Node> columns = this.references(node, "tsql:columns");
        int i = 0;
        while (columns.hasNext()) {
            if (i > 0) {
                this.append(", ");
            }
            this.visit(columns.next());
            ++i;
        }
        this.append(")");
        this.append(" ");
        this.append("AS");
        this.append(" ");
        String name = this.propertyString(node, "tsql:name");
        this.appendDisplayName(name);
        this.addMakeDep(node);
        return null;
    }

    public Object textTable(TeiidSqlContext context) throws Exception {
        String quote;
        String delimiter;
        Node node = (Node)context.get(NODE_KEY);
        this.addHintComment(node);
        this.append("TEXTTABLE");
        this.append("(");
        Node fileExp = this.reference(node, "tsql:file");
        this.visit(fileExp);
        String selector = this.propertyString(node, "tsql:selector");
        if (selector != null) {
            this.append(" ");
            this.append("SELECTOR");
            this.append(" ");
            this.append(this.escapeSinglePart(selector));
        }
        this.append(" ");
        this.append("COLUMNS");
        Iterator<Node> columns = this.references(node, "tsql:columns");
        int i = 0;
        while (columns.hasNext()) {
            if (i > 0) {
                this.append(",");
            }
            this.visit(columns.next());
            ++i;
        }
        boolean usingRowDelimiter = this.propertyBoolean(node, "tsql:usingRowDelimiter");
        if (!usingRowDelimiter) {
            this.append(" ");
            this.append("NO");
            this.append(" ");
            this.append("ROW");
            this.append(" ");
            this.append("DELIMITER");
        }
        if ((delimiter = this.propertyString(node, "tsql:delimiter")) != null) {
            this.append(" ");
            this.append("DELIMITER");
            this.append(" ");
            this.appendLiteral(String.class, false, delimiter);
        }
        if ((quote = this.propertyString(node, "tsql:quote")) != null) {
            this.append(" ");
            boolean escape = this.propertyBoolean(node, "tsql:escape");
            if (escape) {
                this.append("ESCAPE");
            } else {
                this.append("QUOTE");
            }
            this.append(" ");
            this.appendLiteral(String.class, false, quote);
        }
        if (node.hasProperty("tsql:header")) {
            this.append(" ");
            this.append("HEADER");
            long header = this.propertyLong(node, "tsql:header");
            if (1L != header) {
                this.append(" ");
                this.append(Long.toString(header));
            }
        }
        if (node.hasProperty("tsql:skip")) {
            this.append(" ");
            this.append("SKIP");
            this.append(" ");
            long skip = this.propertyLong(node, "tsql:skip");
            this.append(Long.toString(skip));
        }
        this.append(")");
        this.append(" ");
        this.append("AS");
        this.append(" ");
        String name = this.propertyString(node, "tsql:name");
        this.appendDisplayName(name);
        this.addMakeDep(node);
        return null;
    }

    public Object xmlTable(TeiidSqlContext context) throws Exception {
        Node node = (Node)context.get(NODE_KEY);
        this.addHintComment(node);
        this.append("XMLTABLE");
        this.append("(");
        Node namespaces = this.reference(node, "tsql:namespaces");
        if (namespaces != null) {
            this.visit(namespaces);
            this.append(",");
            this.append(" ");
        }
        String xquery = this.propertyString(node, "tsql:xquery");
        this.appendLiteral(String.class, false, xquery);
        Iterator<Node> passings = this.references(node, "tsql:passing");
        if (passings.hasNext()) {
            this.append(" ");
            this.append("PASSING");
            this.append(" ");
            this.iterate(node, "tsql:passing");
        }
        Iterator<Node> columns = this.references(node, "tsql:columns");
        boolean usingDefColumn = this.propertyBoolean(node, "tsql:usingDefaultColumn");
        if (columns.hasNext() && !usingDefColumn) {
            this.append(" ");
            this.append("COLUMNS");
            int i = 0;
            while (columns.hasNext()) {
                if (i > 0) {
                    this.append(", ");
                }
                this.visit(columns.next());
                ++i;
            }
        }
        this.append(")");
        this.append(" ");
        this.append("AS");
        this.append(" ");
        String name = this.propertyString(node, "tsql:name");
        this.appendDisplayName(name);
        this.addMakeDep(node);
        return null;
    }

    public Object joinPredicate(TeiidSqlContext context) throws Exception {
        Node leftClause;
        Node node = (Node)context.get(NODE_KEY);
        this.addHintComment(node);
        boolean hasHint = this.hasHint(node);
        if (hasHint) {
            this.append("(");
        }
        if (this.instanceOf(leftClause = this.reference(node, "tsql:leftClause"), TeiidSqlLexicon.LexTokens.JOIN_PREDICATE) && !this.hasHint(leftClause)) {
            this.append("(");
            this.visit(leftClause);
            this.append(")");
        } else {
            this.visit(leftClause);
        }
        this.append(" ");
        Node joinType = this.reference(node, "tsql:joinType");
        this.visit(joinType);
        this.append(" ");
        Node rightClause = this.reference(node, "tsql:rightClause");
        if (this.instanceOf(rightClause, TeiidSqlLexicon.LexTokens.JOIN_PREDICATE) && !this.hasHint(rightClause)) {
            this.append("(");
            this.visit(rightClause);
            this.append(")");
        } else {
            this.visit(rightClause);
        }
        Iterator<Node> criterions = this.references(node, "tsql:joinCriteria");
        int size = this.size(node, "tsql:joinCriteria");
        System.out.println(size);
        if (criterions.hasNext()) {
            this.append(" ");
            this.append("ON");
            this.append(" ");
            int i = 0;
            while (criterions.hasNext()) {
                Node criterion;
                if (i > 0) {
                    this.append(" ");
                    this.append("AND");
                    this.append(" ");
                }
                if (this.instanceOf(criterion = criterions.next(), TeiidSqlLexicon.LexTokens.PREDICATE_CRITERIA) || this.instanceOf(criterion, TeiidSqlLexicon.LexTokens.NOT_CRITERIA)) {
                    this.visit(criterion);
                } else {
                    this.append("(");
                    this.visit(criterion);
                    this.append(")");
                }
                ++i;
            }
        }
        if (hasHint) {
            this.append(")");
        }
        this.addMakeDep(node);
        return null;
    }

    public Object subqueryFromClause(TeiidSqlContext context) throws Exception {
        Node node = (Node)context.get(NODE_KEY);
        this.addHintComment(node);
        boolean table = this.propertyBoolean(node, "tsql:table");
        if (table) {
            this.append("TABLE");
        }
        this.append("(");
        Node command = this.reference(node, "tsql:command");
        this.visit(command);
        this.append(")");
        this.append(" AS ");
        String name = this.propertyString(node, "tsql:name");
        this.append(this.escapeSinglePart(name));
        this.addMakeDep(node);
        return null;
    }

    public Object unaryFromClause(TeiidSqlContext context) throws Exception {
        Node node = (Node)context.get(NODE_KEY);
        this.addHintComment(node);
        Node group = this.reference(node, "tsql:group");
        this.visit(group);
        this.addMakeDep(node);
        return null;
    }

    public Object from(TeiidSqlContext context) throws Exception {
        Node node = (Node)context.get(NODE_KEY);
        this.appendToken(node);
        this.beginClause(1);
        this.iterate(node, "tsql:clauses");
        return null;
    }

    public Object groupBy(TeiidSqlContext context) throws Exception {
        Node node = (Node)context.get(NODE_KEY);
        this.append("GROUP");
        this.append(" ");
        this.append("BY");
        this.append(" ");
        boolean rollup = this.propertyBoolean(node, "tsql:rollup");
        if (this.isTeiidVersionOrGreater(DefaultTeiidVersion.Version.TEIID_8_5) && rollup) {
            this.append("ROLLUP");
            this.append("(");
        }
        this.iterate(node, "tsql:symbols");
        if (this.isTeiidVersionOrGreater(DefaultTeiidVersion.Version.TEIID_8_5) && rollup) {
            this.append(")");
        }
        return null;
    }

    public Object into(TeiidSqlContext context) throws Exception {
        Node node = (Node)context.get(NODE_KEY);
        this.appendToken(node);
        this.append(" ");
        Node group = this.reference(node, "tsql:group");
        this.visit(group);
        return null;
    }

    public Object joinType(TeiidSqlContext context) throws Exception {
        Node node = (Node)context.get(NODE_KEY);
        String kindName = this.propertyString(node, "tsql:kind");
        JoinTypeTypes kind = JoinTypeTypes.findType((String)kindName);
        this.append(kind.toPrintStatement());
        return null;
    }

    public Object limit(TeiidSqlContext context) throws Exception {
        Node node = (Node)context.get(NODE_KEY);
        boolean strict = this.propertyBoolean(node, "tsql:strict");
        if (!strict) {
            this.append(BEGIN_HINT);
            this.append(" ");
            this.append("NON_STRICT");
            this.append(" ");
            this.append(END_HINT);
            this.append(" ");
        }
        Node offset = this.reference(node, "tsql:offset");
        Node rowLimit = this.reference(node, "tsql:rowLimit");
        if (rowLimit == null) {
            this.append("OFFSET");
            this.append(" ");
            this.visit(offset);
            this.append(" ");
            this.append("ROWS");
        } else {
            this.append("LIMIT");
            if (offset != null) {
                this.append(" ");
                this.visit(offset);
                this.append(",");
            }
            this.append(" ");
            this.visit(rowLimit);
        }
        return null;
    }

    public Object namespaceItem(TeiidSqlContext context) throws Exception {
        Node node = (Node)context.get(NODE_KEY);
        String prefix = this.propertyString(node, "tsql:prefix");
        String uri = this.propertyString(node, "tsql:uri");
        if (prefix == null) {
            if (uri == null) {
                this.append("NO DEFAULT");
            } else {
                this.append("DEFAULT ");
                this.appendLiteral(String.class, false, uri);
            }
        } else {
            this.appendLiteral(String.class, false, uri);
            this.append(" AS ");
            this.appendLiteral(String.class, false, prefix);
        }
        return null;
    }

    public Object projectedColumn(TeiidSqlContext context) throws Exception {
        Node node = (Node)context.get(NODE_KEY);
        String name = this.propertyString(node, "tsql:name");
        String type = this.propertyString(node, "tsql:type");
        this.append(" ");
        this.appendDisplayName(name);
        this.append(" ");
        this.append(type);
        return null;
    }

    public Object objectColumn(TeiidSqlContext context) throws Exception {
        Node node = (Node)context.get(NODE_KEY);
        String name = this.propertyString(node, "tsql:name");
        String type = this.propertyString(node, "tsql:type");
        String path = this.propertyString(node, "tsql:path");
        this.append(" ");
        this.appendDisplayName(name);
        this.append(" ");
        this.append(type);
        this.append(" ");
        this.appendLiteral(String.class, false, path);
        Node defaultExp = this.reference(node, "tsql:defaultExpression");
        if (defaultExp != null) {
            this.append(" ");
            this.append("DEFAULT");
            this.append(" ");
            this.visit(defaultExp);
        }
        return null;
    }

    public Object textColumn(TeiidSqlContext context) throws Exception {
        Node node = (Node)context.get(NODE_KEY);
        String name = this.propertyString(node, "tsql:name");
        String type = this.propertyString(node, "tsql:type");
        boolean ordinal = this.propertyBoolean(node, "tsql:ordinal");
        this.append(" ");
        this.appendDisplayName(name);
        this.append(" ");
        if (ordinal) {
            this.append("FOR");
            this.append(" ");
            this.append("ORDINALITY");
        } else {
            String colSelector;
            boolean noTrim;
            this.append(type);
            String width = this.propertyString(node, "tsql:width");
            if (width != null) {
                this.append(" ");
                this.append("WIDTH");
                this.append(" ");
                this.append(width);
            }
            if (noTrim = this.propertyBoolean(node, "tsql:noTrim")) {
                this.append(" ");
                this.append("NO");
                this.append(" ");
                this.append("TRIM");
            }
            if ((colSelector = this.propertyString(node, "tsql:selector")) != null) {
                this.append(" ");
                this.append("SELECTOR");
                this.append(" ");
                this.append(this.escapeSinglePart(colSelector));
                this.append(" ");
                long position = this.propertyLong(node, "tsql:position");
                this.append(Long.toString(position));
            }
        }
        return null;
    }

    public Object xmlColumn(TeiidSqlContext context) throws Exception {
        Node node = (Node)context.get(NODE_KEY);
        String name = this.propertyString(node, "tsql:name");
        String type = this.propertyString(node, "tsql:type");
        String path = this.propertyString(node, "tsql:path");
        Node defaultExp = this.reference(node, "tsql:defaultExpression");
        boolean ordinal = this.propertyBoolean(node, "tsql:ordinal");
        this.append(" ");
        this.appendDisplayName(name);
        this.append(" ");
        if (ordinal) {
            this.append("FOR");
            this.append(" ");
            this.append("ORDINALITY");
        } else {
            this.append(type);
            if (defaultExp != null) {
                this.append(" ");
                this.append("DEFAULT");
                this.append(" ");
                this.visit(defaultExp);
            }
            if (path != null) {
                this.append(" ");
                this.append("PATH");
                this.append(" ");
                this.appendLiteral(String.class, false, path);
            }
        }
        return null;
    }

    public Object makeDep(TeiidSqlContext context) throws Exception {
        if (this.isLessThanTeiidVersion(DefaultTeiidVersion.Version.TEIID_8_5)) {
            return null;
        }
        Node node = (Node)context.get(NODE_KEY);
        boolean hasMax = node.hasProperty("tsql:max");
        boolean join = this.propertyBoolean(node, "tsql:join");
        boolean parens = false;
        if (hasMax || join) {
            this.append("(");
            parens = true;
        }
        boolean space = false;
        if (hasMax) {
            if (space) {
                this.append(" ");
            } else {
                space = true;
            }
            this.append("MAX");
            this.append(":");
            long max = this.propertyLong(node, "tsql:max");
            this.append(Long.toString(max));
        }
        if (join) {
            if (space) {
                this.append(" ");
            } else {
                space = true;
            }
            this.append("JOIN");
        }
        if (parens) {
            this.append(")");
        }
        return null;
    }

    public Object option(TeiidSqlContext context) throws Exception {
        Collection notGroups;
        int i;
        Node node = (Node)context.get(NODE_KEY);
        this.append("OPTION");
        Collection groups = this.propertyValues(node, "tsql:dependentGroups", DataTypeManager.DataTypeName.STRING);
        if (groups != null && !groups.isEmpty()) {
            this.append(" ");
            this.append("MAKEDEP");
            this.append(" ");
            Iterator iter = groups.iterator();
            Iterator<Node> groupOptions = this.references(node, "tsql:dependentGroupOptions");
            i = 0;
            while (iter.hasNext()) {
                if (i > 0) {
                    this.append(", ");
                }
                this.appendDisplayName((String)iter.next());
                if (groupOptions.hasNext()) {
                    this.visit(groupOptions.next());
                }
                ++i;
            }
        }
        if ((notGroups = this.propertyValues(node, "tsql:notDependentGroups", DataTypeManager.DataTypeName.STRING)) != null && !notGroups.isEmpty()) {
            this.append(" ");
            this.append("MAKENOTDEP");
            this.append(" ");
            Iterator iter = groups.iterator();
            i = 0;
            while (iter.hasNext()) {
                if (i > 0) {
                    this.append(", ");
                }
                this.appendDisplayName((String)iter.next());
                ++i;
            }
        }
        boolean noCache = this.propertyBoolean(node, "tsql:noCache");
        Collection noCacheGroups = this.propertyValues(node, "tsql:noCacheGroups", DataTypeManager.DataTypeName.STRING);
        if (noCacheGroups != null && !noCacheGroups.isEmpty()) {
            this.append(" ");
            this.append("NOCACHE");
            this.append(" ");
            Iterator iter = noCacheGroups.iterator();
            int i2 = 0;
            while (iter.hasNext()) {
                if (i2 > 0) {
                    this.append(", ");
                }
                this.appendDisplayName((String)iter.next());
                ++i2;
            }
        } else if (noCache) {
            this.append(" ");
            this.append("NOCACHE");
        }
        return null;
    }

    public Object orderBy(TeiidSqlContext context) throws Exception {
        Node node = (Node)context.get(NODE_KEY);
        this.append("ORDER");
        this.append(" ");
        this.append("BY");
        this.append(" ");
        this.iterate(node, "tsql:orderByItems");
        return null;
    }

    public Object orderByItem(TeiidSqlContext context) throws Exception {
        String nullOrderingName;
        SortSpecification.NullOrdering nullOrdering;
        Node node = (Node)context.get(NODE_KEY);
        Node ses = this.reference(node, "tsql:symbol");
        if (this.instanceOf(ses, TeiidSqlLexicon.LexTokens.ALIAS_SYMBOL)) {
            this.appendDisplayName(this.outputName(ses));
        } else {
            this.visit(ses);
        }
        boolean ascending = this.propertyBoolean(node, "tsql:ascending");
        if (!ascending) {
            this.append(" ");
            this.append("DESC");
        }
        if ((nullOrdering = SortSpecification.NullOrdering.findNullOrdering(nullOrderingName = this.propertyString(node, "tsql:nullOrdering"))) != null) {
            this.append(" ");
            this.append("NULLS");
            this.append(" ");
            this.append(nullOrdering.name());
        }
        return null;
    }

    public Object spParameter(TeiidSqlContext context) {
        return null;
    }

    public Object select(TeiidSqlContext context) throws Exception {
        Node node = (Node)context.get(NODE_KEY);
        boolean distinct = this.propertyBoolean(node, "tsql:distinct");
        if (distinct) {
            this.append(" ");
            this.append("DISTINCT");
        }
        this.append(" ");
        this.iterate(node, "tsql:symbols");
        return null;
    }

    public Object setClause(TeiidSqlContext context) throws Exception {
        Node node = (Node)context.get(NODE_KEY);
        Node symbol = this.reference(node, "tsql:symbol");
        String name = this.propertyString(symbol, "tsql:name");
        this.append(this.shortName(name));
        this.append(" = ");
        Node value = this.reference(node, "tsql:value");
        this.visit(value);
        return null;
    }

    public Object setClauseList(TeiidSqlContext context) throws Exception {
        Node node = (Node)context.get(NODE_KEY);
        this.iterate(node, "tsql:setClauses");
        return null;
    }

    protected void appendSourceHintValue(String sh) {
        this.append(":");
        this.append("'");
        this.append(this.escapeStringValue(sh, "'"));
        this.append("'");
        this.append(" ");
    }

    public Object sourceHint(TeiidSqlContext context) throws Exception {
        String generalHint;
        Node node = (Node)context.get(NODE_KEY);
        this.append(" ");
        this.append(BEGIN_HINT);
        this.append("sh");
        boolean useAliases = this.propertyBoolean(node, "tsql:useAliases");
        if (useAliases) {
            this.append(" ");
            this.append("KEEP ALIASES");
        }
        if ((generalHint = this.propertyString(node, "tsql:generalHint")) != null) {
            this.appendSourceHintValue(generalHint);
        } else {
            this.append(" ");
        }
        Iterator<Node> specificHints = this.references(node, "tsql:sourceHints");
        while (specificHints.hasNext()) {
            this.visit(specificHints.next());
        }
        this.append(END_HINT);
        return null;
    }

    public Object specificHint(TeiidSqlContext context) throws Exception {
        Node node = (Node)context.get(NODE_KEY);
        boolean useAliases = this.propertyBoolean(node, "tsql:useAliases");
        String translator = this.propertyString(node, "tsql:translatorName");
        String hint = this.propertyString(node, "tsql:hint");
        this.append(translator);
        if (useAliases) {
            this.append(" ");
            this.append("KEEP ALIASES");
        }
        this.appendSourceHintValue(hint);
        return null;
    }

    public Object subqueryHint(TeiidSqlContext context) throws Exception {
        Node node = (Node)context.get(NODE_KEY);
        boolean noUnnest = this.propertyBoolean(node, "tsql:noUnnest");
        boolean depJoin = this.propertyBoolean(node, "tsql:depJoin");
        boolean mergeJoin = this.propertyBoolean(node, "tsql:mergeJoin");
        if (noUnnest) {
            this.append(" ");
            this.append(BEGIN_HINT);
            this.append(" ");
            this.append("NO_UNNEST");
            this.append(" ");
            this.append(END_HINT);
        } else if (depJoin) {
            this.append(" ");
            this.append(BEGIN_HINT);
            this.append(" ");
            this.append("DJ");
            this.append(" ");
            this.append(END_HINT);
        } else if (mergeJoin) {
            this.append(" ");
            this.append(BEGIN_HINT);
            this.append(" ");
            this.append("MJ");
            this.append(" ");
            this.append(END_HINT);
        }
        return null;
    }

    public Object withQueryCommand(TeiidSqlContext context) throws Exception {
        Node node = (Node)context.get(NODE_KEY);
        Node groupSymbol = this.reference(node, "tsql:groupSymbol");
        this.visit(groupSymbol);
        this.append(" ");
        Iterator<Node> columns = this.references(node, "tsql:columns");
        if (columns != null && columns.hasNext()) {
            this.append("(");
            int i = 0;
            while (columns.hasNext()) {
                if (i > 0) {
                    this.append(", ");
                }
                Node column = columns.next();
                TeiidSqlNodeContext ccontext = new TeiidSqlNodeContext(column);
                ccontext.add(SHORT_NAME_ONLY_KEY, true);
                this.visit(column, ccontext);
                ++i;
            }
            this.append(")");
            this.append(" ");
        }
        this.append("AS");
        this.append(" ");
        this.append("(");
        Node command = this.reference(node, "tsql:command");
        if (this.isTeiidVersionOrGreater(DefaultTeiidVersion.Version.TEIID_8_5) && command == null) {
            this.append("<dependent values>");
        } else {
            this.visit(command);
        }
        this.append(")");
        return null;
    }

    private void createAssignment(Node node) throws Exception {
        Node variable = this.reference(node, "tsql:variable");
        this.visit(variable);
        Node value = this.reference(node, "tsql:value");
        if (value == null) {
            value = this.reference(node, "tsql:expression");
        }
        if (value != null) {
            this.append(" = ");
            this.visit(value);
        }
        this.append(";");
    }

    public Object assignmentStatement(TeiidSqlContext context) throws Exception {
        Node node = (Node)context.get(NODE_KEY);
        this.createAssignment(node);
        return null;
    }

    public Object declareStatement(TeiidSqlContext context) throws Exception {
        Node node = (Node)context.get(NODE_KEY);
        this.append("DECLARE");
        this.append(" ");
        String varType = this.propertyString(node, "tsql:variableType");
        this.append(varType);
        this.append(" ");
        this.createAssignment(node);
        return null;
    }

    public Object returnStatement(TeiidSqlContext context) throws Exception {
        Node node = (Node)context.get(NODE_KEY);
        this.append("RETURN");
        Node expression = this.reference(node, "tsql:expression");
        if (expression != null) {
            this.append(" ");
            this.visit(expression);
        }
        this.append(";");
        return null;
    }

    public Object block(TeiidSqlContext context) throws Exception {
        Node node = (Node)context.get(NODE_KEY);
        this.appendLabel(node);
        this.append("BEGIN");
        boolean atomic = this.propertyBoolean(node, "tsql:atomic");
        if (atomic) {
            this.append(" ");
            this.append("ATOMIC");
        }
        this.append("\n");
        this.appendStatements(node, "tsql:statements");
        String exceptionGroup = this.propertyString(node, "tsql:exceptionGroup");
        if (exceptionGroup != null) {
            this.append("EXCEPTION");
            this.append(" ");
            this.appendDisplayName(exceptionGroup);
            this.append("\n");
            this.appendStatements(node, "tsql:exceptionStatements");
        }
        this.append("END");
        return null;
    }

    public Object branchingStatement(TeiidSqlContext context) throws Exception {
        Node node = (Node)context.get(NODE_KEY);
        String modeName = this.propertyString(node, "tsql:mode");
        BranchingMode mode = BranchingMode.findBranchingMode((String)modeName);
        this.append(mode.name());
        String label = this.propertyString(node, "tsql:label");
        if (label != null) {
            this.append(" ");
            this.appendDisplayName(label);
        }
        this.append(";");
        return null;
    }

    public Object commandStatement(TeiidSqlContext context) throws Exception {
        Node node = (Node)context.get(NODE_KEY);
        Node command = this.reference(node, "tsql:command");
        this.visit(command);
        boolean returnable = this.propertyBoolean(node, "tsql:returnable");
        if (!returnable) {
            this.append(" ");
            this.append("WITHOUT");
            this.append(" ");
            this.append("RETURN");
        }
        this.append(";");
        return null;
    }

    public Object ifStatement(TeiidSqlContext context) throws Exception {
        Node node = (Node)context.get(NODE_KEY);
        this.append("IF");
        this.append("(");
        Node condition = this.reference(node, "tsql:condition");
        this.visit(condition);
        this.append(")");
        this.append("\n");
        Node ifBlock = this.reference(node, "tsql:ifBlock");
        this.visit(ifBlock);
        Node elseBlock = this.reference(node, "tsql:elseBlock");
        if (elseBlock != null) {
            this.append("\n");
            this.append("ELSE");
            this.append("\n");
            this.visit(elseBlock);
        }
        return null;
    }

    public Object loopStatement(TeiidSqlContext context) throws Exception {
        Node node = (Node)context.get(NODE_KEY);
        this.appendLabel(node);
        this.append("LOOP");
        this.append(" ");
        this.append("ON");
        this.append(" (");
        Node command = this.reference(node, "tsql:command");
        this.visit(command);
        this.append(") ");
        this.append("AS");
        this.append(" ");
        String cursorName = this.propertyString(node, "tsql:cursorName");
        this.appendDisplayName(cursorName);
        this.append("\n");
        Node block = this.reference(node, "tsql:block");
        this.visit(block);
        return null;
    }

    public Object raiseStatement(TeiidSqlContext context) throws Exception {
        Node node = (Node)context.get(NODE_KEY);
        this.append("RAISE");
        this.append(" ");
        boolean warning = this.propertyBoolean(node, "tsql:warning");
        if (warning) {
            this.append("SQLWARNING");
            this.append(" ");
        }
        Node expression = this.reference(node, "tsql:expression");
        this.visit(expression);
        this.append(";");
        return null;
    }

    public Object whileStatement(TeiidSqlContext context) throws Exception {
        Node node = (Node)context.get(NODE_KEY);
        this.appendLabel(node);
        this.append("WHILE");
        this.append("(");
        Node condition = this.reference(node, "tsql:condition");
        this.visit(condition);
        this.append(";\n");
        Node block = this.reference(node, "tsql:block");
        this.visit(block);
        return null;
    }

    public Object exceptionExpression(TeiidSqlContext context) throws Exception {
        Node node = (Node)context.get(NODE_KEY);
        this.append("SQLEXCEPTION");
        this.append(" ");
        Node message = this.reference(node, "tsql:message");
        Node sqlState = this.reference(node, "tsql:sqlState");
        Node errorCode = this.reference(node, "tsql:errorCode");
        Node parent = this.reference(node, "tsql:parentExpression");
        this.visit(message);
        if (sqlState != null) {
            this.append(" ");
            this.append("SQLSTATE");
            this.append(" ");
            this.visit(sqlState);
            if (errorCode != null) {
                this.append(",");
                this.append(" ");
                this.visit(errorCode);
            }
        }
        if (parent != null) {
            this.append(" ");
            this.append("CHAIN");
            this.append(" ");
            this.visit(parent);
        }
        return null;
    }

    public Object function(TeiidSqlContext context) throws Exception {
        Node node = (Node)context.get(NODE_KEY);
        String name = this.propertyString(node, "tsql:name");
        boolean implicit = this.propertyBoolean(node, "tsql:implicit");
        Iterator<Node> args = this.references(node, "tsql:args");
        if (implicit) {
            this.visit(args.next());
        } else if (name.equalsIgnoreCase("CONVERT") || name.equalsIgnoreCase("CAST")) {
            this.append(name);
            this.append("(");
            if (args.hasNext()) {
                this.visit(args.next());
                if (name.equalsIgnoreCase("CONVERT")) {
                    this.append(", ");
                } else {
                    this.append(" ");
                    this.append("AS");
                    this.append(" ");
                }
                Node args1 = null;
                if (args.hasNext()) {
                    args1 = args.next();
                }
                if (args1 != null && this.instanceOf(args1, TeiidSqlLexicon.LexTokens.CONSTANT)) {
                    Property valueProp = args1.getProperty("tsql:value");
                    this.append(this.toString(valueProp));
                } else {
                    this.append(this.undefined());
                }
            }
            this.append(")");
        } else if (name.equals("+") || name.equals("-") || name.equals("*") || name.equals("/") || name.equals("||")) {
            this.append("(");
            int i = 0;
            while (args.hasNext()) {
                if (i > 0) {
                    this.append(" ");
                    this.append(name);
                    this.append(" ");
                }
                this.visit(args.next());
                ++i;
            }
            this.append(")");
        } else if (name.equalsIgnoreCase("TIMESTAMPADD") || name.equalsIgnoreCase("TIMESTAMPDIFF")) {
            this.append(name);
            this.append("(");
            if (args.hasNext()) {
                Property valueProp = args.next().getProperty("tsql:value");
                this.append(this.toString(valueProp));
                this.iterate(args);
            }
            this.append(")");
        } else if (name.equalsIgnoreCase("XMLPI")) {
            this.append(name);
            this.append("(NAME ");
            Property valueProp = args.next().getProperty("tsql:value");
            this.appendDisplayName(this.toString(valueProp));
            this.iterate(args);
            this.append(")");
        } else if (name.equalsIgnoreCase("TRIM")) {
            this.append(name);
            this.append("(");
            Property valueProp = args.next().getProperty("tsql:value");
            String value = this.toString(valueProp);
            if (!value.equalsIgnoreCase("BOTH")) {
                this.append(value);
                this.append(" ");
            }
            this.visit(args.next());
            this.append(" ");
            this.append("FROM");
            this.append(" ");
            this.visit(args.next());
            this.append(")");
        } else {
            this.append(name);
            this.append("(");
            this.iterate(args);
            this.append(")");
        }
        return null;
    }

    public Object aggregateSymbol(TeiidSqlContext context) throws Exception {
        Node node = (Node)context.get(NODE_KEY);
        String name = this.propertyString(node, "tsql:name");
        boolean distinct = this.propertyBoolean(node, "tsql:distinct");
        String aggFunctionName = this.propertyString(node, "tsql:aggregateFunction");
        AggregateFunctions aggregateFunction = AggregateFunctions.findAggregateFunction((String)aggFunctionName);
        this.append(name);
        this.append("(");
        if (distinct) {
            this.append("DISTINCT");
            this.append(" ");
        } else if (aggregateFunction == AggregateFunctions.USER_DEFINED) {
            this.append("ALL");
            this.append(" ");
        }
        Iterator<Node> args = this.references(node, "tsql:args");
        if (args.hasNext()) {
            this.iterate(args);
        } else if (aggregateFunction == AggregateFunctions.COUNT) {
            this.append("*");
        }
        Node orderBy = this.reference(node, "tsql:orderBy");
        if (orderBy != null) {
            this.append(" ");
            this.visit(orderBy);
        }
        this.append(")");
        Node condition = this.reference(node, "tsql:condition");
        if (condition != null) {
            this.append(" ");
            this.append("FILTER");
            this.append("(");
            this.append("WHERE");
            this.append(" ");
            this.visit(condition);
            this.append(")");
        }
        return null;
    }

    public Object aliasSymbol(TeiidSqlContext context) throws Exception {
        Node node = (Node)context.get(NODE_KEY);
        Node symbol = this.reference(node, "tsql:symbol");
        this.visit(symbol);
        this.append(" ");
        this.append("AS");
        this.append(" ");
        this.append(this.escapeSinglePart(this.outputName(node)));
        return null;
    }

    public Object elementSymbol(TeiidSqlContext context) throws Exception {
        Node node = (Node)context.get(NODE_KEY);
        boolean shortNameOnly = context.get(SHORT_NAME_ONLY_KEY) != null ? (Boolean)context.get(SHORT_NAME_ONLY_KEY) : false;
        String displayModeName = this.propertyString(node, "tsql:displayMode");
        DisplayMode displayMode = DisplayMode.findDisplayMode((String)displayModeName);
        String outputName = this.outputName(node);
        if (DisplayMode.SHORT_OUTPUT_NAME.equals((Object)displayMode) || shortNameOnly) {
            this.appendDisplayName(this.shortName(outputName));
            return null;
        }
        if (DisplayMode.FULLY_QUALIFIED.equals((Object)displayMode)) {
            outputName = this.propertyString(node, "tsql:name");
        }
        this.appendDisplayName(outputName);
        return null;
    }

    public Object expressionSymbol(TeiidSqlContext context) throws Exception {
        Node node = (Node)context.get(NODE_KEY);
        Node expression = this.reference(node, "tsql:expression");
        this.visit(expression);
        return null;
    }

    public Object groupSymbol(TeiidSqlContext context) throws Exception {
        Node node = (Node)context.get(NODE_KEY);
        String alias = null;
        String name = this.propertyString(node, "tsql:name");
        String defn = this.propertyString(node, "tsql:definition");
        if (defn != null) {
            alias = name;
            name = defn;
        }
        this.appendDisplayName(name);
        if (alias != null) {
            this.append(" ");
            this.append("AS");
            this.append(" ");
            this.append(this.escapeSinglePart(alias));
        }
        return null;
    }

    public Object arraySymbol(TeiidSqlContext context) throws Exception {
        Node node = (Node)context.get(NODE_KEY);
        boolean implicit = this.propertyBoolean(node, "tsql:implicit");
        if (!implicit) {
            this.append("(");
        }
        this.iterate(node, "tsql:expressions");
        if (!implicit) {
            if (this.size(node, "tsql:expressions") == 1) {
                this.append(",");
            }
            this.append(")");
        }
        return null;
    }

    public Object caseExpression(TeiidSqlContext context) throws Exception {
        Node node = (Node)context.get(NODE_KEY);
        this.append("CASE");
        this.append(" ");
        Node expression = this.reference(node, "tsql:expression");
        this.visit(expression);
        this.append(" ");
        Iterator<Node> whens = this.references(node, "tsql:when");
        Iterator<Node> thens = this.references(node, "tsql:then");
        while (whens.hasNext() && thens.hasNext()) {
            this.append("WHEN");
            this.append(" ");
            this.visit(whens.next());
            this.append(" ");
            this.append("THEN");
            this.append(" ");
            this.visit(thens.next());
            this.append(" ");
        }
        Node elseExpression = this.reference(node, "tsql:elseExpression");
        if (elseExpression != null) {
            this.append("ELSE");
            this.append(" ");
            this.visit(elseExpression);
            this.append(" ");
        }
        this.append("END");
        return null;
    }

    public Object constant(TeiidSqlContext context) throws Exception {
        Node node = (Node)context.get(NODE_KEY);
        String typeName = this.propertyString(node, "tsql:typeClass");
        DataTypeManager.DataTypeName dataTypeName = DataTypeManager.DataTypeName.findDataTypeName((String)typeName);
        if (dataTypeName == null) {
            dataTypeName = DataTypeManager.DataTypeName.OBJECT;
        }
        Class type = this.getDataTypeManager().getDefaultDataClass(dataTypeName);
        boolean multiValued = this.propertyBoolean(node, "tsql:multiValued");
        Object value = this.propertyValue(node, "tsql:value", dataTypeName);
        this.appendLiteral(type, multiValued, value);
        return null;
    }

    public Object derivedColumn(TeiidSqlContext context) throws Exception {
        Node node = (Node)context.get(NODE_KEY);
        Node expression = this.reference(node, "tsql:expression");
        this.visit(expression);
        String alias = this.propertyString(node, "tsql:alias");
        if (alias != null) {
            this.append(" ");
            this.append("AS");
            this.append(" ");
            this.appendDisplayName(alias);
        }
        return null;
    }

    public Object jsonObject(TeiidSqlContext context) throws Exception {
        Node node = (Node)context.get(NODE_KEY);
        this.append("JSONOBJECT");
        this.append("(");
        this.iterate(node, "tsql:args");
        this.append(")");
        return null;
    }

    public Object multipleElementSymbol(TeiidSqlContext context) throws Exception {
        Node node = (Node)context.get(NODE_KEY);
        Node groupNode = this.reference(node, "tsql:group");
        if (groupNode == null) {
            this.append("*");
        } else {
            this.visit(groupNode);
            this.append(".");
            this.append("*");
        }
        return null;
    }

    public Object queryString(TeiidSqlContext context) throws Exception {
        Node node = (Node)context.get(NODE_KEY);
        this.append("QUERYSTRING");
        this.append("(");
        Node path = this.reference(node, "tsql:path");
        this.visit(path);
        Iterator<Node> args = this.references(node, "tsql:args");
        if (args.hasNext()) {
            this.append(",");
            this.append(" ");
            this.iterate(node, "tsql:args");
        }
        this.append(")");
        return null;
    }

    public Object reference(TeiidSqlContext context) throws Exception {
        Node node = (Node)context.get(NODE_KEY);
        Node expression = this.reference(node, "tsql:expression");
        boolean positional = this.propertyBoolean(node, "tsql:positional");
        if (!positional && expression != null) {
            this.visit(expression);
        } else {
            this.append("?");
        }
        return null;
    }

    public Object scalarSubquery(TeiidSqlContext context) throws Exception {
        Node node = (Node)context.get(NODE_KEY);
        this.append("(");
        Node command = this.reference(node, "tsql:command");
        this.visit(command);
        this.append(")");
        return null;
    }

    public Object searchedCaseExpression(TeiidSqlContext context) throws Exception {
        Node node = (Node)context.get(NODE_KEY);
        this.append("CASE");
        Iterator<Node> whens = this.references(node, "tsql:when");
        Iterator<Node> thens = this.references(node, "tsql:then");
        while (whens.hasNext() && thens.hasNext()) {
            this.append(" ");
            this.append("WHEN");
            this.append(" ");
            this.visit(whens.next());
            this.append(" ");
            this.append("THEN");
            this.append(" ");
            this.visit(thens.next());
        }
        this.append(" ");
        Node elseExpression = this.reference(node, "tsql:elseExpression");
        if (elseExpression != null) {
            this.append("ELSE");
            this.append(" ");
            this.visit(elseExpression);
            this.append(" ");
        }
        this.append("END");
        return null;
    }

    public Object textLine(TeiidSqlContext context) throws Exception {
        String encoding;
        boolean includeHeader;
        String quote;
        Node node = (Node)context.get(NODE_KEY);
        this.append("FOR");
        this.append(" ");
        this.iterate(node, "tsql:expressions");
        String delimiter = this.propertyString(node, "tsql:delimiter");
        if (delimiter != null) {
            this.append(" ");
            this.append("DELIMITER");
            this.append(" ");
            this.appendLiteral(String.class, false, delimiter);
        }
        if ((quote = this.propertyString(node, "tsql:quote")) != null) {
            this.append(" ");
            this.append("QUOTE");
            this.append(" ");
            this.appendLiteral(String.class, false, quote);
        }
        if (!(includeHeader = this.propertyBoolean(node, "tsql:includeHeader"))) {
            this.append(" ");
            this.append("HEADER");
        }
        if ((encoding = this.propertyString(node, "tsql:encoding")) != null) {
            this.append(" ");
            this.append("ENCODING");
            this.append(" ");
            this.appendDisplayName(encoding);
        }
        return null;
    }

    public Object windowFunction(TeiidSqlContext context) throws Exception {
        Node node = (Node)context.get(NODE_KEY);
        Node windowFunction = this.reference(node, "tsql:function");
        this.visit(windowFunction);
        this.append(" ");
        this.append("OVER");
        this.append(" ");
        Node windowSpec = this.reference(node, "tsql:windowSpecification");
        this.visit(windowSpec);
        return null;
    }

    public Object windowSpecification(TeiidSqlContext context) throws Exception {
        Node orderBy;
        Node node = (Node)context.get(NODE_KEY);
        this.append("(");
        boolean needsSpace = false;
        Iterator<Node> partitions = this.references(node, "tsql:partition");
        if (partitions.hasNext()) {
            this.append("PARTITION");
            this.append(" ");
            this.append("BY");
            this.append(" ");
            this.iterate(node, "tsql:partition");
            needsSpace = true;
        }
        if ((orderBy = this.reference(node, "tsql:orderBy")) != null) {
            if (needsSpace) {
                this.append(" ");
            }
            this.visit(orderBy);
        }
        this.append(")");
        return null;
    }

    public Object xmlAttributes(TeiidSqlContext context) throws Exception {
        Node node = (Node)context.get(NODE_KEY);
        this.append("XMLATTRIBUTES");
        this.append("(");
        this.iterate(node, "tsql:args");
        this.append(")");
        return null;
    }

    public Object xmlElement(TeiidSqlContext context) throws Exception {
        Iterator<Node> contents;
        Node attributes;
        Node node = (Node)context.get(NODE_KEY);
        this.append("XMLELEMENT");
        this.append("(NAME ");
        String name = this.propertyString(node, "tsql:name");
        this.appendDisplayName(name);
        Node namespaces = this.reference(node, "tsql:namespaces");
        if (namespaces != null) {
            this.append(", ");
            this.visit(namespaces);
        }
        if ((attributes = this.reference(node, "tsql:attributes")) != null) {
            this.append(", ");
            this.visit(attributes);
        }
        if ((contents = this.references(node, "tsql:content")).hasNext()) {
            this.append(", ");
        }
        this.iterate(node, "tsql:content");
        this.append(")");
        return null;
    }

    public Object xmlForest(TeiidSqlContext context) throws Exception {
        Node node = (Node)context.get(NODE_KEY);
        this.append("XMLFOREST");
        this.append("(");
        Node namespaces = this.reference(node, "tsql:namespaces");
        if (namespaces != null) {
            this.visit(namespaces);
            this.append(", ");
        }
        this.iterate(node, "tsql:arguments");
        this.append(")");
        return null;
    }

    public Object xmlNamespaces(TeiidSqlContext context) throws Exception {
        Node node = (Node)context.get(NODE_KEY);
        this.append("XMLNAMESPACES");
        this.append("(");
        this.iterate(node, "tsql:namespaceItems");
        this.append(")");
        return null;
    }

    public Object xmlParse(TeiidSqlContext context) throws Exception {
        Node node = (Node)context.get(NODE_KEY);
        this.append("XMLPARSE");
        this.append("(");
        boolean document = this.propertyBoolean(node, "tsql:document");
        if (document) {
            this.append("DOCUMENT");
        } else {
            this.append("CONTENT");
        }
        this.append(" ");
        Node expression = this.reference(node, "tsql:expression");
        this.visit(expression);
        boolean wellFormed = this.propertyBoolean(node, "tsql:wellFormed");
        if (wellFormed) {
            this.append(" ");
            this.append("WELLFORMED");
        }
        this.append(")");
        return null;
    }

    public Object xmlQuery(TeiidSqlContext context) throws Exception {
        Node node = (Node)context.get(NODE_KEY);
        this.append("XMLQUERY");
        this.append("(");
        Node namespaces = this.reference(node, "tsql:namespaces");
        if (namespaces != null) {
            this.visit(namespaces);
            this.append(",");
            this.append(" ");
        }
        String xquery = this.propertyString(node, "tsql:xquery");
        this.appendLiteral(String.class, false, xquery);
        Iterator<Node> passings = this.references(node, "tsql:passing");
        if (passings.hasNext()) {
            this.append(" ");
            this.append("PASSING");
            this.append(" ");
            this.iterate(node, "tsql:passing");
        }
        if (node.hasProperty("tsql:emptyOnEmpty")) {
            this.append(" ");
            boolean emptyOnEmpty = this.propertyBoolean(node, "tsql:emptyOnEmpty");
            if (emptyOnEmpty) {
                this.append("EMPTY");
            } else {
                this.append("NULL");
            }
            this.append(" ");
            this.append("ON");
            this.append(" ");
            this.append("EMPTY");
        }
        this.append(")");
        return null;
    }

    public Object xmlSerialize(TeiidSqlContext context) throws Exception {
        String version;
        String encoding;
        Node node = (Node)context.get(NODE_KEY);
        this.append("XMLSERIALIZE");
        this.append("(");
        if (node.hasProperty("tsql:document")) {
            boolean document = this.propertyBoolean(node, "tsql:document");
            if (document) {
                this.append("DOCUMENT");
            } else {
                this.append("CONTENT");
            }
            this.append(" ");
        }
        Node expression = this.reference(node, "tsql:expression");
        this.visit(expression);
        String typeString = this.propertyString(node, "tsql:typeString");
        if (typeString != null) {
            this.append(" ");
            this.append("AS");
            this.append(" ");
            this.append(typeString);
        }
        if ((encoding = this.propertyString(node, "tsql:encoding")) != null) {
            this.append(" ");
            this.append("ENCODING");
            this.append(" ");
            this.append(this.escapeSinglePart(encoding));
        }
        if ((version = this.propertyString(node, "tsql:version")) != null) {
            this.append(" ");
            this.append("VERSION");
            this.append(" ");
            this.appendLiteral(String.class, false, version);
        }
        if (node.hasProperty("tsql:declaration")) {
            boolean declaration = this.propertyBoolean(node, "tsql:declaration");
            this.append(" ");
            if (declaration) {
                this.append("INCLUDING");
            } else {
                this.append("EXCLUDING");
            }
            this.append(" ");
            this.append("XMLDECLARATION");
        }
        this.append(")");
        return null;
    }

    public Object cacheHint(TeiidSqlContext context) throws Exception {
        Long minRows;
        String scope;
        boolean updateable;
        String ttl;
        Node node = (Node)context.get(NODE_KEY);
        this.append(BEGIN_HINT);
        this.append(" ");
        this.append("cache");
        boolean addParens = false;
        boolean prefersMemory = this.propertyBoolean(node, "tsql:prefersMemory");
        if (prefersMemory) {
            this.append("(");
            addParens = true;
            this.append("pref_mem");
        }
        if ((ttl = this.propertyString(node, "tsql:ttl")) != null) {
            if (!addParens) {
                this.append("(");
                addParens = true;
            } else {
                this.append(" ");
            }
            this.append("ttl:");
            this.append(ttl);
        }
        if (updateable = this.propertyBoolean(node, "tsql:updateable")) {
            if (!addParens) {
                this.append("(");
                addParens = true;
            } else {
                this.append(" ");
            }
            this.append("updatable");
        }
        if ((scope = this.propertyString(node, "tsql:scope")) != null) {
            if (!addParens) {
                this.append("(");
                addParens = true;
            } else {
                this.append(" ");
            }
            this.append("scope:");
            this.append(scope);
        }
        if ((minRows = Long.valueOf(this.propertyLong(node, "tsql:minRows"))) != null) {
            if (!addParens) {
                this.append("(");
                addParens = true;
            } else {
                this.append(" ");
            }
            this.append("min:");
            this.append(minRows.toString());
        }
        if (addParens) {
            this.append(")");
        }
        this.append(" ");
        this.append(END_HINT);
        this.beginClause(0);
        return null;
    }

    protected class TeiidSqlNodeContext
    implements TeiidSqlContext {
        private Node node;
        private Map<String, Object> index = new HashMap<String, Object>();

        public TeiidSqlNodeContext(Node node) {
            this.node = node;
        }

        public Object get(String key) {
            if (TeiidSqlNodeVisitor.NODE_KEY.equals(key)) {
                return this.node;
            }
            return this.index.get(key);
        }

        public void add(String key, Object obj) {
            this.index.put(key, obj);
        }
    }
}

