/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.modeshape.teiid;

import java.io.IOException;
import java.io.InputStream;
import javax.jcr.Binary;
import javax.jcr.NamespaceRegistry;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import org.komodo.spi.query.TeiidService;
import org.komodo.spi.runtime.version.TeiidVersion;
import org.komodo.spi.runtime.version.TeiidVersionProvider;
import org.komodo.teiid.TeiidServiceProvider;
import org.komodo.utils.KLog;
import org.modeshape.common.annotation.NotThreadSafe;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.IoUtil;
import org.modeshape.jcr.api.nodetype.NodeTypeManager;
import org.modeshape.jcr.api.sequencer.Sequencer;

@NotThreadSafe
public class TeiidSqlSequencer
extends Sequencer {
    private static final KLog LOGGER = KLog.getLogger();

    public TeiidVersion getTeiidVersion() {
        return TeiidVersionProvider.getInstance().getTeiidVersion();
    }

    public void initialize(NamespaceRegistry registry, NodeTypeManager nodeTypeManager) throws RepositoryException, IOException {
        this.registerNodeTypes("cnd/TeiidSql.cnd", nodeTypeManager, true);
    }

    public boolean execute(Property inputProperty, Node outputNode, Sequencer.Context context) throws Exception {
        Binary sqlContent = inputProperty.getBinary();
        CheckArg.isNotNull((Object)sqlContent, (String)"teiid sql content binary value");
        try (InputStream stream = sqlContent.getStream();){
            String sql = IoUtil.read((InputStream)stream);
            TeiidService teiidService = TeiidServiceProvider.getInstance().getTeiidService(this.getTeiidVersion());
            teiidService.nodeConvert(sql, (Object)outputNode);
        }
        return true;
    }
}

