/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.modeshape.teiid.generators.bnf;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.komodo.modeshape.teiid.generators.GeneratorConstants;
import org.komodo.modeshape.teiid.generators.bnf.clause.AbstractGroupClause;
import org.komodo.modeshape.teiid.generators.bnf.clause.BracketClause;
import org.komodo.modeshape.teiid.generators.bnf.clause.CaseStatement;
import org.komodo.modeshape.teiid.generators.bnf.clause.ClauseStack;
import org.komodo.modeshape.teiid.generators.bnf.clause.IClause;
import org.komodo.modeshape.teiid.generators.bnf.clause.IGroupClause;
import org.komodo.modeshape.teiid.generators.bnf.clause.OptionalClause;
import org.komodo.modeshape.teiid.generators.bnf.clause.OrClause;
import org.komodo.modeshape.teiid.generators.bnf.clause.TokenClause;
import org.komodo.modeshape.teiid.parser.bnf.AbstractBNF;
import org.komodo.modeshape.teiid.parser.bnf.BNFConstants;
import org.komodo.spi.runtime.version.DefaultTeiidVersion;
import org.komodo.spi.runtime.version.TeiidVersion;
import org.komodo.utils.ArgCheck;

public class TeiidBNFGenerator
implements GeneratorConstants {
    private static final String JAVACC_DIR = GEN_DIR + File.separator + "javacc";
    private static final String BNF_DIR = DEMI_GEN_DIR + File.separator + GeneratorConstants.Utilities.convertPackageToDirPath(BNFConstants.class.getPackage());
    private static final String BNF_FILENAME = "BNF.java";
    private static final String TEIID_SQL_JJT = "TeiidCompletionParser.jjt";
    private static final Pattern METHOD_DEC_PATTERN = Pattern.compile("[A-Za-z]+ ([a-z][a-zA-Z]+)\\([a-zA-Z ]*\\) :");
    private static final Pattern COMMENT_PATTERN = Pattern.compile("[\\s]*([\\/\\/]|[\\/\\*]|[\\*]|[\\*\\/])+.*");
    private static final Pattern TRY_PATTERN = Pattern.compile("[\\s]*try.*");
    private static final Pattern CATCH_PATTERN = Pattern.compile("[\\s]*catch.*");
    private static final Pattern BRACE_PATTERN = Pattern.compile("[\\s]*[\\{\\}][\\s]*");
    private final BufferedReader ccReader;
    private final BufferedWriter bnfWriter;

    public TeiidBNFGenerator() throws Exception {
        File templateFile = new File(JAVACC_DIR, TEIID_SQL_JJT);
        ArgCheck.isTrue((boolean)templateFile.exists(), (String)"JJT template cannot be found!");
        File bnfFile = new File(BNF_DIR, BNF_FILENAME);
        this.ccReader = new BufferedReader(new FileReader(templateFile));
        this.bnfWriter = new BufferedWriter(new FileWriter(bnfFile));
    }

    public static void main(String[] args) throws Exception {
        TeiidBNFGenerator generator = new TeiidBNFGenerator();
        generator.generate();
    }

    private void append(String line) throws Exception {
        this.bnfWriter.write(line);
    }

    private boolean isComment(String line) {
        Matcher m = COMMENT_PATTERN.matcher(line);
        return m.matches();
    }

    private boolean isStartComment(String line) {
        Matcher m = Pattern.compile("[\\s]*\\/\\*.*").matcher(line);
        return m.matches();
    }

    private boolean isEndComment(String line) {
        Matcher m = Pattern.compile("[\\s]*\\*\\/.*").matcher(line);
        return m.matches();
    }

    private boolean isTryOrCatch(String line) {
        Matcher mTry = TRY_PATTERN.matcher(line);
        Matcher mCatch = CATCH_PATTERN.matcher(line);
        return mTry.matches() || mCatch.matches();
    }

    private boolean isSingleBrace(String line) {
        Matcher mBrace = BRACE_PATTERN.matcher(line);
        return mBrace.matches();
    }

    private boolean isDoubleBrace(String line) {
        return line.contains("{}");
    }

    private boolean isReturnStatement(String line) {
        return line.contains("return ");
    }

    private boolean isTokenDeclaration(String line) {
        return line.endsWith(":") && line.startsWith("TOKEN :");
    }

    private boolean isMethodDeclaration(String line) {
        Pattern p = Pattern.compile("[A-Za-z]+ [A-Za-z]+\\(.*\\) :");
        Matcher m = p.matcher(line);
        return m.matches();
    }

    private boolean isPPSetNullMethod(String line) {
        return line.contains("ppSet(null);");
    }

    private String extractMethodName(String line) {
        if (!line.endsWith(":")) {
            return null;
        }
        Matcher m = METHOD_DEC_PATTERN.matcher(line);
        if (!m.matches()) {
            return null;
        }
        return m.group(1);
    }

    private void writeLicence() throws Exception {
        this.append("/*\n * JBoss, Home of Professional Open Source.\n * See the COPYRIGHT.txt file distributed with this work for information\n * regarding copyright ownership.  Some portions may be licensed\n * to Red Hat, Inc. under one or more contributor license agreements.\n * \n * This library is free software; you can redistribute it and/or\n * modify it under the terms of the GNU Lesser General Public\n * License as published by the Free Software Foundation; either\n * version 2.1 of the License, or (at your option) any later version.\n * \n * This library is distributed in the hope that it will be useful,\n * but WITHOUT ANY WARRANTY; without even the implied warranty of\n * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU\n * Lesser General Public License for more details.\n * \n * You should have received a copy of the GNU Lesser General Public\n * License along with this library; if not, write to the Free Software\n * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA\n * 02110-1301 USA.\n */\n");
    }

    private void writePackageDeclaration() throws Exception {
        Package p = BNFConstants.class.getPackage();
        this.append("package " + p.getName() + ";" + "\n" + "\n");
    }

    private void writeImports() throws Exception {
        Class[] klazzes;
        String imp = "import";
        for (Class klazz : klazzes = new Class[]{List.class, TeiidVersion.class, DefaultTeiidVersion.Version.class}) {
            this.append(imp + " " + klazz.getCanonicalName() + ";" + "\n");
        }
        this.append("\n");
    }

    private void writeClassDeclaration() throws Exception {
        StringBuffer buf = new StringBuffer();
        buf.append("/**\n").append(" * Teiid BNF implemented auto completion class based on Teiid Parser template\n").append(" */\n").append("@SuppressWarnings({\"static-access\", \"nls\"})\n").append("public class BNF  extends ").append(AbstractBNF.class.getSimpleName() + " " + "{" + "\n").append("\n").append("\t/**\n").append("\t * @param version of teiid\n").append("\t */\n").append("\tpublic BNF(").append(TeiidVersion.class.getSimpleName() + " " + "version" + ")").append(" {\n").append("\t\tsuper(version);\n").append("\t}\n\n");
        this.append(buf.toString());
    }

    private boolean removeSubstitutions(Map<String, String> tokenMap) {
        boolean subsMade = false;
        Pattern tokenPattern = Pattern.compile("<([A-Z_]+)>");
        for (Map.Entry<String, String> entry : tokenMap.entrySet()) {
            Matcher m = tokenPattern.matcher(entry.getValue());
            if (!m.find()) continue;
            StringBuffer buf = new StringBuffer();
            do {
                String replacement = tokenMap.get(m.group(1));
                m.appendReplacement(buf, replacement);
            } while (m.find());
            m.appendTail(buf);
            String varValue = buf.toString();
            varValue = varValue.replaceAll("\"", "\\\\\"");
            varValue = varValue.replaceAll("\\\\\\\\\"", "\\\\\"");
            tokenMap.put(entry.getKey(), varValue);
            subsMade = true;
        }
        return subsMade;
    }

    private Map<String, String> analyseTokens(List<TokenModel> tokens) throws Exception {
        HashMap<String, String> tokenMap = new HashMap<String, String>();
        for (TokenModel tokenModel : tokens) {
            String contents = tokenModel.getContent();
            contents = contents.replaceAll("[\\s]+", " ");
            contents = contents.replaceAll("< ([A-Z_]+) >", "<$1>");
            contents = contents.replaceAll("\\( ", "\\(");
            Stack<Character> bStack = new Stack<Character>();
            StringBuffer vNameBuf = new StringBuffer();
            StringBuffer vValueBuf = new StringBuffer();
            StringBuffer currBuf = null;
            boolean inSpeechMarks = false;
            for (int i = 0; i < contents.length(); ++i) {
                char c = contents.charAt(i);
                if (c == '\"') {
                    Character ce1 = null;
                    if (i > 0) {
                        ce1 = Character.valueOf(contents.charAt(i - 1));
                    }
                    if (ce1 == null || !ce1.equals(Character.valueOf('\\'))) {
                        inSpeechMarks = !inSpeechMarks;
                    }
                } else if (c == '<' && !inSpeechMarks) {
                    bStack.push(Character.valueOf(c));
                    if (currBuf == null) {
                        currBuf = vNameBuf;
                        continue;
                    }
                } else if (c == '>' && !inSpeechMarks) {
                    bStack.pop();
                }
                if (bStack.isEmpty() && currBuf == vValueBuf) {
                    currBuf = null;
                    String varName = vNameBuf.toString().trim();
                    if (varName.startsWith("#")) {
                        varName = varName.substring(1);
                    }
                    String varValue = vValueBuf.toString().trim();
                    varValue = varValue.replaceAll("\"", "\\\\\"");
                    varValue = varValue.replaceAll("\\\\\\\\\"", "\\\\\"");
                    tokenMap.put(varName, varValue);
                    vNameBuf = new StringBuffer();
                    vValueBuf = new StringBuffer();
                    continue;
                }
                if (c == ':' && !inSpeechMarks) {
                    currBuf = vValueBuf;
                    continue;
                }
                if (currBuf == null) continue;
                currBuf.append(c);
            }
        }
        boolean removeSubs = true;
        while (removeSubs) {
            removeSubs = this.removeSubstitutions(tokenMap);
        }
        return tokenMap;
    }

    private Collection<TokenClause> nextTokenClauses(IClause clause) {
        LinkedHashSet<TokenClause> tokenClauses = new LinkedHashSet<TokenClause>();
        IClause nextClause = clause.nextClause();
        ClauseStack owningStack = clause.getOwningStack();
        IClause parent = owningStack.getParent();
        IClause targetClause = clause;
        while (parent != IClause.ROOT_CLAUSE && parent != null) {
            if (parent instanceof BracketClause && ((BracketClause)parent).isMulti() && owningStack.isConsideredLastClause(targetClause)) {
                tokenClauses.addAll(parent.getFirstTokenClauses());
            }
            if ((owningStack = parent.getOwningStack()) == null) {
                targetClause = null;
                parent = null;
                continue;
            }
            targetClause = parent;
            parent = owningStack.getParent();
        }
        if (nextClause == null) {
            return tokenClauses;
        }
        tokenClauses.addAll(nextClause.getFirstTokenClauses());
        if (nextClause instanceof OptionalClause || nextClause instanceof BracketClause && ((BracketClause)nextClause).isMulti()) {
            tokenClauses.addAll(this.nextTokenClauses(nextClause));
        }
        return tokenClauses;
    }

    private CaseStatement createCaseStatement(String ppFunction, MethodModel method) throws Exception {
        if (ppFunction == null) {
            return null;
        }
        CaseStatement caseStmt = new CaseStatement();
        if (method.requiresSwitch()) {
            caseStmt.addDeclaration("\t\t\tcase " + ppFunction + ":" + "\n");
            return caseStmt;
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("\t\t} else if (index == ");
        if (ppFunction.contains(",")) {
            buffer.append("concat(" + ppFunction + ")" + ")");
        } else {
            buffer.append(ppFunction + ")");
        }
        buffer.append(" {\n");
        caseStmt.addDeclaration(buffer.toString());
        return caseStmt;
    }

    private void appendRemainingTokenClauses(Collection<CaseStatement> caseStmts, MethodModel method, List<TokenClause> currClauses, Set<TokenClause> tokenCache) throws Exception {
        if (currClauses == null || currClauses.isEmpty()) {
            return;
        }
        ArrayList<TokenClause> nextClauses = new ArrayList<TokenClause>();
        for (TokenClause currClause : currClauses) {
            if (tokenCache.contains(currClause)) continue;
            tokenCache.add(currClause);
            String ppFunction = currClause.getPPFunction();
            CaseStatement caseStmt = this.createCaseStatement(ppFunction, method);
            Collection<TokenClause> nextTokenClauses = this.nextTokenClauses(currClause);
            if (nextTokenClauses.isEmpty() && caseStmt != null) {
                StringBuffer commentBuffer = new StringBuffer();
                if (method.requiresSwitch()) {
                    commentBuffer.append("\t\t\t\t");
                } else {
                    commentBuffer.append("\t\t\t");
                }
                commentBuffer.append("// No completions required\n");
                caseStmt.addStatement(commentBuffer.toString());
            }
            for (TokenClause nextTokenClause : nextTokenClauses) {
                if (caseStmt != null) {
                    StringBuffer appendStmt = new StringBuffer();
                    if (method.requiresSwitch()) {
                        appendStmt.append("\t\t\t\t");
                    } else {
                        appendStmt.append("\t\t\t");
                    }
                    if (nextTokenClause.getMinVersion() != null) {
                        appendStmt.append(nextTokenClause.getVersionStatement() + " ");
                    }
                    appendStmt.append(nextTokenClause.getAppendStatement() + "\n");
                    caseStmt.addStatement(appendStmt.toString());
                }
                nextClauses.add(nextTokenClause);
            }
            if (caseStmt == null) continue;
            caseStmts.add(caseStmt);
        }
        this.appendRemainingTokenClauses(caseStmts, method, nextClauses, tokenCache);
    }

    private void analyseMethod(MethodModel method) throws Exception {
        StringBuffer buf = new StringBuffer();
        buf.append("\t/**\n").append("\t* Create completions for " + method.getName() + "\n").append("\t*\n").append("\t* @param indices identifiers specified in the parser\n").append("\t* @return array of possible completion choices\n").append("\t*\n").append("\t* @generated\n").append("\t*/\n");
        buf.append("\tpublic " + String.class.getSimpleName()).append("[] ").append(method.getName() + "(" + "int... indices" + ")" + " " + "{").append("\n");
        buf.append("\t\tList<String> bnf = newList();\n\n");
        ClauseStack clauseStack = method.getClauseStack();
        if (!method.requiresSwitch() && !method.requiresIfElse()) {
            for (IClause clause : clauseStack) {
                for (String appendStatement : clause.getAppendStatements()) {
                    buf.append("\t\t" + appendStatement + "\n");
                }
            }
        } else {
            buf.append("\t\tint index = concat(indices);\n");
            if (method.requiresIfElse()) {
                buf.append("\t\tif (index == 0) {\n");
            } else {
                buf.append("\t\tswitch (index) {\n");
                buf.append("\t\t\tcase 0:\n");
            }
            IClause clause = (IClause)clauseStack.get(0);
            List<TokenClause> firstClauses = clause.getFirstTokenClauses();
            for (TokenClause tokenClause : firstClauses) {
                if (method.requiresSwitch()) {
                    buf.append("\t\t\t\t");
                } else {
                    buf.append("\t\t\t");
                }
                if (tokenClause.getMinVersion() != null) {
                    buf.append(tokenClause.getVersionStatement() + " ");
                }
                buf.append(tokenClause.getAppendStatement() + "\n");
            }
            if (method.requiresSwitch()) {
                buf.append("\t\t\t\tbreak;\n");
            }
            LinkedHashSet<CaseStatement> caseStatements = new LinkedHashSet<CaseStatement>();
            this.appendRemainingTokenClauses(caseStatements, method, firstClauses, new HashSet<TokenClause>());
            for (CaseStatement caseStmt : caseStatements) {
                for (String declaration : caseStmt.getDeclarations()) {
                    buf.append(declaration);
                }
                for (String statement : caseStmt.getStatements()) {
                    buf.append(statement);
                }
                if (!method.requiresSwitch()) continue;
                buf.append("\t\t\t\tbreak;\n");
            }
            buf.append("\t\t}\n\n");
        }
        buf.append("\t\treturn array(bnf);\n");
        buf.append("\t}\n\n");
        this.append(buf.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate() throws Exception {
        try {
            String line = null;
            boolean startAnalysis = false;
            boolean inComment = false;
            ArrayList<MethodModel> methods = new ArrayList<MethodModel>();
            ArrayList<TokenModel> tokens = new ArrayList<TokenModel>();
            MethodModel currentMethod = null;
            TokenModel currentToken = null;
            while ((line = this.ccReader.readLine()) != null) {
                if (line.startsWith("PARSER_END")) {
                    startAnalysis = true;
                }
                if (!startAnalysis) continue;
                if (this.isStartComment(line)) {
                    inComment = true;
                }
                if (this.isEndComment(line)) {
                    inComment = false;
                }
                if (inComment) continue;
                if (this.isTokenDeclaration(line)) {
                    currentToken = new TokenModel();
                    tokens.add(currentToken);
                    currentMethod = null;
                    continue;
                }
                if (this.isMethodDeclaration(line)) {
                    String methodName = this.extractMethodName(line);
                    if (methodName == null) {
                        currentMethod = null;
                    } else {
                        currentMethod = new MethodModel(methodName);
                        methods.add(currentMethod);
                    }
                    currentToken = null;
                    continue;
                }
                if (currentMethod == null && currentToken == null || line.isEmpty() || this.isComment(line) || this.isTryOrCatch(line) || this.isSingleBrace(line) || this.isDoubleBrace(line) || this.isReturnStatement(line) || this.isPPSetNullMethod(line)) continue;
                if (currentMethod != null) {
                    currentMethod.addContent(line);
                    continue;
                }
                if (currentToken == null) continue;
                currentToken.addContent(line);
            }
            this.writeLicence();
            this.writePackageDeclaration();
            this.writeImports();
            this.writeClassDeclaration();
            Map<String, String> tokenMap = this.analyseTokens(tokens);
            for (MethodModel method : methods) {
                method.setTokenMap(tokenMap);
                this.analyseMethod(method);
            }
            this.append("\n}");
        }
        finally {
            this.bnfWriter.close();
            this.ccReader.close();
        }
    }

    private class MethodModel {
        private final String name;
        private List<String> contents;
        private Map<String, String> tokenMap;
        private ClauseStack clauseStack;

        public MethodModel(String name) {
            this.name = name;
            this.contents = new ArrayList<String>();
        }

        public void setTokenMap(Map<String, String> tokenMap) {
            this.tokenMap = tokenMap;
        }

        private void createClauses() throws Exception {
            Pattern tokenPattern = Pattern.compile("<([A-Z_0-9]+)>");
            Pattern functionPattern = Pattern.compile("([a-zA-Z]+)\\(.*\\)");
            Pattern ppPattern = Pattern.compile("pp[AS]+[a-z]+\\(bnf\\." + this.name + "\\((.*?)\\).*");
            Pattern reqPattern = Pattern.compile("requiresVersionAtLeast\\((Version.TEIID_[0-9]_[0-9])\\);");
            StringTokenizer tokenizer = new StringTokenizer(this.getContent());
            String identifier = null;
            this.clauseStack = new ClauseStack(IClause.ROOT_CLAUSE);
            block0: while (tokenizer.hasMoreTokens()) {
                IClause bClause;
                IClause clause;
                TokenClause clause2;
                boolean hasBrackets;
                String token = tokenizer.nextToken();
                if (token.startsWith("LOOKAHEAD")) {
                    int brackets = 0;
                    int iterations = 0;
                    do {
                        if (hasBrackets = token.contains("(")) {
                            brackets = this.checkBrackets(token);
                            if (brackets == 0) {
                                continue block0;
                            }
                        } else {
                            brackets = 1;
                        }
                        if (iterations > 10) {
                            throw new Exception(token + " has an uneven number of brackets. Tried to continue but something really has gone wrong!");
                        }
                        token = token + tokenizer.nextToken();
                        ++iterations;
                    } while (brackets > 0);
                    continue;
                }
                if (token.startsWith("ppAppend") || token.startsWith("ppSet")) {
                    int brackets = 0;
                    int iterations = 0;
                    do {
                        if (hasBrackets = token.contains("(")) {
                            brackets = this.checkBrackets(token);
                            if (brackets == 0) {
                                break;
                            }
                        } else {
                            brackets = 1;
                        }
                        if (iterations > 10) {
                            throw new Exception(token + " has an uneven number of brackets. Tried to continue but something really has gone wrong!");
                        }
                        token = token + tokenizer.nextToken();
                        ++iterations;
                    } while (brackets > 0);
                }
                Matcher tokenMatcher = tokenPattern.matcher(token);
                Matcher functionMatcher = functionPattern.matcher(token);
                Matcher ppMatcher = ppPattern.matcher(token);
                Matcher reqMatcher = reqPattern.matcher(token);
                if (tokenMatcher.matches()) {
                    identifier = tokenMatcher.group(1);
                    ArgCheck.isNotNull((Object)identifier);
                    identifier = identifier.trim();
                    if ("EOF".equals(identifier)) continue;
                    String tokenValue = this.tokenMap.get(identifier);
                    clause2 = new TokenClause(identifier, false);
                    clause2.setValue(tokenValue);
                    this.clauseStack.push(clause2);
                    continue;
                }
                if (functionMatcher.matches()) {
                    identifier = functionMatcher.group(1);
                    ArgCheck.isNotNull((Object)identifier);
                    identifier = identifier.trim();
                    clause = new TokenClause(identifier, true);
                    ((TokenClause)clause).setValue(identifier + "(0)");
                    this.clauseStack.push(clause);
                    continue;
                }
                if (ppMatcher.matches()) {
                    String ppFunction = ppMatcher.group(1);
                    clause2 = this.clauseStack.expectedLastClause(TokenClause.class);
                    if (clause2 == null) continue;
                    clause2.setPPFunction(ppFunction);
                    continue;
                }
                if (token.equals("(")) {
                    clause = new BracketClause();
                    this.clauseStack.push(clause);
                    continue;
                }
                if (token.equals(")")) {
                    clause = this.clauseStack.getLatestOpenGroupClause(BracketClause.class);
                    if (clause == null) continue;
                    bClause = clause;
                    ((AbstractGroupClause)bClause).closeClause(BracketClause.class);
                    continue;
                }
                if (token.equals(")*")) {
                    clause = this.clauseStack.getLatestOpenGroupClause(BracketClause.class);
                    if (clause == null) continue;
                    bClause = clause;
                    ((BracketClause)bClause).setMulti(true);
                    ((AbstractGroupClause)bClause).closeClause(BracketClause.class);
                    continue;
                }
                if (token.equals("[")) {
                    clause = new OptionalClause();
                    this.clauseStack.push(clause);
                    continue;
                }
                if (token.equals("]")) {
                    clause = this.clauseStack.getLatestOpenGroupClause(OptionalClause.class);
                    if (clause == null) continue;
                    IClause oClause = clause;
                    ((AbstractGroupClause)oClause).closeClause(OptionalClause.class);
                    continue;
                }
                if (token.equals("|")) {
                    OrClause orClause = new OrClause();
                    IClause topClause = (IClause)this.clauseStack.peek();
                    if (topClause instanceof IGroupClause && ((IGroupClause)topClause).isOpen()) {
                        IGroupClause gClause = (IGroupClause)topClause;
                        gClause.addClause(orClause);
                        continue;
                    }
                    this.clauseStack.push(orClause);
                    continue;
                }
                if (!reqMatcher.matches()) continue;
                String version = reqMatcher.group(1);
                ArgCheck.isNotNull((Object)version);
                clause2 = this.clauseStack.expectedLastClause(TokenClause.class);
                if (clause2 == null) continue;
                clause2.setMinimumVersion(version);
            }
        }

        private int checkBrackets(String token) {
            int brackets = 0;
            for (int i = 0; i < token.length(); ++i) {
                char c = token.charAt(i);
                if (c == '(') {
                    ++brackets;
                    continue;
                }
                if (c != ')') continue;
                --brackets;
            }
            return brackets;
        }

        public void addContent(String line) throws Exception {
            this.contents.add(line);
        }

        public String getName() {
            return this.name;
        }

        public List<String> getContents() {
            return Collections.unmodifiableList(this.contents);
        }

        public String getContent() {
            StringBuffer buf = new StringBuffer();
            for (String line : this.getContents()) {
                line = line.replaceAll("[\\s]+", " ");
                line = line.replaceAll("< ([A-Z_0-9]+) >", "<$1>");
                buf.append(line);
            }
            return buf.toString();
        }

        public ClauseStack getClauseStack() throws Exception {
            if (this.clauseStack == null) {
                this.createClauses();
            }
            return this.clauseStack;
        }

        public boolean requiresSwitch() throws Exception {
            if (this.requiresIfElse()) {
                return false;
            }
            ClauseStack clauseStack = this.getClauseStack();
            for (IClause clause : clauseStack) {
                if (!clause.hasPPFunction()) continue;
                return true;
            }
            return false;
        }

        public boolean requiresIfElse() throws Exception {
            ClauseStack clauseStack = this.getClauseStack();
            for (IClause clause : clauseStack) {
                if (!clause.hasMultiParameterPPFunction()) continue;
                return true;
            }
            return false;
        }
    }

    private class TokenModel {
        private StringBuffer content = new StringBuffer();

        private TokenModel() {
        }

        public void addContent(String line) {
            this.content.append(line);
        }

        public String getContent() {
            return this.content.toString();
        }
    }
}

