/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.modeshape.teiid.generators.bnf.clause;

import org.komodo.modeshape.teiid.generators.bnf.clause.ClauseStack;
import org.komodo.modeshape.teiid.generators.bnf.clause.IClause;
import org.komodo.modeshape.teiid.generators.bnf.clause.IGroupClause;
import org.komodo.modeshape.teiid.generators.bnf.clause.OrClause;

public abstract class AbstractGroupClause
implements IGroupClause {
    private boolean open = true;
    private ClauseStack clauseStack = new ClauseStack(this);
    private ClauseStack owningStack;

    @Override
    public ClauseStack getOwningStack() {
        return this.owningStack;
    }

    @Override
    public void setOwningStack(ClauseStack clauseStack) {
        this.owningStack = clauseStack;
    }

    @Override
    public IClause nextClause() {
        return this.getOwningStack().nextClause(this);
    }

    @Override
    public ClauseStack getClauseStack() {
        return this.clauseStack;
    }

    @Override
    public void addClause(IClause clause) {
        if (this.clauseStack.isEmpty() && clause instanceof OrClause) {
            throw new RuntimeException("Cannot add an or clause to an empty stack");
        }
        this.clauseStack.push(clause);
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }

    @Override
    public boolean isClosed() {
        return !this.open;
    }

    @Override
    public void closeClause(Class<? extends IClause> clauseClass) {
        IGroupClause gClause;
        IClause topClause;
        if (!this.clauseStack.isEmpty() && (topClause = (IClause)this.clauseStack.peek()) instanceof IGroupClause && (gClause = (IGroupClause)topClause).isOpen()) {
            gClause.closeClause(clauseClass);
            return;
        }
        this.open = false;
    }

    @Override
    public <T extends IClause> T getLastClause(Class<T> clauseClass) {
        if (this.clauseStack.isEmpty()) {
            return null;
        }
        IClause topClause = (IClause)this.clauseStack.peek();
        T lastClause = topClause.getLastClause(clauseClass);
        if (lastClause != null) {
            return lastClause;
        }
        if (clauseClass.isInstance(topClause)) {
            return (T)topClause;
        }
        if (clauseClass.isInstance(this)) {
            return (T)this;
        }
        return null;
    }

    @Override
    public <T extends IGroupClause> T findLatestOpenGroupClause(Class<T> groupClass) {
        T innerClause = this.getClauseStack().getLatestOpenGroupClause(groupClass);
        if (innerClause != null) {
            return innerClause;
        }
        if (groupClass.isInstance(this) && this.isOpen()) {
            return (T)this;
        }
        return null;
    }

    @Override
    public boolean hasPPFunction() {
        for (IClause clause : this.getClauseStack()) {
            if (!clause.hasPPFunction()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasMultiParameterPPFunction() {
        for (IClause clause : this.getClauseStack()) {
            if (!clause.hasMultiParameterPPFunction()) continue;
            return true;
        }
        return false;
    }
}

