/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.modeshape.teiid.generators.bnf.clause;

import java.util.Iterator;
import java.util.Stack;
import org.komodo.modeshape.teiid.generators.bnf.clause.IClause;
import org.komodo.modeshape.teiid.generators.bnf.clause.IGroupClause;
import org.komodo.modeshape.teiid.generators.bnf.clause.OptionalClause;
import org.komodo.modeshape.teiid.generators.bnf.clause.OrClause;

public class ClauseStack
extends Stack<IClause> {
    private static final long serialVersionUID = 1L;
    private final IClause parent;

    public ClauseStack(IClause parent) {
        this.parent = parent;
    }

    public IClause getParent() {
        return this.parent;
    }

    @Override
    public IClause push(IClause clause) {
        OrClause orClause;
        if (this.isEmpty()) {
            clause.setOwningStack(this);
            return super.push(clause);
        }
        IClause topClause = (IClause)this.peek();
        if (topClause == clause) {
            throw new RuntimeException("Should not be adding the top of the stack to the stack a second time!");
        }
        if (topClause instanceof IGroupClause) {
            IGroupClause gClause = (IGroupClause)topClause;
            if (gClause.isOpen()) {
                gClause.addClause(clause);
                return clause;
            }
        } else if (topClause instanceof OrClause) {
            orClause = (OrClause)topClause;
            clause.setOwningStack(this);
            if (orClause.setRightClause(clause)) {
                return clause;
            }
        }
        if (clause instanceof OrClause) {
            orClause = (OrClause)clause;
            topClause = (IClause)this.pop();
            orClause.setOwningStack(this);
            super.push(orClause);
            orClause.setLeftClause(topClause);
            return orClause;
        }
        clause.setOwningStack(this);
        return super.push(clause);
    }

    public <T extends IClause> T expectedLastClause(Class<T> expectedType) {
        if (this.isEmpty()) {
            return null;
        }
        IClause topClause = (IClause)this.peek();
        T lastClause = topClause.getLastClause(expectedType);
        if (lastClause != null) {
            return lastClause;
        }
        if (expectedType.isInstance(topClause)) {
            return (T)topClause;
        }
        return null;
    }

    public <T extends IGroupClause> T getLatestOpenGroupClause(Class<T> groupClass) {
        if (this.isEmpty()) {
            return null;
        }
        IClause topClause = (IClause)this.peek();
        return topClause.findLatestOpenGroupClause(groupClass);
    }

    private IClause nextFromIterator(Iterator<IClause> iterator) {
        if (iterator.hasNext()) {
            IClause nextClause = iterator.next();
            return nextClause;
        }
        IClause parent = this.getParent();
        if (parent == IClause.ROOT_CLAUSE) {
            return null;
        }
        ClauseStack parentStack = parent.getOwningStack();
        IClause nextClause = parentStack.nextClause(parent);
        return nextClause;
    }

    private IClause searchOrClause(OrClause orClause, Iterator<IClause> targetIterator, IClause searchClause) {
        if (orClause == searchClause) {
            return this.nextFromIterator(targetIterator);
        }
        if (orClause.getLeftClause() == searchClause) {
            return this.nextFromIterator(targetIterator);
        }
        if (orClause.getRightClause() == searchClause) {
            return this.nextFromIterator(targetIterator);
        }
        if (orClause.getLeftClause() instanceof OrClause) {
            return this.searchOrClause((OrClause)orClause.getLeftClause(), targetIterator, searchClause);
        }
        if (orClause.getRightClause() instanceof OrClause) {
            return this.searchOrClause((OrClause)orClause.getRightClause(), targetIterator, searchClause);
        }
        return null;
    }

    public IClause nextClause(IClause searchClause) {
        Iterator<IClause> iterator = this.iterator();
        while (iterator.hasNext()) {
            IClause clause;
            IClause iterClause = (IClause)iterator.next();
            if (iterClause == searchClause) {
                return this.nextFromIterator(iterator);
            }
            if (!(iterClause instanceof OrClause) || (clause = this.searchOrClause((OrClause)iterClause, iterator, searchClause)) == null) continue;
            return clause;
        }
        return null;
    }

    public boolean isConsideredLastClause(IClause clause) {
        if (clause == this.peek()) {
            return true;
        }
        int index = this.indexOf(clause);
        if (index == -1) {
            return false;
        }
        for (int i = index + 1; i < this.size(); ++i) {
            IClause next = (IClause)this.get(i);
            if (next instanceof OptionalClause) continue;
            return false;
        }
        return true;
    }
}

