/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.modeshape.teiid.generators.bnf.clause;

import java.util.ArrayList;
import java.util.List;
import org.komodo.modeshape.teiid.generators.bnf.clause.ClauseStack;
import org.komodo.modeshape.teiid.generators.bnf.clause.IClause;
import org.komodo.modeshape.teiid.generators.bnf.clause.IGroupClause;
import org.komodo.modeshape.teiid.generators.bnf.clause.TokenClause;

public class OrClause
implements IClause {
    private IClause leftClause;
    private IClause rightClause;
    private ClauseStack owningStack;

    @Override
    public ClauseStack getOwningStack() {
        return this.owningStack;
    }

    @Override
    public void setOwningStack(ClauseStack clauseStack) {
        this.owningStack = clauseStack;
    }

    @Override
    public IClause nextClause() {
        return this.getOwningStack().nextClause(this);
    }

    public IClause getLeftClause() {
        return this.leftClause;
    }

    public boolean setLeftClause(IClause leftClause) {
        if (leftClause == this) {
            throw new RuntimeException("Cannot add an orClause as its own left operand");
        }
        this.leftClause = leftClause;
        this.leftClause.setOwningStack(this.getOwningStack());
        return true;
    }

    public IClause getRightClause() {
        return this.rightClause;
    }

    public boolean setRightClause(IClause rightClause) {
        if (rightClause == this) {
            throw new RuntimeException("Cannot add an orClause as its own right operand");
        }
        if (this.rightClause == null) {
            this.rightClause = rightClause;
            this.rightClause.setOwningStack(this.getOwningStack());
            return true;
        }
        if (this.rightClause instanceof IGroupClause && ((IGroupClause)this.rightClause).isOpen()) {
            ((IGroupClause)this.rightClause).addClause(rightClause);
            return true;
        }
        if (this.rightClause instanceof OrClause) {
            ((OrClause)this.rightClause).setRightClause(rightClause);
            this.rightClause.setOwningStack(this.getOwningStack());
            return true;
        }
        if (rightClause instanceof OrClause) {
            OrClause orClause = (OrClause)rightClause;
            orClause.setLeftClause(this.rightClause);
            this.rightClause = orClause;
            this.rightClause.setOwningStack(this.getOwningStack());
            return true;
        }
        return false;
    }

    @Override
    public <T extends IClause> T getLastClause(Class<T> clauseClass) {
        T lastClause = this.rightClause.getLastClause(clauseClass);
        if (lastClause != null) {
            return lastClause;
        }
        if (clauseClass.isInstance(this)) {
            return (T)this;
        }
        return null;
    }

    @Override
    public <T extends IGroupClause> T findLatestOpenGroupClause(Class<T> groupClass) {
        if (this.rightClause == null) {
            return null;
        }
        return this.rightClause.findLatestOpenGroupClause(groupClass);
    }

    @Override
    public List<String> getAppendStatements() {
        ArrayList<String> appendStatements = new ArrayList<String>();
        appendStatements.addAll(this.leftClause.getAppendStatements());
        appendStatements.addAll(this.rightClause.getAppendStatements());
        return appendStatements;
    }

    @Override
    public List<TokenClause> getFirstTokenClauses() {
        ArrayList<TokenClause> tokenClauses = new ArrayList<TokenClause>();
        tokenClauses.addAll(this.leftClause.getFirstTokenClauses());
        tokenClauses.addAll(this.rightClause.getFirstTokenClauses());
        return tokenClauses;
    }

    @Override
    public boolean hasPPFunction() {
        return this.leftClause.hasPPFunction() || this.rightClause.hasPPFunction();
    }

    @Override
    public boolean hasMultiParameterPPFunction() {
        return this.leftClause.hasMultiParameterPPFunction() || this.rightClause.hasMultiParameterPPFunction();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.getLeftClause() + "\n");
        buf.append("|\n");
        buf.append(this.getRightClause());
        return buf.toString();
    }
}

