/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.modeshape.teiid.generators.bnf.clause;

import java.util.Collections;
import java.util.List;
import org.komodo.modeshape.teiid.generators.bnf.clause.ClauseStack;
import org.komodo.modeshape.teiid.generators.bnf.clause.IClause;
import org.komodo.modeshape.teiid.generators.bnf.clause.IGroupClause;

public class TokenClause
implements IClause {
    private final String identifier;
    private final boolean isFunction;
    private String value;
    private String ppFunction;
    private ClauseStack owningStack;
    private String minVersion;

    public TokenClause(String identifier, boolean isFunction) {
        this.identifier = identifier;
        this.isFunction = isFunction;
    }

    @Override
    public ClauseStack getOwningStack() {
        return this.owningStack;
    }

    @Override
    public void setOwningStack(ClauseStack clauseStack) {
        this.owningStack = clauseStack;
    }

    @Override
    public IClause nextClause() {
        return this.getOwningStack().nextClause(this);
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getPPFunction() {
        return this.ppFunction;
    }

    public void setPPFunction(String ppFunction) {
        this.ppFunction = ppFunction;
    }

    @Override
    public <T extends IClause> T getLastClause(Class<T> clauseClass) {
        if (TokenClause.class.equals(clauseClass)) {
            return (T)this;
        }
        return null;
    }

    @Override
    public <T extends IGroupClause> T findLatestOpenGroupClause(Class<T> groupClass) {
        return null;
    }

    @Override
    public List<TokenClause> getFirstTokenClauses() {
        return Collections.singletonList(this);
    }

    public String getVersionStatement() {
        if (this.minVersion == null) {
            return "";
        }
        return "if (versionAtLeast(" + this.minVersion + "))";
    }

    public String getAppendStatement() {
        StringBuffer buf = new StringBuffer();
        buf.append("append(bnf, ");
        if (!this.isFunction) {
            buf.append("\"");
        }
        String value = this.value.replaceAll("\\\\\\\"", "");
        if (!this.isFunction) {
            value = value.toUpperCase();
        }
        buf.append(value);
        if (!this.isFunction) {
            buf.append("\"");
        }
        buf.append(");");
        return buf.toString();
    }

    @Override
    public List<String> getAppendStatements() {
        StringBuffer buffer = new StringBuffer();
        if (this.minVersion != null) {
            buffer.append(this.getVersionStatement() + " ");
        }
        buffer.append(this.getAppendStatement());
        return Collections.singletonList(buffer.toString());
    }

    @Override
    public boolean hasPPFunction() {
        return this.getPPFunction() != null;
    }

    @Override
    public boolean hasMultiParameterPPFunction() {
        if (!this.hasPPFunction()) {
            return false;
        }
        return this.getPPFunction().contains(",");
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.getIdentifier() + " ");
        buf.append("{ " + this.getValue() + " " + "}" + " ");
        if (this.getPPFunction() != null) {
            buf.append("ppSet|Append " + this.getPPFunction() + " ");
        }
        buf.append("\t\t" + this.owningStack.hashCode());
        return buf.toString();
    }

    public String getMinVersion() {
        return this.minVersion;
    }

    public void setMinimumVersion(String version) {
        this.minVersion = version;
    }
}

