/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.modeshape.teiid.parser;

import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import org.komodo.modeshape.teiid.Messages;
import org.komodo.modeshape.teiid.TeiidClientException;
import org.komodo.modeshape.teiid.parser.ParseInfo;
import org.komodo.spi.annotation.Removed;
import org.komodo.spi.annotation.Since;
import org.komodo.spi.constants.StringConstants;
import org.komodo.spi.runtime.version.DefaultTeiidVersion;
import org.komodo.spi.runtime.version.TeiidVersion;
import org.komodo.utils.StringUtils;

public abstract class AbstractTeiidParser {
    protected List<ParsingError> errors = new ArrayList<ParsingError>();
    protected Pattern udtPattern = Pattern.compile("(\\w+)\\s*\\(\\s*(\\d+),\\s*(\\d+),\\s*(\\d+)\\)");
    protected Pattern SOURCE_HINT = Pattern.compile("\\s*sh(\\s+KEEP ALIASES)?\\s*(?::((?:'[^']*')+))?\\s*", 34);
    protected Pattern SOURCE_HINT_ARG = Pattern.compile("\\s*([^: ]+)(\\s+KEEP ALIASES)?\\s*:((?:'[^']*')+)", 34);
    protected TeiidVersion version;

    public TeiidVersion getVersion() {
        return this.version;
    }

    public List<ParsingError> getErrors() {
        return Collections.unmodifiableList(this.errors);
    }

    protected abstract void ReInit(Reader var1);

    public void reset(Reader reader) {
        this.errors.clear();
        this.ReInit(reader);
    }

    public void setVersion(TeiidVersion teiidVersion) {
        this.version = teiidVersion;
    }

    protected boolean versionLessThan(DefaultTeiidVersion.Version requiredVersionEnum) {
        return this.getVersion().isLessThan(requiredVersionEnum.get());
    }

    protected boolean versionAtLeast(DefaultTeiidVersion.Version requiredVersionEnum) {
        return !this.versionLessThan(requiredVersionEnum);
    }

    protected String prependSign(String sign, String literal) {
        if (sign != null && sign.charAt(0) == '-') {
            return sign + literal;
        }
        return literal;
    }

    private int parseNumericValue(CharSequence string, StringBuilder sb, int i, int value, int possibleDigits, int radixExp) {
        char digit;
        int val;
        for (int j = 0; j < possibleDigits && i + 1 != string.length() && (val = Character.digit(digit = string.charAt(i + 1), 1 << radixExp)) != -1; ++j) {
            ++i;
            value = (value << radixExp) + val;
        }
        sb.append((char)value);
        return i;
    }

    private String unescape(CharSequence string, int quoteChar, boolean useAsciiEscapes, StringBuilder sb) {
        boolean escaped = false;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (escaped) {
                switch (c) {
                    case 'b': {
                        sb.append('\b');
                        break;
                    }
                    case 't': {
                        sb.append('\t');
                        break;
                    }
                    case 'n': {
                        sb.append('\n');
                        break;
                    }
                    case 'f': {
                        sb.append('\f');
                        break;
                    }
                    case 'r': {
                        sb.append('\r');
                        break;
                    }
                    case 'u': {
                        i = this.parseNumericValue(string, sb, i, 0, 4, 4);
                        break;
                    }
                    default: {
                        if (c == quoteChar) {
                            sb.append(quoteChar);
                            break;
                        }
                        if (!useAsciiEscapes) break;
                        int value = Character.digit(c, 8);
                        if (value == -1) {
                            sb.append(c);
                            break;
                        }
                        int possibleDigits = value < 3 ? 2 : 1;
                        int radixExp = 3;
                        i = this.parseNumericValue(string, sb, i, value, possibleDigits, radixExp);
                    }
                }
                escaped = false;
                continue;
            }
            if (c == '\\') {
                escaped = true;
                continue;
            }
            if (c == quoteChar) break;
            sb.append(c);
        }
        return sb.toString();
    }

    private String unescape(String string) {
        return this.unescape(string, -1, true, new StringBuilder());
    }

    private String removeEscapeChars(String str, String tickChar) {
        return StringUtils.replaceAll((String)str, (String)(tickChar + tickChar), (String)tickChar);
    }

    protected String normalizeStringLiteral(String s) {
        if (s == null) {
            return null;
        }
        int start = 1;
        boolean unescape = false;
        if (s.charAt(0) == 'N') {
            ++start;
        } else if (s.charAt(0) == 'E') {
            ++start;
            unescape = true;
        }
        char tickChar = s.charAt(start - 1);
        s = s.substring(start, s.length() - 1);
        String result = this.removeEscapeChars(s, String.valueOf(tickChar));
        if (unescape) {
            result = this.unescape(result);
        }
        return result;
    }

    protected String normalizeId(String s) {
        if (s == null || s.indexOf(34) == -1) {
            return s;
        }
        LinkedList<String> nameParts = new LinkedList<String>();
        block0: while (s.length() > 0) {
            if (s.charAt(0) == '\"') {
                boolean escape = false;
                for (int i = 1; i < s.length(); ++i) {
                    boolean end;
                    if (s.charAt(i) != '\"') continue;
                    escape = !escape;
                    boolean bl = end = i == s.length() - 1;
                    if (!end && (!escape || s.charAt(i + 1) != '.')) continue;
                    String part = s.substring(1, i);
                    s = s.substring(i + (end ? 1 : 2));
                    nameParts.add(this.removeEscapeChars(part, "\""));
                    continue block0;
                }
                continue;
            }
            int index = s.indexOf(46);
            if (index == -1) {
                nameParts.add(s);
                break;
            }
            nameParts.add(s.substring(0, index));
            s = s.substring(index + 1);
        }
        StringBuilder sb = new StringBuilder();
        Iterator i = nameParts.iterator();
        while (i.hasNext()) {
            sb.append((String)i.next());
            if (!i.hasNext()) continue;
            sb.append('.');
        }
        return sb.toString();
    }

    protected boolean isStringLiteral(String str, ParseInfo info) {
        if (info.useAnsiQuotedIdentifiers() || str.charAt(0) != '\"' || str.charAt(str.length() - 1) != '\"') {
            return false;
        }
        for (int index = 1; index < str.length() - 1; index += 2) {
            if ((index = str.indexOf(34, index)) == -1 || index + 1 == str.length()) {
                return true;
            }
            if (str.charAt(index + 1) == '\"') continue;
            return false;
        }
        return true;
    }

    protected String validateName(String id, boolean element) throws Exception {
        if (id.indexOf(46) != -1) {
            Messages.TeiidParser key = Messages.TeiidParser.Invalid_alias;
            if (element) {
                key = Messages.TeiidParser.Invalid_short_name;
            }
            throw new TeiidClientException(Messages.getString(key, id));
        }
        return id;
    }

    @Removed(value=DefaultTeiidVersion.Version.TEIID_8_0)
    protected String matchesAny(String arg, String ... expected) {
        for (String string : expected) {
            if (!string.equalsIgnoreCase(arg)) continue;
            return arg;
        }
        return null;
    }

    @Since(value=DefaultTeiidVersion.Version.TEIID_8_0)
    protected boolean isTrue(String text) {
        return Boolean.valueOf(text);
    }

    public static class ParsingError
    implements StringConstants {
        private final String token;
        private final int line;
        private final int column;
        private final String message;

        public ParsingError(String token, int line, int column, String message) {
            this.token = token;
            this.line = line;
            this.column = column;
            this.message = message;
        }

        public String getToken() {
            return this.token;
        }

        public int getLine() {
            return this.line;
        }

        public int getColumn() {
            return this.column;
        }

        public String getMessage() {
            return this.message;
        }

        public String toString() {
            return Messages.getString(Messages.TeiidParser.parsing_error, this.token, this.line, this.column, this.message);
        }
    }
}

