/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.modeshape.lib;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.logging.Level;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.RollingFileAppender;

public class LogConfigurator {
    private static final String CONSOLE_APPENDER = "KLOG-CONSOLE";
    private static final String FILE_APPENDER = "KLOG-FILE";
    private String logPath;
    private String level = "INFO";
    private RollingFileAppender fileAppender;
    private static LogConfigurator instance;

    public static LogConfigurator getInstance() throws Exception {
        if (instance == null) {
            instance = new LogConfigurator();
            instance.initContext();
        }
        return instance;
    }

    private void initContext() throws Exception {
        PatternLayout layout;
        Path logFilePath;
        if (this.logPath == null || this.logPath.isEmpty()) {
            String tempPath = System.getProperty("komodo.dataDir");
            if (tempPath == null) {
                tempPath = System.getProperty("java.io.tmpdir");
            }
            this.logPath = tempPath = tempPath + File.separator + "komodo.log";
        }
        if (!Files.exists(logFilePath = Paths.get(this.logPath, new String[0]), new LinkOption[0])) {
            if (!Files.exists(logFilePath.getParent(), new LinkOption[0])) {
                Files.createDirectories(logFilePath.getParent(), new FileAttribute[0]);
            }
            Files.createFile(logFilePath, new FileAttribute[0]);
        }
        Logger rootLogger = Logger.getRootLogger();
        rootLogger.setLevel(org.apache.log4j.Level.toLevel((String)this.level));
        if (rootLogger.getAppender(CONSOLE_APPENDER) == null) {
            layout = new PatternLayout("%d{ISO8601} [%t] %-5p %c %x - %m%n");
            ConsoleAppender consoleAppender = new ConsoleAppender((Layout)layout);
            consoleAppender.setName(CONSOLE_APPENDER);
            rootLogger.addAppender((Appender)consoleAppender);
        }
        if (rootLogger.getAppender(FILE_APPENDER) == null) {
            layout = new PatternLayout("%d{ISO8601} [%t] %-5p %c %x - %m%n");
            this.fileAppender = new RollingFileAppender((Layout)layout, this.logPath);
            this.fileAppender.setName(FILE_APPENDER);
            rootLogger.addAppender((Appender)this.fileAppender);
        }
    }

    public String getLogPath() {
        return this.logPath;
    }

    public void setLogPath(String logPath) throws Exception {
        File oldLog;
        Logger rootLogger = Logger.getRootLogger();
        if (this.fileAppender != null) {
            this.fileAppender.close();
            rootLogger.removeAppender((Appender)this.fileAppender);
            this.fileAppender = null;
        }
        if (this.logPath != null && (oldLog = new File(this.logPath)).canRead() && oldLog.length() == 0L) {
            Files.deleteIfExists(oldLog.toPath());
        }
        String logPathMsg = "Location of old log file was " + this.logPath;
        this.logPath = logPath;
        this.initContext();
        rootLogger.debug((Object)logPathMsg);
    }

    public void setLevel(Level level) throws Exception {
        this.level = Level.OFF.equals(level) || Level.ALL.equals(level) || Level.INFO.equals(level) ? level.getName() : (Level.SEVERE.equals(level) ? org.apache.log4j.Level.FATAL.toString() : (Level.WARNING.equals(level) ? org.apache.log4j.Level.WARN.toString() : (Level.FINE.equals(level) ? org.apache.log4j.Level.DEBUG.toString() : (Level.FINER.equals(level) || Level.FINEST.equals(level) ? org.apache.log4j.Level.TRACE.toString() : org.apache.log4j.Level.INFO.toString()))));
        this.initContext();
    }

    public void dispose() {
    }
}

