/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.modeshape.lib.sequencer;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import javax.jcr.Binary;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.Session;
import org.modeshape.common.text.ParsingException;
import org.modeshape.common.util.IoUtil;
import org.modeshape.jcr.api.sequencer.Sequencer;
import org.teiid.modeshape.sequencer.ddl.DdlParser;
import org.teiid.modeshape.sequencer.ddl.TeiidDdlParser;
import org.teiid.modeshape.sequencer.ddl.TeiidDdlSequencer;
import org.teiid.modeshape.sequencer.ddl.node.AstNode;
import org.teiid.modeshape.sequencer.ddl.node.AstNodeFactory;

public class KDdlSequencer
extends TeiidDdlSequencer {
    private final DdlParser teiidParser = new TeiidDdlParser();

    protected List<DdlParser> getParserList() {
        return Collections.singletonList(this.teiidParser);
    }

    public boolean execute(Property inputProperty, Node outputNode, Sequencer.Context context) throws Exception {
        if (!super.execute(inputProperty, outputNode, context)) {
            AstNodeFactory nodeFactory = new AstNodeFactory();
            AstNode tempNode = nodeFactory.node("ddl:statements");
            Binary ddlContent = inputProperty.getBinary();
            try (InputStream stream = ddlContent.getStream();){
                this.teiidParser.parse(IoUtil.read((InputStream)stream), tempNode, null);
            }
            catch (ParsingException e) {
                throw new Exception(e);
            }
            catch (IOException e) {
                throw new Exception(e);
            }
            return false;
        }
        if (!outputNode.hasNode("ddl:statements")) {
            return false;
        }
        Node ddlStmtsNode = outputNode.getNode("ddl:statements");
        NodeIterator children = ddlStmtsNode.getNodes();
        Session session = ddlStmtsNode.getSession();
        if (!session.isLive()) {
            return false;
        }
        while (children.hasNext()) {
            Node child = children.nextNode();
            session.move(child.getPath(), outputNode.getPath() + "/" + child.getName());
            if (outputNode.hasNode(child.getName())) continue;
            throw new Exception("Failed to move DDL sequence node to output node");
        }
        session.removeItem(ddlStmtsNode.getPath());
        return outputNode.hasNodes();
    }
}

