/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands;

import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Iterator;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.komodo.relational.commands.server.WkspStatusServerManager;
import org.komodo.repository.RepositoryImpl;
import org.komodo.shell.api.CommandResult;
import org.komodo.spi.repository.Repository;
import org.komodo.utils.KLog;

public abstract class AbstractCommandTest
extends org.komodo.shell.AbstractCommandTest {
    private static final KLog LOGGER = KLog.getLogger();
    private static final Path SHELL_DATA_DIRECTORY;
    private static Path _saveShellDataDirectory;

    @AfterClass
    public static void restoreShellDataDirectory() {
        _shellDataDirectory = _saveShellDataDirectory;
        System.setProperty("vdbbuilder.dataDir", _shellDataDirectory.toString());
    }

    @BeforeClass
    public static void setShellDataDirectory() {
        _saveShellDataDirectory = _shellDataDirectory;
        _shellDataDirectory = SHELL_DATA_DIRECTORY;
        System.setProperty("vdbbuilder.dataDir", _shellDataDirectory.toString());
    }

    @Before
    public void beforeEach() throws Exception {
        this.globalProperties.put("SERVER_CONNECT_ON_STARTUP", "false|java.lang.Boolean");
        super.beforeEach();
        String[] commands = new String[]{"workspace"};
        CommandResult result = this.execute(commands);
        this.assertCommandResultOk(result);
        this.assertContextIs(RepositoryImpl.komodoWorkspacePath((Repository.UnitOfWork)this.getTransaction()));
    }

    @After
    public void clearServer() throws Exception {
        WkspStatusServerManager.reset();
    }

    static {
        Path tempDataDir = null;
        try {
            tempDataDir = Files.createTempDirectory("VdbBuilderDataDir", new FileAttribute[0]);
            tempDataDir.toFile().deleteOnExit();
            System.setProperty("vdbbuilder.dataDir", tempDataDir.toString());
            LOGGER.debug("AbstractCommandTest:_shellDataDirectory = {0}", new Object[]{tempDataDir});
            Path commandsDir = Paths.get(tempDataDir.toString() + "/commands", new String[0]);
            commandsDir.toFile().deleteOnExit();
            Files.createDirectory(commandsDir, new FileAttribute[0]);
            System.setProperty("komodo.shell.commandsDir", commandsDir.toString());
            LOGGER.debug("AbstractCommandTest: commands directory is {0}", new Object[]{commandsDir});
            String relativeTargetPath = "target";
            Path targetDir = Paths.get("target", new String[0]);
            LOGGER.debug("AbstractCommandTest: Looking for jar here: {0}", new Object[]{targetDir});
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(targetDir, "*-with-dependencies.jar");){
                Iterator<Path> itr = stream.iterator();
                if (itr.hasNext()) {
                    Path path = itr.next();
                    String pathString = path.toString();
                    LOGGER.debug("AbstractCommandTest: found jar {0}", new Object[]{pathString});
                    if (itr.hasNext()) {
                        Assert.fail((String)"*** Found more than one relational command provider jar ***");
                    }
                    Path filePath = Paths.get(commandsDir.toString() + '/' + path.getFileName(), new String[0]);
                    Files.copy(path, filePath, new CopyOption[0]);
                    filePath.toFile().deleteOnExit();
                    LOGGER.debug("AbstractCommandTest: copying jar to {0}", new Object[]{commandsDir.toString() + '/' + path.getFileName()});
                } else {
                    Assert.fail((String)"*** Failed to find relational command provider jar ***");
                }
            }
            catch (IOException e) {
                Assert.fail((String)("Failed to copy jar to commands directory: " + e.getMessage()));
            }
        }
        catch (Exception e) {
            Assert.fail((String)e.getLocalizedMessage());
        }
        SHELL_DATA_DIRECTORY = tempDataDir;
    }
}

