/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.komodo.importer.ImportMessages;
import org.komodo.importer.ImportOptions;
import org.komodo.spi.repository.KomodoObject;
import org.komodo.spi.repository.Property;
import org.komodo.spi.repository.Repository;
import org.komodo.test.utils.AbstractLocalRepositoryTest;
import org.komodo.utils.KLog;
import org.modeshape.jcr.JcrSession;

public abstract class AbstractImporterTest
extends AbstractLocalRepositoryTest {
    protected static final String DATA_DIRECTORY = File.separator + "data";
    protected static final String VDB_DIRECTORY = DATA_DIRECTORY + File.separator + "vdb";
    protected static final String BOOKS_DIRECTORY = DATA_DIRECTORY + File.separator + "books";
    protected static final String DDL_DIRECTORY = DATA_DIRECTORY + File.separator + "ddl";

    protected abstract void runImporter(Repository var1, InputStream var2, KomodoObject var3, ImportOptions var4, ImportMessages var5) throws Exception;

    protected abstract void runImporter(Repository var1, File var2, KomodoObject var3, ImportOptions var4, ImportMessages var5) throws Exception;

    protected void runImporter(Repository repository, Object content, KomodoObject parentObject, ImportOptions importOptions, ImportMessages importMessages) throws Exception {
        if (content instanceof File) {
            this.runImporter(repository, (File)content, parentObject, importOptions, importMessages);
        } else if (content instanceof InputStream) {
            this.runImporter(repository, (InputStream)content, parentObject, importOptions, importMessages);
        }
    }

    protected void executeImporter(Object content, KomodoObject parentObject, ImportOptions importOptions, ImportMessages importMessages) throws Exception {
        Assert.assertNotNull((Object)_repo);
        Assert.assertNotNull((Object)content);
        Assert.assertNotNull((Object)parentObject);
        Assert.assertNotNull((Object)importOptions);
        Assert.assertNotNull((Object)importMessages);
        this.runImporter((Repository)_repo, content, parentObject, importOptions, importMessages);
        if (importMessages.hasError()) {
            KLog.getLogger().debug(importMessages.errorMessagesToString(), new Object[0]);
        }
        this.traverse(this.getTransaction(), parentObject.getAbsolutePath());
    }

    protected String enc(String input) throws Exception {
        return ((JcrSession)this.session(this.getTransaction())).encode(input);
    }

    protected void verifyProperty(KomodoObject node, String propertyName, String ... expectedValues) throws Exception {
        List<Object> values;
        Property property = node.getRawProperty(this.getTransaction(), propertyName);
        Assert.assertNotNull((Object)property);
        if (property.isMultiple(this.getTransaction())) {
            values = Arrays.asList(property.getStringValues(this.getTransaction()));
        } else {
            values = new ArrayList<String>();
            values.add(property.getStringValue(this.getTransaction()));
        }
        Assert.assertEquals((long)expectedValues.length, (long)values.size());
        for (String expectedValue : expectedValues) {
            Assert.assertTrue((boolean)values.contains(expectedValue));
        }
    }

    protected void verifyPrimaryType(KomodoObject node, String expectedValue) throws Exception {
        this.verifyProperty(node, "jcr:primaryType", expectedValue);
    }

    protected void verifyMixinType(KomodoObject node, String ... expectedValues) throws Exception {
        List<Object> values;
        Property property = node.getRawProperty(this.getTransaction(), "jcr:mixinTypes");
        Assert.assertNotNull((Object)property);
        if (property.isMultiple(this.getTransaction())) {
            values = Arrays.asList(property.getStringValues(this.getTransaction()));
        } else {
            values = new ArrayList<String>();
            values.add(property.getStringValue(this.getTransaction()));
        }
        Assert.assertEquals((long)expectedValues.length, (long)values.size());
        for (String expectedValue : expectedValues) {
            Assert.assertTrue((boolean)values.contains(expectedValue));
        }
    }

    protected void verifyBaseProperties(KomodoObject node, String primaryType, String mixinType) throws Exception {
        this.verifyPrimaryType(node, primaryType);
        if (mixinType == null) {
            return;
        }
        this.verifyMixinType(node, mixinType);
    }

    protected KomodoObject verify(KomodoObject parentNode, String relativePath, String primaryType, int index, String mixinType) throws Exception {
        String indexExp = "";
        if (index > -1) {
            indexExp = "[" + index + "]";
        }
        KomodoObject childNode = null;
        childNode = parentNode.hasChild(this.getTransaction(), relativePath) ? parentNode.getChild(this.getTransaction(), relativePath + indexExp) : parentNode.getChild(this.getTransaction(), this.enc(relativePath) + indexExp);
        Assert.assertNotNull((Object)childNode);
        this.verifyBaseProperties(childNode, primaryType, mixinType);
        return childNode;
    }

    protected KomodoObject verify(KomodoObject parentNode, String relativePath, String primaryType, String mixinType) throws Exception {
        return this.verify(parentNode, relativePath, primaryType, -1, mixinType);
    }

    protected KomodoObject verify(KomodoObject parentNode, String relativePath, String primaryType) throws Exception {
        return this.verify(parentNode, relativePath, primaryType, -1, null);
    }

    protected KomodoObject verify(KomodoObject parentNode, String relativePath) throws Exception {
        return this.verify(parentNode, relativePath, "nt:unstructured", -1, null);
    }
}

