/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands;

import java.util.Arrays;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.komodo.relational.commands.AbstractCommandTest;
import org.komodo.relational.model.OptionContainer;
import org.komodo.relational.model.StatementOption;
import org.komodo.relational.vdb.Vdb;
import org.komodo.relational.workspace.WorkspaceManager;
import org.komodo.spi.KException;

public class CustomOptionCommandTest
extends AbstractCommandTest {
    protected Vdb getVDB(String vdbName, WorkspaceManager wkspMgr) throws KException {
        Vdb[] vdbs;
        for (Vdb vdb : vdbs = wkspMgr.findVdbs(this.getTransaction())) {
            if (!vdb.getName(this.getTransaction()).equals(vdbName)) continue;
            return vdb;
        }
        return null;
    }

    protected void assertCustomOptions(OptionContainer kobject, String[][] expectedOptions) throws KException {
        StatementOption[] options = kobject.getCustomOptions(this.getTransaction());
        int counter = 0;
        String[][] actualOptions = new String[options.length][2];
        for (StatementOption option : options) {
            actualOptions[counter][0] = option.getName(this.getTransaction());
            actualOptions[counter][1] = option.getStringValue(this.getTransaction());
            ++counter;
        }
        String compareMessage = "Expected: " + Arrays.deepToString((Object[])expectedOptions) + " Actual: " + Arrays.deepToString((Object[])actualOptions);
        Assert.assertThat((String)("Invalid number of option keys " + compareMessage), (Object)actualOptions.length, (Matcher)Is.is((Object)expectedOptions.length));
        Assert.assertThat((String)("Invalid elements: " + compareMessage), (Object)Arrays.deepEquals((Object[])expectedOptions, (Object[])actualOptions), (Matcher)Is.is((Object)true));
    }
}

