/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands;

import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.komodo.relational.commands.CustomOptionCommandTest;
import org.komodo.relational.model.Column;
import org.komodo.relational.model.Function;
import org.komodo.relational.model.Model;
import org.komodo.relational.model.OptionContainer;
import org.komodo.relational.model.Procedure;
import org.komodo.relational.model.PushdownFunction;
import org.komodo.relational.model.ResultSetColumn;
import org.komodo.relational.model.StatementOption;
import org.komodo.relational.model.Table;
import org.komodo.relational.model.TabularResultSet;
import org.komodo.relational.vdb.Vdb;
import org.komodo.relational.workspace.WorkspaceManager;
import org.komodo.shell.api.CommandResult;
import org.komodo.spi.repository.Repository;

public class SetCustomOptionCommandTest
extends CustomOptionCommandTest {
    @Test
    public void testCustomOptionTable() throws Exception {
        WorkspaceManager wkspMgr = WorkspaceManager.getInstance((Repository)_repo, (Repository.UnitOfWork)this.getTransaction());
        this.setup("commandFiles", "addCustomOptions.cmd");
        String[][] expectedOptions = new String[][]{{"myCustomOption1", "myValue1"}, {"myCustomOption2", "myValue2"}, {"MyCustomOption3", "myValue3"}, {"my.custom.option", "myValue1"}, {"My\"Custom\"Option3", "myValue3"}};
        Vdb vdb = this.getVDB("myVDB1", wkspMgr);
        Assert.assertNotNull((Object)vdb);
        Model[] models = vdb.getModels(this.getTransaction(), new String[]{"myModel1"});
        Assert.assertEquals((long)1L, (long)models.length);
        Table[] tables = models[0].getTables(this.getTransaction(), new String[]{"myTable1"});
        Assert.assertEquals((long)1L, (long)tables.length);
        this.assertCustomOptions((OptionContainer)tables[0], expectedOptions);
    }

    @Test
    public void testCustomOptionColumn() throws Exception {
        WorkspaceManager wkspMgr = WorkspaceManager.getInstance((Repository)_repo, (Repository.UnitOfWork)this.getTransaction());
        this.setup("commandFiles", "addColumns.cmd");
        String[] commands = new String[]{"cd myColumn1", "set-custom-option myCustomOption myValue"};
        CommandResult result = this.execute(commands);
        this.assertCommandResultOk(result);
        String[] expectedOption = new String[]{"myCustomOption", "myValue"};
        Vdb vdb = this.getVDB("myVDB1", wkspMgr);
        Assert.assertNotNull((Object)vdb);
        Model[] models = vdb.getModels(this.getTransaction(), new String[]{"myModel1"});
        Assert.assertThat((Object)models.length, (Matcher)Is.is((Object)1));
        Table[] tables = models[0].getTables(this.getTransaction(), new String[]{"myTable1"});
        Assert.assertThat((Object)tables.length, (Matcher)Is.is((Object)1));
        Column[] columns = tables[0].getColumns(this.getTransaction(), new String[]{"myColumn1"});
        Assert.assertThat((Object)columns.length, (Matcher)Is.is((Object)1));
        StatementOption[] options = columns[0].getCustomOptions(this.getTransaction());
        Assert.assertThat((Object)options.length, (Matcher)Is.is((Object)1));
        Assert.assertThat((String)"Option key does not match", (Object)options[0].getName(this.getTransaction()), (Matcher)Is.is((Object)expectedOption[0]));
        Assert.assertThat((String)"Option value does not match", (Object)options[0].getStringValue(this.getTransaction()), (Matcher)Is.is((Object)expectedOption[1]));
    }

    @Test
    public void testCustomOptionProcedure() throws Exception {
        WorkspaceManager wkspMgr = WorkspaceManager.getInstance((Repository)_repo, (Repository.UnitOfWork)this.getTransaction());
        this.setup("commandFiles", "addStoredProcedures.cmd");
        String[] commands = new String[]{"cd myStoredProcedure1", "set-custom-option myCustomOption myValue"};
        CommandResult result = this.execute(commands);
        this.assertCommandResultOk(result);
        String[][] expectedOptions = new String[][]{{"myCustomOption", "myValue"}};
        Vdb vdb = this.getVDB("myVDB1", wkspMgr);
        Assert.assertNotNull((Object)vdb);
        Model[] models = vdb.getModels(this.getTransaction(), new String[]{"myModel1"});
        Assert.assertThat((Object)models.length, (Matcher)Is.is((Object)1));
        Procedure[] procedures = models[0].getProcedures(this.getTransaction(), new String[]{"myStoredProcedure1"});
        Assert.assertThat((Object)procedures.length, (Matcher)Is.is((Object)1));
        this.assertCustomOptions((OptionContainer)procedures[0], expectedOptions);
    }

    @Test
    public void testCustomOptionResultSet() throws Exception {
        WorkspaceManager wkspMgr = WorkspaceManager.getInstance((Repository)_repo, (Repository.UnitOfWork)this.getTransaction());
        this.setup("commandFiles", "addResSetColumns.cmd");
        String[] commands = new String[]{"cd myColumn1", "set-custom-option myCustomOption myValue"};
        CommandResult result = this.execute(commands);
        this.assertCommandResultOk(result);
        String[][] expectedOptions = new String[][]{{"myCustomOption", "myValue"}};
        Vdb vdb = this.getVDB("myVDB1", wkspMgr);
        Assert.assertNotNull((Object)vdb);
        Model[] models = vdb.getModels(this.getTransaction(), new String[]{"myModel1"});
        Assert.assertThat((Object)models.length, (Matcher)Is.is((Object)1));
        Function[] procedures = models[0].getFunctions(this.getTransaction(), new String[]{"myPushdownFunction1"});
        Assert.assertThat((Object)procedures.length, (Matcher)Is.is((Object)1));
        PushdownFunction function = (PushdownFunction)wkspMgr.resolve(this.getTransaction(), (Object)procedures[0], PushdownFunction.class);
        Assert.assertNotNull((Object)function);
        TabularResultSet resultSet = (TabularResultSet)wkspMgr.resolve(this.getTransaction(), (Object)function.getResultSet(this.getTransaction()), TabularResultSet.class);
        ResultSetColumn col = null;
        for (ResultSetColumn rsc : resultSet.getColumns(this.getTransaction())) {
            if (!rsc.getName(this.getTransaction()).equals("myColumn1")) continue;
            col = rsc;
        }
        Assert.assertNotNull(col);
        this.assertCustomOptions((OptionContainer)col, expectedOptions);
    }

    @Test
    public void testNoOptionContainer() throws Exception {
        this.setup("commandFiles", "addTables.cmd");
        this.assertCommandsNotAvailable(new String[]{"set-custom-option", "unset-custom-option"});
    }
}

