/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.komodo.relational.commands.AbstractCommandTest;
import org.komodo.relational.vdb.Vdb;
import org.komodo.relational.workspace.ServerManager;
import org.komodo.relational.workspace.WorkspaceManager;
import org.komodo.shell.api.CommandResult;
import org.komodo.spi.repository.Property;
import org.komodo.spi.repository.Repository;

public class SetCustomPropertyCommandTest
extends AbstractCommandTest {
    @Before
    public void init() throws Exception {
        this.wsStatus.setProvidedGlobalProperty(ServerManager.SERVER_CONNECT_ON_STARTUP, Boolean.FALSE.toString(), Boolean.class.getName());
    }

    @Test
    public void testCustomProperty1() throws Exception {
        String[] commands = new String[]{"create-vdb testVdb vdbPath", "cd testVdb", "set-custom-property newProperty myProperty"};
        CommandResult result = this.execute(commands);
        this.assertCommandResultOk(result);
        WorkspaceManager wkspMgr = WorkspaceManager.getInstance((Repository)_repo, (Repository.UnitOfWork)this.getTransaction());
        Vdb[] vdbs = wkspMgr.findVdbs(this.getTransaction());
        Assert.assertEquals((long)1L, (long)vdbs.length);
        Assert.assertEquals((Object)"testVdb", (Object)vdbs[0].getName(this.getTransaction()));
        Property prop = vdbs[0].getProperty(this.getTransaction(), "newProperty");
        Assert.assertEquals((Object)"myProperty", (Object)prop.getStringValue(this.getTransaction()));
    }
}

